/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.RepositoryService;
import org.jetbrains.settingsRepository.git.GitExKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/settingsRepository/git/GitRepositoryService;", "Lorg/jetbrains/settingsRepository/RepositoryService;", "()V", "isValidRepository", "", "file", "Ljava/nio/file/Path;", "intellij.settingsRepository"})
public final class GitRepositoryService
implements RepositoryService {
    @Override
    public boolean isValidRepository(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Path path = file.resolve(".git");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"file.resolve(Constants.DOT_GIT)");
        if (PathKt.exists((Path)path)) {
            return true;
        }
        try {
            GitExKt.buildRepository$default(null, false, file, true, 3, null);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    @NlsContexts.DialogMessage
    @Nullable
    public String checkUrl(@NotNull String uriString, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
        return RepositoryService.DefaultImpls.checkUrl(this, uriString, project);
    }
}

