/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.formatter.YAMLFormattingContext;
import org.jetbrains.yaml.psi.impl.YAMLBlockScalarImpl;

final class YAMLBlockScalarItemBlock
implements Block {
    @NotNull
    final TextRange myRange;
    @Nullable
    final Indent myIndent;
    @Nullable
    final Alignment myAlignment;

    private YAMLBlockScalarItemBlock(@NotNull TextRange range, @Nullable Indent indent, @Nullable Alignment alignment) {
        if (range == null) {
            YAMLBlockScalarItemBlock.$$$reportNull$$$0(0);
        }
        this.myRange = range;
        this.myIndent = indent;
        this.myAlignment = alignment;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            YAMLBlockScalarItemBlock.$$$reportNull$$$0(1);
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        List<Block> list = Collections.emptyList();
        if (list == null) {
            YAMLBlockScalarItemBlock.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public Wrap getWrap() {
        return null;
    }

    @Nullable
    public Indent getIndent() {
        return this.myIndent;
    }

    @Nullable
    public Alignment getAlignment() {
        return this.myAlignment;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            YAMLBlockScalarItemBlock.$$$reportNull$$$0(3);
        }
        return null;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        return new ChildAttributes(null, null);
    }

    public boolean isIncomplete() {
        return false;
    }

    public boolean isLeaf() {
        return true;
    }

    @NotNull
    static Block createBlockScalarItem(@NotNull YAMLFormattingContext context, @NotNull ASTNode node) {
        Indent indent;
        TextRange range;
        if (context == null) {
            YAMLBlockScalarItemBlock.$$$reportNull$$$0(4);
        }
        if (node == null) {
            YAMLBlockScalarItemBlock.$$$reportNull$$$0(5);
        }
        ASTNode blockScalarNode = node.getTreeParent();
        YAMLBlockScalarImpl blockScalarImpl = (YAMLBlockScalarImpl)blockScalarNode.getPsi();
        int parentFullIndent = YAMLBlockScalarItemBlock.getParentFullIndent(context, blockScalarNode.getTreeParent());
        Alignment alignment = null;
        int oldOffset = Math.max(YAMLBlockScalarItemBlock.getNodeFullIndent(node) - parentFullIndent, 0);
        if (blockScalarImpl.hasExplicitIndent()) {
            range = new TextRange(node.getStartOffset() - oldOffset, node.getTextRange().getEndOffset());
            indent = Indent.getSpaceIndent((int)0, (boolean)true);
        } else {
            int needOffset = Math.max(oldOffset - YAMLBlockScalarItemBlock.getFirstLineOffset(context, blockScalarImpl), 0);
            range = new TextRange(node.getStartOffset() - needOffset, node.getTextRange().getEndOffset());
            alignment = context.computeAlignment(node);
            indent = Indent.getNormalIndent((boolean)true);
        }
        return new YAMLBlockScalarItemBlock(range, indent, alignment);
    }

    private static int getFirstLineOffset(@NotNull YAMLFormattingContext context, @NotNull YAMLBlockScalarImpl blockScalarPsi) {
        if (context == null) {
            YAMLBlockScalarItemBlock.$$$reportNull$$$0(6);
        }
        if (blockScalarPsi == null) {
            YAMLBlockScalarItemBlock.$$$reportNull$$$0(7);
        }
        int parentFullIndent = YAMLBlockScalarItemBlock.getParentFullIndent(context, blockScalarPsi.getNode().getTreeParent());
        ASTNode firstLine = blockScalarPsi.getNthContentTypeChild(1);
        if (firstLine == null) {
            return 0;
        }
        return Math.max(YAMLBlockScalarItemBlock.getNodeFullIndent(firstLine) - parentFullIndent, 0);
    }

    private static int getParentFullIndent(@NotNull YAMLFormattingContext context, @NotNull ASTNode node) {
        if (context == null) {
            YAMLBlockScalarItemBlock.$$$reportNull$$$0(8);
        }
        if (node == null) {
            YAMLBlockScalarItemBlock.$$$reportNull$$$0(9);
        }
        String fullText = context.getFullText();
        int start = node.getTextRange().getStartOffset();
        for (int cur = start - 1; cur >= 0; --cur) {
            if (fullText.charAt(cur) == '\n') {
                return start - cur - 1;
            }
            if (start - cur <= 1000) continue;
            return 0;
        }
        return start;
    }

    private static int getNodeFullIndent(@NotNull ASTNode node) {
        ASTNode indentNode;
        if (node == null) {
            YAMLBlockScalarItemBlock.$$$reportNull$$$0(10);
        }
        if ((indentNode = node.getTreePrev()) == null || indentNode.getElementType() != YAMLTokenTypes.INDENT) {
            return 0;
        }
        return indentNode.getTextLength();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/formatter/YAMLBlockScalarItemBlock";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockScalarPsi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/formatter/YAMLBlockScalarItemBlock";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createBlockScalarItem";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFirstLineOffset";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParentFullIndent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNodeFullIndent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

