/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.extended;

import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.LanguageCodeStylePropertyMapper;
import com.intellij.openapi.util.text.StringUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.editorconfig.configmanagement.extended.IntellijPropertyKindMap;
import org.jetbrains.annotations.NotNull;

public final class EditorConfigIntellijNameUtil {
    public static final String IDE_PREFIX = "ij_";
    static final String GENERIC_PROPERTY_PREFIX = "any_";
    static final String GENERIC_OPTION_KEY_PREFIX = "ij_any_";

    private EditorConfigIntellijNameUtil() {
    }

    @NotNull
    public static List<String> toEditorConfigNames(@NotNull AbstractCodeStylePropertyMapper mapper, @NotNull String propertyName) {
        if (mapper == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(0);
        }
        if (propertyName == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(1);
        }
        switch (IntellijPropertyKindMap.getPropertyKind(propertyName)) {
            case EDITOR_CONFIG_STANDARD: {
                List<String> list = Collections.singletonList(propertyName);
                if (list == null) {
                    EditorConfigIntellijNameUtil.$$$reportNull$$$0(2);
                }
                return list;
            }
            case UNSUPPORTED: {
                break;
            }
            case LANGUAGE: {
                if (!(mapper instanceof LanguageCodeStylePropertyMapper)) break;
                List<String> list = Collections.singletonList(EditorConfigIntellijNameUtil.getLanguageProperty(mapper, propertyName));
                if (list == null) {
                    EditorConfigIntellijNameUtil.$$$reportNull$$$0(3);
                }
                return list;
            }
            case COMMON: {
                ArrayList<String> names = new ArrayList<String>();
                names.add(GENERIC_OPTION_KEY_PREFIX + propertyName);
                names.add(EditorConfigIntellijNameUtil.getLanguageProperty(mapper, propertyName));
                ArrayList<String> arrayList = names;
                if (arrayList == null) {
                    EditorConfigIntellijNameUtil.$$$reportNull$$$0(4);
                }
                return arrayList;
            }
            case GENERIC: {
                List<CallSite> list = Collections.singletonList(IDE_PREFIX + propertyName);
                if (list == null) {
                    EditorConfigIntellijNameUtil.$$$reportNull$$$0(5);
                }
                return list;
            }
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public static String getLanguageProperty(@NotNull AbstractCodeStylePropertyMapper mapper, @NotNull String propertyName) {
        if (mapper == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(7);
        }
        if (propertyName == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(8);
        }
        String string = IDE_PREFIX + mapper.getLanguageDomainId() + "_" + propertyName;
        if (string == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String toIntellijName(@NotNull String editorConfigName) {
        if (editorConfigName == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(10);
        }
        String string = StringUtil.trimStart((String)StringUtil.trimStart((String)editorConfigName, (String)IDE_PREFIX), (String)GENERIC_PROPERTY_PREFIX);
        if (string == null) {
            EditorConfigIntellijNameUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/editorconfig/configmanagement/extended/EditorConfigIntellijNameUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorConfigName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/editorconfig/configmanagement/extended/EditorConfigIntellijNameUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toEditorConfigNames";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageProperty";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toIntellijName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "toEditorConfigNames";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageProperty";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "toIntellijName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

