/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.ImageDescriptor;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.BitUtil;
import com.intellij.util.CacheKey;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SVGLoader;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.swing.Icon;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImageLoader {
    public static final int ALLOW_FLOAT_SCALING = 1;
    public static final int USE_CACHE = 2;
    public static final int USE_DARK = 4;
    public static final int USE_SVG = 8;
    private static final long CACHED_IMAGE_MAX_SIZE = (long)(SystemProperties.getFloatProperty((String)"ide.cached.image.max.size", (float)1.5f) * 1024.0f * 1024.0f);
    private static final Set<String> IO_MISS_CACHE = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final ConcurrentMap<CacheKey, Pair<Image, Dimension2DDouble>> imageCache = CollectionFactory.createConcurrentSoftValueMap();
    private static final ConcurrentMap<CacheKey, Image> largeImageCache = CollectionFactory.createConcurrentWeakValueMap();
    private static final ConcurrentMap<Image, Dimension2DDouble> largeImageDimensionMap = CollectionFactory.createConcurrentWeakMap();
    public static final Component ourComponent = new Component(){};

    @NotNull
    private static Logger getLogger() {
        Logger logger = Logger.getInstance(ImageLoader.class);
        if (logger == null) {
            ImageLoader.$$$reportNull$$$0(0);
        }
        return logger;
    }

    @ApiStatus.Internal
    public static boolean isIconTooLargeForCache(@NotNull Icon icon) {
        if (icon == null) {
            ImageLoader.$$$reportNull$$$0(1);
        }
        return 4L * (long)icon.getIconWidth() * (long)icon.getIconHeight() > CACHED_IMAGE_MAX_SIZE;
    }

    private static void addFileNameVariant(boolean retina, boolean isDark, boolean isSvg, String name, String ext, float scale, @NotNull List<ImageDescriptor> list) {
        float _scale;
        String _ext;
        if (list == null) {
            ImageLoader.$$$reportNull$$$0(2);
        }
        String string = _ext = isSvg ? "svg" : ext;
        float f = isSvg ? scale : (_scale = (float)(retina ? 2 : 1));
        if (retina && isDark) {
            list.add(new ImageDescriptor(name + "@2x_dark." + _ext, _scale, isSvg, true));
        }
        list.add(new ImageDescriptor(name + (isDark ? "_dark" : "") + (retina ? "@2x" : "") + "." + _ext, _scale, isSvg, isDark));
        if (retina) {
            list.add(new ImageDescriptor(name + (isDark ? "_dark" : "") + "." + _ext, isSvg ? scale : 1.0f, isSvg, isDark));
        }
    }

    public static void clearCache() {
        imageCache.clear();
        largeImageCache.clear();
        largeImageDimensionMap.clear();
        IO_MISS_CACHE.clear();
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @Nullable
    public static Image loadRasterized(@NotNull String path, @Nullable List<ImageFilter> filters, @NotNull ClassLoader classLoader, int flags, @NotNull ScaleContext scaleContext, boolean isUpScaleNeeded, long rasterizedCacheKey, int n) {
        float imageScale;
        Object effectivePath;
        void imageFlags;
        if (path == null) {
            ImageLoader.$$$reportNull$$$0(3);
        }
        if (classLoader == null) {
            ImageLoader.$$$reportNull$$$0(4);
        }
        if (scaleContext == null) {
            ImageLoader.$$$reportNull$$$0(5);
        }
        long loadingStart = StartUpMeasurer.getCurrentTimeIfEnabled();
        float pixScale = (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE);
        int dotIndex = path.lastIndexOf(46);
        String name = dotIndex < 0 ? path : path.substring(0, dotIndex);
        float scale = ImageLoader.adjustScaleFactor(BitUtil.isSet((int)flags, (int)1), pixScale);
        boolean isSvg = rasterizedCacheKey != 0L;
        boolean isDark = BitUtil.isSet((int)flags, (int)4);
        boolean isRetina = JBUIScale.isHiDPI(pixScale);
        String ext = isSvg ? "svg" : (dotIndex < 0 || dotIndex == path.length() - 1 ? "" : path.substring(dotIndex + 1));
        boolean isEffectiveDark = isDark;
        if (isRetina && isDark && (imageFlags & 4) == 4) {
            effectivePath = name + "@2x_dark." + ext;
            imageScale = isSvg ? scale : 2.0f;
        } else if (isDark && (imageFlags & 2) == 2) {
            effectivePath = name + "_dark." + ext;
            imageScale = isSvg ? scale : 1.0f;
        } else {
            isEffectiveDark = false;
            if (isRetina && (imageFlags & 1) == 1) {
                effectivePath = name + "@2x." + ext;
                imageScale = isSvg ? scale : 2.0f;
            } else {
                effectivePath = path;
                imageScale = isSvg ? scale : 1.0f;
            }
        }
        Dimension2DDouble originalUserSize = new Dimension2DDouble(0.0, 0.0);
        try {
            long start = StartUpMeasurer.getCurrentTimeIfEnabled();
            Image image = isSvg ? SVGLoader.loadFromClassResource(null, classLoader, (String)effectivePath, rasterizedCacheKey, imageScale, isEffectiveDark, originalUserSize) : ImageLoader.loadPngFromClassResource((String)effectivePath, null, classLoader, imageScale, originalUserSize);
            if (start != -1L) {
                IconLoadMeasurer.loadFromResources.end(start);
            }
            if (loadingStart != -1L) {
                IconLoadMeasurer.addLoading(isSvg, loadingStart);
            }
            if (image == null) {
                return null;
            }
            return ImageLoader.convertImage(image, filters, flags, scaleContext, isUpScaleNeeded, StartupUiUtil.isJreHiDPI(scaleContext), imageScale, isSvg, originalUserSize);
        }
        catch (IOException e) {
            ImageLoader.getLogger().debug((Throwable)e);
            return null;
        }
    }

    @ApiStatus.Internal
    @Nullable
    public static Image load(@NotNull String path, @Nullable List<ImageFilter> filters, @Nullable Class<?> resourceClass, @Nullable ClassLoader classLoader, int flags, @NotNull ScaleContext scaleContext, boolean isUpScaleNeeded) {
        if (path == null) {
            ImageLoader.$$$reportNull$$$0(6);
        }
        if (scaleContext == null) {
            ImageLoader.$$$reportNull$$$0(7);
        }
        long start = StartUpMeasurer.getCurrentTimeIfEnabled();
        List<ImageDescriptor> descriptors = ImageLoader.createImageDescriptorList(path, flags, scaleContext);
        boolean ioExceptionThrown = false;
        boolean isHiDpiNeeded = StartupUiUtil.isJreHiDPI(scaleContext);
        Dimension2DDouble originalUserSize = new Dimension2DDouble(0.0, 0.0);
        for (int i = 0; i < descriptors.size(); ++i) {
            ImageDescriptor descriptor = descriptors.get(i);
            try {
                Image image = ImageLoader.loadByDescriptor(descriptor, flags, resourceClass, classLoader, originalUserSize, i == 0 ? IO_MISS_CACHE : null, path);
                if (image == null) continue;
                if (start != -1L) {
                    IconLoadMeasurer.addLoading(descriptor.isSvg, start);
                }
                return ImageLoader.convertImage(image, filters, flags, scaleContext, isUpScaleNeeded, isHiDpiNeeded, descriptor.scale, descriptor.isSvg, originalUserSize);
            }
            catch (IOException e) {
                ioExceptionThrown = true;
            }
        }
        if (ioExceptionThrown) {
            IO_MISS_CACHE.add(path);
        }
        return null;
    }

    @Nullable
    private static Image loadByDescriptor(@NotNull ImageDescriptor descriptor, int flags, @Nullable Class<?> resourceClass, @Nullable ClassLoader classLoader, @NotNull Dimension2DDouble originalUserSize, @Nullable Set<String> ioMissCache, @Nullable String ioMissCacheKey) throws IOException {
        Image image;
        if (descriptor == null) {
            ImageLoader.$$$reportNull$$$0(8);
        }
        if (originalUserSize == null) {
            ImageLoader.$$$reportNull$$$0(9);
        }
        CacheKey cacheKey = null;
        if (BitUtil.isSet((int)flags, (int)2) && !SVGLoader.isSelectionContext()) {
            Dimension2DDouble dimension;
            cacheKey = new CacheKey(descriptor.path, descriptor.isSvg ? (double)descriptor.scale : 0.0);
            Pair pair = (Pair)imageCache.get(cacheKey);
            if (pair != null) {
                originalUserSize.setSize((Dimension2DDouble)pair.second);
                return (Image)pair.first;
            }
            Image image2 = (Image)largeImageCache.get(cacheKey);
            if (image2 != null && (dimension = (Dimension2DDouble)largeImageDimensionMap.get(image2)) != null) {
                originalUserSize.setSize(dimension);
                return image2;
            }
        }
        if (ioMissCache != null && ioMissCache.contains(ioMissCacheKey)) {
            return null;
        }
        long start = StartUpMeasurer.getCurrentTimeIfEnabled();
        if (resourceClass == null && (classLoader == null || URLUtil.containsScheme((String)descriptor.path))) {
            URLConnection connection = new URL(descriptor.path).openConnection();
            if (connection instanceof HttpURLConnection) {
                if (!descriptor.original) {
                    return null;
                }
                connection.addRequestProperty("User-Agent", "IntelliJ");
            }
            try (InputStream stream = connection.getInputStream();){
                image = descriptor.isSvg ? SVGLoader.load(descriptor.path, stream, descriptor.scale, descriptor.isDark, originalUserSize) : ImageLoader.loadPng(stream, descriptor.scale, originalUserSize);
            }
            if (start != -1L) {
                IconLoadMeasurer.loadFromUrl.end(start);
            }
        } else {
            image = descriptor.isSvg ? SVGLoader.loadFromClassResource(resourceClass, classLoader, descriptor.path, 0L, descriptor.scale, descriptor.isDark, originalUserSize) : ImageLoader.loadPngFromClassResource(descriptor.path, resourceClass, classLoader, descriptor.scale, originalUserSize);
            if (start != -1L) {
                IconLoadMeasurer.loadFromResources.end(start);
            }
        }
        if (cacheKey != null && image != null) {
            if (4L * (long)image.getWidth(null) * (long)image.getHeight(null) <= CACHED_IMAGE_MAX_SIZE) {
                imageCache.put(cacheKey, (Pair<Image, Dimension2DDouble>)new Pair((Object)image, (Object)originalUserSize));
            } else {
                largeImageCache.put(cacheKey, image);
                largeImageDimensionMap.put(image, originalUserSize);
            }
        }
        return image;
    }

    @Nullable
    static InputStream getResourceData(@NotNull String path, @Nullable Class<?> resourceClass, @Nullable ClassLoader classLoader) {
        InputStream stream;
        if (path == null) {
            ImageLoader.$$$reportNull$$$0(10);
        }
        assert (resourceClass != null || classLoader != null);
        if (classLoader != null && (stream = classLoader.getResourceAsStream(path.startsWith("/") ? path.substring(1) : path)) != null) {
            return stream;
        }
        if (resourceClass != null) {
            return resourceClass.getResourceAsStream(path);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private static Image loadPngFromClassResource(String path, @Nullable Class<?> resourceClass, @Nullable ClassLoader classLoader, double scale, @NotNull Dimension2DDouble dimension2DDouble) throws IOException {
        InputStream stream;
        if (dimension2DDouble == null) {
            ImageLoader.$$$reportNull$$$0(11);
        }
        if ((stream = ImageLoader.getResourceData(path, resourceClass, classLoader)) == null) {
            return null;
        }
        try (InputStream inputStream = stream;){
            void originalUserSize;
            BufferedImage bufferedImage = ImageLoader.loadPng(stream, scale, (Dimension2DDouble)originalUserSize);
            return bufferedImage;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ApiStatus.Internal
    @NotNull
    public static Image loadFromStream(@NotNull InputStream stream, @Nullable String path, float scale, @NotNull Dimension2DDouble originalUserSize, int flags) throws IOException {
        if (stream == null) {
            ImageLoader.$$$reportNull$$$0(12);
        }
        if (originalUserSize == null) {
            ImageLoader.$$$reportNull$$$0(13);
        }
        InputStream inputStream = stream;
        if (BitUtil.isSet((int)flags, (int)8)) {
            Image image = SVGLoader.load(path, stream, scale, BitUtil.isSet((int)flags, (int)4), originalUserSize);
            Image image2 = image;
            if (image2 == null) {
                ImageLoader.$$$reportNull$$$0(14);
            }
            return image2;
        }
        BufferedImage bufferedImage = ImageLoader.loadPng(stream, scale, originalUserSize);
        BufferedImage bufferedImage2 = bufferedImage;
        if (bufferedImage2 == null) {
            ImageLoader.$$$reportNull$$$0(15);
        }
        return bufferedImage2;
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    private static BufferedImage loadPng(@NotNull InputStream stream, double scale, @NotNull Dimension2DDouble dimension2DDouble) throws IOException {
        void originalUserSize;
        BufferedImage image;
        if (stream == null) {
            ImageLoader.$$$reportNull$$$0(16);
        }
        if (dimension2DDouble == null) {
            ImageLoader.$$$reportNull$$$0(17);
        }
        long start = StartUpMeasurer.getCurrentTimeIfEnabled();
        ImageReader reader = ImageIO.getImageReadersByFormatName("png").next();
        try (MemoryCacheImageInputStream imageInputStream = new MemoryCacheImageInputStream(stream);){
            reader.setInput(imageInputStream, true, true);
            image = reader.read(0, null);
        }
        finally {
            reader.dispose();
        }
        originalUserSize.setSize((double)image.getWidth() / scale, (double)image.getHeight() / scale);
        if (start != -1L) {
            IconLoadMeasurer.pngDecoding.end(start);
        }
        BufferedImage bufferedImage = image;
        if (bufferedImage == null) {
            ImageLoader.$$$reportNull$$$0(18);
        }
        return bufferedImage;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static Image convertImage(@NotNull Image image, @Nullable List<ImageFilter> filters, int flags, ScaleContext scaleContext, boolean isUpScaleNeeded, boolean isHiDpiNeeded, double imageScale, boolean isSvg, @NotNull Dimension2DDouble dimension2DDouble) {
        if (image == null) {
            ImageLoader.$$$reportNull$$$0(19);
        }
        if (dimension2DDouble == null) {
            ImageLoader.$$$reportNull$$$0(20);
        }
        if (isUpScaleNeeded && !isSvg) {
            double scale = ImageLoader.adjustScaleFactor(BitUtil.isSet((int)flags, (int)1), (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE));
            if (imageScale > 1.0) {
                scale /= imageScale;
            }
            image = ImageLoader.scaleImage(image, scale);
        }
        if (filters != null && !filters.isEmpty()) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            for (ImageFilter filter : filters) {
                if (filter == null) continue;
                image = toolkit.createImage(new FilteredImageSource(ImageUtil.toBufferedImage(image, false).getSource(), filter));
            }
        }
        if (isHiDpiNeeded) {
            void originalUserSize;
            double userScale = scaleContext.getScale(DerivedScaleType.EFF_USR_SCALE);
            image = new JBHiDPIScaledImage(image, originalUserSize.getWidth() * userScale, originalUserSize.getHeight() * userScale, 2);
        }
        return image;
    }

    @NotNull
    public static List<ImageDescriptor> getImageDescriptors(@NotNull String path, int flags, @NotNull ScaleContext scaleContext) {
        if (path == null) {
            ImageLoader.$$$reportNull$$$0(21);
        }
        if (scaleContext == null) {
            ImageLoader.$$$reportNull$$$0(22);
        }
        List<ImageDescriptor> list = ImageLoader.createImageDescriptorList(path, flags, scaleContext);
        if (list == null) {
            ImageLoader.$$$reportNull$$$0(23);
        }
        return list;
    }

    private static List<ImageDescriptor> createImageDescriptorList(@NotNull String path, int flags, @NotNull ScaleContext scaleContext) {
        List<ImageDescriptor> list;
        if (path == null) {
            ImageLoader.$$$reportNull$$$0(24);
        }
        if (scaleContext == null) {
            ImageLoader.$$$reportNull$$$0(25);
        }
        float pixScale = (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE);
        int i = path.lastIndexOf(46);
        String name = i < 0 ? path : path.substring(0, i);
        String ext = i < 0 || i == path.length() - 1 ? "" : path.substring(i + 1);
        float scale = ImageLoader.adjustScaleFactor(BitUtil.isSet((int)flags, (int)1), pixScale);
        if (!path.startsWith("file:") && path.contains("://")) {
            int qI = path.lastIndexOf(63);
            boolean isSvg = StringUtilRt.endsWithIgnoreCase((CharSequence)(qI == -1 ? path : path.substring(0, qI)), (CharSequence)".svg");
            list = Collections.singletonList(new ImageDescriptor(name + "." + ext, 1.0f, isSvg, true));
        } else {
            boolean isSvg = "svg".equalsIgnoreCase(ext);
            boolean isDark = BitUtil.isSet((int)flags, (int)4);
            boolean retina = JBUIScale.isHiDPI(pixScale);
            list = new ArrayList<ImageDescriptor>();
            if (!isSvg && BitUtil.isSet((int)flags, (int)8)) {
                ImageLoader.addFileNameVariant(retina, isDark, true, name, ext, scale, list);
            }
            ImageLoader.addFileNameVariant(retina, isDark, isSvg, name, ext, scale, list);
            if (isDark) {
                ImageLoader.addFileNameVariant(retina, false, isSvg, name, ext, scale, list);
                if (!isSvg && BitUtil.isSet((int)flags, (int)8)) {
                    ImageLoader.addFileNameVariant(false, false, true, name, ext, scale, list);
                }
            }
        }
        return list;
    }

    @Nullable
    public static Image loadFromUrl(@NotNull URL url) {
        if (url == null) {
            ImageLoader.$$$reportNull$$$0(26);
        }
        int flags = 11;
        if (StartupUiUtil.isUnderDarcula()) {
            flags |= 4;
        }
        String path = url.toString();
        return ImageLoader.load(path, null, null, null, flags, ScaleContext.create(), !path.endsWith(".svg"));
    }

    @Nullable
    public static Image loadFromUrl(@NotNull String path, @Nullable Class<?> aClass, int flags, @Nullable List<ImageFilter> filters, @NotNull ScaleContext scaleContext) {
        if (path == null) {
            ImageLoader.$$$reportNull$$$0(27);
        }
        if (scaleContext == null) {
            ImageLoader.$$$reportNull$$$0(28);
        }
        return ImageLoader.load(path, filters, aClass, null, flags, scaleContext, !path.endsWith(".svg"));
    }

    private static float adjustScaleFactor(boolean allowFloatScaling, float scale) {
        return allowFloatScaling ? scale : (JBUIScale.isHiDPI(scale) ? 2.0f : 1.0f);
    }

    @NotNull
    public static Image scaleImage(@NotNull Image image, double scale) {
        if (image == null) {
            ImageLoader.$$$reportNull$$$0(29);
        }
        if (scale == 1.0) {
            Image image2 = image;
            if (image2 == null) {
                ImageLoader.$$$reportNull$$$0(30);
            }
            return image2;
        }
        if (image instanceof JBHiDPIScaledImage) {
            JBHiDPIScaledImage jBHiDPIScaledImage = ((JBHiDPIScaledImage)image).scale(scale);
            if (jBHiDPIScaledImage == null) {
                ImageLoader.$$$reportNull$$$0(31);
            }
            return jBHiDPIScaledImage;
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w <= 0 || h <= 0) {
            Image image3 = image;
            if (image3 == null) {
                ImageLoader.$$$reportNull$$$0(32);
            }
            return image3;
        }
        int width = (int)Math.round(scale * (double)w);
        int height = (int)Math.round(scale * (double)h);
        BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image, false), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)width, (int)height, (BufferedImageOp[])null);
        if (bufferedImage == null) {
            ImageLoader.$$$reportNull$$$0(33);
        }
        return bufferedImage;
    }

    @NotNull
    public static Image scaleImage(@NotNull Image image, int targetSize) {
        if (image == null) {
            ImageLoader.$$$reportNull$$$0(34);
        }
        return ImageLoader.scaleImage(image, targetSize, targetSize);
    }

    @NotNull
    public static Image scaleImage(@NotNull Image image, int targetWidth, int targetHeight) {
        if (image == null) {
            ImageLoader.$$$reportNull$$$0(35);
        }
        if (image instanceof JBHiDPIScaledImage) {
            JBHiDPIScaledImage jBHiDPIScaledImage = ((JBHiDPIScaledImage)image).scale(targetWidth, targetHeight);
            if (jBHiDPIScaledImage == null) {
                ImageLoader.$$$reportNull$$$0(36);
            }
            return jBHiDPIScaledImage;
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        if (w <= 0 || h <= 0 || w == targetWidth && h == targetHeight) {
            Image image2 = image;
            if (image2 == null) {
                ImageLoader.$$$reportNull$$$0(37);
            }
            return image2;
        }
        BufferedImage bufferedImage = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(image), (Scalr.Method)Scalr.Method.QUALITY, (Scalr.Mode)Scalr.Mode.FIT_EXACT, (int)targetWidth, (int)targetHeight, (BufferedImageOp[])null);
        if (bufferedImage == null) {
            ImageLoader.$$$reportNull$$$0(38);
        }
        return bufferedImage;
    }

    @Deprecated
    @Nullable
    public static Image loadFromResource(@NonNls @NotNull String s) {
        Class callerClass;
        if (s == null) {
            ImageLoader.$$$reportNull$$$0(39);
        }
        return (callerClass = ReflectionUtil.getGrandCallerClass()) == null ? null : ImageLoader.loadFromResource(s, callerClass);
    }

    @Nullable
    public static Image loadFromResource(@NonNls @NotNull String path, @NotNull Class<?> aClass) {
        if (path == null) {
            ImageLoader.$$$reportNull$$$0(40);
        }
        if (aClass == null) {
            ImageLoader.$$$reportNull$$$0(41);
        }
        ScaleContext scaleContext = ScaleContext.create();
        int flags = 11;
        flags = BitUtil.set((int)flags, (int)4, (boolean)StartupUiUtil.isUnderDarcula());
        return ImageLoader.load(path, null, aClass, null, flags, scaleContext, false);
    }

    public static Image loadFromBytes(byte @NotNull [] bytes) {
        if (bytes == null) {
            ImageLoader.$$$reportNull$$$0(42);
        }
        return ImageLoader.loadFromStream(new ByteArrayInputStream(bytes));
    }

    public static Image loadFromStream(@NotNull InputStream inputStream) {
        BufferedImage bufferedImage;
        block10: {
            if (inputStream == null) {
                ImageLoader.$$$reportNull$$$0(43);
            }
            ScaleContext scaleContext = ScaleContext.create();
            InputStream inputStream2 = inputStream;
            try {
                Dimension2DDouble originalUserSize = new Dimension2DDouble(0.0, 0.0);
                double scale = scaleContext.getScale(DerivedScaleType.PIX_SCALE);
                BufferedImage image = ImageLoader.loadPng(inputStream, scale, originalUserSize);
                if (StartupUiUtil.isJreHiDPI(scaleContext)) {
                    double userScale = scaleContext.getScale(DerivedScaleType.EFF_USR_SCALE);
                    image = new JBHiDPIScaledImage((Image)image, originalUserSize.getWidth() * userScale, originalUserSize.getHeight() * userScale, 2);
                }
                bufferedImage = image;
                if (inputStream2 == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream2 != null) {
                        try {
                            inputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    ImageLoader.getLogger().error((Throwable)e);
                    return null;
                }
            }
            inputStream2.close();
        }
        return bufferedImage;
    }

    @Nullable
    public static Image loadCustomIcon(@NotNull File file) throws IOException {
        if (file == null) {
            ImageLoader.$$$reportNull$$$0(44);
        }
        ScaleContext scaleContext = ScaleContext.create();
        float scale = (float)scaleContext.getScale(DerivedScaleType.PIX_SCALE);
        ImageDescriptor imageDescriptor = new ImageDescriptor(file.toURI().toURL().toString(), scale, StringUtilRt.endsWithIgnoreCase((CharSequence)file.getPath(), (CharSequence)".svg"), file.getPath().contains("_dark."));
        Image icon = ImageUtil.ensureHiDPI(ImageLoader.loadByDescriptor(imageDescriptor, 2, null, null, new Dimension2DDouble(0.0, 0.0), null, null), scaleContext);
        if (icon == null) {
            return null;
        }
        int w = icon.getWidth(null);
        int h = icon.getHeight(null);
        if (w <= 0 || h <= 0) {
            ImageLoader.getLogger().error("negative image size: w=" + w + ", h=" + h + ", path=" + file.getPath());
            return null;
        }
        if (w > EmptyIcon.ICON_18.getIconWidth() || h > EmptyIcon.ICON_18.getIconHeight()) {
            double s = (double)EmptyIcon.ICON_18.getIconWidth() / (double)Math.max(w, h);
            return ImageLoader.scaleImage(icon, s);
        }
        return icon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ImageLoader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 21: 
            case 24: 
            case 27: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 5: 
            case 7: 
            case 22: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scaleContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalUserSize";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 19: 
            case 29: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ImageLoader";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFromStream";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPng";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getImageDescriptors";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "scaleImage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isIconTooLargeForCache";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addFileNameVariant";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadRasterized";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadByDescriptor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getResourceData";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadPngFromClassResource";
                break;
            }
            case 12: 
            case 13: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "loadFromStream";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadPng";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "convertImage";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getImageDescriptors";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createImageDescriptorList";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "loadFromUrl";
                break;
            }
            case 29: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "scaleImage";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "loadFromResource";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "loadFromBytes";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "loadCustomIcon";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 34: 
            case 35: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Dimension2DDouble {
        private double myWidth;
        private double myHeight;

        public Dimension2DDouble(double width, double height) {
            this.myWidth = width;
            this.myHeight = height;
        }

        public void setSize(Dimension2DDouble size) {
            this.myWidth = size.myWidth;
            this.myHeight = size.myHeight;
        }

        public void setSize(double width, double height) {
            this.myWidth = width;
            this.myHeight = height;
        }

        public double getWidth() {
            return this.myWidth;
        }

        public double getHeight() {
            return this.myHeight;
        }
    }
}

