/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColorHexUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.MixedColorProducer;
import com.intellij.util.MathUtil;
import com.intellij.util.NotNullProducer;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColorUtil {
    private ColorUtil() {
    }

    @NotNull
    public static Color marker(final @NotNull String name) {
        if (name == null) {
            ColorUtil.$$$reportNull$$$0(0);
        }
        return new JBColor(() -> {
            throw new AssertionError((Object)name);
        }){

            @Override
            public boolean equals(Object obj) {
                return this == obj;
            }

            @Override
            public String toString() {
                return name;
            }
        };
    }

    @NotNull
    public static Color softer(@NotNull Color color) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(1);
        }
        if (color.getBlue() > 220 && color.getRed() > 220 && color.getGreen() > 220) {
            Color color2 = color;
            if (color2 == null) {
                ColorUtil.$$$reportNull$$$0(2);
            }
            return color2;
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        Color color3 = Color.getHSBColor(hsb[0], 0.6f * hsb[1], hsb[2]);
        if (color3 == null) {
            ColorUtil.$$$reportNull$$$0(3);
        }
        return color3;
    }

    @NotNull
    public static Color darker(@NotNull Color color, int tones) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(4);
        }
        return ColorUtil.hackBrightness(color, tones, 0.9090909f);
    }

    @NotNull
    public static Color brighter(@NotNull Color color, int tones) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(5);
        }
        return ColorUtil.hackBrightness(color, tones, 1.1f);
    }

    @NotNull
    public static Color hackBrightness(@NotNull Color color, int howMuch, float hackValue) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(6);
        }
        return ColorUtil.hackBrightness(color.getRed(), color.getGreen(), color.getBlue(), howMuch, hackValue);
    }

    @NotNull
    public static Color hackBrightness(int r, int g, int b, int howMuch, float hackValue) {
        float[] hsb = Color.RGBtoHSB(r, g, b, null);
        float brightness = hsb[2];
        for (int i = 0; i < howMuch && (brightness = MathUtil.clamp((float)(brightness * hackValue), (float)0.0f, (float)1.0f)) != 0.0f && brightness != 1.0f; ++i) {
        }
        Color color = Color.getHSBColor(hsb[0], hsb[1], brightness);
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(7);
        }
        return color;
    }

    @NotNull
    public static Color saturate(@NotNull Color color, int tones) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(8);
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float saturation = hsb[1];
        for (int i = 0; i < tones && (saturation = Math.min(1.0f, saturation * 1.1f)) != 1.0f; ++i) {
        }
        Color color2 = Color.getHSBColor(hsb[0], saturation, hsb[2]);
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(9);
        }
        return color2;
    }

    @NotNull
    public static Color desaturate(@NotNull Color color, int tones) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(10);
        }
        float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        float saturation = hsb[1];
        for (int i = 0; i < tones && (saturation = Math.max(0.0f, saturation / 1.1f)) != 0.0f; ++i) {
        }
        Color color2 = Color.getHSBColor(hsb[0], saturation, hsb[2]);
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(11);
        }
        return color2;
    }

    @NotNull
    public static Color dimmer(@NotNull Color color) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(12);
        }
        Color color2 = ColorUtil.wrap(color, (NotNullProducer<? extends Color>)((NotNullProducer)() -> {
            float[] rgb = color.getRGBColorComponents(null);
            float alpha = 0.8f;
            float rem = 1.0f - alpha;
            return new Color(rgb[0] * alpha + rem, rgb[1] * alpha + rem, rgb[2] * alpha + rem);
        }));
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(13);
        }
        return color2;
    }

    private static Color wrap(@NotNull Color color, NotNullProducer<? extends Color> func) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(14);
        }
        return color instanceof JBColor ? new JBColor(func) : (Color)func.produce();
    }

    private static int shift(int colorComponent, double d) {
        int n = (int)((double)colorComponent * d);
        return n > 255 ? 255 : Math.max(n, 0);
    }

    @NotNull
    public static Color shift(@NotNull Color c, double d) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(15);
        }
        NotNullProducer func = () -> new Color(ColorUtil.shift(c.getRed(), d), ColorUtil.shift(c.getGreen(), d), ColorUtil.shift(c.getBlue(), d), c.getAlpha());
        Color color = ColorUtil.wrap(c, (NotNullProducer<? extends Color>)func);
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(16);
        }
        return color;
    }

    @NotNull
    public static Color withAlpha(@NotNull Color c, double a) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(17);
        }
        return ColorUtil.toAlpha(c, (int)(255.0 * a));
    }

    @NotNull
    public static Color withPreAlpha(@NotNull Color c, double a) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(18);
        }
        float[] rgba = new float[4];
        rgba = ColorUtil.withAlpha(c, a).getRGBComponents(rgba);
        return new Color(rgba[0] * rgba[3], rgba[1] * rgba[3], rgba[2] * rgba[3], 1.0f);
    }

    @NotNull
    public static Color toAlpha(@Nullable Color color, int a) {
        Color c = color == null ? Color.black : color;
        NotNullProducer func = () -> new Color(c.getRed(), c.getGreen(), c.getBlue(), a);
        Color color2 = ColorUtil.wrap(c, (NotNullProducer<? extends Color>)func);
        if (color2 == null) {
            ColorUtil.$$$reportNull$$$0(19);
        }
        return color2;
    }

    @NotNull
    public static String toHex(@NotNull Color c) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(20);
        }
        return ColorUtil.toHex(c, false);
    }

    @NotNull
    public static String toHex(@NotNull Color c, boolean withAlpha) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(21);
        }
        String R = Integer.toHexString(c.getRed());
        String G = Integer.toHexString(c.getGreen());
        String B = Integer.toHexString(c.getBlue());
        String rgbHex = (R.length() < 2 ? "0" : "") + R + (G.length() < 2 ? "0" : "") + G + (B.length() < 2 ? "0" : "") + B;
        if (!withAlpha) {
            String string = rgbHex;
            if (string == null) {
                ColorUtil.$$$reportNull$$$0(22);
            }
            return string;
        }
        String A = Integer.toHexString(c.getAlpha());
        String string = rgbHex + (A.length() < 2 ? "0" : "") + A;
        if (string == null) {
            ColorUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String toHtmlColor(@NotNull Color c) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(24);
        }
        String string = "#" + ColorUtil.toHex(c);
        if (string == null) {
            ColorUtil.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    public static Color fromHex(@NotNull String str) {
        if (str == null) {
            ColorUtil.$$$reportNull$$$0(26);
        }
        Color color = ColorHexUtil.fromHex((String)str);
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(27);
        }
        return color;
    }

    @Nullable
    public static Color fromHex(@Nullable String str, @Nullable Color defaultValue) {
        return ColorHexUtil.fromHex((String)str, (Color)defaultValue);
    }

    public static boolean isDark(@NotNull Color c) {
        if (c == null) {
            ColorUtil.$$$reportNull$$$0(28);
        }
        return (ColorUtil.getLuminance(c) + 0.05) / 0.05 < 4.5;
    }

    public static boolean areContrasting(@NotNull Color c1, @NotNull Color c2) {
        if (c1 == null) {
            ColorUtil.$$$reportNull$$$0(29);
        }
        if (c2 == null) {
            ColorUtil.$$$reportNull$$$0(30);
        }
        return Double.compare(ColorUtil.getContrast(c1, c2), 4.5) >= 0;
    }

    public static double getContrast(@NotNull Color c1, @NotNull Color c2) {
        if (c1 == null) {
            ColorUtil.$$$reportNull$$$0(31);
        }
        if (c2 == null) {
            ColorUtil.$$$reportNull$$$0(32);
        }
        double l1 = ColorUtil.getLuminance(c1);
        double l2 = ColorUtil.getLuminance(c2);
        return (Math.max(l1, l2) + 0.05) / (Math.min(l2, l1) + 0.05);
    }

    public static double getLuminance(@NotNull Color color) {
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(33);
        }
        return ColorUtil.getLinearRGBComponentValue((double)color.getRed() / 255.0) * 0.2126 + ColorUtil.getLinearRGBComponentValue((double)color.getGreen() / 255.0) * 0.7152 + ColorUtil.getLinearRGBComponentValue((double)color.getBlue() / 255.0) * 0.0722;
    }

    private static double getLinearRGBComponentValue(double colorValue) {
        if (colorValue <= 0.03928) {
            return colorValue / 12.92;
        }
        return Math.pow((colorValue + 0.055) / 1.055, 2.4);
    }

    @NotNull
    public static Color mix(@NotNull Color c1, @NotNull Color c2, double balance) {
        if (c1 == null) {
            ColorUtil.$$$reportNull$$$0(34);
        }
        if (c2 == null) {
            ColorUtil.$$$reportNull$$$0(35);
        }
        if (balance <= 0.0) {
            Color color = c1;
            if (color == null) {
                ColorUtil.$$$reportNull$$$0(36);
            }
            return color;
        }
        if (balance >= 1.0) {
            Color color = c2;
            if (color == null) {
                ColorUtil.$$$reportNull$$$0(37);
            }
            return color;
        }
        MixedColorProducer func = new MixedColorProducer(c1, c2, balance);
        Color color = c1 instanceof JBColor || c2 instanceof JBColor ? new JBColor(func) : (Color)func.produce();
        if (color == null) {
            ColorUtil.$$$reportNull$$$0(38);
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 36: 
            case 37: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 36: 
            case 37: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ColorUtil";
                break;
            }
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 29: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 30: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ColorUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "softer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "hackBrightness";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "saturate";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "desaturate";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "dimmer";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "shift";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "toAlpha";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "toHex";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "toHtmlColor";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "fromHex";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "mix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "marker";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "softer";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 36: 
            case 37: 
            case 38: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "darker";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "brighter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hackBrightness";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "saturate";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "desaturate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "dimmer";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shift";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "withAlpha";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "withPreAlpha";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "toHex";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "toHtmlColor";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "fromHex";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isDark";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "areContrasting";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getContrast";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getLuminance";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "mix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 16: 
            case 19: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 36: 
            case 37: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

