/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.project.Project;
import java.util.ArrayDeque;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.Item;
import org.jetbrains.ide.SearchConfigurableByNameHelper;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J\b\u0010\u0017\u001a\u0004\u0018\u00010\u0014R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/ide/SearchConfigurableByNameHelper;", "", "name", "", "project", "Lcom/intellij/openapi/project/Project;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;)V", "rootGroup", "Lcom/intellij/openapi/options/ConfigurableGroup;", "(Ljava/lang/String;Lcom/intellij/openapi/options/ConfigurableGroup;)V", "names", "", "getRootGroup", "()Lcom/intellij/openapi/options/ConfigurableGroup;", "stack", "Ljava/util/ArrayDeque;", "Lorg/jetbrains/ide/Item;", "isMatched", "", "child", "Lcom/intellij/openapi/options/Configurable;", "parent", "processChildren", "searchByName", "intellij.platform.builtInServer.impl"})
public final class SearchConfigurableByNameHelper {
    private final List<String> names;
    private final ArrayDeque<Item> stack;
    @NotNull
    private final ConfigurableGroup rootGroup;

    @Nullable
    public final Configurable searchByName() {
        block1: {
            Item item;
            Configurable result2;
            this.stack.add(new Item((Configurable.Composite)this.rootGroup, null));
            do {
                if (this.stack.pollFirst() != null) continue;
                break block1;
            } while ((result2 = this.processChildren(item)) == null);
            return result2;
        }
        return null;
    }

    private final Configurable processChildren(Item parent) {
        for (Configurable child2 : parent.getConfigurable().getConfigurables()) {
            if (SearchUtil.isAcceptable(child2)) {
                Configurable configurable2 = child2;
                Intrinsics.checkNotNullExpressionValue((Object)configurable2, (String)"child");
                if (this.isMatched(configurable2, parent)) {
                    return child2;
                }
            }
            if (!(child2 instanceof Configurable.Composite)) continue;
            this.stack.add(new Item((Configurable.Composite)child2, parent));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isMatched(Configurable child2, Item parent) {
        if (this.names.size() > 1 && parent.getParent() == null) {
            return false;
        }
        if (!StringsKt.equals((String)((String)CollectionsKt.last(this.names)), (String)child2.getDisplayName(), (boolean)true)) {
            return false;
        }
        Item currentParent = parent;
        int n = this.names.size() - 2;
        boolean bl = false;
        while (n >= 0) {
            void i2;
            Configurable.Composite composite = currentParent.getConfigurable();
            if (composite == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.options.Configurable");
            }
            String currentName = ((Configurable)composite).getDisplayName();
            if (!StringsKt.equals((String)this.names.get((int)i2), (String)currentName, (boolean)true)) {
                return false;
            }
            if (currentParent.getParent() == null) {
                return false;
            }
            --i2;
        }
        return true;
    }

    @NotNull
    public final ConfigurableGroup getRootGroup() {
        return this.rootGroup;
    }

    public SearchConfigurableByNameHelper(@NotNull String name, @NotNull ConfigurableGroup rootGroup) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)rootGroup, (String)"rootGroup");
        this.rootGroup = rootGroup;
        this.names = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)StringsKt.splitToSequence$default((CharSequence)name, (String[])new String[]{"--", "|"}, (boolean)false, (int)0, (int)6, null), (Function1)names.1.INSTANCE));
        this.stack = new ArrayDeque();
    }

    public SearchConfigurableByNameHelper(@NotNull String name, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ConfigurableGroup configurableGroup = ConfigurableExtensionPointUtil.getConfigurableGroup(project, true);
        Intrinsics.checkNotNullExpressionValue((Object)configurableGroup, (String)"ConfigurableExtensionPoi\u2026rableGroup(project, true)");
        this(name, configurableGroup);
    }
}

