/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.xml.util.XmlStringUtil;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;

public final class RegExpReplacementUtil {
    private static final String DUMMY = "a";

    private RegExpReplacementUtil() {
    }

    public static void replaceInContext(@NotNull PsiElement element2, @NotNull String text2) {
        if (element2 == null) {
            RegExpReplacementUtil.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            RegExpReplacementUtil.$$$reportNull$$$0(1);
        }
        PsiFile file2 = element2.getContainingFile();
        text2 = RegExpReplacementUtil.escapeForContext(text2, file2);
        Document document = file2.getViewProvider().getDocument();
        assert (document != null);
        TextRange replaceRange = element2.getTextRange();
        document.replaceString(replaceRange.getStartOffset(), replaceRange.getEndOffset(), (CharSequence)text2);
    }

    private static String escapeForContext(String text2, PsiFile file2) {
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)file2.getProject());
        if (injectedLanguageManager.isInjectedFragment(file2)) {
            PsiElement copy2;
            PsiElement newElement;
            ElementManipulator manipulator;
            PsiElement context = file2.getContext();
            ElementManipulator elementManipulator = manipulator = context == null ? null : ElementManipulators.getManipulator((PsiElement)context);
            if (manipulator != null && (newElement = manipulator.handleContentChange(copy2 = context.copy(), DUMMY + text2)) != null) {
                String newElementText = newElement.getText();
                TextRange newRange = manipulator.getRangeInElement(newElement);
                return newElementText.substring(newRange.getStartOffset() + DUMMY.length(), newRange.getEndOffset());
            }
            if (RegExpElementImpl.isLiteralExpression(context)) {
                return StringUtil.escapeStringCharacters((String)text2);
            }
            if (context instanceof XmlElement) {
                return XmlStringUtil.escapeString((String)text2);
            }
        }
        return text2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "text";
                break;
            }
        }
        objectArray[1] = "org/intellij/lang/regexp/inspection/RegExpReplacementUtil";
        objectArray[2] = "replaceInContext";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

