/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.inspection.RegExpReplacementUtil;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EscapedMetaCharacterInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            EscapedMetaCharacterInspection.$$$reportNull$$$0(0);
        }
        return new EscapedMetaCharacterVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/EscapedMetaCharacterInspection", "buildVisitor"));
    }

    private static class EscapedMetaCharacterFix
    implements LocalQuickFix {
        private final char myC;

        EscapedMetaCharacterFix(char c) {
            this.myC = c;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{"[" + this.myC + "]"});
            if (string == null) {
                EscapedMetaCharacterFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = RegExpBundle.message("inspection.quick.fix.replace.with.character.inside.class", new Object[0]);
            if (string == null) {
                EscapedMetaCharacterFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element2;
            if (project == null) {
                EscapedMetaCharacterFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                EscapedMetaCharacterFix.$$$reportNull$$$0(3);
            }
            if (!((element2 = descriptor2.getPsiElement()) instanceof RegExpChar)) {
                return;
            }
            RegExpReplacementUtil.replaceInContext(element2, "[" + this.myC + "]");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/inspection/EscapedMetaCharacterInspection$EscapedMetaCharacterFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/inspection/EscapedMetaCharacterInspection$EscapedMetaCharacterFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class EscapedMetaCharacterVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        EscapedMetaCharacterVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpChar(RegExpChar ch) {
            if (ch.getType() != RegExpChar.Type.CHAR) {
                return;
            }
            String text2 = ch.getUnescapedText();
            if (text2.length() != 2 || text2.charAt(0) != '\\') {
                return;
            }
            char c = text2.charAt(1);
            if ("{}().*+?|$".indexOf(c) < 0) {
                return;
            }
            ASTNode node = ch.getNode().getFirstChildNode();
            if (node != null && node.getElementType() == RegExpTT.REDUNDANT_ESCAPE) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)ch, RegExpBundle.message("inspection.warning.escaped.meta.character.0", Character.valueOf(c)), new LocalQuickFix[]{new EscapedMetaCharacterFix(c)});
        }
    }
}

