/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.HashSet;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.inspection.RegExpEquivalenceChecker;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DuplicateAlternationBranchInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DuplicateAlternationBranchInspection.$$$reportNull$$$0(0);
        }
        return new DuplicateAlternationBranchVisitor(holder, isOnTheFly);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/DuplicateAlternationBranchInspection", "buildVisitor"));
    }

    private static class DuplicateAlternationBranchFix
    implements LocalQuickFix {
        private DuplicateAlternationBranchFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = RegExpBundle.message("inspection.quick.fix.remove.duplicate.branch", new Object[0]);
            if (string == null) {
                DuplicateAlternationBranchFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element2;
            if (project == null) {
                DuplicateAlternationBranchFix.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                DuplicateAlternationBranchFix.$$$reportNull$$$0(2);
            }
            if (!((element2 = descriptor2.getPsiElement()) instanceof RegExpBranch)) {
                return;
            }
            PsiElement prevSibling = element2.getPrevSibling();
            if (prevSibling != null) {
                prevSibling.delete();
            } else {
                PsiElement nextSibling = element2.getNextSibling();
                if (nextSibling != null) {
                    nextSibling.delete();
                }
            }
            element2.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/inspection/DuplicateAlternationBranchInspection$DuplicateAlternationBranchFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/inspection/DuplicateAlternationBranchInspection$DuplicateAlternationBranchFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DuplicateAlternationBranchVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;
        private final boolean myIsOnTheFly;

        DuplicateAlternationBranchVisitor(ProblemsHolder holder, boolean isOnTheFly) {
            this.myHolder = holder;
            this.myIsOnTheFly = isOnTheFly;
        }

        @Override
        public void visitRegExpPattern(RegExpPattern pattern) {
            RegExpBranch[] branches = pattern.getBranches();
            if (branches.length < 2) {
                return;
            }
            HashSet<RegExpBranch> reported = new HashSet<RegExpBranch>(2);
            for (int i2 = 0; i2 < branches.length - 1; ++i2) {
                RegExpBranch branch1 = branches[i2];
                if (branch1.getAtoms().length == 0) continue;
                for (int j = i2 + 1; j < branches.length; ++j) {
                    RegExpBranch branch2 = branches[j];
                    if (!RegExpEquivalenceChecker.areElementsEquivalent(branch1, branch2)) continue;
                    if (reported.add(branch1) && this.myIsOnTheFly) {
                        this.registerProblem(branch1);
                    }
                    if (!reported.add(branch2)) continue;
                    this.registerProblem(branch2);
                }
            }
        }

        private void registerProblem(RegExpBranch branch1) {
            this.myHolder.registerProblem((PsiElement)branch1, RegExpBundle.message("inspection.warning.duplicate.branch.in.alternation", new Object[0]), new LocalQuickFix[]{new DuplicateAlternationBranchFix()});
        }
    }
}

