/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.openapi.util.ClassExtension;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.Collections;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.psi.RegExpBoundary;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpConditional;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedCharacter;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RegExpLanguageHosts
extends ClassExtension<RegExpLanguageHost> {
    private static final RegExpLanguageHosts INSTANCE = new RegExpLanguageHosts();
    private final DefaultRegExpPropertiesProvider myDefaultProvider = DefaultRegExpPropertiesProvider.getInstance();

    public static RegExpLanguageHosts getInstance() {
        return INSTANCE;
    }

    private RegExpLanguageHosts() {
        super("com.intellij.regExpLanguageHost");
    }

    @Contract(value="null -> null")
    @Nullable
    private static RegExpLanguageHost findRegExpHost(@Nullable PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        PsiFile file2 = element2.getContainingFile();
        PsiElement context = file2.getContext();
        if (context instanceof RegExpLanguageHost) {
            return (RegExpLanguageHost)context;
        }
        if (context != null) {
            return (RegExpLanguageHost)INSTANCE.forClass(context.getClass());
        }
        return null;
    }

    public boolean isRedundantEscape(@NotNull RegExpChar ch, @NotNull String text2) {
        if (ch == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(1);
        }
        if (text2.length() <= 1) {
            return false;
        }
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(ch);
        if (host != null) {
            char c = text2.charAt(1);
            return !host.characterNeedsEscaping(c);
        }
        return !"\\]".equals(text2) && !"\\}".equals(text2);
    }

    public boolean supportsInlineOptionFlag(char flag, PsiElement context) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(context);
        return host == null || host.supportsInlineOptionFlag(flag, context);
    }

    public boolean supportsExtendedHexCharacter(@Nullable RegExpChar regExpChar) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(regExpChar);
        try {
            return host != null && host.supportsExtendedHexCharacter(regExpChar);
        }
        catch (AbstractMethodError e) {
            return false;
        }
    }

    public boolean supportsLiteralBackspace(@Nullable RegExpChar regExpChar) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(regExpChar);
        return host != null && host.supportsLiteralBackspace(regExpChar);
    }

    public boolean supportsPropertySyntax(@NotNull PsiElement context) {
        RegExpLanguageHost host;
        if (context == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(2);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(context)) != null && host.supportsPropertySyntax(context);
    }

    public boolean supportsNamedGroupSyntax(@Nullable RegExpGroup group2) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(group2);
        return host != null && host.supportsNamedGroupSyntax(group2);
    }

    public boolean supportsNamedGroupRefSyntax(@Nullable RegExpNamedGroupRef ref) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(ref);
        try {
            return host != null && host.supportsNamedGroupRefSyntax(ref);
        }
        catch (AbstractMethodError e) {
            return false;
        }
    }

    public Collection<RegExpGroup.Type> getSupportedNamedGroupTypes(RegExpElement context) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(context);
        if (host == null) {
            return Collections.emptySet();
        }
        return host.getSupportedNamedGroupTypes(context);
    }

    public boolean isValidGroupName(String name, @Nullable RegExpGroup group2) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(group2);
        return host != null && host.isValidGroupName(name, group2);
    }

    public boolean supportsPerl5EmbeddedComments(@Nullable PsiComment comment) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost((PsiElement)comment);
        return host != null && host.supportsPerl5EmbeddedComments();
    }

    public boolean supportsConditionals(@Nullable RegExpConditional conditional) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(conditional);
        return host != null && host.supportsPythonConditionalRefs();
    }

    public boolean supportsPossessiveQuantifiers(@Nullable RegExpElement context) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(context);
        return host == null || host.supportsPossessiveQuantifiers();
    }

    public boolean supportsBoundary(@Nullable RegExpBoundary boundary) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(boundary);
        return host == null || host.supportsBoundary(boundary);
    }

    public boolean supportsSimpleClass(@Nullable RegExpSimpleClass simpleClass) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(simpleClass);
        return host == null || host.supportsSimpleClass(simpleClass);
    }

    public boolean isValidCategory(@NotNull PsiElement element2, @NotNull String category) {
        RegExpLanguageHost host;
        if (element2 == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(3);
        }
        if (category == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(4);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(element2)) != null ? host.isValidCategory(category) : this.myDefaultProvider.isValidCategory(category);
    }

    public boolean isValidPropertyName(@NotNull PsiElement element2, @NotNull String type) {
        RegExpLanguageHost host;
        if (element2 == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(5);
        }
        if (type == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(6);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(element2)) == null || host.isValidPropertyName(type);
    }

    public boolean isValidPropertyValue(@NotNull PsiElement element2, @NotNull String propertyName, @NotNull String propertyValue) {
        RegExpLanguageHost host;
        if (element2 == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(7);
        }
        if (propertyName == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(8);
        }
        if (propertyValue == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(9);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(element2)) == null || host.isValidPropertyValue(propertyName, propertyValue);
    }

    public boolean supportsNamedCharacters(@NotNull RegExpNamedCharacter namedCharacter) {
        RegExpLanguageHost host;
        if (namedCharacter == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(10);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(namedCharacter)) != null && host.supportsNamedCharacters(namedCharacter);
    }

    public boolean isValidNamedCharacter(@NotNull RegExpNamedCharacter namedCharacter) {
        RegExpLanguageHost host;
        if (namedCharacter == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(11);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(namedCharacter)) != null && host.isValidNamedCharacter(namedCharacter);
    }

    public RegExpLanguageHost.Lookbehind supportsLookbehind(RegExpGroup group2) {
        RegExpLanguageHost host = RegExpLanguageHosts.findRegExpHost(group2);
        if (host == null) {
            return RegExpLanguageHost.Lookbehind.FULL;
        }
        return host.supportsLookbehind(group2);
    }

    @Nullable
    public Number getQuantifierValue(@NotNull RegExpNumber valueElement) {
        RegExpLanguageHost host;
        if (valueElement == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(12);
        }
        if ((host = RegExpLanguageHosts.findRegExpHost(valueElement)) == null) {
            return Double.valueOf(valueElement.getText());
        }
        return host.getQuantifierValue(valueElement);
    }

    public String[] @NotNull [] getAllKnownProperties(@NotNull PsiElement element2) {
        RegExpLanguageHost host;
        if (element2 == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(13);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(element2)) != null ? host.getAllKnownProperties() : this.myDefaultProvider.getAllKnownProperties();
    }

    public String[] @NotNull [] getAllPropertyValues(@NotNull PsiElement element2, @NotNull String propertyName) {
        RegExpLanguageHost host;
        if (element2 == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(14);
        }
        if (propertyName == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(15);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(element2)) != null ? host.getAllPropertyValues(propertyName) : RegExpLanguageHost.EMPTY_COMPLETION_ITEMS_ARRAY;
    }

    @Nullable
    String getPropertyDescription(@NotNull PsiElement element2, @Nullable String name) {
        RegExpLanguageHost host;
        if (element2 == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(16);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(element2)) != null ? host.getPropertyDescription(name) : this.myDefaultProvider.getPropertyDescription(name);
    }

    String[] @NotNull [] getKnownCharacterClasses(@NotNull PsiElement element2) {
        RegExpLanguageHost host;
        if (element2 == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(17);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(element2)) != null ? host.getKnownCharacterClasses() : this.myDefaultProvider.getKnownCharacterClasses();
    }

    String[][] getPosixCharacterClasses(@NotNull PsiElement element2) {
        if (element2 == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(18);
        }
        return this.myDefaultProvider.getPosixCharacterClasses();
    }

    public boolean belongsToConditionalExpression(@NotNull PsiElement regexpElement, @NotNull PsiElement hostElement) {
        RegExpLanguageHost host;
        if (regexpElement == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(19);
        }
        if (hostElement == null) {
            RegExpLanguageHosts.$$$reportNull$$$0(20);
        }
        return (host = RegExpLanguageHosts.findRegExpHost(regexpElement)) != null && host.belongsToConditionalExpression(hostElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ch";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyValue";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedCharacter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueElement";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regexpElement";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostElement";
                break;
            }
        }
        objectArray2[1] = "org/intellij/lang/regexp/RegExpLanguageHosts";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isRedundantEscape";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsPropertySyntax";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidCategory";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidPropertyName";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidPropertyValue";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "supportsNamedCharacters";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidNamedCharacter";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getQuantifierValue";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllKnownProperties";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllPropertyValues";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getPropertyDescription";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "getKnownCharacterClasses";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "getPosixCharacterClasses";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "belongsToConditionalExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

