/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.impl.IdeVirtualFileUrlManagerImpl;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlIndex;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000G\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007*\u0001\u0011\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0007J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0018H\u0016J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001d\u001a\u00020\u0016H\u0016J\b\u0010\u001e\u001a\u00020\u0014H\u0007R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/intellij/workspaceModel/ide/impl/IdeVirtualFileUrlManagerImpl;", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "filePointerManager", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointerManager;", "kotlin.jvm.PlatformType", "projectDisposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "rootsValidityChangedListener", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointerListener;", "getRootsValidityChangedListener", "()Lcom/intellij/openapi/vfs/pointers/VirtualFilePointerListener;", "testDisposable", "virtualFilePointerListener", "com/intellij/workspaceModel/ide/impl/IdeVirtualFileUrlManagerImpl$virtualFilePointerListener$1", "Lcom/intellij/workspaceModel/ide/impl/IdeVirtualFileUrlManagerImpl$virtualFilePointerListener$1;", "disposePointersCreatedInTest", "", "fromDirUrl", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "url", "", "fromPath", "path", "fromUrl", "getParentVirtualUrl", "vfu", "startTrackPointersCreatedInTest", "intellij.platform.workspaceModel.ide"})
public final class IdeVirtualFileUrlManagerImpl
implements VirtualFileUrlManager {
    private Disposable testDisposable;
    private Disposable projectDisposable;
    private final VirtualFilePointerManager filePointerManager;
    private final virtualFilePointerListener.1 virtualFilePointerListener;
    private final Project project;

    private final VirtualFilePointerListener getRootsValidityChangedListener() {
        ProjectRootManagerImpl projectRootManagerImpl = ProjectRootManagerImpl.getInstanceImpl(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)projectRootManagerImpl), (String)"ProjectRootManagerImpl.getInstanceImpl(project)");
        VirtualFilePointerListener virtualFilePointerListener2 = projectRootManagerImpl.getRootsValidityChangedListener();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFilePointerListener2, (String)"ProjectRootManagerImpl.g\u2026tsValidityChangedListener");
        return virtualFilePointerListener2;
    }

    @Override
    @NotNull
    public VirtualFileUrl fromUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Disposable disposable2 = this.testDisposable;
        if (disposable2 == null) {
            disposable2 = this.projectDisposable;
        }
        VirtualFilePointer virtualFilePointer = this.filePointerManager.create(url, disposable2, (VirtualFilePointerListener)this.virtualFilePointerListener);
        if (virtualFilePointer == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.url.VirtualFileUrl");
        }
        return (VirtualFileUrl)virtualFilePointer;
    }

    @NotNull
    public final VirtualFileUrl fromDirUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Disposable disposable2 = this.testDisposable;
        if (disposable2 == null) {
            disposable2 = this.projectDisposable;
        }
        VirtualFilePointer virtualFilePointer = this.filePointerManager.createDirectoryPointer(url, true, disposable2, (VirtualFilePointerListener)this.virtualFilePointerListener);
        if (virtualFilePointer == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.url.VirtualFileUrl");
        }
        return (VirtualFileUrl)virtualFilePointer;
    }

    @Override
    @NotNull
    public VirtualFileUrl fromPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = FileUtil.toSystemIndependentName((String)path);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.toSystemIndependentName(path)");
        String systemIndependentName = string;
        return this.fromUrl("file://" + systemIndependentName);
    }

    @Override
    @Nullable
    public VirtualFileUrl getParentVirtualUrl(@NotNull VirtualFileUrl vfu) {
        Intrinsics.checkNotNullParameter((Object)vfu, (String)"vfu");
        String url = vfu.getUrl();
        Path path = VirtualFileUrlManagerUtil.toPath(vfu).getParent();
        if (path == null) {
            return null;
        }
        Path parent = path;
        int protocolEnd = StringsKt.indexOf$default((CharSequence)url, (String)"://", (int)0, (boolean)false, (int)6, null);
        if (protocolEnd == -1) {
            return null;
        }
        String string = url;
        int n = 0;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, protocolEnd);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String protocol = string3;
        String string4 = FileUtil.toSystemIndependentName((String)((Object)parent).toString());
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"FileUtil.toSystemIndepen\u2026ntName(parent.toString())");
        String systemIndependentName = string4;
        return this.fromUrl(protocol + "://" + systemIndependentName);
    }

    @TestOnly
    public final void startTrackPointersCreatedInTest() {
        this.testDisposable = Disposer.newDisposable((String)"VirtualFileUrlManager");
    }

    @TestOnly
    public final void disposePointersCreatedInTest() {
        if (this.testDisposable != null) {
            Disposable disposable2 = this.testDisposable;
            Intrinsics.checkNotNull((Object)disposable2);
            Disposer.dispose((Disposable)disposable2);
            this.testDisposable = null;
        }
    }

    public IdeVirtualFileUrlManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Disposable disposable2 = Disposer.newDisposable((Disposable)((Disposable)this.project), (String)"VirtualFileUrlManager");
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"Disposer.newDisposable(p\u2026 \"VirtualFileUrlManager\")");
        this.projectDisposable = disposable2;
        this.filePointerManager = VirtualFilePointerManager.getInstance();
        this.virtualFilePointerListener = new VirtualFilePointerListener(this){
            final /* synthetic */ IdeVirtualFileUrlManagerImpl this$0;

            public void beforeValidityChanged(@NotNull VirtualFilePointer[] pointers) {
                Intrinsics.checkNotNullParameter((Object)pointers, (String)"pointers");
                if (IdeVirtualFileUrlManagerImpl.access$getProject$p(this.this$0).isDisposed()) {
                    return;
                }
                if (!this.isValidRootsChangedForWorkspaceModel(pointers)) {
                    return;
                }
                IdeVirtualFileUrlManagerImpl.access$getRootsValidityChangedListener$p(this.this$0).beforeValidityChanged(pointers);
            }

            public void validityChanged(@NotNull VirtualFilePointer[] pointers) {
                Intrinsics.checkNotNullParameter((Object)pointers, (String)"pointers");
                if (IdeVirtualFileUrlManagerImpl.access$getProject$p(this.this$0).isDisposed()) {
                    return;
                }
                if (!this.isValidRootsChangedForWorkspaceModel(pointers)) {
                    return;
                }
                IdeVirtualFileUrlManagerImpl.access$getRootsValidityChangedListener$p(this.this$0).validityChanged(pointers);
            }

            private final boolean isValidRootsChangedForWorkspaceModel(VirtualFilePointer[] pointers) {
                WorkspaceEntityStorage entityStorage = WorkspaceModel.Companion.getInstance(IdeVirtualFileUrlManagerImpl.access$getProject$p(this.this$0)).getEntityStorage().getCurrent();
                VirtualFileUrlIndex virtualFileUrlIndex = entityStorage.getVirtualFileUrlIndex();
                VirtualFilePointer[] virtualFilePointerArray = pointers;
                int n = virtualFilePointerArray.length;
                for (int j = 0; j < n; ++j) {
                    VirtualFilePointer pointer;
                    VirtualFilePointer virtualFilePointer = pointer = virtualFilePointerArray[j];
                    if (virtualFilePointer == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.workspaceModel.storage.url.VirtualFileUrl");
                    }
                    if (!virtualFileUrlIndex.findEntitiesByUrl((VirtualFileUrl)virtualFilePointer).iterator().hasNext()) continue;
                    return true;
                }
                return false;
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    public static final /* synthetic */ Project access$getProject$p(IdeVirtualFileUrlManagerImpl $this) {
        return $this.project;
    }

    public static final /* synthetic */ VirtualFilePointerListener access$getRootsValidityChangedListener$p(IdeVirtualFileUrlManagerImpl $this) {
        return $this.getRootsValidityChangedListener();
    }
}

