/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TabbedPane;
import com.intellij.ui.TabbedPaneImpl;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.UIBundle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.tabs.PinToolwindowTabAction;
import com.intellij.ui.content.tabs.TabbedContentAction;
import com.intellij.util.IJSwingUtilities;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.MenuSelectionManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class TabbedPaneContentUI
implements ContentUI,
PropertyChangeListener {
    @NonNls
    public static final String POPUP_PLACE = "TabbedPanePopup";
    private ContentManager myManager;
    private final TabbedPaneWrapper myTabbedPaneWrapper;

    public TabbedPaneContentUI() {
        this(3);
    }

    public TabbedPaneContentUI(int tabPlacement) {
        this.myTabbedPaneWrapper = new MyTabbedPaneWrapper(tabPlacement);
    }

    public JComponent getComponent() {
        return this.myTabbedPaneWrapper.getComponent();
    }

    public void setManager(@NotNull ContentManager manager) {
        if (manager == null) {
            TabbedPaneContentUI.$$$reportNull$$$0(0);
        }
        if (this.myManager != null) {
            throw new IllegalStateException();
        }
        this.myManager = manager;
        this.myManager.addContentManagerListener((ContentManagerListener)new MyContentManagerListener());
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Content content2;
        int index;
        if ("displayName".equals(e.getPropertyName())) {
            Content content3 = (Content)e.getSource();
            int index2 = this.myTabbedPaneWrapper.indexOfComponent(content3.getComponent());
            if (index2 != -1) {
                this.myTabbedPaneWrapper.setTitleAt(index2, content3.getTabName());
            }
        } else if ("description".equals(e.getPropertyName())) {
            Content content4 = (Content)e.getSource();
            int index3 = this.myTabbedPaneWrapper.indexOfComponent(content4.getComponent());
            if (index3 != -1) {
                this.myTabbedPaneWrapper.setToolTipTextAt(index3, content4.getDescription());
            }
        } else if ("component".equals(e.getPropertyName())) {
            Content content5 = (Content)e.getSource();
            JComponent oldComponent = (JComponent)e.getOldValue();
            int index4 = this.myTabbedPaneWrapper.indexOfComponent(oldComponent);
            if (index4 != -1) {
                boolean hasFocus = IJSwingUtilities.hasFocus2(oldComponent);
                this.myTabbedPaneWrapper.setComponentAt(index4, content5.getComponent());
                if (hasFocus) {
                    content5.getComponent().requestDefaultFocus();
                }
            }
        } else if ("icon".equals(e.getPropertyName()) && (index = this.myTabbedPaneWrapper.indexOfComponent((content2 = (Content)e.getSource()).getComponent())) != -1) {
            this.myTabbedPaneWrapper.setIconAt(index, (Icon)e.getNewValue());
        }
    }

    private Content getSelectedContent() {
        JComponent selectedComponent = this.myTabbedPaneWrapper.getSelectedComponent();
        return selectedComponent == null ? null : this.myManager.getContent(selectedComponent);
    }

    public boolean isSingleSelection() {
        return true;
    }

    public boolean isToSelectAddedContent() {
        return false;
    }

    public boolean canBeEmptySelection() {
        return false;
    }

    public boolean canChangeSelectionTo(@NotNull Content content2, boolean implicit) {
        if (content2 == null) {
            TabbedPaneContentUI.$$$reportNull$$$0(1);
        }
        return true;
    }

    @NotNull
    public String getCloseActionName() {
        String string = UIBundle.message((String)"tabbed.pane.close.tab.action.name", (Object[])new Object[0]);
        if (string == null) {
            TabbedPaneContentUI.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getCloseAllButThisActionName() {
        String string = UIBundle.message((String)"tabbed.pane.close.all.tabs.but.this.action.name", (Object[])new Object[0]);
        if (string == null) {
            TabbedPaneContentUI.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getPreviousContentActionName() {
        String string = IdeBundle.message((String)"action.text.select.previous.tab", (Object[])new Object[0]);
        if (string == null) {
            TabbedPaneContentUI.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getNextContentActionName() {
        String string = IdeBundle.message((String)"action.text.select.next.tab", (Object[])new Object[0]);
        if (string == null) {
            TabbedPaneContentUI.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/content/TabbedPaneContentUI";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/content/TabbedPaneContentUI";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloseActionName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCloseAllButThisActionName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousContentActionName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextContentActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setManager";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canChangeSelectionTo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyContentManagerListener
    implements ContentManagerListener {
        private MyContentManagerListener() {
        }

        public void contentAdded(@NotNull ContentManagerEvent event) {
            if (event == null) {
                MyContentManagerListener.$$$reportNull$$$0(0);
            }
            Content content2 = event.getContent();
            TabbedPaneContentUI.this.myTabbedPaneWrapper.insertTab(content2.getTabName(), content2.getIcon(), content2.getComponent(), content2.getDescription(), event.getIndex());
            content2.addPropertyChangeListener((PropertyChangeListener)TabbedPaneContentUI.this);
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            if (event == null) {
                MyContentManagerListener.$$$reportNull$$$0(1);
            }
            event.getContent().removePropertyChangeListener((PropertyChangeListener)TabbedPaneContentUI.this);
            TabbedPaneContentUI.this.myTabbedPaneWrapper.removeTabAt(event.getIndex());
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            int index;
            if (event == null) {
                MyContentManagerListener.$$$reportNull$$$0(2);
            }
            if ((index = event.getIndex()) != -1 && event.getOperation() != ContentManagerEvent.ContentOperation.remove) {
                TabbedPaneContentUI.this.myTabbedPaneWrapper.setSelectedIndex(index);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/ui/content/TabbedPaneContentUI$MyContentManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyTabbedPaneWrapper
    extends TabbedPaneWrapper.AsJTabbedPane {
        MyTabbedPaneWrapper(int tabPlacement) {
            super(tabPlacement);
        }

        @Override
        protected TabbedPane createTabbedPane(int tabPlacement) {
            return new MyTabbedPane(tabPlacement);
        }

        @Override
        protected TabbedPaneWrapper.TabbedPaneHolder createTabbedPaneHolder() {
            return new MyTabbedPaneHolder(this);
        }

        private final class MyTabbedPaneHolder
        extends TabbedPaneWrapper.TabbedPaneHolder
        implements DataProvider {
            private MyTabbedPaneHolder(TabbedPaneWrapper wrapper2) {
                super(wrapper2);
            }

            public Object getData(@NotNull String dataId) {
                if (dataId == null) {
                    MyTabbedPaneHolder.$$$reportNull$$$0(0);
                }
                if (PlatformDataKeys.CONTENT_MANAGER.is(dataId)) {
                    return TabbedPaneContentUI.this.myManager;
                }
                if (PlatformDataKeys.NONEMPTY_CONTENT_MANAGER.is(dataId) && TabbedPaneContentUI.this.myManager.getContentCount() > 1) {
                    return TabbedPaneContentUI.this.myManager;
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/ui/content/TabbedPaneContentUI$MyTabbedPaneWrapper$MyTabbedPaneHolder", "getData"));
            }
        }

        private class MyTabbedPane
        extends TabbedPaneImpl {
            MyTabbedPane(int tabPlacement) {
                super(tabPlacement);
                this.addMouseListener((MouseListener)((Object)new MyPopupHandler()));
                this.enableEvents(16L);
            }

            private void closeTabAt(int x, int y) {
                TabbedPaneUI ui = this.getUI();
                int index = ui.tabForCoordinate((JTabbedPane)((Object)this), x, y);
                if (index < 0 || !TabbedPaneContentUI.this.myManager.canCloseContents()) {
                    return;
                }
                Content content2 = TabbedPaneContentUI.this.myManager.getContent(index);
                if (content2 != null && content2.isCloseable()) {
                    TabbedPaneContentUI.this.myManager.removeContent(content2, true);
                }
            }

            private void hideMenu() {
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                menuSelectionManager.clearSelectedPath();
            }

            protected void processMouseEvent(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showPopup(e.getX(), e.getY());
                    return;
                }
                if (!e.isShiftDown() && (0x10 & e.getModifiers()) > 0) {
                    if (502 == e.getID()) {
                        TabbedPaneUI ui = this.getUI();
                        int index = ui.tabForCoordinate((JTabbedPane)((Object)this), e.getX(), e.getY());
                        if (index != -1) {
                            this.setSelectedIndex(index);
                            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)MyTabbedPaneWrapper.this.getComponent(), true));
                        }
                        this.hideMenu();
                    }
                } else if (e.isShiftDown() && (0x10 & e.getModifiers()) > 0) {
                    if (502 == e.getID()) {
                        this.closeTabAt(e.getX(), e.getY());
                        this.hideMenu();
                    }
                } else if ((8 & e.getModifiers()) > 0) {
                    if (502 == e.getID()) {
                        this.closeTabAt(e.getX(), e.getY());
                        this.hideMenu();
                    }
                } else if ((4 & e.getModifiers()) <= 0 || !SystemInfo.isWindows) {
                    super.processMouseEvent(e);
                }
            }

            protected ChangeListener createChangeListener() {
                return new MyModelListener();
            }

            private Content getContentAt(int x, int y) {
                TabbedPaneUI ui = this.getUI();
                int index = ui.tabForCoordinate((JTabbedPane)((Object)this), x, y);
                if (index < 0) {
                    return null;
                }
                return TabbedPaneContentUI.this.myManager.getContent(index);
            }

            private void showPopup(int x, int y) {
                Content content2 = this.getContentAt(x, y);
                if (content2 == null) {
                    return;
                }
                DefaultActionGroup group2 = new DefaultActionGroup();
                group2.add((AnAction)new TabbedContentAction.CloseAction(content2));
                if (TabbedPaneContentUI.this.myTabbedPaneWrapper.getTabCount() > 1) {
                    group2.add((AnAction)new TabbedContentAction.CloseAllAction(TabbedPaneContentUI.this.myManager));
                    group2.add((AnAction)new TabbedContentAction.CloseAllButThisAction(content2));
                }
                group2.addSeparator();
                group2.add(PinToolwindowTabAction.getPinAction());
                group2.addSeparator();
                group2.add((AnAction)new TabbedContentAction.MyNextTabAction(TabbedPaneContentUI.this.myManager));
                group2.add((AnAction)new TabbedContentAction.MyPreviousTabAction(TabbedPaneContentUI.this.myManager));
                List additionalActions = TabbedPaneContentUI.this.myManager.getAdditionalPopupActions(content2);
                if (!additionalActions.isEmpty()) {
                    group2.addSeparator();
                    group2.addAll((Collection)additionalActions);
                }
                ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu(TabbedPaneContentUI.POPUP_PLACE, (ActionGroup)group2);
                menu.getComponent().show(TabbedPaneContentUI.this.myTabbedPaneWrapper.getComponent(), x, y);
            }

            protected class MyPopupHandler
            extends PopupHandler {
                protected MyPopupHandler() {
                }

                public void invokePopup(Component comp, int x, int y) {
                    if (TabbedPaneContentUI.this.myManager.getContentCount() == 0) {
                        return;
                    }
                    MyTabbedPane.this.showPopup(x, y);
                }
            }

            private class MyModelListener
            extends JTabbedPane.ModelListener {
                private MyModelListener() {
                    super((JTabbedPane)((Object)MyTabbedPane.this));
                }

                @Override
                public void stateChanged(ChangeEvent e) {
                    Content content2 = TabbedPaneContentUI.this.getSelectedContent();
                    if (content2 != null) {
                        TabbedPaneContentUI.this.myManager.setSelectedContent(content2);
                    }
                    super.stateChanged(e);
                }
            }
        }
    }
}

