/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.util.Key;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubSerializationUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectStubTree<T extends Stub> {
    private static final Key<ObjectStubTree<?>> STUB_TO_TREE_REFERENCE = Key.create((String)"stub to tree reference");
    protected final ObjectStubBase<?> myRoot;
    private String myDebugInfo;
    private boolean myHasBackReference;
    private final List<T> myPlainList;

    public ObjectStubTree(@NotNull ObjectStubBase<?> root, boolean withBackReference) {
        if (root == null) {
            ObjectStubTree.$$$reportNull$$$0(0);
        }
        this.myRoot = root;
        this.myPlainList = this.enumerateStubs((Stub)root);
        if (withBackReference) {
            this.myRoot.putUserData(STUB_TO_TREE_REFERENCE, (Object)this);
        }
    }

    @NotNull
    public Stub getRoot() {
        ObjectStubBase<?> objectStubBase = this.myRoot;
        if (objectStubBase == null) {
            ObjectStubTree.$$$reportNull$$$0(1);
        }
        return objectStubBase;
    }

    @NotNull
    public List<T> getPlainList() {
        List<T> list2 = this.myPlainList;
        if (list2 == null) {
            ObjectStubTree.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    List<T> getPlainListFromAllRoots() {
        List<T> list2 = this.getPlainList();
        if (list2 == null) {
            ObjectStubTree.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Deprecated
    @ApiStatus.Internal
    @NotNull
    public Map<StubIndexKey<?, ?>, Map<Object, int[]>> indexStubTree() {
        Map<StubIndexKey<?, ?>, Map<Object, int[]>> map2 = this.indexStubTree(key -> ContainerUtil.canonicalStrategy());
        if (map2 == null) {
            ObjectStubTree.$$$reportNull$$$0(4);
        }
        return map2;
    }

    @ApiStatus.Internal
    @NotNull
    public Map<StubIndexKey<?, ?>, Map<Object, int[]>> indexStubTree(@NotNull Function<StubIndexKey<?, ?>, TObjectHashingStrategy<?>> keyHashingStrategyFunction) {
        if (keyHashingStrategyFunction == null) {
            ObjectStubTree.$$$reportNull$$$0(5);
        }
        StubIndexSink sink = new StubIndexSink(keyHashingStrategyFunction);
        List<T> plainList = this.getPlainListFromAllRoots();
        int plainListSize = plainList.size();
        for (int i2 = 0; i2 < plainListSize; ++i2) {
            Stub stub = (Stub)plainList.get(i2);
            sink.myStubIdx = i2;
            StubSerializationUtil.getSerializer((Stub)stub).indexStub(stub, (IndexSink)sink);
        }
        Map<StubIndexKey<?, ?>, Map<Object, int[]>> map2 = sink.getResult();
        if (map2 == null) {
            ObjectStubTree.$$$reportNull$$$0(6);
        }
        return map2;
    }

    @NotNull
    protected List<T> enumerateStubs(@NotNull Stub root) {
        if (root == null) {
            ObjectStubTree.$$$reportNull$$$0(7);
        }
        ArrayList result2 = new ArrayList();
        ObjectStubTree.enumerateStubsInto(root, result2);
        ArrayList arrayList = result2;
        if (arrayList == null) {
            ObjectStubTree.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static void enumerateStubsInto(@NotNull Stub root, @NotNull List<? super Stub> result2) {
        if (root == null) {
            ObjectStubTree.$$$reportNull$$$0(9);
        }
        if (result2 == null) {
            ObjectStubTree.$$$reportNull$$$0(10);
        }
        ((ObjectStubBase)root).id = result2.size();
        result2.add((Stub)root);
        List childrenStubs = root.getChildrenStubs();
        for (int i2 = 0; i2 < childrenStubs.size(); ++i2) {
            Stub child2 = (Stub)childrenStubs.get(i2);
            ObjectStubTree.enumerateStubsInto(child2, result2);
        }
    }

    public void setDebugInfo(@NotNull @NonNls String info) {
        ObjectStubTree ref;
        if (info == null) {
            ObjectStubTree.$$$reportNull$$$0(11);
        }
        if ((ref = ObjectStubTree.getStubTree(this.myRoot)) != null) assert (ref == this);
        this.myHasBackReference = ref != null;
        this.myDebugInfo = info;
    }

    @Nullable
    public static ObjectStubTree getStubTree(@NotNull ObjectStubBase root) {
        if (root == null) {
            ObjectStubTree.$$$reportNull$$$0(12);
        }
        return (ObjectStubTree)root.getUserData(STUB_TO_TREE_REFERENCE);
    }

    @NonNls
    public String getDebugInfo() {
        return this.myHasBackReference ? this.myDebugInfo + "; with backReference" : this.myDebugInfo;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{myDebugInfo='" + this.getDebugInfo() + '\'' + ", myRoot=" + this.myRoot + '}' + this.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/ObjectStubTree";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyHashingStrategyFunction";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/ObjectStubTree";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlainList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlainListFromAllRoots";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "indexStubTree";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "enumerateStubs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "indexStubTree";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "enumerateStubs";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "enumerateStubsInto";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setDebugInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getStubTree";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class StubIndexSink
    implements IndexSink,
    TObjectProcedure<Map<Object, int[]>>,
    TObjectObjectProcedure<Object, int[]> {
        private final THashMap<StubIndexKey<?, ?>, Map<Object, int[]>> myResult;
        private final Function<StubIndexKey<?, ?>, TObjectHashingStrategy<?>> myHashingStrategyFunction;
        private int myStubIdx;
        private Map<Object, int[]> myProcessingMap;

        private StubIndexSink(@NotNull Function<StubIndexKey<?, ?>, TObjectHashingStrategy<?>> hashingStrategyFunction) {
            if (hashingStrategyFunction == null) {
                StubIndexSink.$$$reportNull$$$0(0);
            }
            this.myResult = new THashMap();
            this.myHashingStrategyFunction = hashingStrategyFunction;
        }

        public void occurrence(@NotNull StubIndexKey indexKey, @NotNull Object value2) {
            int[] list2;
            Map map2;
            if (indexKey == null) {
                StubIndexSink.$$$reportNull$$$0(1);
            }
            if (value2 == null) {
                StubIndexSink.$$$reportNull$$$0(2);
            }
            if ((map2 = (Map)this.myResult.get((Object)indexKey)) == null) {
                map2 = new THashMap(this.myHashingStrategyFunction.apply(indexKey));
                this.myResult.put((Object)indexKey, (Object)map2);
            }
            if ((list2 = (int[])map2.get(value2)) == null) {
                map2.put(value2, new int[]{this.myStubIdx});
            } else {
                int lastNonZero = ArrayUtil.lastIndexOfNot((int[])list2, (int)0);
                if (lastNonZero >= 0 && list2[lastNonZero] == this.myStubIdx) {
                    return;
                }
                int lastZero = lastNonZero + 1;
                if (lastZero == list2.length) {
                    list2 = ArrayUtil.realloc((int[])list2, (int)Math.max(4, list2.length << 1));
                    map2.put(value2, list2);
                }
                list2[lastZero] = this.myStubIdx;
            }
        }

        @NotNull
        public Map<StubIndexKey<?, ?>, Map<Object, int[]>> getResult() {
            this.myResult.forEachValue((TObjectProcedure)this);
            THashMap<StubIndexKey<?, ?>, Map<Object, int[]>> tHashMap = this.myResult;
            if (tHashMap == null) {
                StubIndexSink.$$$reportNull$$$0(3);
            }
            return tHashMap;
        }

        public boolean execute(Map<Object, int[]> object) {
            this.myProcessingMap = object;
            ((THashMap)object).forEachEntry((TObjectObjectProcedure)this);
            return true;
        }

        public boolean execute(Object a, int[] b) {
            if (b.length == 1) {
                return true;
            }
            int firstZero = ArrayUtil.indexOf((int[])b, (int)0);
            if (firstZero != -1) {
                int[] shorterList = ArrayUtil.realloc((int[])b, (int)firstZero);
                this.myProcessingMap.put(a, shorterList);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hashingStrategyFunction";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexKey";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/stubs/ObjectStubTree$StubIndexSink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/stubs/ObjectStubTree$StubIndexSink";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "occurrence";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

