/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModelEx;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiBasedFormattingModel
implements FormattingModelEx {
    private static final Logger LOG = Logger.getInstance(PsiBasedFormattingModel.class);
    private final Project myProject;
    private final ASTNode myASTNode;
    private final FormattingDocumentModelImpl myDocumentModel;
    @NotNull
    private final Block myRootBlock;
    protected boolean myCanModifyAllWhiteSpaces;

    public PsiBasedFormattingModel(PsiFile file2, @NotNull Block rootBlock, FormattingDocumentModelImpl documentModel) {
        if (rootBlock == null) {
            PsiBasedFormattingModel.$$$reportNull$$$0(0);
        }
        this.myCanModifyAllWhiteSpaces = false;
        this.myASTNode = SourceTreeToPsiMap.psiElementToTree((PsiElement)file2);
        this.myDocumentModel = documentModel;
        this.myRootBlock = rootBlock;
        this.myProject = file2.getProject();
    }

    public TextRange replaceWhiteSpace(TextRange textRange, String whiteSpace) {
        return this.replaceWhiteSpace(textRange, null, whiteSpace);
    }

    public TextRange replaceWhiteSpace(TextRange textRange, ASTNode nodeAfter, String whiteSpace) {
        String whiteSpaceToUse = this.myDocumentModel.adjustWhiteSpaceIfNecessary(whiteSpace, textRange.getStartOffset(), textRange.getEndOffset(), nodeAfter, true).toString();
        String wsReplaced = this.replaceWithPSI(textRange, whiteSpaceToUse);
        if (wsReplaced != null) {
            return new TextRange(textRange.getStartOffset(), textRange.getStartOffset() + wsReplaced.length());
        }
        return textRange;
    }

    public TextRange shiftIndentInsideRange(ASTNode node, TextRange textRange, int shift) {
        return textRange;
    }

    public void commitChanges() {
    }

    @Nullable
    private String replaceWithPSI(TextRange textRange, String whiteSpace) {
        int offset = textRange.getEndOffset();
        ASTNode leafElement = this.findElementAt(offset);
        if (leafElement != null) {
            PsiFile hostFile = this.myASTNode.getPsi().getContainingFile();
            TextRange effectiveRange = textRange;
            List injections = InjectedLanguageManager.getInstance((Project)hostFile.getProject()).getCachedInjectedDocumentsInRange(hostFile, TextRange.from((int)offset, (int)0));
            if (!injections.isEmpty()) {
                TextRange corrected;
                PsiFile injectedElement = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile((Document)injections.get(0));
                PsiLanguageInjectionHost host = InjectedLanguageUtilBase.findInjectionHost((PsiElement)injectedElement);
                TextRange textRange2 = corrected = host == null ? null : PsiBasedFormattingModel.correctRangeByInjection(textRange, host);
                if (corrected != null) {
                    effectiveRange = corrected;
                }
            }
            if (leafElement.getPsi() instanceof PsiFile) {
                return null;
            }
            LOG.assertTrue(leafElement.getPsi().isValid());
            return this.replaceWithPsiInLeaf(effectiveRange, whiteSpace, leafElement);
        }
        if (textRange.getEndOffset() == this.myASTNode.getTextLength()) {
            CodeStyleManager.getInstance((Project)this.myProject).performActionWithFormatterDisabled(() -> FormatterUtil.replaceLastWhiteSpace(this.myASTNode, whiteSpace, textRange));
            return whiteSpace;
        }
        return null;
    }

    private static TextRange correctRangeByInjection(TextRange textRange, PsiLanguageInjectionHost host) {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)host);
        if (manipulator == null) {
            return null;
        }
        TextRange injectionRangeInHost = manipulator.getRangeInElement((PsiElement)host);
        int hostStartOffset = host.getTextRange().getStartOffset();
        int injectedDocumentStartOffset = hostStartOffset + injectionRangeInHost.getStartOffset();
        int injectedDocumentEndOffset = hostStartOffset + injectionRangeInHost.getEndOffset();
        if (textRange.getEndOffset() < injectedDocumentStartOffset || textRange.getStartOffset() > injectedDocumentEndOffset) {
            return null;
        }
        return textRange.shiftLeft(injectedDocumentStartOffset);
    }

    @Nullable
    protected String replaceWithPsiInLeaf(TextRange textRange, String whiteSpace, ASTNode leafElement) {
        if (!this.myCanModifyAllWhiteSpaces && leafElement.getElementType() == TokenType.WHITE_SPACE) {
            return null;
        }
        CodeStyleManager.getInstance((Project)this.myProject).performActionWithFormatterDisabled(() -> FormatterUtil.replaceWhiteSpace(whiteSpace, leafElement, TokenType.WHITE_SPACE, textRange));
        return whiteSpace;
    }

    @Nullable
    protected ASTNode findElementAt(int offset) {
        PsiElement psiElement;
        PsiFile containingFile = this.myASTNode.getPsi().getContainingFile();
        Project project = containingFile.getProject();
        assert (!PsiDocumentManager.getInstance((Project)project).isUncommited(this.myDocumentModel.getDocument()));
        PsiElement psiElement2 = psiElement = project.isDefault() ? null : InjectedLanguageManager.getInstance((Project)containingFile.getProject()).findInjectedElementAt(containingFile, offset);
        if (psiElement != null) {
            return psiElement.getNode();
        }
        psiElement = containingFile.findElementAt(offset);
        return psiElement != null ? psiElement.getNode() : null;
    }

    @NotNull
    public FormattingDocumentModel getDocumentModel() {
        FormattingDocumentModelImpl formattingDocumentModelImpl = this.myDocumentModel;
        if (formattingDocumentModelImpl == null) {
            PsiBasedFormattingModel.$$$reportNull$$$0(1);
        }
        return formattingDocumentModelImpl;
    }

    @NotNull
    public Block getRootBlock() {
        Block block = this.myRootBlock;
        if (block == null) {
            PsiBasedFormattingModel.$$$reportNull$$$0(2);
        }
        return block;
    }

    public void canModifyAllWhiteSpaces() {
        this.myCanModifyAllWhiteSpaces = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootBlock";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/PsiBasedFormattingModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/PsiBasedFormattingModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

