/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.customFrameDecorations.header;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.wm.impl.customFrameDecorations.CustomFrameTitleButtons;
import com.intellij.openapi.wm.impl.customFrameDecorations.ResizableCustomFrameTitleButtons;
import com.intellij.openapi.wm.impl.customFrameDecorations.header.CustomHeader;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.util.ui.JBFont;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0010\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u0014H\u0002J\b\u0010\u001e\u001a\u00020\u0014H\u0002J\b\u0010\u001f\u001a\u00020\u0014H\u0002J\b\u0010 \u001a\u00020\u0014H\u0002J\b\u0010!\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/FrameHeader;", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/header/CustomHeader;", "frame", "Ljavax/swing/JFrame;", "(Ljavax/swing/JFrame;)V", "getFrame", "()Ljavax/swing/JFrame;", "myIconifyAction", "Ljavax/swing/Action;", "myMaximizeAction", "myRestoreAction", "myState", "", "getMyState", "()I", "setMyState", "(I)V", "windowStateListener", "Ljava/awt/event/WindowStateListener;", "addMenuItems", "", "menu", "Ljavax/swing/JPopupMenu;", "addNotify", "createButtonsPane", "Lcom/intellij/openapi/wm/impl/customFrameDecorations/CustomFrameTitleButtons;", "getHitTestSpots", "Ljava/util/ArrayList;", "Lcom/intellij/ui/awt/RelativeRectangle;", "iconify", "maximize", "restore", "updateActions", "windowStateChanged", "intellij.platform.ide.impl"})
public class FrameHeader
extends CustomHeader {
    private final Action myIconifyAction;
    private final Action myRestoreAction;
    private final Action myMaximizeAction;
    private WindowStateListener windowStateListener;
    private int myState;
    @NotNull
    private final JFrame frame;

    protected final int getMyState() {
        return this.myState;
    }

    protected final void setMyState(int n) {
        this.myState = n;
    }

    @Override
    @NotNull
    public CustomFrameTitleButtons createButtonsPane() {
        return ResizableCustomFrameTitleButtons.Companion.create(this.getMyCloseAction(), this.myRestoreAction, this.myIconifyAction, this.myMaximizeAction);
    }

    @Override
    public void windowStateChanged() {
        super.windowStateChanged();
        this.updateActions();
    }

    private final void iconify() {
        this.frame.setExtendedState(this.myState | 1);
    }

    private final void maximize() {
        this.frame.setExtendedState(this.myState | 6);
    }

    private final void restore() {
        if ((this.myState & 1) != 0) {
            this.frame.setExtendedState(this.myState & ~1);
        } else {
            this.frame.setExtendedState(this.myState & ~6);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateActions();
    }

    private final void updateActions() {
        this.myState = this.frame.getExtendedState();
        if (this.frame.isResizable()) {
            if ((this.myState & 6) != 0) {
                this.myMaximizeAction.setEnabled(false);
                this.myRestoreAction.setEnabled(true);
            } else {
                this.myMaximizeAction.setEnabled(true);
                this.myRestoreAction.setEnabled(false);
            }
        } else {
            this.myMaximizeAction.setEnabled(false);
            this.myRestoreAction.setEnabled(false);
        }
        this.myIconifyAction.setEnabled(true);
        this.getMyCloseAction().setEnabled(true);
        this.getButtonPanes().updateVisibility();
        this.updateCustomDecorationHitTestSpots();
    }

    @Override
    public void addMenuItems(@NotNull JPopupMenu menu) {
        JMenuItem closeMenuItem;
        Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
        menu.add(this.myRestoreAction);
        menu.add(this.myIconifyAction);
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            menu.add(this.myMaximizeAction);
        }
        menu.add(new JSeparator());
        JMenuItem jMenuItem = closeMenuItem = menu.add(this.getMyCloseAction());
        Intrinsics.checkNotNullExpressionValue((Object)jMenuItem, (String)"closeMenuItem");
        jMenuItem.setFont(JBFont.label().deriveFont(1));
    }

    @NotNull
    public ArrayList<RelativeRectangle> getHitTestSpots() {
        ArrayList<RelativeRectangle> hitTestSpots = new ArrayList<RelativeRectangle>();
        hitTestSpots.add(new RelativeRectangle(this.getProductIcon()));
        hitTestSpots.add(new RelativeRectangle(this.getButtonPanes().getView()));
        return hitTestSpots;
    }

    @NotNull
    public final JFrame getFrame() {
        return this.frame;
    }

    public FrameHeader(@NotNull JFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        super(frame);
        this.frame = frame;
        String string = ActionsBundle.message((String)"action.MinimizeCurrentWindow.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ActionsBundle.message(\"a\u2026imizeCurrentWindow.text\")");
        Icon icon2 = AllIcons.Windows.MinimizeSmall;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.Windows.MinimizeSmall");
        this.myIconifyAction = new CustomHeader.CustomFrameAction(string, icon2, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ FrameHeader this$0;

            public final void invoke() {
                FrameHeader.access$iconify(this.this$0);
            }
            {
                this.this$0 = frameHeader;
                super(0);
            }
        }));
        String string2 = CommonBundle.message((String)"button.without.mnemonic.restore", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"CommonBundle.message(\"bu\u2026ithout.mnemonic.restore\")");
        Icon icon3 = AllIcons.Windows.RestoreSmall;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"AllIcons.Windows.RestoreSmall");
        this.myRestoreAction = new CustomHeader.CustomFrameAction(string2, icon3, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ FrameHeader this$0;

            public final void invoke() {
                FrameHeader.access$restore(this.this$0);
            }
            {
                this.this$0 = frameHeader;
                super(0);
            }
        }));
        String string3 = IdeBundle.message((String)"action.maximize.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"IdeBundle.message(\"action.maximize.text\")");
        Icon icon4 = AllIcons.Windows.MaximizeSmall;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"AllIcons.Windows.MaximizeSmall");
        this.myMaximizeAction = new CustomHeader.CustomFrameAction(string3, icon4, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ FrameHeader this$0;

            public final void invoke() {
                FrameHeader.access$maximize(this.this$0);
            }
            {
                this.this$0 = frameHeader;
                super(0);
            }
        }));
        this.windowStateListener = new WindowAdapter(){

            @Override
            public void windowStateChanged(@Nullable WindowEvent e) {
                this.updateActions();
            }
        };
    }

    public static final /* synthetic */ void access$iconify(FrameHeader $this) {
        $this.iconify();
    }

    public static final /* synthetic */ void access$restore(FrameHeader $this) {
        $this.restore();
    }

    public static final /* synthetic */ void access$maximize(FrameHeader $this) {
        $this.maximize();
    }
}

