/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.impl.Stripe;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImplKt;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Container;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.JdkConstants;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000l\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u001c\u0010\u0014\u001a\u00020\f2\b\b\u0001\u0010\u0015\u001a\u00020\b2\b\b\u0001\u0010\u0016\u001a\u00020\bH\u0002\u001a\"\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002\u001a\u001a\u0010#\u001a\u00020\f2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0002\u001a\u0010\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\bH\u0003\u001a\u0010\u0010*\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0007\u001a\u00020\b8CX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\r\u00a8\u0006+"}, d2={"ACTIVE_ATTR_VALUE", "", "EDITOR_ELEMENT", "LAYOUT_TO_RESTORE", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "activateToolWindowVKsMask", "", "getActivateToolWindowVKsMask", "()I", "isStackEnabled", "", "()Z", "addStripeButton", "", "button", "Lcom/intellij/openapi/wm/impl/StripeButton;", "stripe", "Lcom/intellij/openapi/wm/impl/Stripe;", "areAllModifiersPressed", "modifiers", "mask", "findIconFromBean", "Ljavax/swing/Icon;", "bean", "Lcom/intellij/openapi/wm/ToolWindowEP;", "factory", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "getRootBounds", "Ljava/awt/Rectangle;", "frame", "Ljavax/swing/JFrame;", "isInActiveToolWindow", "component", "", "activeToolWindow", "Lcom/intellij/openapi/wm/impl/ToolWindowImpl;", "keyCodeToInputMask", "code", "removeStripeButton", "intellij.platform.ide.impl"})
public final class ToolWindowManagerImplKt {
    private static final Logger LOG;
    private static final String EDITOR_ELEMENT = "editor";
    private static final String ACTIVE_ATTR_VALUE = "active";
    private static final String LAYOUT_TO_RESTORE = "layout-to-restore";

    private static final boolean areAllModifiersPressed(@JdkConstants.InputEventMask int modifiers, @JdkConstants.InputEventMask int mask) {
        return (modifiers ^ mask) == 0;
    }

    @JdkConstants.InputEventMask
    private static final int keyCodeToInputMask(int code) {
        int n;
        switch (code) {
            case 16: {
                n = 1;
                break;
            }
            case 17: {
                n = 2;
                break;
            }
            case 157: {
                n = 4;
                break;
            }
            case 18: {
                n = 8;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @JdkConstants.InputEventMask
    private static final int getActivateToolWindowVKsMask() {
        if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
            return 0;
        }
        if (Registry.is((String)"toolwindow.disable.overlay.by.double.key")) {
            return 0;
        }
        KeymapManager keymapManager2 = KeymapManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)keymapManager2, (String)"KeymapManager.getInstance()");
        Keymap keymap2 = keymapManager2.getActiveKeymap();
        Intrinsics.checkNotNullExpressionValue((Object)keymap2, (String)"KeymapManager.getInstance().activeKeymap");
        Keymap keymap3 = keymap2;
        Shortcut[] baseShortcut = keymap3.getShortcuts("ActivateProjectToolWindow");
        int baseModifiers = SystemInfo.isMac ? 4 : 8;
        for (Shortcut each : baseShortcut) {
            KeyStroke keyStroke;
            if (!(each instanceof KeyboardShortcut)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)((KeyboardShortcut)each).getFirstKeyStroke(), (String)"each.firstKeyStroke");
            baseModifiers = keyStroke.getModifiers();
            if (baseModifiers > 0) break;
        }
        return baseModifiers & 0xF;
    }

    private static final boolean isStackEnabled() {
        return Registry.is((String)"ide.enable.toolwindow.stack");
    }

    private static final Rectangle getRootBounds(JFrame frame) {
        JRootPane rootPane;
        JRootPane jRootPane = rootPane = frame.getRootPane();
        Intrinsics.checkNotNullExpressionValue((Object)jRootPane, (String)"rootPane");
        Rectangle bounds2 = jRootPane.getBounds();
        bounds2.setLocation(frame.getX() + rootPane.getX(), frame.getY() + rootPane.getY());
        Rectangle rectangle = bounds2;
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"bounds");
        return rectangle;
    }

    private static final boolean isInActiveToolWindow(Object component2, ToolWindowImpl activeToolWindow) {
        JComponent source = component2 instanceof JComponent ? (JComponent)component2 : null;
        JComponent activeToolWindowComponent = activeToolWindow.getComponentIfInitialized();
        if (activeToolWindowComponent != null) {
            while (source != null && source != activeToolWindowComponent) {
                JComponent jComponent;
                if (source.getParent() != null && source.getParent() instanceof JComponent) {
                    Container container = source.getParent();
                    if (container == null) {
                        throw new NullPointerException("null cannot be cast to non-null type javax.swing.JComponent");
                    }
                    jComponent = (JComponent)container;
                } else {
                    jComponent = null;
                }
                source = jComponent;
            }
        }
        return source != null;
    }

    private static final Icon findIconFromBean(ToolWindowEP bean, ToolWindowFactory factory2, PluginDescriptor pluginDescriptor) {
        try {
            String string = bean.icon;
            if (string == null) {
                return null;
            }
            return IconLoader.findIcon((String)string, factory2.getClass(), (ClassLoader)pluginDescriptor.getPluginClassLoader(), null, (boolean)true);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return EmptyIcon.ICON_13;
        }
    }

    private static final void addStripeButton(StripeButton button2, Stripe stripe) {
        stripe.addButton(button2, addStripeButton.1.INSTANCE);
    }

    private static final void removeStripeButton(StripeButton button2) {
        block1: {
            Container container = button2.getParent();
            if (!(container instanceof Stripe)) {
                container = null;
            }
            Stripe stripe = (Stripe)container;
            if (stripe == null) break block1;
            stripe.removeButton(button2);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ToolWindowManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ boolean access$isInActiveToolWindow(Object component2, ToolWindowImpl activeToolWindow) {
        return ToolWindowManagerImplKt.isInActiveToolWindow(component2, activeToolWindow);
    }

    public static final /* synthetic */ int access$getActivateToolWindowVKsMask$p() {
        return ToolWindowManagerImplKt.getActivateToolWindowVKsMask();
    }

    public static final /* synthetic */ int access$keyCodeToInputMask(int code) {
        return ToolWindowManagerImplKt.keyCodeToInputMask(code);
    }

    public static final /* synthetic */ boolean access$areAllModifiersPressed(int modifiers, int mask) {
        return ToolWindowManagerImplKt.areAllModifiersPressed(modifiers, mask);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ Icon access$findIconFromBean(ToolWindowEP bean, ToolWindowFactory factory2, PluginDescriptor pluginDescriptor) {
        return ToolWindowManagerImplKt.findIconFromBean(bean, factory2, pluginDescriptor);
    }

    public static final /* synthetic */ boolean access$isStackEnabled$p() {
        return ToolWindowManagerImplKt.isStackEnabled();
    }

    public static final /* synthetic */ void access$addStripeButton(StripeButton button2, Stripe stripe) {
        ToolWindowManagerImplKt.addStripeButton(button2, stripe);
    }

    public static final /* synthetic */ void access$removeStripeButton(StripeButton button2) {
        ToolWindowManagerImplKt.removeStripeButton(button2);
    }

    public static final /* synthetic */ Rectangle access$getRootBounds(JFrame frame) {
        return ToolWindowManagerImplKt.getRootBounds(frame);
    }
}

