/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.diff.DiffApplicationSettings;
import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffManager;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.LineStatusMarkerDrawUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ex.LineStatusMarkerPopupPanel;
import com.intellij.openapi.vcs.ex.LineStatusMarkerRenderer;
import com.intellij.openapi.vcs.ex.LineStatusTrackerBase;
import com.intellij.openapi.vcs.ex.LineStatusTrackerI;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LineStatusMarkerPopupRenderer
extends LineStatusMarkerRenderer {
    @Deprecated
    public LineStatusMarkerPopupRenderer(@NotNull LineStatusTrackerBase<?> tracker2) {
        if (tracker2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(0);
        }
        this((LineStatusTrackerI<?>)tracker2);
    }

    public LineStatusMarkerPopupRenderer(@NotNull LineStatusTrackerI<?> tracker2) {
        if (tracker2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(1);
        }
        super(tracker2);
    }

    @Override
    protected boolean canDoAction(@NotNull Editor editor, @NotNull List<? extends Range> ranges, @NotNull MouseEvent e) {
        if (editor == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(2);
        }
        if (ranges == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(3);
        }
        if (e == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(4);
        }
        return LineStatusMarkerDrawUtil.isInsideMarkerArea(e);
    }

    @Override
    protected void doAction(@NotNull Editor editor, @NotNull List<? extends Range> ranges, @NotNull MouseEvent e) {
        if (editor == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(5);
        }
        if (ranges == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(6);
        }
        if (e == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(7);
        }
        Range range2 = ranges.get(0);
        if (ranges.size() > 1) {
            this.scrollAndShow(editor, range2);
        } else {
            this.showHint(editor, range2, e);
        }
    }

    @NotNull
    protected abstract List<AnAction> createToolbarActions(@NotNull Editor var1, @NotNull Range var2, @Nullable Point var3);

    @NotNull
    protected FileType getFileType() {
        VirtualFile virtualFile = this.myTracker.getVirtualFile();
        PlainTextFileType plainTextFileType = virtualFile != null ? virtualFile.getFileType() : PlainTextFileType.INSTANCE;
        if (plainTextFileType == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(8);
        }
        return plainTextFileType;
    }

    @Nullable
    protected JComponent createAdditionalInfoPanel(@NotNull Editor editor, @NotNull Range range2, @Nullable Point mousePosition, @NotNull Disposable disposable2) {
        if (editor == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(9);
        }
        if (range2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(10);
        }
        if (disposable2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(11);
        }
        return null;
    }

    public void scrollAndShow(@NotNull Editor editor, @NotNull Range range2) {
        if (editor == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(12);
        }
        if (range2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(13);
        }
        if (!this.myTracker.isValid()) {
            return;
        }
        LineStatusMarkerPopupRenderer.moveToRange(editor, range2);
        this.showAfterScroll(editor, range2);
    }

    public static void moveToRange(@NotNull Editor editor, @NotNull Range range2) {
        if (editor == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(14);
        }
        if (range2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(15);
        }
        Document document = editor.getDocument();
        int targetLine = !range2.hasLines() ? range2.getLine2() : range2.getLine2() - 1;
        int line = Math.min(targetLine, DiffUtil.getLineCount(document) - 1);
        int lastOffset = document.getLineStartOffset(line);
        editor.getCaretModel().moveToOffset(lastOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
    }

    public void showAfterScroll(@NotNull Editor editor, @NotNull Range range2) {
        if (editor == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(16);
        }
        if (range2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(17);
        }
        editor.getScrollingModel().runActionOnScrollingFinished(() -> this.reopenRange(editor, range2, null));
    }

    public void showHint(@NotNull Editor editor, @NotNull Range range2, @NotNull MouseEvent e) {
        if (editor == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(18);
        }
        if (range2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(19);
        }
        if (e == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(20);
        }
        JComponent comp = (JComponent)e.getComponent();
        JLayeredPane layeredPane = comp.getRootPane().getLayeredPane();
        Point point = SwingUtilities.convertPoint(comp, ((EditorEx)editor).getGutterComponentEx().getWidth(), e.getY(), layeredPane);
        this.showHintAt(editor, range2, point);
        e.consume();
    }

    public void showHintAt(@NotNull Editor editor, @NotNull Range range2, @Nullable Point mousePosition) {
        if (editor == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(21);
        }
        if (range2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(22);
        }
        if (!this.myTracker.isValid()) {
            return;
        }
        Disposable disposable2 = Disposer.newDisposable();
        JComponent editorComponent = null;
        if (range2.hasVcsLines()) {
            String content2 = this.getVcsContent(range2).toString();
            EditorTextField textField2 = LineStatusMarkerPopupPanel.createTextField(editor, content2);
            LineStatusMarkerPopupPanel.installBaseEditorSyntaxHighlighters(this.myTracker.getProject(), textField2, this.myTracker.getVcsDocument(), this.getVcsTextRange(range2), this.getFileType());
            this.installWordDiff(editor, textField2, range2, disposable2);
            editorComponent = LineStatusMarkerPopupPanel.createEditorComponent(editor, textField2);
        }
        List<AnAction> actions = this.createToolbarActions(editor, range2, mousePosition);
        ActionToolbar toolbar = LineStatusMarkerPopupPanel.buildToolbar(editor, actions, disposable2);
        JComponent additionalInfoPanel = this.createAdditionalInfoPanel(editor, range2, mousePosition, disposable2);
        LineStatusMarkerPopupPanel.showPopupAt(editor, toolbar, editorComponent, additionalInfoPanel, mousePosition, disposable2, null);
    }

    protected void reopenRange(@NotNull Editor editor, @NotNull Range range2, @Nullable Point mousePosition) {
        Object newRange;
        if (editor == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(23);
        }
        if (range2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(24);
        }
        if ((newRange = this.myTracker.findRange(range2)) != null) {
            this.showHintAt(editor, (Range)newRange, mousePosition);
        } else {
            HintManagerImpl.getInstanceImpl().hideHints(32, false, false);
        }
    }

    private void installWordDiff(@NotNull Editor editor, @NotNull EditorTextField textField2, @NotNull Range range2, @NotNull Disposable disposable2) {
        if (editor == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(25);
        }
        if (textField2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(26);
        }
        if (range2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(27);
        }
        if (disposable2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(28);
        }
        if (!DiffApplicationSettings.getInstance().SHOW_LST_WORD_DIFFERENCES) {
            return;
        }
        if (!range2.hasLines() || !range2.hasVcsLines()) {
            return;
        }
        CharSequence vcsContent = this.getVcsContent(range2);
        CharSequence currentContent = this.getCurrentContent(range2);
        int currentStartOffset = this.getCurrentTextRange(range2).getStartOffset();
        List wordDiff = (List)BackgroundTaskUtil.tryComputeFast(indicator -> ByWord.compare(vcsContent, currentContent, ComparisonPolicy.DEFAULT, indicator), 200L);
        if (wordDiff == null) {
            return;
        }
        LineStatusMarkerPopupPanel.installMasterEditorWordHighlighters(editor, currentStartOffset, wordDiff, disposable2);
        LineStatusMarkerPopupPanel.installPopupEditorWordHighlighters(textField2, wordDiff);
    }

    @NotNull
    private CharSequence getCurrentContent(Range range2) {
        CharSequence charSequence = DiffUtil.getLinesContent(this.myTracker.getDocument(), range2.getLine1(), range2.getLine2());
        if (charSequence == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(29);
        }
        return charSequence;
    }

    @NotNull
    private CharSequence getVcsContent(Range range2) {
        CharSequence charSequence = DiffUtil.getLinesContent(this.myTracker.getVcsDocument(), range2.getVcsLine1(), range2.getVcsLine2());
        if (charSequence == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(30);
        }
        return charSequence;
    }

    @NotNull
    private TextRange getCurrentTextRange(@NotNull Range range2) {
        if (range2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(31);
        }
        TextRange textRange = DiffUtil.getLinesRange(this.myTracker.getDocument(), range2.getLine1(), range2.getLine2());
        if (textRange == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(32);
        }
        return textRange;
    }

    @NotNull
    private TextRange getVcsTextRange(@NotNull Range range2) {
        if (range2 == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(33);
        }
        TextRange textRange = DiffUtil.getLinesRange(this.myTracker.getVcsDocument(), range2.getVcsLine1(), range2.getVcsLine2());
        if (textRange == null) {
            LineStatusMarkerPopupRenderer.$$$reportNull$$$0(34);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 29: 
            case 30: 
            case 32: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 29: 
            case 30: 
            case 32: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tracker";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 4: 
            case 7: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 8: 
            case 29: 
            case 30: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer";
                break;
            }
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 27: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 11: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentContent";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsContent";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentTextRange";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getVcsTextRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canDoAction";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doAction";
                break;
            }
            case 8: 
            case 29: 
            case 30: 
            case 32: 
            case 34: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalInfoPanel";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "scrollAndShow";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "moveToRange";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showAfterScroll";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "showHintAt";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "reopenRange";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "installWordDiff";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentTextRange";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getVcsTextRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 29: 
            case 30: 
            case 32: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class ToggleByWordDiffAction
    extends ToggleAction
    implements DumbAware,
    LightEditCompatible {
        @NotNull
        private final Editor myEditor;
        @NotNull
        private final Range myRange;
        @Nullable
        private final Point myMousePosition;

        public ToggleByWordDiffAction(@NotNull Editor editor, @Nullable Range range2, Point position) {
            if (editor == null) {
                ToggleByWordDiffAction.$$$reportNull$$$0(0);
            }
            if (range2 == null) {
                ToggleByWordDiffAction.$$$reportNull$$$0(1);
            }
            super(DiffBundle.message((String)"highlight.words", (Object[])new Object[0]), null, AllIcons.Actions.Highlighting);
            this.myEditor = editor;
            this.myRange = range2;
            this.myMousePosition = position;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleByWordDiffAction.$$$reportNull$$$0(2);
            }
            return DiffApplicationSettings.getInstance().SHOW_LST_WORD_DIFFERENCES;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ToggleByWordDiffAction.$$$reportNull$$$0(3);
            }
            if (!LineStatusMarkerPopupRenderer.this.myTracker.isValid()) {
                return;
            }
            DiffApplicationSettings.getInstance().SHOW_LST_WORD_DIFFERENCES = state;
            LineStatusMarkerPopupRenderer.this.reopenRange(this.myEditor, this.myRange, this.myMousePosition);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer$ToggleByWordDiffAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class ShowLineStatusRangeDiffAction
    extends RangeMarkerAction
    implements LightEditCompatible {
        public ShowLineStatusRangeDiffAction(@NotNull Editor editor, Range range2) {
            if (editor == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(0);
            }
            if (range2 == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(1);
            }
            super(editor, range2, "Diff.ShowDiff");
        }

        @Override
        protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range2) {
            if (editor == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(2);
            }
            if (range2 == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(3);
            }
            return true;
        }

        @Override
        protected void actionPerformed(@NotNull Editor editor, @NotNull Range range2) {
            if (editor == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(4);
            }
            if (range2 == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(5);
            }
            Range ourRange = this.expand(range2, LineStatusMarkerPopupRenderer.this.myTracker.getDocument(), LineStatusMarkerPopupRenderer.this.myTracker.getVcsDocument());
            DiffContent vcsContent = this.createDiffContent(LineStatusMarkerPopupRenderer.this.myTracker.getVcsDocument(), LineStatusMarkerPopupRenderer.this.myTracker.getVirtualFile(), LineStatusMarkerPopupRenderer.this.getVcsTextRange(ourRange));
            DiffContent currentContent = this.createDiffContent(LineStatusMarkerPopupRenderer.this.myTracker.getDocument(), LineStatusMarkerPopupRenderer.this.myTracker.getVirtualFile(), LineStatusMarkerPopupRenderer.this.getCurrentTextRange(ourRange));
            SimpleDiffRequest request = new SimpleDiffRequest(DiffBundle.message((String)"dialog.title.diff.for.range", (Object[])new Object[0]), vcsContent, currentContent, DiffBundle.message((String)"diff.content.title.up.to.date", (Object[])new Object[0]), DiffBundle.message((String)"diff.content.title.current.range", (Object[])new Object[0]));
            DiffManager.getInstance().showDiff(LineStatusMarkerPopupRenderer.this.myTracker.getProject(), (DiffRequest)request);
        }

        @NotNull
        private DiffContent createDiffContent(@NotNull Document document, @Nullable VirtualFile highlightFile, @NotNull TextRange textRange) {
            if (document == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(6);
            }
            if (textRange == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(7);
            }
            Project project = LineStatusMarkerPopupRenderer.this.myTracker.getProject();
            DocumentContent content2 = DiffContentFactory.getInstance().create(project, document, highlightFile);
            DocumentContent documentContent = DiffContentFactory.getInstance().createFragment(project, content2, textRange);
            if (documentContent == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(8);
            }
            return documentContent;
        }

        @NotNull
        private Range expand(@NotNull Range range2, @NotNull Document document, @NotNull Document uDocument) {
            if (range2 == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(9);
            }
            if (document == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(10);
            }
            if (uDocument == null) {
                ShowLineStatusRangeDiffAction.$$$reportNull$$$0(11);
            }
            boolean canExpandBefore = range2.getLine1() != 0 && range2.getVcsLine1() != 0;
            boolean canExpandAfter = range2.getLine2() < DiffUtil.getLineCount(document) && range2.getVcsLine2() < DiffUtil.getLineCount(uDocument);
            int offset1 = range2.getLine1() - (canExpandBefore ? 1 : 0);
            int uOffset1 = range2.getVcsLine1() - (canExpandBefore ? 1 : 0);
            int offset2 = range2.getLine2() + (canExpandAfter ? 1 : 0);
            int uOffset2 = range2.getVcsLine2() + (canExpandAfter ? 1 : 0);
            return new Range(offset1, offset2, uOffset1, uOffset2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textRange";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer$ShowLineStatusRangeDiffAction";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uDocument";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer$ShowLineStatusRangeDiffAction";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDiffContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isEnabled";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createDiffContent";
                    break;
                }
                case 8: {
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "expand";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class CopyLineStatusRangeAction
    extends RangeMarkerAction
    implements LightEditCompatible {
        public CopyLineStatusRangeAction(@NotNull Editor editor, Range range2) {
            if (editor == null) {
                CopyLineStatusRangeAction.$$$reportNull$$$0(0);
            }
            if (range2 == null) {
                CopyLineStatusRangeAction.$$$reportNull$$$0(1);
            }
            super(editor, range2, "$Copy");
        }

        @Override
        protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range2) {
            if (editor == null) {
                CopyLineStatusRangeAction.$$$reportNull$$$0(2);
            }
            if (range2 == null) {
                CopyLineStatusRangeAction.$$$reportNull$$$0(3);
            }
            return range2.hasVcsLines();
        }

        @Override
        protected void actionPerformed(@NotNull Editor editor, @NotNull Range range2) {
            if (editor == null) {
                CopyLineStatusRangeAction.$$$reportNull$$$0(4);
            }
            if (range2 == null) {
                CopyLineStatusRangeAction.$$$reportNull$$$0(5);
            }
            String content2 = LineStatusMarkerPopupRenderer.this.getVcsContent(range2) + "\n";
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(content2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer$CopyLineStatusRangeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class ShowPrevChangeMarkerAction
    extends RangeMarkerAction
    implements LightEditCompatible {
        public ShowPrevChangeMarkerAction(@NotNull Editor editor, Range range2) {
            if (editor == null) {
                ShowPrevChangeMarkerAction.$$$reportNull$$$0(0);
            }
            if (range2 == null) {
                ShowPrevChangeMarkerAction.$$$reportNull$$$0(1);
            }
            super(editor, range2, "VcsShowPrevChangeMarker");
        }

        @Override
        protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range2) {
            if (editor == null) {
                ShowPrevChangeMarkerAction.$$$reportNull$$$0(2);
            }
            if (range2 == null) {
                ShowPrevChangeMarkerAction.$$$reportNull$$$0(3);
            }
            return LineStatusMarkerPopupRenderer.this.myTracker.getPrevRange(range2.getLine1()) != null;
        }

        @Override
        protected void actionPerformed(@NotNull Editor editor, @NotNull Range range2) {
            Object targetRange;
            if (editor == null) {
                ShowPrevChangeMarkerAction.$$$reportNull$$$0(4);
            }
            if (range2 == null) {
                ShowPrevChangeMarkerAction.$$$reportNull$$$0(5);
            }
            if ((targetRange = LineStatusMarkerPopupRenderer.this.myTracker.getPrevRange(range2.getLine1())) != null) {
                LineStatusMarkerPopupRenderer.this.scrollAndShow(editor, (Range)targetRange);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer$ShowPrevChangeMarkerAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class ShowNextChangeMarkerAction
    extends RangeMarkerAction
    implements LightEditCompatible {
        public ShowNextChangeMarkerAction(@NotNull Editor editor, Range range2) {
            if (editor == null) {
                ShowNextChangeMarkerAction.$$$reportNull$$$0(0);
            }
            if (range2 == null) {
                ShowNextChangeMarkerAction.$$$reportNull$$$0(1);
            }
            super(editor, range2, "VcsShowNextChangeMarker");
        }

        @Override
        protected boolean isEnabled(@NotNull Editor editor, @NotNull Range range2) {
            if (editor == null) {
                ShowNextChangeMarkerAction.$$$reportNull$$$0(2);
            }
            if (range2 == null) {
                ShowNextChangeMarkerAction.$$$reportNull$$$0(3);
            }
            return LineStatusMarkerPopupRenderer.this.myTracker.getNextRange(range2.getLine1()) != null;
        }

        @Override
        protected void actionPerformed(@NotNull Editor editor, @NotNull Range range2) {
            Object targetRange;
            if (editor == null) {
                ShowNextChangeMarkerAction.$$$reportNull$$$0(4);
            }
            if (range2 == null) {
                ShowNextChangeMarkerAction.$$$reportNull$$$0(5);
            }
            if ((targetRange = LineStatusMarkerPopupRenderer.this.myTracker.getNextRange(range2.getLine1())) != null) {
                LineStatusMarkerPopupRenderer.this.scrollAndShow(editor, (Range)targetRange);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer$ShowNextChangeMarkerAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected abstract class RangeMarkerAction
    extends DumbAwareAction {
        @NotNull
        private final Range myRange;
        @NotNull
        private final Editor myEditor;

        public RangeMarkerAction(@NotNull Editor editor, @Nullable @NonNls Range range2, String actionId) {
            if (editor == null) {
                RangeMarkerAction.$$$reportNull$$$0(0);
            }
            if (range2 == null) {
                RangeMarkerAction.$$$reportNull$$$0(1);
            }
            this.myRange = range2;
            this.myEditor = editor;
            if (actionId != null) {
                ActionUtil.copyFrom((AnAction)this, (String)actionId);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RangeMarkerAction.$$$reportNull$$$0(2);
            }
            Object newRange = LineStatusMarkerPopupRenderer.this.myTracker.findRange(this.myRange);
            e.getPresentation().setEnabled(newRange != null && !this.myEditor.isDisposed() && this.isEnabled(this.myEditor, (Range)newRange));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Object newRange;
            if (e == null) {
                RangeMarkerAction.$$$reportNull$$$0(3);
            }
            if ((newRange = LineStatusMarkerPopupRenderer.this.myTracker.findRange(this.myRange)) != null) {
                this.actionPerformed(this.myEditor, (Range)newRange);
            }
        }

        protected abstract boolean isEnabled(@NotNull Editor var1, @NotNull Range var2);

        protected abstract void actionPerformed(@NotNull Editor var1, @NotNull Range var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/ex/LineStatusMarkerPopupRenderer$RangeMarkerAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

