/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u001a\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u0010\u0010\n\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0007\u001a\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000b"}, d2={"systemIndependentPath", "", "Ljava/io/File;", "getSystemIndependentPath", "(Ljava/io/File;)Ljava/lang/String;", "endsWithName", "", "path", "name", "endsWithSlash", "getParentPath", "intellij.platform.ide.impl"})
public final class FileUtilKt {
    @NotNull
    public static final String getSystemIndependentPath(@NotNull File $this$systemIndependentPath) {
        Intrinsics.checkNotNullParameter((Object)$this$systemIndependentPath, (String)"$this$systemIndependentPath");
        String string = $this$systemIndependentPath.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
        return StringsKt.replace$default((String)string, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
    }

    @Nullable
    public static final String getParentPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return StringUtil.nullize((String)PathUtilRt.getParentPath((String)path));
    }

    public static final boolean endsWithSlash(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Character c = StringsKt.getOrNull((CharSequence)path, (int)(path.length() - 1));
        return c != null && c.charValue() == '/';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean endsWithName(@NotNull String path, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!StringsKt.endsWith$default((String)path, (String)name, (boolean)false, (int)2, null)) return false;
        if (path.length() == name.length()) return true;
        Character c = StringsKt.getOrNull((CharSequence)path, (int)(path.length() - name.length() - 1));
        if (c == null) return false;
        if (c.charValue() != '/') return false;
        return true;
    }
}

