/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.colors.pages;

import com.intellij.application.options.colors.highlighting.RendererWrapper;
import com.intellij.codeHighlighting.RainbowHighlighter;
import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.colors.AttributesDescriptor;
import com.intellij.openapi.options.colors.ColorDescriptor;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.RainbowColorSettingsPage;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.DisplayPriority;
import com.intellij.psi.codeStyle.DisplayPrioritySortable;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultLanguageColorsPage
implements RainbowColorSettingsPage,
DisplayPrioritySortable,
ColorSettingsPage.PreviewCustomizer {
    private static final TextAttributesKey FAKE_BAD_CHAR = TextAttributesKey.createTextAttributesKey((String)"FAKE_BAD_CHAR", (TextAttributesKey)HighlighterColors.BAD_CHARACTER);
    private static final Map<String, TextAttributesKey> TAG_HIGHLIGHTING_MAP = RainbowHighlighter.createRainbowHLM();
    private static final Map<String, TextAttributesKey> INLINE_ELEMENTS;
    private static final AttributesDescriptor[] ATTRIBUTES_DESCRIPTORS;
    private static final ColorDescriptor[] COLOR_DESCRIPTORS;

    @Nullable
    public Icon getIcon() {
        return FileTypes.PLAIN_TEXT.getIcon();
    }

    @NotNull
    public SyntaxHighlighter getHighlighter() {
        return new PlainSyntaxHighlighter();
    }

    @NotNull
    public String getDemoText() {
        String string = "Bad characters: <bad_char>????</bad_char>\n<keyword>Keyword</keyword>\n<identifier>Identifier</identifier>\n<string>'String <valid_esc_seq>\\n</valid_esc_seq><invalid_esc_seq>\\?</invalid_esc_seq>'</string>\n<number>12345</number>\n<operation_sign>Operator</operation_sign>\nDot: <dot>.</dot> comma: <comma>,</comma> semicolon: <semicolon>;</semicolon>\n<braces>{</braces> Braces <braces>}</braces>\n<parenths>(</parenths> Parentheses <parenths>)</parenths>\n<brackets>[</brackets> Brackets <brackets>]</brackets>\n<line_comment>// Line comment</line_comment>\n<block_comment>/* Block comment */</block_comment>\n<label>:Label</label>\n<predefined>predefined_symbol()</predefined>\n<const>CONSTANT</const>\nGlobal <global_var>variable</global_var>\n<doc_comment>/** \n * Doc comment\n * <doc_tag>@tag</doc_tag> <doc_markup><code></doc_markup>Markup<<doc_markup></code></doc_markup>" + RainbowHighlighter.generatePaletteExample("\n * ") + "\n * <doc_tag>@param</doc_tag> <doc_tag_value>parameter1</doc_tag_value> documentation\n * <doc_tag>@param</doc_tag> <doc_tag_value>parameter2</doc_tag_value> documentation\n * <doc_tag>@param</doc_tag> <doc_tag_value>parameter3</doc_tag_value> documentation\n * <doc_tag>@param</doc_tag> <doc_tag_value>parameter4</doc_tag_value> documentation\n */</doc_comment>\nFunction <func_decl>declaration</func_decl> (<param>parameter1</param> <param>parameter2</param> <param>parameter3</param> <param>parameter4</param>)\n    Local <local_var>variable1</local_var> <local_var>variable2</local_var> <local_var>variable3</local_var> <local_var>variable4</local_var>\n    Reassigned local <reassigned_local>variable</reassigned_local>\n    Reassigned <reassigned_parameter>parameter</reassigned_parameter>\nFunction <func_call>call</func_call>(<parameter_hint p:>0, <parameter_hint param:>1, <parameter_hint parameterName:>2)\nCurrent function <func_call>call</func_call>(<parameter_hint_highlighted param:>0, <parameter_hint_current currentParam:>1)\nInterface <interface>Name</interface>\n<metadata>@Metadata</metadata>\nClass <class_name>Name</class_name>\n    instance <inst_method>method</inst_method>\n    instance <inst_field>field</inst_field>\n    static <static_method>method</static_method>\n    static <static_field>field</static_field>\n\n<func_call>function</func_call>(<string>\"</string><highlighted_reference>/highlighted/reference/{param}</highlighted_reference><string>\"</string>)\n\n<tag><keyword>@TAG</keyword> <attribute>attribute</attribute>=<string>Value</string></tag>\n    Entity: <entity>&amp;</entity>\n    <template_language>{% Template language %}</template_language>";
        if (string == null) {
            DefaultLanguageColorsPage.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public Map<String, TextAttributesKey> getAdditionalHighlightingTagToDescriptorMap() {
        return TAG_HIGHLIGHTING_MAP;
    }

    @Nullable
    public Map<String, TextAttributesKey> getAdditionalInlineElementToDescriptorMap() {
        return INLINE_ELEMENTS;
    }

    public AttributesDescriptor @NotNull [] getAttributeDescriptors() {
        if (ATTRIBUTES_DESCRIPTORS == null) {
            DefaultLanguageColorsPage.$$$reportNull$$$0(1);
        }
        return ATTRIBUTES_DESCRIPTORS;
    }

    public ColorDescriptor @NotNull [] getColorDescriptors() {
        if (COLOR_DESCRIPTORS == null) {
            DefaultLanguageColorsPage.$$$reportNull$$$0(2);
        }
        return COLOR_DESCRIPTORS;
    }

    @NotNull
    public String getDisplayName() {
        String string = OptionsBundle.message((String)"options.language.defaults.display.name", (Object[])new Object[0]);
        if (string == null) {
            DefaultLanguageColorsPage.$$$reportNull$$$0(3);
        }
        return string;
    }

    public DisplayPriority getPriority() {
        return DisplayPriority.GENERAL_SETTINGS;
    }

    public boolean isRainbowType(TextAttributesKey type) {
        return DefaultLanguageHighlighterColors.LOCAL_VARIABLE.equals((Object)type) || DefaultLanguageHighlighterColors.PARAMETER.equals((Object)type) || DefaultLanguageHighlighterColors.DOC_COMMENT_TAG_VALUE.equals((Object)type);
    }

    @Nullable
    public Language getLanguage() {
        return null;
    }

    @Nullable
    public ColorSettingsPage.PreviewCustomizer getPreviewEditorCustomizer() {
        return this;
    }

    public void removeCustomizations(@NotNull Editor editor) {
        if (editor == null) {
            DefaultLanguageColorsPage.$$$reportNull$$$0(4);
        }
        editor.getInlayModel().getBlockElementsInRange(0, editor.getDocument().getTextLength()).forEach(Disposer::dispose);
    }

    @Nullable
    public TextRange addCustomizations(@NotNull Editor editor, @Nullable String selectedKeyName) {
        if (editor == null) {
            DefaultLanguageColorsPage.$$$reportNull$$$0(5);
        }
        boolean ourKey = DefaultLanguageHighlighterColors.DOC_COMMENT_GUIDE.getExternalName().equals(selectedKeyName) || DefaultLanguageHighlighterColors.DOC_COMMENT_LINK.getExternalName().equals(selectedKeyName);
        int offset = editor.getDocument().getText().indexOf("/**");
        editor.getInlayModel().addBlockElement(offset, false, true, 0, (EditorCustomElementRenderer)new RendererWrapper(DocRenderItem.createDemoRenderer(editor), ourKey));
        return ourKey ? new TextRange(offset - 1, offset) : null;
    }

    @Nullable
    public String getCustomizationAt(@NotNull Editor editor, @NotNull Point location) {
        Inlay inlay;
        if (editor == null) {
            DefaultLanguageColorsPage.$$$reportNull$$$0(6);
        }
        if (location == null) {
            DefaultLanguageColorsPage.$$$reportNull$$$0(7);
        }
        return (inlay = editor.getInlayModel().getElementAt(location)) != null && inlay.getPlacement() == Inlay.Placement.ABOVE_LINE ? (location.x < 20 ? DefaultLanguageHighlighterColors.DOC_COMMENT_GUIDE.getExternalName() : DefaultLanguageHighlighterColors.DOC_COMMENT_LINK.getExternalName()) : null;
    }

    static {
        TAG_HIGHLIGHTING_MAP.put("bad_char", FAKE_BAD_CHAR);
        TAG_HIGHLIGHTING_MAP.put("template_language", DefaultLanguageHighlighterColors.TEMPLATE_LANGUAGE_COLOR);
        TAG_HIGHLIGHTING_MAP.put("identifier", DefaultLanguageHighlighterColors.IDENTIFIER);
        TAG_HIGHLIGHTING_MAP.put("number", DefaultLanguageHighlighterColors.NUMBER);
        TAG_HIGHLIGHTING_MAP.put("keyword", DefaultLanguageHighlighterColors.KEYWORD);
        TAG_HIGHLIGHTING_MAP.put("string", DefaultLanguageHighlighterColors.STRING);
        TAG_HIGHLIGHTING_MAP.put("line_comment", DefaultLanguageHighlighterColors.LINE_COMMENT);
        TAG_HIGHLIGHTING_MAP.put("block_comment", DefaultLanguageHighlighterColors.BLOCK_COMMENT);
        TAG_HIGHLIGHTING_MAP.put("operation_sign", DefaultLanguageHighlighterColors.OPERATION_SIGN);
        TAG_HIGHLIGHTING_MAP.put("braces", DefaultLanguageHighlighterColors.BRACES);
        TAG_HIGHLIGHTING_MAP.put("doc_comment", DefaultLanguageHighlighterColors.DOC_COMMENT);
        TAG_HIGHLIGHTING_MAP.put("dot", DefaultLanguageHighlighterColors.DOT);
        TAG_HIGHLIGHTING_MAP.put("semicolon", DefaultLanguageHighlighterColors.SEMICOLON);
        TAG_HIGHLIGHTING_MAP.put("comma", DefaultLanguageHighlighterColors.COMMA);
        TAG_HIGHLIGHTING_MAP.put("brackets", DefaultLanguageHighlighterColors.BRACKETS);
        TAG_HIGHLIGHTING_MAP.put("parenths", DefaultLanguageHighlighterColors.PARENTHESES);
        TAG_HIGHLIGHTING_MAP.put("func_decl", DefaultLanguageHighlighterColors.FUNCTION_DECLARATION);
        TAG_HIGHLIGHTING_MAP.put("func_call", DefaultLanguageHighlighterColors.FUNCTION_CALL);
        TAG_HIGHLIGHTING_MAP.put("param", DefaultLanguageHighlighterColors.PARAMETER);
        TAG_HIGHLIGHTING_MAP.put("class_name", DefaultLanguageHighlighterColors.CLASS_NAME);
        TAG_HIGHLIGHTING_MAP.put("class_ref", DefaultLanguageHighlighterColors.CLASS_REFERENCE);
        TAG_HIGHLIGHTING_MAP.put("inst_method", DefaultLanguageHighlighterColors.INSTANCE_METHOD);
        TAG_HIGHLIGHTING_MAP.put("inst_field", DefaultLanguageHighlighterColors.INSTANCE_FIELD);
        TAG_HIGHLIGHTING_MAP.put("static_method", DefaultLanguageHighlighterColors.STATIC_METHOD);
        TAG_HIGHLIGHTING_MAP.put("static_field", DefaultLanguageHighlighterColors.STATIC_FIELD);
        TAG_HIGHLIGHTING_MAP.put("label", DefaultLanguageHighlighterColors.LABEL);
        TAG_HIGHLIGHTING_MAP.put("local_var", DefaultLanguageHighlighterColors.LOCAL_VARIABLE);
        TAG_HIGHLIGHTING_MAP.put("global_var", DefaultLanguageHighlighterColors.GLOBAL_VARIABLE);
        TAG_HIGHLIGHTING_MAP.put("const", DefaultLanguageHighlighterColors.CONSTANT);
        TAG_HIGHLIGHTING_MAP.put("interface", DefaultLanguageHighlighterColors.INTERFACE_NAME);
        TAG_HIGHLIGHTING_MAP.put("doc_markup", DefaultLanguageHighlighterColors.DOC_COMMENT_MARKUP);
        TAG_HIGHLIGHTING_MAP.put("doc_tag", DefaultLanguageHighlighterColors.DOC_COMMENT_TAG);
        TAG_HIGHLIGHTING_MAP.put("doc_tag_value", DefaultLanguageHighlighterColors.DOC_COMMENT_TAG_VALUE);
        TAG_HIGHLIGHTING_MAP.put("valid_esc_seq", DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
        TAG_HIGHLIGHTING_MAP.put("invalid_esc_seq", DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE);
        TAG_HIGHLIGHTING_MAP.put("predefined", DefaultLanguageHighlighterColors.PREDEFINED_SYMBOL);
        TAG_HIGHLIGHTING_MAP.put("metadata", DefaultLanguageHighlighterColors.METADATA);
        TAG_HIGHLIGHTING_MAP.put("tag", DefaultLanguageHighlighterColors.MARKUP_TAG);
        TAG_HIGHLIGHTING_MAP.put("attribute", DefaultLanguageHighlighterColors.MARKUP_ATTRIBUTE);
        TAG_HIGHLIGHTING_MAP.put("entity", DefaultLanguageHighlighterColors.MARKUP_ENTITY);
        TAG_HIGHLIGHTING_MAP.put("reassigned_parameter", DefaultLanguageHighlighterColors.REASSIGNED_PARAMETER);
        TAG_HIGHLIGHTING_MAP.put("reassigned_local", DefaultLanguageHighlighterColors.REASSIGNED_LOCAL_VARIABLE);
        TAG_HIGHLIGHTING_MAP.put("highlighted_reference", DefaultLanguageHighlighterColors.HIGHLIGHTED_REFERENCE);
        INLINE_ELEMENTS = new HashMap<String, TextAttributesKey>();
        INLINE_ELEMENTS.put("parameter_hint", DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT);
        INLINE_ELEMENTS.put("parameter_hint_highlighted", DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT_HIGHLIGHTED);
        INLINE_ELEMENTS.put("parameter_hint_current", DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT_CURRENT);
        ATTRIBUTES_DESCRIPTORS = new AttributesDescriptor[]{new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.java.attribute.descriptor.bad.character", (Object[])new Object[0]), HighlighterColors.BAD_CHARACTER), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.keyword", (Object[])new Object[0]), DefaultLanguageHighlighterColors.KEYWORD), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.identifier", (Object[])new Object[0]), DefaultLanguageHighlighterColors.IDENTIFIER), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.string", (Object[])new Object[0]), DefaultLanguageHighlighterColors.STRING), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.valid.esc.seq", (Object[])new Object[0]), DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.invalid.esc.seq", (Object[])new Object[0]), DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.number", (Object[])new Object[0]), DefaultLanguageHighlighterColors.NUMBER), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.operation", (Object[])new Object[0]), DefaultLanguageHighlighterColors.OPERATION_SIGN), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.braces", (Object[])new Object[0]), DefaultLanguageHighlighterColors.BRACES), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.parentheses", (Object[])new Object[0]), DefaultLanguageHighlighterColors.PARENTHESES), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.brackets", (Object[])new Object[0]), DefaultLanguageHighlighterColors.BRACKETS), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.dot", (Object[])new Object[0]), DefaultLanguageHighlighterColors.DOT), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.comma", (Object[])new Object[0]), DefaultLanguageHighlighterColors.COMMA), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.semicolon", (Object[])new Object[0]), DefaultLanguageHighlighterColors.SEMICOLON), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.line.comment", (Object[])new Object[0]), DefaultLanguageHighlighterColors.LINE_COMMENT), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.block.comment", (Object[])new Object[0]), DefaultLanguageHighlighterColors.BLOCK_COMMENT), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.doc.comment", (Object[])new Object[0]), DefaultLanguageHighlighterColors.DOC_COMMENT), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.doc.markup", (Object[])new Object[0]), DefaultLanguageHighlighterColors.DOC_COMMENT_MARKUP), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.doc.tag", (Object[])new Object[0]), DefaultLanguageHighlighterColors.DOC_COMMENT_TAG), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.doc.tag.value", (Object[])new Object[0]), DefaultLanguageHighlighterColors.DOC_COMMENT_TAG_VALUE), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.label", (Object[])new Object[0]), DefaultLanguageHighlighterColors.LABEL), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.constant", (Object[])new Object[0]), DefaultLanguageHighlighterColors.CONSTANT), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.predefined", (Object[])new Object[0]), DefaultLanguageHighlighterColors.PREDEFINED_SYMBOL), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.local.variable", (Object[])new Object[0]), DefaultLanguageHighlighterColors.LOCAL_VARIABLE), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.reassigned.local.variable", (Object[])new Object[0]), DefaultLanguageHighlighterColors.REASSIGNED_LOCAL_VARIABLE), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.global.variable", (Object[])new Object[0]), DefaultLanguageHighlighterColors.GLOBAL_VARIABLE), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.function.declaration", (Object[])new Object[0]), DefaultLanguageHighlighterColors.FUNCTION_DECLARATION), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.function.call", (Object[])new Object[0]), DefaultLanguageHighlighterColors.FUNCTION_CALL), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.parameter", (Object[])new Object[0]), DefaultLanguageHighlighterColors.PARAMETER), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.reassigned.parameter", (Object[])new Object[0]), DefaultLanguageHighlighterColors.REASSIGNED_PARAMETER), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.interface.name", (Object[])new Object[0]), DefaultLanguageHighlighterColors.INTERFACE_NAME), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.metadata", (Object[])new Object[0]), DefaultLanguageHighlighterColors.METADATA), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.class.name", (Object[])new Object[0]), DefaultLanguageHighlighterColors.CLASS_NAME), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.class.reference", (Object[])new Object[0]), DefaultLanguageHighlighterColors.CLASS_REFERENCE), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.instance.method", (Object[])new Object[0]), DefaultLanguageHighlighterColors.INSTANCE_METHOD), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.instance.field", (Object[])new Object[0]), DefaultLanguageHighlighterColors.INSTANCE_FIELD), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.static.method", (Object[])new Object[0]), DefaultLanguageHighlighterColors.STATIC_METHOD), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.static.field", (Object[])new Object[0]), DefaultLanguageHighlighterColors.STATIC_FIELD), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.markup.tag", (Object[])new Object[0]), DefaultLanguageHighlighterColors.MARKUP_TAG), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.markup.attribute", (Object[])new Object[0]), DefaultLanguageHighlighterColors.MARKUP_ATTRIBUTE), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.markup.entity", (Object[])new Object[0]), DefaultLanguageHighlighterColors.MARKUP_ENTITY), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.template.language", (Object[])new Object[0]), DefaultLanguageHighlighterColors.TEMPLATE_LANGUAGE_COLOR), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.java.attribute.descriptor.inline.parameter.hint", (Object[])new Object[0]), DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.java.attribute.descriptor.inline.parameter.hint.highlighted", (Object[])new Object[0]), DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT_HIGHLIGHTED), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.java.attribute.descriptor.inline.parameter.hint.current", (Object[])new Object[0]), DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT_CURRENT), new AttributesDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.highlighted.reference", (Object[])new Object[0]), DefaultLanguageHighlighterColors.HIGHLIGHTED_REFERENCE)};
        COLOR_DESCRIPTORS = new ColorDescriptor[]{new ColorDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.doc.guide", (Object[])new Object[0]), DefaultLanguageHighlighterColors.DOC_COMMENT_GUIDE, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.messagePointer((String)"options.language.defaults.doc.link", (Object[])new Object[0]), DefaultLanguageHighlighterColors.DOC_COMMENT_LINK, ColorDescriptor.Kind.FOREGROUND), new ColorDescriptor(OptionsBundle.messagePointer((String)"options.java.attribute.descriptor.inline.parameter.hint.default", (Object[])new Object[0]), DefaultLanguageHighlighterColors.INLINE_REFACTORING_SETTINGS_DEFAULT, ColorDescriptor.Kind.BACKGROUND_WITH_TRANSPARENCY), new ColorDescriptor(OptionsBundle.messagePointer((String)"options.java.attribute.descriptor.inline.parameter.hint.focused", (Object[])new Object[0]), DefaultLanguageHighlighterColors.INLINE_REFACTORING_SETTINGS_FOCUSED, ColorDescriptor.Kind.BACKGROUND_WITH_TRANSPARENCY), new ColorDescriptor(OptionsBundle.messagePointer((String)"options.java.attribute.descriptor.inline.parameter.hint.hovered", (Object[])new Object[0]), DefaultLanguageHighlighterColors.INLINE_REFACTORING_SETTINGS_HOVERED, ColorDescriptor.Kind.BACKGROUND_WITH_TRANSPARENCY)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/options/colors/pages/DefaultLanguageColorsPage";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDemoText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeDescriptors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorDescriptors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/options/colors/pages/DefaultLanguageColorsPage";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeCustomizations";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addCustomizations";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCustomizationAt";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

