/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.custom.SyntaxTable;
import com.intellij.lang.LangBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.FileTypesBundle;
import com.intellij.openapi.fileTypes.UserFileType;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import com.intellij.openapi.fileTypes.impl.FileTypeConfigurableInteractions;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.fileTypes.impl.FileTypePanel;
import com.intellij.openapi.fileTypes.impl.FileTypePatternDialog;
import com.intellij.openapi.fileTypes.impl.FileTypeRenderer;
import com.intellij.openapi.fileTypes.impl.FileTypeSelectable;
import com.intellij.openapi.fileTypes.impl.HashBangFileTypeDetector;
import com.intellij.openapi.fileTypes.impl.IgnoredFilesAndFoldersPanel;
import com.intellij.openapi.fileTypes.impl.TypeEditor;
import com.intellij.openapi.fileTypes.impl.associate.OSAssociateFileTypesUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.templateLanguages.TemplateDataLanguagePatterns;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileTypeConfigurable
implements SearchableConfigurable,
Configurable.NoScroll,
FileTypeSelectable {
    private static final Insets TITLE_INSETS = JBUI.insetsTop((int)8);
    private RecognizedFileTypesPanel myRecognizedFileType;
    private PatternsPanel myPatterns;
    private HashBangPanel myHashBangs;
    private FileTypePanel myFileTypePanel;
    private Set<FileType> myTempFileTypes;
    private FileTypeAssocTable<FileType> myTempPatternsTable;
    private FileTypeAssocTable<Language> myTempTemplateDataLanguages;
    private final Map<UserFileType, UserFileType> myOriginalToEditedMap = new HashMap<UserFileType, UserFileType>();
    private FileType myFileTypeToPreselect;
    private IgnoredFilesAndFoldersPanel myIgnoreFilesPanel;

    public String getDisplayName() {
        return FileTypesBundle.message("filetype.settings.title", new Object[0]);
    }

    public JComponent createComponent() {
        JBTabbedPane tabbedPane = new JBTabbedPane();
        this.myFileTypePanel = new FileTypePanel();
        this.myRecognizedFileType = new RecognizedFileTypesPanel();
        JBSplitter splitter = new JBSplitter(false, 0.3f);
        splitter.setFirstComponent((JComponent)this.myRecognizedFileType);
        JPanel rightPanel = new JPanel(new BorderLayout());
        this.myPatterns = new PatternsPanel();
        this.myHashBangs = new HashBangPanel();
        rightPanel.add((Component)this.myPatterns, "Center");
        rightPanel.add((Component)this.myHashBangs, "South");
        splitter.setSecondComponent((JComponent)rightPanel);
        this.myFileTypePanel.myUpperPanel.add((Component)splitter, "Center");
        this.myRecognizedFileType.myFileTypesList.addListSelectionListener(__ -> this.updateExtensionList());
        this.myFileTypePanel.myAssociatePanel.setVisible(OSAssociateFileTypesUtil.isAvailable());
        this.myFileTypePanel.myAssociatePanel.setBorder((Border)JBUI.Borders.emptyTop((int)16));
        this.myFileTypePanel.myAssociateButton.setText(FileTypesBundle.message("filetype.associate.button", ApplicationNamesInfo.getInstance().getFullProductName()));
        this.myFileTypePanel.myAssociateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OSAssociateFileTypesUtil.chooseAndAssociate(new OSAssociateFileTypesUtil.Callback(){

                    @Override
                    public void beforeStart() {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            FileTypeConfigurable.this.myFileTypePanel.myAssociateButton.setEnabled(false);
                            FileTypeConfigurable.this.updateAssociateMessageLabel(FileTypesBundle.message("filetype.associate.message.updating", new Object[0]), null);
                        }, ModalityState.any());
                    }

                    @Override
                    public void onSuccess(boolean isOsRestartRequired) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            FileTypeConfigurable.this.myFileTypePanel.myAssociateButton.setEnabled(true);
                            if (isOsRestartRequired) {
                                FileTypeConfigurable.this.updateAssociateMessageLabel(FileTypesBundle.message("filetype.associate.message.os.restart", new Object[0]), AllIcons.General.Warning);
                            } else {
                                FileTypeConfigurable.this.updateAssociateMessageLabel("", null);
                            }
                            FileTypeConfigurable.this.showAssociationBalloon(FileTypesBundle.message("filetype.associate.success.message", ApplicationInfo.getInstance().getFullApplicationName()), HintUtil.getInformationColor());
                        }, ModalityState.any());
                    }

                    @Override
                    public void onFailure(@NotNull @Nls String errorMessage) {
                        if (errorMessage == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ApplicationManager.getApplication().invokeLater(() -> {
                            FileTypeConfigurable.this.myFileTypePanel.myAssociateButton.setEnabled(true);
                            FileTypeConfigurable.this.updateAssociateMessageLabel("", null);
                            FileTypeConfigurable.this.showAssociationBalloon(errorMessage, HintUtil.getErrorColor());
                        }, ModalityState.any());
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$1$1", "onFailure"));
                    }
                });
            }
        });
        tabbedPane.add(FileTypesBundle.message("filetype.recognized.group", new Object[0]), (Component)this.myFileTypePanel.myWholePanel);
        this.myIgnoreFilesPanel = new IgnoredFilesAndFoldersPanel();
        tabbedPane.add(FileTypesBundle.message("filetype.ignore.group", new Object[0]), (Component)this.myIgnoreFilesPanel);
        return tabbedPane;
    }

    private void updateAssociateMessageLabel(@NotNull @Nls String message, @Nullable Icon icon2) {
        if (message == null) {
            FileTypeConfigurable.$$$reportNull$$$0(0);
        }
        this.myFileTypePanel.myAssociateMessageLabel.setText(message);
        this.myFileTypePanel.myAssociateMessageLabel.setIcon(icon2);
    }

    private void showAssociationBalloon(@NotNull @Nls String message, @NotNull Color color) {
        if (message == null) {
            FileTypeConfigurable.$$$reportNull$$$0(1);
        }
        if (color == null) {
            FileTypeConfigurable.$$$reportNull$$$0(2);
        }
        Balloon balloon2 = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JLabel(message)).setFillColor(color).setHideOnKeyOutside(true).createBalloon();
        JButton component2 = this.myFileTypePanel.myAssociateButton;
        RelativePoint relativePoint = new RelativePoint((Component)component2, new Point(component2.getWidth() / 2, component2.getHeight() - JBUI.scale((int)10)));
        balloon2.show(relativePoint, Balloon.Position.below);
    }

    private void updateFileTypeList() {
        List types = ContainerUtil.filter(this.myTempFileTypes, fileType -> !fileType.isReadOnly());
        types.sort((o1, o2) -> o1.getDescription().compareToIgnoreCase(o2.getDescription()));
        this.myRecognizedFileType.setFileTypes(types);
    }

    @NotNull
    private static Set<FileType> getRegisteredFilesTypes() {
        Set set2 = ContainerUtil.set((Object[])FileTypeManager.getInstance().getRegisteredFileTypes());
        if (set2 == null) {
            FileTypeConfigurable.$$$reportNull$$$0(3);
        }
        return set2;
    }

    public void apply() {
        this.copyTypeMap();
        FileTypeManagerImpl fileTypeManager = (FileTypeManagerImpl)FileTypeManager.getInstance();
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (!fileTypeManager.isIgnoredFilesListEqualToCurrent(this.myIgnoreFilesPanel.getValues())) {
                fileTypeManager.setIgnoredFilesList(this.myIgnoreFilesPanel.getValues());
            }
            fileTypeManager.setPatternsTable(this.myTempFileTypes, this.myTempPatternsTable);
            TemplateDataLanguagePatterns.getInstance().setAssocTable(this.myTempTemplateDataLanguages);
        });
    }

    private void copyTypeMap() {
        Set<UserFileType> modifiedUserTypes = this.myOriginalToEditedMap.keySet();
        for (UserFileType oldType : modifiedUserTypes) {
            oldType.copyFrom(this.myOriginalToEditedMap.get(oldType));
        }
        this.myOriginalToEditedMap.clear();
    }

    public void reset() {
        FileTypeManagerImpl fileTypeManager = (FileTypeManagerImpl)FileTypeManager.getInstance();
        this.myTempPatternsTable = fileTypeManager.getExtensionMap().copy();
        this.myTempTemplateDataLanguages = TemplateDataLanguagePatterns.getInstance().getAssocTable();
        this.myTempFileTypes = FileTypeConfigurable.getRegisteredFilesTypes();
        this.myOriginalToEditedMap.clear();
        this.updateFileTypeList();
        this.updateExtensionList();
        this.myIgnoreFilesPanel.setValues(fileTypeManager.getIgnoredFilesList());
        if (this.myFileTypeToPreselect != null) {
            this.myRecognizedFileType.selectFileType(this.myFileTypeToPreselect);
        }
    }

    public boolean isModified() {
        FileTypeManagerImpl fileTypeManager = (FileTypeManagerImpl)FileTypeManager.getInstance();
        if (!fileTypeManager.isIgnoredFilesListEqualToCurrent(this.myIgnoreFilesPanel.getValues())) {
            return true;
        }
        return !this.myTempPatternsTable.equals(fileTypeManager.getExtensionMap()) || !this.myTempFileTypes.equals(FileTypeConfigurable.getRegisteredFilesTypes()) || !this.myOriginalToEditedMap.isEmpty() || !this.myTempTemplateDataLanguages.equals(TemplateDataLanguagePatterns.getInstance().getAssocTable());
    }

    public void disposeUIResources() {
        if (this.myFileTypePanel != null) {
            this.myRecognizedFileType.setFileTypes(Collections.emptyList());
            this.myPatterns.clearList();
            this.myHashBangs.clearList();
        }
        this.myFileTypePanel = null;
        this.myRecognizedFileType = null;
        this.myPatterns = null;
        this.myHashBangs = null;
    }

    private void updateExtensionList() {
        FileType type = this.myRecognizedFileType.getSelectedFileType();
        if (type == null) {
            return;
        }
        this.myPatterns.refill(this.myTempPatternsTable.getAssociations((Object)type));
        this.myHashBangs.refill(this.myTempPatternsTable.getHashBangPatterns((Object)type));
    }

    private void editFileType() {
        TypeEditor<UserFileType> editor;
        FileType fileType = this.myRecognizedFileType.getSelectedFileType();
        if (!FileTypeConfigurable.canBeModified(fileType)) {
            return;
        }
        UserFileType userFileType = (UserFileType)fileType;
        UserFileType ftToEdit = this.myOriginalToEditedMap.get(userFileType);
        if (ftToEdit == null) {
            ftToEdit = userFileType.clone();
        }
        if ((editor = new TypeEditor<UserFileType>(this.myRecognizedFileType.myFileTypesList, ftToEdit, FileTypesBundle.message("filetype.edit.existing.title", new Object[0]))).showAndGet()) {
            FileTypeConfigurableInteractions.fileTypeEdited.log();
            this.myOriginalToEditedMap.put(userFileType, ftToEdit);
        }
    }

    private void removeFileType() {
        FileType fileType = this.myRecognizedFileType.getSelectedFileType();
        if (fileType == null) {
            return;
        }
        FileTypeConfigurableInteractions.fileTypeRemoved.log();
        this.myTempFileTypes.remove(fileType);
        if (fileType instanceof UserFileType) {
            this.myOriginalToEditedMap.remove(fileType);
        }
        this.myTempPatternsTable.removeAllAssociations((Object)fileType);
        this.updateFileTypeList();
        this.updateExtensionList();
    }

    private static boolean canBeModified(FileType fileType) {
        return fileType instanceof AbstractFileType;
    }

    private void addFileType() {
        AbstractFileType type = new AbstractFileType(new SyntaxTable());
        TypeEditor<AbstractFileType> editor = new TypeEditor<AbstractFileType>(this.myRecognizedFileType.myFileTypesList, type, FileTypesBundle.message("filetype.edit.new.title", new Object[0]));
        if (editor.showAndGet()) {
            FileTypeConfigurableInteractions.fileTypeAdded.log();
            this.myTempFileTypes.add(type);
            this.updateFileTypeList();
            this.updateExtensionList();
            this.myRecognizedFileType.selectFileType(type);
        }
    }

    private void editPattern() {
        String item = this.myPatterns.getSelectedItem();
        if (item != null) {
            this.editPattern(item);
        }
    }

    private void editPattern(@Nullable String item) {
        FileType type = this.myRecognizedFileType.getSelectedFileType();
        if (type == null) {
            return;
        }
        if (item == null) {
            FileTypeConfigurableInteractions.patternAdded.log((Object)type);
        } else {
            FileTypeConfigurableInteractions.patternEdited.log((Object)type);
        }
        String title = item == null ? FileTypesBundle.message("filetype.edit.add.pattern.title", new Object[0]) : FileTypesBundle.message("filetype.edit.edit.pattern.title", new Object[0]);
        Language oldLanguage = item == null ? null : (Language)this.myTempTemplateDataLanguages.findAssociatedFileType((CharSequence)item);
        FileTypePatternDialog dialog2 = new FileTypePatternDialog(item, type, oldLanguage);
        DialogBuilder builder2 = new DialogBuilder(this.myPatterns.myList);
        builder2.setPreferredFocusComponent((JComponent)dialog2.getPatternField());
        builder2.setCenterPanel((JComponent)dialog2.getMainPanel());
        builder2.setTitle(title);
        builder2.showModal(true);
        if (builder2.getDialogWrapper().isOK()) {
            String pattern = dialog2.getPatternField().getText();
            if (StringUtil.isEmpty((String)pattern)) {
                return;
            }
            FileNameMatcher matcher = FileTypeManager.parseFromString((String)pattern);
            FileType registeredFileType = this.findExistingFileType(matcher);
            if (registeredFileType != null && registeredFileType != type) {
                if (registeredFileType.isReadOnly()) {
                    Messages.showMessageDialog(this.myPatterns.myList, (String)FileTypesBundle.message("filetype.edit.add.pattern.exists.error", registeredFileType.getDescription()), (String)title, (Icon)Messages.getErrorIcon());
                    return;
                }
                int ret = Messages.showOkCancelDialog(this.myPatterns.myList, (String)FileTypesBundle.message("filetype.edit.add.pattern.exists.message", registeredFileType.getDescription()), (String)FileTypesBundle.message("filetype.edit.add.pattern.exists.title", new Object[0]), (String)FileTypesBundle.message("filetype.edit.add.pattern.reassign.button", new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
                if (ret == 0) {
                    this.myTempPatternsTable.removeAssociation(matcher, (Object)registeredFileType);
                    if (oldLanguage != null) {
                        this.myTempTemplateDataLanguages.removeAssociation(matcher, (Object)oldLanguage);
                    }
                } else {
                    return;
                }
            }
            if (item != null) {
                FileNameMatcher oldMatcher = FileTypeManager.parseFromString((String)item);
                this.myTempPatternsTable.removeAssociation(oldMatcher, (Object)type);
                if (oldLanguage != null) {
                    this.myTempTemplateDataLanguages.removeAssociation(oldMatcher, (Object)oldLanguage);
                }
            }
            this.myTempPatternsTable.addAssociation(matcher, (Object)type);
            Language language = dialog2.getTemplateDataLanguage();
            if (language != null) {
                this.myTempTemplateDataLanguages.addAssociation(matcher, (Object)language);
            }
            this.updateExtensionList();
            this.myPatterns.select(pattern);
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myPatterns.myList, true));
        }
    }

    private void addPattern() {
        this.editPattern(null);
    }

    @Nullable
    private FileType findExistingFileType(@NotNull FileNameMatcher matcher) {
        FileType type;
        if (matcher == null) {
            FileTypeConfigurable.$$$reportNull$$$0(4);
        }
        if ((type = (FileType)this.myTempPatternsTable.findAssociatedFileType(matcher)) != null && type != FileTypes.UNKNOWN) {
            return type;
        }
        FileType registeredFileType = FileTypeManager.getInstance().getFileTypeByExtension(matcher.getPresentableString());
        if (registeredFileType != FileTypes.UNKNOWN && registeredFileType.isReadOnly()) {
            return registeredFileType;
        }
        return null;
    }

    private void removePattern() {
        FileType type = this.myRecognizedFileType.getSelectedFileType();
        if (type == null) {
            return;
        }
        FileTypeConfigurableInteractions.patternRemoved.log((Object)type);
        String extension = this.myPatterns.removeSelected();
        if (extension == null) {
            return;
        }
        FileNameMatcher matcher = FileTypeManager.parseFromString((String)extension);
        this.myTempPatternsTable.removeAssociation(matcher, (Object)type);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myPatterns.myList, true));
    }

    private void removeHashBang() {
        FileType type = this.myRecognizedFileType.getSelectedFileType();
        if (type == null) {
            return;
        }
        FileTypeConfigurableInteractions.hashbangRemoved.log((Object)type);
        String extension = this.myHashBangs.removeSelected();
        if (extension == null) {
            return;
        }
        this.myTempPatternsTable.removeHashBangPattern(extension, (Object)type);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myHashBangs.myList, true));
    }

    @NotNull
    public String getHelpTopic() {
        return "preferences.fileTypes";
    }

    @Override
    public void selectFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeConfigurable.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myRecognizedFileType == null) {
            this.myFileTypeToPreselect = fileType;
        } else {
            this.myRecognizedFileType.selectFileType(fileType);
        }
    }

    private void editHashBang() {
        String item = this.myHashBangs.getSelectedItem();
        if (item == null) {
            return;
        }
        this.editHashBang(item);
    }

    private void editHashBang(@Nullable(value="null means new") @Nullable(value="null means new") String oldHashBang) {
        FileType type = this.myRecognizedFileType.getSelectedFileType();
        if (type == null) {
            return;
        }
        if (oldHashBang == null) {
            FileTypeConfigurableInteractions.hashbangAdded.log((Object)type);
        } else {
            FileTypeConfigurableInteractions.hashbangEdited.log((Object)type);
        }
        String title = FileTypesBundle.message("filetype.edit.hashbang.title", new Object[0]);
        Language oldLanguage = oldHashBang == null ? null : (Language)this.myTempTemplateDataLanguages.findAssociatedFileType((CharSequence)oldHashBang);
        String hashbang = Messages.showInputDialog(this.myHashBangs.myList, (String)FileTypesBundle.message("filetype.edit.hashbang.prompt", new Object[0]), (String)title, null, (String)oldHashBang, null);
        if (StringUtil.isEmpty((String)hashbang)) {
            return;
        }
        HashBangConflict conflict = this.checkHashBangConflict(hashbang);
        if (conflict != null && conflict.fileType != type) {
            FileType existingFileType = conflict.fileType;
            if (!conflict.writeable) {
                String message = conflict.exact ? FileTypesBundle.message("filetype.edit.hashbang.exists.exact.error", existingFileType.getDescription()) : FileTypesBundle.message("filetype.edit.hashbang.exists.similar.error", existingFileType.getDescription(), conflict.existingHashBang);
                Messages.showMessageDialog(this.myHashBangs.myList, (String)message, (String)title, (Icon)Messages.getErrorIcon());
                return;
            }
            String message = conflict.exact ? FileTypesBundle.message("filetype.edit.hashbang.exists.exact.message", existingFileType.getDescription()) : FileTypesBundle.message("filetype.edit.hashbang.exists.similar.message", existingFileType.getDescription(), conflict.existingHashBang);
            int ret = Messages.showOkCancelDialog(this.myHashBangs.myList, (String)message, (String)FileTypesBundle.message("filetype.edit.hashbang.exists.title", new Object[0]), (String)FileTypesBundle.message("filetype.edit.hashbang.reassign.button", new Object[0]), (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getQuestionIcon());
            if (ret != 0) {
                return;
            }
            this.myTempPatternsTable.removeHashBangPattern(hashbang, (Object)existingFileType);
            if (oldLanguage != null) {
                this.myTempTemplateDataLanguages.removeHashBangPattern(hashbang, (Object)oldLanguage);
            }
            this.myTempPatternsTable.removeHashBangPattern(conflict.existingHashBang, (Object)conflict.fileType);
        }
        if (oldHashBang != null) {
            this.myTempPatternsTable.removeHashBangPattern(oldHashBang, (Object)type);
            if (oldLanguage != null) {
                this.myTempTemplateDataLanguages.removeHashBangPattern(oldHashBang, (Object)oldLanguage);
            }
        }
        this.myTempPatternsTable.addHashBangPattern(hashbang, (Object)type);
        this.updateExtensionList();
        this.myHashBangs.select(hashbang);
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myPatterns.myList, true));
    }

    private static boolean isStandardFileType(@NotNull FileType fileType) {
        if (fileType == null) {
            FileTypeConfigurable.$$$reportNull$$$0(6);
        }
        return FileTypeManager.getInstance().getStdFileType(fileType.getName()) == fileType;
    }

    private HashBangConflict checkHashBangConflict(@NotNull String hashbang) {
        String existingHashBang;
        if (hashbang == null) {
            FileTypeConfigurable.$$$reportNull$$$0(7);
        }
        HashBangConflict conflict = new HashBangConflict();
        for (Map.Entry entry : this.myTempPatternsTable.getInternalRawHashBangPatterns().entrySet()) {
            existingHashBang = (String)entry.getKey();
            if (!hashbang.contains(existingHashBang) && !existingHashBang.contains(hashbang)) continue;
            conflict.fileType = (FileType)entry.getValue();
            conflict.exact = existingHashBang.equals(hashbang);
            conflict.writeable = !conflict.fileType.isReadOnly() && !FileTypeConfigurable.isStandardFileType(conflict.fileType);
            conflict.existingHashBang = existingHashBang;
            return conflict;
        }
        for (FileTypeRegistry.FileTypeDetector detector : FileTypeRegistry.FileTypeDetector.EP_NAME.getIterable()) {
            if (!(detector instanceof HashBangFileTypeDetector) || !hashbang.contains(existingHashBang = ((HashBangFileTypeDetector)detector).getMarker()) && !existingHashBang.contains(hashbang)) continue;
            conflict.fileType = ((HashBangFileTypeDetector)detector).getFileType();
            conflict.exact = existingHashBang.equals(hashbang);
            conflict.writeable = false;
            conflict.existingHashBang = existingHashBang;
            return conflict;
        }
        return null;
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            FileTypeConfigurable.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashbang";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredFilesTypes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateAssociateMessageLabel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showAssociationBalloon";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findExistingFileType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "selectFileType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isStandardFileType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkHashBangConflict";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HashBangConflict {
        FileType fileType;
        boolean exact;
        boolean writeable;
        String existingHashBang;

        private HashBangConflict() {
        }
    }

    class HashBangPanel
    extends JPanel {
        private final JBList<String> myList = new JBList(new DefaultListModel());

        HashBangPanel() {
            this.setLayout(new BorderLayout());
            this.myList.setSelectionMode(0);
            this.myList.setCellRenderer((ListCellRenderer)new ExtensionRenderer(){

                @Override
                @NotNull
                public Component getListCellRendererComponent(@NotNull JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                    if (list2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Component component2 = super.getListCellRendererComponent(list2, value2, index, isSelected, cellHasFocus);
                    this.setText(" #!*" + value2 + "*");
                    Component component3 = component2;
                    if (component3 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return component3;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "list";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$HashBangPanel$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$HashBangPanel$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getListCellRendererComponent";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getListCellRendererComponent";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
            this.myList.setEmptyText(FileTypesBundle.message("filetype.settings.no.patterns", new Object[0]));
            ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myList).setScrollPaneBorder((Border)JBUI.Borders.empty()).setPanelBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)1, (int)0, (int)1)).setAddAction(__ -> FileTypeConfigurable.this.editHashBang(null)).setAddActionName(LangBundle.message((String)"action.HashBangPanel.add.hashbang.pattern.text", (Object[])new Object[0])).setEditAction(__ -> FileTypeConfigurable.this.editHashBang()).setRemoveAction(__ -> FileTypeConfigurable.this.removeHashBang()).disableUpDownActions();
            this.add((Component)decorator.createPanel(), "North");
            JBScrollPane scrollPane = new JBScrollPane(this.myList);
            this.add((Component)scrollPane, "Center");
            this.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FileTypesBundle.message("filetype.hashbang.group", new Object[0]), (boolean)false, (Insets)TITLE_INSETS).setShowLine(false));
        }

        void clearList() {
            ((DefaultListModel)this.myList.getModel()).clear();
            this.myList.clearSelection();
        }

        void select(@NotNull String pattern) {
            if (pattern == null) {
                HashBangPanel.$$$reportNull$$$0(0);
            }
            ScrollingUtil.selectItem(this.myList, (Object)pattern);
        }

        String removeSelected() {
            String selectedValue = this.getSelectedItem();
            if (selectedValue == null) {
                return null;
            }
            ListUtil.removeSelectedItems(this.myList);
            return selectedValue;
        }

        String getSelectedItem() {
            return (String)this.myList.getSelectedValue();
        }

        private void refill(@NotNull List<String> patterns) {
            if (patterns == null) {
                HashBangPanel.$$$reportNull$$$0(1);
            }
            this.clearList();
            Collections.sort(patterns);
            DefaultListModel model2 = (DefaultListModel)this.myList.getModel();
            for (String pattern : patterns) {
                model2.addElement(pattern);
            }
            ScrollingUtil.ensureSelectionExists(this.myList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patterns";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$HashBangPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "select";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refill";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    class PatternsPanel
    extends JPanel {
        private final JBList<String> myList = new JBList(new DefaultListModel());

        PatternsPanel() {
            this.setLayout(new BorderLayout());
            this.myList.setSelectionMode(0);
            this.myList.setCellRenderer((ListCellRenderer)new ExtensionRenderer());
            this.myList.getEmptyText().setText(FileTypesBundle.message("filetype.settings.no.patterns", new Object[0]));
            ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myList).setScrollPaneBorder((Border)JBUI.Borders.empty()).setPanelBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)1, (int)0, (int)1)).setAddAction(__ -> FileTypeConfigurable.this.addPattern()).setEditAction(__ -> FileTypeConfigurable.this.editPattern()).setRemoveAction(__ -> FileTypeConfigurable.this.removePattern()).disableUpDownActions();
            this.add((Component)decorator.createPanel(), "North");
            JBScrollPane scrollPane = new JBScrollPane(this.myList);
            this.add((Component)scrollPane, "Center");
            this.setBorder((Border)IdeBorderFactory.createTitledBorder((String)FileTypesBundle.message("filetype.registered.patterns.group", new Object[0]), (boolean)false, (Insets)TITLE_INSETS).setShowLine(false));
        }

        void clearList() {
            ((DefaultListModel)this.myList.getModel()).clear();
            this.myList.clearSelection();
        }

        void select(@NotNull String pattern) {
            if (pattern == null) {
                PatternsPanel.$$$reportNull$$$0(0);
            }
            for (int i2 = 0; i2 < this.myList.getItemsCount(); ++i2) {
                String at = (String)this.myList.getModel().getElementAt(i2);
                FileNameMatcher matcher = FileTypeManager.parseFromString((String)at);
                if (!matcher.acceptsCharSequence((CharSequence)pattern)) continue;
                ScrollingUtil.selectItem(this.myList, (int)i2);
                return;
            }
        }

        String removeSelected() {
            String selectedValue = this.getSelectedItem();
            if (selectedValue == null) {
                return null;
            }
            ListUtil.removeSelectedItems(this.myList);
            return selectedValue;
        }

        String getSelectedItem() {
            return (String)this.myList.getSelectedValue();
        }

        private void refill(@NotNull List<? extends FileNameMatcher> matchers) {
            if (matchers == null) {
                PatternsPanel.$$$reportNull$$$0(1);
            }
            this.clearList();
            ArrayList<? extends FileNameMatcher> copy2 = new ArrayList<FileNameMatcher>(matchers);
            copy2.sort(Comparator.comparing(FileNameMatcher::getPresentableString));
            DefaultListModel model2 = (DefaultListModel)this.myList.getModel();
            for (FileNameMatcher fileNameMatcher : copy2) {
                model2.addElement(fileNameMatcher.getPresentableString());
            }
            ScrollingUtil.ensureSelectionExists(this.myList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchers";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$PatternsPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "select";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refill";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    class RecognizedFileTypesPanel
    extends JPanel {
        private final JList<FileType> myFileTypesList = new JBList(new DefaultListModel());

        RecognizedFileTypesPanel() {
            this.setLayout(new BorderLayout());
            this.myFileTypesList.setSelectionMode(0);
            this.myFileTypesList.setCellRenderer((ListCellRenderer<FileType>)((Object)new FileTypeRenderer(this.myFileTypesList.getModel())));
            new DoubleClickListener(){

                protected boolean onDoubleClick(@NotNull MouseEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    FileTypeConfigurable.this.editFileType();
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$RecognizedFileTypesPanel$1", "onDoubleClick"));
                }
            }.installOn(this.myFileTypesList);
            ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator(this.myFileTypesList).setScrollPaneBorder((Border)JBUI.Borders.empty()).setPanelBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)1, (int)0, (int)1)).setAddAction(__ -> FileTypeConfigurable.this.addFileType()).setRemoveAction(__ -> FileTypeConfigurable.this.removeFileType()).setEditAction(__ -> FileTypeConfigurable.this.editFileType()).setEditActionUpdater(e -> {
                FileType fileType = this.getSelectedFileType();
                return FileTypeConfigurable.canBeModified(fileType);
            }).setRemoveActionUpdater(e -> FileTypeConfigurable.canBeModified(this.getSelectedFileType())).disableUpDownActions();
            this.add((Component)toolbarDecorator.createPanel(), "North");
            JBScrollPane scrollPane = new JBScrollPane(this.myFileTypesList);
            this.add((Component)scrollPane, "Center");
            new MySpeedSearch(this.myFileTypesList);
        }

        FileType getSelectedFileType() {
            return this.myFileTypesList.getSelectedValue();
        }

        void setFileTypes(@NotNull Iterable<? extends FileType> types) {
            if (types == null) {
                RecognizedFileTypesPanel.$$$reportNull$$$0(0);
            }
            DefaultListModel listModel = (DefaultListModel)this.myFileTypesList.getModel();
            listModel.clear();
            for (FileType fileType : types) {
                if (fileType == FileTypes.UNKNOWN) continue;
                listModel.addElement(fileType);
            }
            ScrollingUtil.ensureSelectionExists(this.myFileTypesList);
        }

        void selectFileType(@NotNull FileType fileType) {
            if (fileType == null) {
                RecognizedFileTypesPanel.$$$reportNull$$$0(1);
            }
            this.myFileTypesList.setSelectedValue(fileType, true);
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myFileTypesList, true));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileType";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$RecognizedFileTypesPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setFileTypes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectFileType";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private final class MySpeedSearch
        extends SpeedSearchBase<JList<FileType>> {
            private final List<Condition<Pair<Object, String>>> myOrderedConverters;
            private Object myCurrentType;
            private String myExtension;

            private MySpeedSearch(JList<FileType> component2) {
                if (component2 == null) {
                    MySpeedSearch.$$$reportNull$$$0(0);
                }
                super(component2);
                this.myOrderedConverters = Arrays.asList(p -> {
                    String value2 = p.first.toString();
                    if (p.first instanceof FileType) {
                        value2 = ((FileType)p.first).getDescription();
                    }
                    return this.getComparator().matchingFragments((String)p.second, value2) != null;
                }, p -> p.first instanceof FileType && this.myCurrentType != null && this.myCurrentType.equals(p.first));
            }

            @Override
            protected boolean isMatchingElement(Object element2, String pattern) {
                for (Condition<Pair<Object, String>> convertor : this.myOrderedConverters) {
                    boolean matched = convertor.value((Object)Pair.pair((Object)element2, (Object)pattern));
                    if (!matched) continue;
                    return true;
                }
                return false;
            }

            @Override
            @Nullable
            protected final String getElementText(Object element2) {
                throw new IllegalStateException();
            }

            @Override
            protected int getSelectedIndex() {
                return ((JList)this.myComponent).getSelectedIndex();
            }

            @Override
            protected Object @NotNull [] getAllElements() {
                Object[] objectArray = ListSpeedSearch.getAllListElements((JList)this.myComponent);
                if (objectArray == null) {
                    MySpeedSearch.$$$reportNull$$$0(1);
                }
                return objectArray;
            }

            @Override
            protected void selectElement(Object element2, String selectedText) {
                if (element2 != null) {
                    ScrollingUtil.selectItem((JList)((JList)this.myComponent), (Object)((FileType)element2));
                    if (element2.equals(this.myCurrentType)) {
                        FileTypeConfigurable.this.myPatterns.select(this.myExtension);
                    }
                }
            }

            @Override
            protected void onSearchFieldUpdated(String s) {
                if (FileTypeConfigurable.this.myTempPatternsTable == null) {
                    return;
                }
                int index = ((String)s).lastIndexOf(46);
                if (index < 0) {
                    s = "." + (String)s;
                }
                this.myCurrentType = FileTypeConfigurable.this.myTempPatternsTable.findAssociatedFileType((CharSequence)s);
                this.myExtension = this.myCurrentType != null ? s : null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "component";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$RecognizedFileTypesPanel$MySpeedSearch";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$RecognizedFileTypesPanel$MySpeedSearch";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAllElements";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
    }

    private static class ExtensionRenderer
    extends DefaultListCellRenderer {
        private ExtensionRenderer() {
        }

        @Override
        @NotNull
        public Component getListCellRendererComponent(@NotNull JList list2, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
            if (list2 == null) {
                ExtensionRenderer.$$$reportNull$$$0(0);
            }
            super.getListCellRendererComponent((JList<?>)list2, value2, index, isSelected, cellHasFocus);
            this.setText(" " + this.getText());
            ExtensionRenderer extensionRenderer = this;
            if (extensionRenderer == null) {
                ExtensionRenderer.$$$reportNull$$$0(1);
            }
            return extensionRenderer;
        }

        @Override
        public Dimension getPreferredSize() {
            return new JBDimension(0, 20);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$ExtensionRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileTypes/impl/FileTypeConfigurable$ExtensionRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getListCellRendererComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getListCellRendererComponent";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

