/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.http;

import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.http.RefreshRemoteFileAction;
import com.intellij.openapi.fileEditor.impl.http.RemoteFileEditorActionProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.FileDownloadingListener;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteFilePanel {
    private static final Logger LOG = Logger.getInstance(RemoteFilePanel.class);
    @NonNls
    private static final String ERROR_CARD = "error";
    @NonNls
    private static final String DOWNLOADING_CARD = "downloading";
    @NonNls
    private static final String EDITOR_CARD = "editor";
    private JPanel myMainPanel;
    private JLabel myProgressLabel;
    private JProgressBar myProgressBar;
    private JButton myCancelButton;
    private JPanel myContentPanel;
    private JLabel myErrorLabel;
    private JButton myTryAgainButton;
    private JButton myChangeProxySettingsButton;
    private JPanel myEditorPanel;
    private JTextField myUrlTextField;
    private JPanel myToolbarPanel;
    private final Project myProject;
    private final HttpVirtualFile myVirtualFile;
    private final MergingUpdateQueue myProgressUpdatesQueue;
    private final MyDownloadingListener myDownloadingListener;
    private final PropertyChangeListener myPropertyChangeListener;
    @Nullable
    private TextEditor myFileEditor;

    public RemoteFilePanel(Project project, HttpVirtualFile virtualFile, @NotNull PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            RemoteFilePanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myVirtualFile = virtualFile;
        this.myPropertyChangeListener = propertyChangeListener;
        this.$$$setupUI$$$();
        this.myErrorLabel.setIcon(AllIcons.General.BalloonError);
        this.myUrlTextField.setText(virtualFile.getUrl());
        this.myProgressUpdatesQueue = new MergingUpdateQueue("downloading progress updates", 300, false, (JComponent)this.myMainPanel);
        this.initToolbar(project);
        final RemoteFileInfo remoteFileInfo = virtualFile.getFileInfo();
        this.myDownloadingListener = new MyDownloadingListener();
        assert (remoteFileInfo != null);
        remoteFileInfo.addDownloadingListener(this.myDownloadingListener);
        this.myCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                remoteFileInfo.cancelDownloading();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileEditor/impl/http/RemoteFilePanel$1", "actionPerformed"));
            }
        });
        this.myTryAgainButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                RemoteFilePanel.this.showCard(RemoteFilePanel.DOWNLOADING_CARD);
                remoteFileInfo.restartDownloading();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileEditor/impl/http/RemoteFilePanel$2", "actionPerformed"));
            }
        });
        this.myChangeProxySettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                HttpConfigurable.editConfigurable((JComponent)RemoteFilePanel.this.myMainPanel);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileEditor/impl/http/RemoteFilePanel$3", "actionPerformed"));
            }
        });
        if (remoteFileInfo.getState() != RemoteFileState.DOWNLOADED) {
            this.showCard(DOWNLOADING_CARD);
            remoteFileInfo.startDownloading();
        }
        if (remoteFileInfo.getState() == RemoteFileState.DOWNLOADED) {
            this.switchEditor();
        } else {
            String errorMessage = remoteFileInfo.getErrorMessage();
            if (errorMessage != null) {
                this.myDownloadingListener.errorOccurred(errorMessage);
            }
        }
    }

    private void initToolbar(Project project) {
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add((AnAction)new RefreshRemoteFileAction(this.myVirtualFile));
        for (RemoteFileEditorActionProvider actionProvider : (RemoteFileEditorActionProvider[])RemoteFileEditorActionProvider.EP_NAME.getExtensions()) {
            group2.addAll(actionProvider.createToolbarActions(project, this.myVirtualFile));
        }
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("RemoteFilePanel", (ActionGroup)group2, true);
        this.myToolbarPanel.add((Component)actionToolbar.getComponent(), "Center");
    }

    private void showCard(String name) {
        ((CardLayout)this.myContentPanel.getLayout()).show(this.myContentPanel, name);
    }

    private void switchEditor() {
        LOG.debug("Switching editor...");
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)this.myProject)).submit(() -> {
            TextEditor textEditor = (TextEditor)TextEditorProvider.getInstance().createEditor(this.myProject, this.myVirtualFile);
            textEditor.addPropertyChangeListener(this.myPropertyChangeListener);
            this.myEditorPanel.removeAll();
            this.myEditorPanel.add((Component)textEditor.getComponent(), "Center");
            this.myFileEditor = textEditor;
            this.showCard(EDITOR_CARD);
            LOG.debug("Editor for downloaded file opened.");
        });
    }

    @Nullable
    public TextEditor getFileEditor() {
        return this.myFileEditor;
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void selectNotify() {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myProgressUpdatesQueue.showNotify();
            if (this.myFileEditor != null) {
                this.myFileEditor.selectNotify();
            }
        });
    }

    public void deselectNotify() {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myProgressUpdatesQueue.hideNotify();
            if (this.myFileEditor != null) {
                this.myFileEditor.deselectNotify();
            }
        });
    }

    public void dispose() {
        this.myVirtualFile.getFileInfo().removeDownloadingListener(this.myDownloadingListener);
        Disposer.dispose((Disposable)this.myProgressUpdatesQueue);
        if (this.myFileEditor != null) {
            Disposer.dispose((Disposable)this.myFileEditor);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyChangeListener", "com/intellij/openapi/fileEditor/impl/http/RemoteFilePanel", "<init>"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel2;
        JTextField jTextField;
        JPanel jPanel3;
        JButton jButton;
        JButton jButton2;
        JLabel jLabel;
        JButton jButton3;
        JProgressBar jProgressBar;
        JLabel jLabel2;
        JPanel jPanel4;
        JPanel jPanel5;
        this.myMainPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        this.myContentPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new CardLayout(0, 0));
        jPanel5.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, DOWNLOADING_CARD);
        this.myProgressLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/IdeBundle", RemoteFilePanel.class).getString("label.downloading.file.started"));
        jPanel6.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(241, 28), null, 1));
        this.myProgressBar = jProgressBar = new JProgressBar();
        jPanel7.add((Component)jProgressBar, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myCancelButton = jButton3 = new JButton();
        this.$$$loadButtonText$$$(jButton3, DynamicBundle.getBundle((String)"messages/CommonBundle", RemoteFilePanel.class).getString("button.cancel"));
        jPanel7.add((Component)jButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel4.add((Component)jPanel8, ERROR_CARD);
        this.myErrorLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel8.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel9, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myChangeProxySettingsButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, DynamicBundle.getBundle((String)"messages/UIBundle", RemoteFilePanel.class).getString("downloading.file.change.http.proxy.settings"));
        jPanel9.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel9.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myTryAgainButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/UIBundle", RemoteFilePanel.class).getString("downloading.file.try.again.button"));
        jPanel9.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel8.add((Component)spacer3, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myEditorPanel = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel3, EDITOR_CARD);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(3, 3, 0, 3), 0, -1, false, false));
        jPanel5.add((Component)jPanel10, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 1, null, null, null));
        this.myUrlTextField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jPanel10.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myToolbarPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel10.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyDownloadingListener
    implements FileDownloadingListener {
        private MyDownloadingListener() {
        }

        @Override
        public void fileDownloaded(@NotNull VirtualFile localFile) {
            if (localFile == null) {
                MyDownloadingListener.$$$reportNull$$$0(0);
            }
            RemoteFilePanel.this.switchEditor();
        }

        @Override
        public void downloadingCancelled() {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (RemoteFilePanel.this.myFileEditor != null) {
                    RemoteFilePanel.this.showCard(RemoteFilePanel.EDITOR_CARD);
                } else {
                    RemoteFilePanel.this.myErrorLabel.setText(IdeBundle.message((String)"label.downloading.cancelled", (Object[])new Object[0]));
                    RemoteFilePanel.this.showCard(RemoteFilePanel.ERROR_CARD);
                }
            });
        }

        @Override
        public void downloadingStarted() {
            ApplicationManager.getApplication().invokeLater(() -> RemoteFilePanel.this.showCard(RemoteFilePanel.DOWNLOADING_CARD));
        }

        @Override
        public void errorOccurred(@NotNull String errorMessage) {
            if (errorMessage == null) {
                MyDownloadingListener.$$$reportNull$$$0(1);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                RemoteFilePanel.this.myErrorLabel.setText(errorMessage);
                RemoteFilePanel.this.showCard(RemoteFilePanel.ERROR_CARD);
            });
        }

        @Override
        public void progressMessageChanged(boolean indeterminate, final @NotNull String message) {
            if (message == null) {
                MyDownloadingListener.$$$reportNull$$$0(2);
            }
            RemoteFilePanel.this.myProgressUpdatesQueue.queue(new Update("progress text"){

                public void run() {
                    RemoteFilePanel.this.myProgressLabel.setText(message);
                }
            });
        }

        @Override
        public void progressFractionChanged(final double fraction) {
            RemoteFilePanel.this.myProgressUpdatesQueue.queue(new Update("fraction"){

                public void run() {
                    RemoteFilePanel.this.myProgressBar.setValue((int)Math.round(100.0 * fraction));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "localFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorMessage";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileEditor/impl/http/RemoteFilePanel$MyDownloadingListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileDownloaded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "errorOccurred";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "progressMessageChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

