/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.configurationStore.BundledSchemeEP;
import com.intellij.configurationStore.LazySchemeProcessor;
import com.intellij.configurationStore.SchemeDataHolder;
import com.intellij.configurationStore.SchemeExtensionProvider;
import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UITheme;
import com.intellij.ide.ui.laf.TempUIThemeBasedLookAndFeelInfo;
import com.intellij.ide.ui.laf.UIThemeBasedLookAndFeelInfo;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.AbstractColorsScheme;
import com.intellij.openapi.editor.colors.impl.AdditionalTextAttributesEP;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorSchemesComparator;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.ReadOnlyColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ComponentTreeEventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.URLUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import javax.swing.UIManager;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="EditorColorsManagerImpl", storages={@Storage(value="colors.scheme.xml")}, additionalExportDirectory="colors")
public final class EditorColorsManagerImpl
extends EditorColorsManager
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(EditorColorsManagerImpl.class);
    private static final ExtensionPointName<BundledSchemeEP> BUNDLED_EP_NAME = ExtensionPointName.create((String)"com.intellij.bundledColorScheme");
    private final ComponentTreeEventDispatcher<EditorColorsListener> myTreeDispatcher;
    private final SchemeManager<EditorColorsScheme> mySchemeManager;
    static final String FILE_SPEC = "colors";
    private State myState;
    @NonNls
    private static final String TEMP_SCHEME_KEY = "TEMP_SCHEME_KEY";
    @NonNls
    private static final String TEMP_SCHEME_FILE_KEY = "TEMP_SCHEME_FILE_KEY";

    public EditorColorsManagerImpl() {
        this(SchemeManagerFactory.getInstance());
    }

    @NonInjectable
    public EditorColorsManagerImpl(@NotNull SchemeManagerFactory schemeManagerFactory) {
        if (schemeManagerFactory == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(0);
        }
        this.myTreeDispatcher = ComponentTreeEventDispatcher.create(EditorColorsListener.class);
        this.myState = new State();
        MultiMap<String, AdditionalTextAttributesEP> additionalTextAttributes = EditorColorsManagerImpl.collectAdditionalTextAttributesEPs();
        final class EditorColorSchemeProcessor
        extends LazySchemeProcessor<EditorColorsScheme, EditorColorsSchemeImpl>
        implements SchemeExtensionProvider {
            private final MultiMap<String, AdditionalTextAttributesEP> myAdditionalTextAttributes;

            EditorColorSchemeProcessor(MultiMap<String, AdditionalTextAttributesEP> additionalTextAttributes) {
                if (additionalTextAttributes == null) {
                    EditorColorSchemeProcessor.$$$reportNull$$$0(0);
                }
                this.myAdditionalTextAttributes = additionalTextAttributes;
            }

            @Override
            @NotNull
            public EditorColorsSchemeImpl createScheme(@NotNull SchemeDataHolder<? super EditorColorsSchemeImpl> dataHolder, @NotNull String name, @NotNull Function<? super String, String> attributeProvider, boolean isBundled) {
                if (dataHolder == null) {
                    EditorColorSchemeProcessor.$$$reportNull$$$0(1);
                }
                if (name == null) {
                    EditorColorSchemeProcessor.$$$reportNull$$$0(2);
                }
                if (attributeProvider == null) {
                    EditorColorSchemeProcessor.$$$reportNull$$$0(3);
                }
                EditorColorsSchemeImpl scheme = isBundled ? new BundledScheme() : new EditorColorsSchemeImpl(null);
                scheme.readExternal(dataHolder.read());
                if (isBundled || ApplicationManager.getApplication().isUnitTestMode() && Boolean.valueOf(scheme.getMetaProperties().getProperty("forceOptimize")) == Boolean.TRUE) {
                    EditorColorsManagerImpl.loadAdditionalTextAttributesForScheme(scheme.myParentScheme, this.myAdditionalTextAttributes);
                    scheme.optimizeAttributeMap();
                }
                EditorColorsSchemeImpl editorColorsSchemeImpl = scheme;
                if (editorColorsSchemeImpl == null) {
                    EditorColorSchemeProcessor.$$$reportNull$$$0(4);
                }
                return editorColorsSchemeImpl;
            }

            @Override
            @NotNull
            public SchemeState getState(@NotNull EditorColorsScheme scheme) {
                if (scheme == null) {
                    EditorColorSchemeProcessor.$$$reportNull$$$0(5);
                }
                SchemeState schemeState = scheme instanceof ReadOnlyColorsScheme ? SchemeState.NON_PERSISTENT : SchemeState.POSSIBLY_CHANGED;
                if (schemeState == null) {
                    EditorColorSchemeProcessor.$$$reportNull$$$0(6);
                }
                return schemeState;
            }

            @Override
            public void onCurrentSchemeSwitched(@Nullable EditorColorsScheme oldScheme, @Nullable EditorColorsScheme newScheme, boolean processChangeSynchronously) {
                if (processChangeSynchronously) {
                    this.handleCurrentSchemeSwitched(newScheme);
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> this.handleCurrentSchemeSwitched(newScheme));
                }
            }

            private void handleCurrentSchemeSwitched(@Nullable EditorColorsScheme newScheme) {
                LafManager.getInstance().updateUI();
                EditorColorsManagerImpl.this.schemeChangedOrSwitched(newScheme);
            }

            @Override
            @NotNull
            @NonNls
            public String getSchemeExtension() {
                return ".icls";
            }

            @Override
            public boolean isSchemeEqualToBundled(@NotNull EditorColorsSchemeImpl scheme) {
                if (scheme == null) {
                    EditorColorSchemeProcessor.$$$reportNull$$$0(7);
                }
                if (!scheme.getName().startsWith("_@user_")) {
                    return false;
                }
                AbstractColorsScheme bundledScheme = (AbstractColorsScheme)EditorColorsManagerImpl.this.mySchemeManager.findSchemeByName(scheme.getName().substring("_@user_".length()));
                if (bundledScheme == null) {
                    return false;
                }
                return scheme.settingsEqual(bundledScheme);
            }

            @Override
            public void reloaded(@NotNull SchemeManager<EditorColorsScheme> schemeManager2, @NotNull Collection<? extends EditorColorsScheme> schemes) {
                if (schemeManager2 == null) {
                    EditorColorSchemeProcessor.$$$reportNull$$$0(8);
                }
                if (schemes == null) {
                    EditorColorSchemeProcessor.$$$reportNull$$$0(9);
                }
                EditorColorsManagerImpl.this.loadBundledSchemes();
                EditorColorsManagerImpl.this.loadSchemesFromThemes();
                EditorColorsManagerImpl.this.initEditableDefaultSchemesCopies();
                EditorColorsManagerImpl.this.initEditableBundledSchemesCopies();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 4: 
                    case 6: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 4: 
                    case 6: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "additionalTextAttributes";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "dataHolder";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "attributeProvider";
                        break;
                    }
                    case 4: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$1EditorColorSchemeProcessor";
                        break;
                    }
                    case 5: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheme";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "schemeManager";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "schemes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$1EditorColorSchemeProcessor";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createScheme";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getState";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "createScheme";
                        break;
                    }
                    case 4: 
                    case 6: {
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "getState";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "isSchemeEqualToBundled";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "reloaded";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 4: 
                    case 6: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
        this.mySchemeManager = schemeManagerFactory.create(FILE_SPEC, new EditorColorSchemeProcessor(additionalTextAttributes));
        this.initDefaultSchemes();
        this.loadBundledSchemes();
        this.loadSchemesFromThemes();
        this.mySchemeManager.loadSchemes();
        this.loadRemainAdditionalTextAttributes(additionalTextAttributes);
        this.initEditableDefaultSchemesCopies();
        this.initEditableBundledSchemesCopies();
        this.resolveLinksToBundledSchemes();
        this.initScheme();
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                EditorColorsManagerImpl.this.reloadKeepingActiveScheme();
            }

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                EditorColorsManagerImpl.this.reloadKeepingActiveScheme();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginLoaded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "pluginUnloaded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void reloadKeepingActiveScheme() {
        EditorColorsScheme scheme;
        String activeScheme = this.mySchemeManager.getCurrentSchemeName();
        this.mySchemeManager.reload();
        if (StringUtil.isNotEmpty((String)activeScheme) && (scheme = this.getScheme(activeScheme)) != null) {
            this.setGlobalScheme(scheme);
        }
    }

    private void initDefaultSchemes() {
        for (DefaultColorsScheme defaultScheme : DefaultColorSchemesManager.getInstance().getAllSchemes()) {
            this.mySchemeManager.addScheme(defaultScheme);
        }
    }

    private void initEditableDefaultSchemesCopies() {
        for (DefaultColorsScheme defaultScheme : DefaultColorSchemesManager.getInstance().getAllSchemes()) {
            if (!defaultScheme.hasEditableCopy()) continue;
            this.createEditableCopy(defaultScheme, defaultScheme.getEditableCopyName());
        }
    }

    private void initScheme() {
        String schemeName;
        LafManager lm;
        UIManager.LookAndFeelInfo laf;
        String wizardEditorScheme = WelcomeWizardUtil.getWizardEditorScheme();
        EditorColorsScheme scheme = null;
        if (wizardEditorScheme != null) {
            scheme = this.getScheme(wizardEditorScheme);
            LOG.assertTrue(scheme != null, (Object)("Wizard scheme " + wizardEditorScheme + " not found"));
        }
        if (scheme == null && (laf = (lm = LafManager.getInstance()).getCurrentLookAndFeel()) instanceof UIThemeBasedLookAndFeelInfo && (schemeName = ((UIThemeBasedLookAndFeelInfo)laf).getTheme().getEditorSchemeName()) != null) {
            scheme = this.getScheme(schemeName);
        }
        if (scheme == null) {
            scheme = StartupUiUtil.isUnderDarcula() ? this.getScheme("Darcula") : this.getDefaultScheme();
        }
        this.setGlobalSchemeInner(scheme);
    }

    private void loadBundledSchemes() {
        if (!EditorColorsManagerImpl.isUnitTestOrHeadlessMode()) {
            BUNDLED_EP_NAME.forEachExtensionSafe(ep2 -> this.mySchemeManager.loadBundledScheme(ep2.getPath() + ".xml", ep2));
        }
    }

    private void loadSchemesFromThemes() {
        if (EditorColorsManagerImpl.isUnitTestOrHeadlessMode()) {
            return;
        }
        for (UIManager.LookAndFeelInfo laf : LafManager.getInstance().getInstalledLookAndFeels()) {
            UITheme theme2;
            String path;
            if (!(laf instanceof UIThemeBasedLookAndFeelInfo) || (path = (theme2 = ((UIThemeBasedLookAndFeelInfo)laf).getTheme()).getEditorScheme()) == null) continue;
            this.mySchemeManager.loadBundledScheme(path, theme2);
        }
    }

    private void initEditableBundledSchemesCopies() {
        for (EditorColorsScheme scheme : this.mySchemeManager.getAllSchemes()) {
            if (!(scheme instanceof BundledScheme)) continue;
            this.createEditableCopy((BundledScheme)scheme, "_@user_" + scheme.getName());
        }
    }

    private void resolveLinksToBundledSchemes() {
        ArrayList<EditorColorsScheme> brokenSchemesList = new ArrayList<EditorColorsScheme>();
        for (EditorColorsScheme scheme : this.mySchemeManager.getAllSchemes()) {
            try {
                this.resolveSchemeParent(scheme);
            }
            catch (InvalidDataException e) {
                brokenSchemesList.add(scheme);
                String message = IdeBundle.message((String)"notification.content.color.scheme", (Object[])new Object[]{scheme.getName(), e.getMessage()});
                Notifications.Bus.notify((Notification)new Notification("System Messages", IdeBundle.message((String)"notification.title.incompatible.color.scheme", (Object[])new Object[0]), message, NotificationType.ERROR));
            }
        }
        for (EditorColorsScheme brokenScheme : brokenSchemesList) {
            this.mySchemeManager.removeScheme(brokenScheme);
        }
    }

    public void resolveSchemeParent(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(1);
        }
        if (scheme instanceof AbstractColorsScheme && !(scheme instanceof ReadOnlyColorsScheme)) {
            ((AbstractColorsScheme)scheme).resolveParent(name -> this.mySchemeManager.findSchemeByName((String)name));
        }
    }

    private void createEditableCopy(@NotNull AbstractColorsScheme initialScheme, @NotNull String editableCopyName) {
        AbstractColorsScheme editableCopy;
        if (initialScheme == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(2);
        }
        if (editableCopyName == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(3);
        }
        if ((editableCopy = (AbstractColorsScheme)this.getScheme(editableCopyName)) == null) {
            editableCopy = (AbstractColorsScheme)initialScheme.clone();
            editableCopy.setName(editableCopyName);
            this.mySchemeManager.addScheme(editableCopy);
        }
        editableCopy.setCanBeDeleted(false);
    }

    public void schemeChangedOrSwitched(@Nullable EditorColorsScheme newScheme) {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            PsiManager.getInstance((Project)project).dropPsiCaches();
        }
        ((EditorColorsListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).globalSchemeChange(newScheme);
        ((EditorColorsListener)this.myTreeDispatcher.getMulticaster()).globalSchemeChange(newScheme);
    }

    public void handleThemeAdded(@NotNull UITheme theme2) {
        String editorScheme;
        if (theme2 == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(4);
        }
        if ((editorScheme = theme2.getEditorScheme()) != null) {
            this.getSchemeManager().loadBundledScheme(editorScheme, theme2);
            this.initEditableBundledSchemesCopies();
        }
    }

    public void handleThemeRemoved(@NotNull UITheme theme2) {
        EditorColorsScheme scheme;
        String editorSchemeName;
        if (theme2 == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(5);
        }
        if ((editorSchemeName = theme2.getEditorSchemeName()) != null && (scheme = this.mySchemeManager.findSchemeByName(editorSchemeName)) != null) {
            this.mySchemeManager.removeScheme(scheme);
            String editableCopyName = EditorColorsManagerImpl.getEditableCopyName(scheme);
            if (editableCopyName != null) {
                this.mySchemeManager.removeScheme(editableCopyName);
            }
        }
    }

    private static boolean isUnitTestOrHeadlessMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    public TextAttributes getDefaultAttributes(@NotNull TextAttributesKey key) {
        if (key == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(6);
        }
        boolean dark = StartupUiUtil.isUnderDarcula() && this.getScheme("Darcula") != null;
        return this.getScheme(dark ? "Darcula" : "Default").getAttributes(key);
    }

    @NotNull
    private static MultiMap<String, AdditionalTextAttributesEP> collectAdditionalTextAttributesEPs() {
        MultiMap schemeNameToAttributesFile = MultiMap.create();
        AdditionalTextAttributesEP.EP_NAME.forEachExtensionSafe(attributesEP -> schemeNameToAttributesFile.putValue((Object)attributesEP.scheme, (Object)attributesEP));
        MultiMap multiMap = schemeNameToAttributesFile;
        if (multiMap == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(7);
        }
        return multiMap;
    }

    private void loadRemainAdditionalTextAttributes(@NotNull MultiMap<String, AdditionalTextAttributesEP> additionalTextAttributes) {
        if (additionalTextAttributes == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(8);
        }
        for (Map.Entry entry : additionalTextAttributes.entrySet()) {
            String schemeName = (String)entry.getKey();
            EditorColorsScheme editorColorsScheme = this.mySchemeManager.findSchemeByName(schemeName);
            if (!(editorColorsScheme instanceof AbstractColorsScheme)) {
                if (EditorColorsManagerImpl.isUnitTestOrHeadlessMode()) continue;
                LOG.warn("Cannot find scheme: " + schemeName + " from plugins: " + StringUtil.join((Collection)((Collection)entry.getValue()), ep2 -> ep2.getPluginDescriptor().getPluginId().getIdString(), (String)";"));
                continue;
            }
            EditorColorsManagerImpl.loadAdditionalTextAttributesForScheme((AbstractColorsScheme)editorColorsScheme, (Collection)entry.getValue());
        }
        additionalTextAttributes.clear();
    }

    private static void loadAdditionalTextAttributesForScheme(@Nullable EditorColorsScheme scheme, @NotNull MultiMap<String, AdditionalTextAttributesEP> additionalTextAttributes) {
        if (additionalTextAttributes == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(9);
        }
        if (!(scheme instanceof AbstractColorsScheme)) {
            return;
        }
        Collection attributesEPs = additionalTextAttributes.remove((Object)scheme.getName());
        if (attributesEPs == null) {
            return;
        }
        EditorColorsManagerImpl.loadAdditionalTextAttributesForScheme((AbstractColorsScheme)scheme, attributesEPs);
    }

    private static void loadAdditionalTextAttributesForScheme(@NotNull AbstractColorsScheme scheme, @NotNull Collection<AdditionalTextAttributesEP> attributesEPs) {
        if (scheme == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(10);
        }
        if (attributesEPs == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(11);
        }
        for (AdditionalTextAttributesEP attributesEP : attributesEPs) {
            URL resource = attributesEP.getLoaderForClass().getResource(attributesEP.file);
            if (resource == null) {
                LOG.warn("resource not found: " + attributesEP.file);
                continue;
            }
            try {
                Element root = JDOMUtil.load((InputStream)URLUtil.openStream((URL)resource));
                Element attrs = (Element)ObjectUtils.notNull((Object)root.getChild("attributes"), (Object)root);
                Element colors = root.getChild(FILE_SPEC);
                scheme.readAttributes(attrs);
                if (colors == null) continue;
                scheme.readColors(colors);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void addColorsScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(12);
        }
        if (!this.isDefaultScheme(scheme) && !StringUtil.isEmpty((String)scheme.getName())) {
            this.mySchemeManager.addScheme(scheme);
        }
    }

    public void removeAllSchemes() {
    }

    public EditorColorsScheme @NotNull [] getAllSchemes() {
        EditorColorsScheme[] result2 = EditorColorsManagerImpl.getAllVisibleSchemes(this.mySchemeManager.getAllSchemes());
        Arrays.sort(result2, EditorColorSchemesComparator.INSTANCE);
        if (result2 == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(13);
        }
        return result2;
    }

    private static EditorColorsScheme[] getAllVisibleSchemes(@NotNull Collection<? extends EditorColorsScheme> schemes) {
        if (schemes == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(14);
        }
        ArrayList<EditorColorsScheme> visibleSchemes = new ArrayList<EditorColorsScheme>(schemes.size() - 1);
        for (EditorColorsScheme editorColorsScheme : schemes) {
            if (!AbstractColorsScheme.isVisible(editorColorsScheme)) continue;
            visibleSchemes.add(editorColorsScheme);
        }
        return visibleSchemes.toArray(new EditorColorsScheme[0]);
    }

    public void setGlobalScheme(@Nullable EditorColorsScheme scheme) {
        this.setGlobalScheme(scheme, false);
    }

    public void setGlobalScheme(@Nullable EditorColorsScheme scheme, boolean processChangeSynchronously) {
        boolean notify2 = LoadingState.COMPONENTS_LOADED.isOccurred();
        this.mySchemeManager.setCurrent(scheme == null ? this.getDefaultScheme() : scheme, notify2, processChangeSynchronously);
    }

    private void setGlobalSchemeInner(@Nullable EditorColorsScheme scheme) {
        this.mySchemeManager.setCurrent(scheme == null ? this.getDefaultScheme() : scheme, false);
    }

    @NotNull
    private EditorColorsScheme getDefaultScheme() {
        DefaultColorsScheme defaultScheme = DefaultColorSchemesManager.getInstance().getFirstScheme();
        String editableCopyName = defaultScheme.getEditableCopyName();
        EditorColorsScheme editableCopy = this.getScheme(editableCopyName);
        assert (editableCopy != null) : "An editable copy of " + defaultScheme.getName() + " has not been initialized.";
        EditorColorsScheme editorColorsScheme = editableCopy;
        if (editorColorsScheme == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(15);
        }
        return editorColorsScheme;
    }

    @NotNull
    public EditorColorsScheme getGlobalScheme() {
        EditorColorsScheme scheme = this.mySchemeManager.getActiveScheme();
        EditorColorsScheme editableCopy = this.getEditableCopy(scheme);
        if (editableCopy != null) {
            EditorColorsScheme editorColorsScheme = editableCopy;
            if (editorColorsScheme == null) {
                EditorColorsManagerImpl.$$$reportNull$$$0(16);
            }
            return editorColorsScheme;
        }
        EditorColorsScheme editorColorsScheme = scheme == null ? this.getDefaultScheme() : scheme;
        if (editorColorsScheme == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(17);
        }
        return editorColorsScheme;
    }

    @Nullable
    private EditorColorsScheme getEditableCopy(EditorColorsScheme scheme) {
        EditorColorsScheme editableCopy;
        if (EditorColorsManagerImpl.isTempScheme(scheme)) {
            return scheme;
        }
        String editableCopyName = EditorColorsManagerImpl.getEditableCopyName(scheme);
        if (editableCopyName != null && (editableCopy = this.getScheme(editableCopyName)) != null) {
            return editableCopy;
        }
        return null;
    }

    @Nullable
    private static String getEditableCopyName(EditorColorsScheme scheme) {
        Object editableCopyName = null;
        if (scheme instanceof DefaultColorsScheme && ((DefaultColorsScheme)scheme).hasEditableCopy()) {
            editableCopyName = ((DefaultColorsScheme)scheme).getEditableCopyName();
        } else if (scheme instanceof BundledScheme) {
            editableCopyName = "_@user_" + scheme.getName();
        }
        return editableCopyName;
    }

    public EditorColorsScheme getScheme(@NonNls @NotNull String schemeName) {
        if (schemeName == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(18);
        }
        return this.mySchemeManager.findSchemeByName(schemeName);
    }

    public void setUseOnlyMonospacedFonts(boolean value2) {
        this.myState.USE_ONLY_MONOSPACED_FONTS = value2;
    }

    public boolean isUseOnlyMonospacedFonts() {
        return this.myState.USE_ONLY_MONOSPACED_FONTS;
    }

    @Nullable
    public State getState() {
        String currentSchemeName = this.mySchemeManager.getCurrentSchemeName();
        if (currentSchemeName != null && !EditorColorsManagerImpl.isTempScheme(this.mySchemeManager.getActiveScheme())) {
            this.myState.colorScheme = currentSchemeName;
        }
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(19);
        }
        this.myState = state;
        this.setGlobalSchemeInner(this.myState.colorScheme == null ? this.getDefaultScheme() : this.mySchemeManager.findSchemeByName(this.myState.colorScheme));
    }

    public boolean isDefaultScheme(EditorColorsScheme scheme) {
        return scheme instanceof DefaultColorsScheme;
    }

    @NotNull
    public EditorColorsScheme getSchemeForCurrentUITheme() {
        EditorColorsScheme editableCopy;
        UITheme theme2;
        String schemeName;
        EditorColorsScheme globalScheme;
        UIManager.LookAndFeelInfo lookAndFeelInfo = LafManager.getInstance().getCurrentLookAndFeel();
        EditorColorsScheme scheme = null;
        if (lookAndFeelInfo instanceof TempUIThemeBasedLookAndFeelInfo && EditorColorsManagerImpl.isTempScheme(globalScheme = EditorColorsManager.getInstance().getGlobalScheme())) {
            EditorColorsScheme editorColorsScheme = globalScheme;
            if (editorColorsScheme == null) {
                EditorColorsManagerImpl.$$$reportNull$$$0(20);
            }
            return editorColorsScheme;
        }
        if (lookAndFeelInfo instanceof UIThemeBasedLookAndFeelInfo && (schemeName = (theme2 = ((UIThemeBasedLookAndFeelInfo)lookAndFeelInfo).getTheme()).getEditorSchemeName()) != null) {
            scheme = this.getScheme(schemeName);
            assert (scheme != null) : "Theme " + theme2.getName() + " refers to unknown color scheme " + schemeName;
        }
        if (scheme == null) {
            String schemeName2 = StartupUiUtil.isUnderDarcula() ? "Darcula" : "Default";
            DefaultColorSchemesManager colorSchemeManager = DefaultColorSchemesManager.getInstance();
            scheme = colorSchemeManager.getScheme(schemeName2);
            assert (scheme != null) : "The default scheme '" + schemeName2 + "' not found, available schemes: " + colorSchemeManager.listNames();
        }
        EditorColorsScheme editorColorsScheme = (editableCopy = this.getEditableCopy(scheme)) != null ? editableCopy : scheme;
        if (editorColorsScheme == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(21);
        }
        return editorColorsScheme;
    }

    @NotNull
    public SchemeManager<EditorColorsScheme> getSchemeManager() {
        SchemeManager<EditorColorsScheme> schemeManager2 = this.mySchemeManager;
        if (schemeManager2 == null) {
            EditorColorsManagerImpl.$$$reportNull$$$0(22);
        }
        return schemeManager2;
    }

    public static boolean isTempScheme(EditorColorsScheme scheme) {
        if (scheme == null) {
            return false;
        }
        return StringUtil.equals((CharSequence)scheme.getMetaProperties().getProperty(TEMP_SCHEME_KEY), (CharSequence)Boolean.TRUE.toString());
    }

    @Nullable
    public static Path getTempSchemeOriginalFilePath(EditorColorsScheme scheme) {
        String path;
        if (EditorColorsManagerImpl.isTempScheme(scheme) && (path = scheme.getMetaProperties().getProperty(TEMP_SCHEME_FILE_KEY)) != null) {
            return Paths.get(path, new String[0]);
        }
        return null;
    }

    public static void setTempScheme(EditorColorsScheme scheme, @Nullable VirtualFile originalSchemeFile) {
        if (scheme == null) {
            return;
        }
        scheme.getMetaProperties().setProperty(TEMP_SCHEME_KEY, Boolean.TRUE.toString());
        if (originalSchemeFile != null) {
            scheme.getMetaProperties().setProperty(TEMP_SCHEME_FILE_KEY, originalSchemeFile.getPath());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeManagerFactory";
                break;
            }
            case 1: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialScheme";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editableCopyName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "theme";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 7: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalTextAttributes";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesEPs";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemes";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemeName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/impl/EditorColorsManagerImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAdditionalTextAttributesEPs";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSchemes";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultScheme";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalScheme";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemeForCurrentUITheme";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemeManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveSchemeParent";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditableCopy";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleThemeAdded";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleThemeRemoved";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultAttributes";
                break;
            }
            case 7: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadRemainAdditionalTextAttributes";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalTextAttributesForScheme";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addColorsScheme";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAllVisibleSchemes";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getScheme";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class State {
        public boolean USE_ONLY_MONOSPACED_FONTS = true;
        @OptionTag(tag="global_color_scheme", nameAttribute="", valueAttribute="name")
        public String colorScheme;

        State() {
        }
    }

    static final class BundledScheme
    extends EditorColorsSchemeImpl
    implements ReadOnlyColorsScheme {
        BundledScheme() {
            super(null);
        }

        @Override
        public boolean isVisible() {
            return false;
        }
    }
}

