/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.CompactActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.actionSystem.impl.ActionUpdater;
import com.intellij.openapi.actionSystem.impl.AsyncDataContext;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

public final class Utils {
    private static final Logger LOG = Logger.getInstance(Utils.class);
    @Nls
    public static final String NOTHING_HERE = CommonBundle.message((String)"empty.menu.filler", (Object[])new Object[0]);
    public static final AnAction EMPTY_MENU_FILLER = new AnAction(CommonBundle.messagePointer((String)"empty.menu.filler", (Object[])new Object[0])){
        {
            this.getTemplatePresentation().setEnabled(false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                1.$$$reportNull$$$0(0);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                1.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/actionSystem/impl/Utils$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final boolean DO_FULL_EXPAND = Boolean.getBoolean("actionSystem.use.full.group.expand");

    public static List<AnAction> expandActionGroup(boolean isInModalContext, @NotNull ActionGroup group2, PresentationFactory presentationFactory, @NotNull DataContext context, String place) {
        if (group2 == null) {
            Utils.$$$reportNull$$$0(0);
        }
        if (context == null) {
            Utils.$$$reportNull$$$0(1);
        }
        return Utils.expandActionGroup(isInModalContext, group2, presentationFactory, context, place, null);
    }

    public static List<AnAction> expandActionGroup(boolean isInModalContext, @NotNull ActionGroup group2, PresentationFactory presentationFactory, @NotNull DataContext context, String place, ActionGroupVisitor visitor) {
        if (group2 == null) {
            Utils.$$$reportNull$$$0(2);
        }
        if (context == null) {
            Utils.$$$reportNull$$$0(3);
        }
        return Utils.expandActionGroup(isInModalContext, group2, presentationFactory, context, place, visitor, false);
    }

    public static List<AnAction> expandActionGroup(boolean isInModalContext, @NotNull ActionGroup group2, PresentationFactory presentationFactory, @NotNull DataContext context, String place, ActionGroupVisitor visitor, boolean isContextMenuAction) {
        if (group2 == null) {
            Utils.$$$reportNull$$$0(4);
        }
        if (context == null) {
            Utils.$$$reportNull$$$0(5);
        }
        return new ActionUpdater(isInModalContext, presentationFactory, context, place, isContextMenuAction, false, false, visitor).expandActionGroup(group2, group2 instanceof CompactActionGroup);
    }

    public static CancellablePromise<List<AnAction>> expandActionGroupAsync(boolean isInModalContext, @NotNull ActionGroup group2, PresentationFactory presentationFactory, @NotNull DataContext context, String place, @Nullable ActionGroupVisitor visitor) {
        if (group2 == null) {
            Utils.$$$reportNull$$$0(6);
        }
        if (context == null) {
            Utils.$$$reportNull$$$0(7);
        }
        if (!(context instanceof AsyncDataContext)) {
            context = new AsyncDataContext(context);
        }
        return new ActionUpdater(isInModalContext, presentationFactory, context, place, false, false, false, visitor).expandActionGroupAsync(group2, group2 instanceof CompactActionGroup);
    }

    public static List<AnAction> expandActionGroupWithTimeout(boolean isInModalContext, @NotNull ActionGroup group2, PresentationFactory presentationFactory, @NotNull DataContext context, String place, ActionGroupVisitor visitor, int timeoutMs) {
        if (group2 == null) {
            Utils.$$$reportNull$$$0(8);
        }
        if (context == null) {
            Utils.$$$reportNull$$$0(9);
        }
        return new ActionUpdater(isInModalContext, presentationFactory, context, place, false, false, false, visitor).expandActionGroupWithTimeout(group2, group2 instanceof CompactActionGroup, timeoutMs);
    }

    static void fillMenu(@NotNull ActionGroup group2, final JComponent component2, boolean enableMnemonics, PresentationFactory presentationFactory, @NotNull DataContext context, String place, boolean isWindowMenu, boolean isInModalContext, boolean useDarkIcons) {
        if (group2 == null) {
            Utils.$$$reportNull$$$0(10);
        }
        if (context == null) {
            Utils.$$$reportNull$$$0(11);
        }
        boolean checked = group2 instanceof CheckedActionGroup;
        ActionUpdater updater = new ActionUpdater(isInModalContext, presentationFactory, context, place, true, false, false);
        List<AnAction> list2 = DO_FULL_EXPAND ? updater.expandActionGroupFull(group2, group2 instanceof CompactActionGroup) : updater.expandActionGroupWithTimeout(group2, group2 instanceof CompactActionGroup);
        boolean fixMacScreenMenu = SystemInfo.isMacSystemMenu && isWindowMenu && Registry.is((String)"actionSystem.mac.screenMenuNotUpdatedFix");
        ArrayList<Component> children2 = new ArrayList<Component>();
        int size = list2.size();
        for (int i2 = 0; i2 < size; ++i2) {
            AnAction action2 = list2.get(i2);
            Presentation presentation2 = presentationFactory.getPresentation(action2);
            if (!(action2 instanceof Separator) && presentation2.isVisible() && StringUtil.isEmpty((String)presentation2.getText())) {
                String message = "Skipping empty menu item for action " + action2 + " of " + action2.getClass();
                if (action2.getTemplatePresentation().getText() == null) {
                    message = message + ". Please specify some default action text in plugin.xml or action constructor";
                }
                LOG.warn(message);
                continue;
            }
            if (action2 instanceof Separator) {
                final String text2 = ((Separator)action2).getText();
                if (StringUtil.isEmpty((String)text2) && (i2 <= 0 || i2 >= size - 1)) continue;
                JPopupMenu.Separator separator = new JPopupMenu.Separator(){
                    private final JMenuItem myMenu;
                    {
                        this.myMenu = !StringUtil.isEmpty((String)text2) ? new JMenuItem(text2) : null;
                    }

                    @Override
                    public void doLayout() {
                        super.doLayout();
                        if (this.myMenu != null) {
                            this.myMenu.setBounds(this.getBounds());
                        }
                    }

                    @Override
                    protected void paintComponent(Graphics g) {
                        if (StartupUiUtil.isUnderDarcula() || UIUtil.isUnderWin10LookAndFeel()) {
                            g.setColor(component2.getBackground());
                            g.fillRect(0, 0, this.getWidth(), this.getHeight());
                        }
                        if (this.myMenu != null) {
                            this.myMenu.paint(g);
                        } else {
                            super.paintComponent(g);
                        }
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        return this.myMenu != null ? this.myMenu.getPreferredSize() : super.getPreferredSize();
                    }
                };
                component2.add(separator);
                children2.add(separator);
                continue;
            }
            if (action2 instanceof ActionGroup && (!updater.canBePerformedCached((ActionGroup)action2) || updater.hasVisibleChildren((ActionGroup)action2))) {
                ActionMenu menu = new ActionMenu(context, place, (ActionGroup)action2, presentationFactory, enableMnemonics, useDarkIcons);
                component2.add((Component)((Object)menu));
                children2.add((Component)((Object)menu));
                continue;
            }
            ActionMenuItem each = new ActionMenuItem(action2, presentation2, place, context, enableMnemonics, !fixMacScreenMenu, checked, useDarkIcons);
            component2.add((Component)((Object)each));
            children2.add((Component)((Object)each));
        }
        if (list2.isEmpty()) {
            ActionMenuItem each = new ActionMenuItem(EMPTY_MENU_FILLER, presentationFactory.getPresentation(EMPTY_MENU_FILLER), place, context, enableMnemonics, !fixMacScreenMenu, checked, useDarkIcons);
            component2.add((Component)((Object)each));
            children2.add((Component)((Object)each));
        }
        if (fixMacScreenMenu) {
            SwingUtilities.invokeLater(() -> {
                for (Component each : children2) {
                    if (each.getParent() == null || !(each instanceof ActionMenuItem)) continue;
                    ((ActionMenuItem)((Object)((Object)each))).prepare();
                }
            });
        }
        if (SystemInfo.isMacSystemMenu && isWindowMenu) {
            if (ActionMenu.isAligned()) {
                Icon icon2 = Utils.hasIcons(children2) ? ActionMenuItem.EMPTY_ICON : null;
                children2.forEach(child2 -> Utils.replaceIconIn(child2, icon2));
            } else if (ActionMenu.isAlignedInGroup()) {
                ArrayList<Component> currentGroup = new ArrayList<Component>();
                for (int i3 = 0; i3 < children2.size(); ++i3) {
                    boolean isLastElement;
                    Component child3 = children2.get(i3);
                    boolean isSeparator = child3 instanceof JPopupMenu.Separator;
                    boolean bl = isLastElement = i3 == children2.size() - 1;
                    if (isLastElement || isSeparator) {
                        if (isLastElement && !isSeparator) {
                            currentGroup.add(child3);
                        }
                        Icon icon3 = Utils.hasIcons(currentGroup) ? ActionMenuItem.EMPTY_ICON : null;
                        currentGroup.forEach(menuItem -> Utils.replaceIconIn(menuItem, icon3));
                        currentGroup.clear();
                        continue;
                    }
                    currentGroup.add(child3);
                }
            }
        }
    }

    private static void replaceIconIn(Component menuItem, Icon icon2) {
        Icon from;
        Icon icon3 = from = icon2 == null ? ActionMenuItem.EMPTY_ICON : null;
        if (menuItem instanceof ActionMenuItem && ((ActionMenuItem)((Object)menuItem)).getIcon() == from) {
            ((ActionMenuItem)((Object)menuItem)).setIcon(icon2);
        } else if (menuItem instanceof ActionMenu && ((ActionMenu)((Object)menuItem)).getIcon() == from) {
            ((ActionMenu)((Object)menuItem)).setIcon(icon2);
        }
    }

    private static boolean hasIcons(List<Component> components) {
        for (Component comp : components) {
            if (!Utils.hasNotEmptyIcon(comp)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasNotEmptyIcon(Component comp) {
        Icon icon2 = null;
        if (comp instanceof ActionMenuItem) {
            icon2 = ((ActionMenuItem)((Object)comp)).getIcon();
        } else if (comp instanceof ActionMenu) {
            icon2 = ((ActionMenu)((Object)comp)).getIcon();
        }
        return icon2 != null && icon2 != ActionMenuItem.EMPTY_ICON;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/actionSystem/impl/Utils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "expandActionGroup";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "expandActionGroupAsync";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "expandActionGroupWithTimeout";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "fillMenu";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ActionGroupVisitor {
        public void begin();

        public boolean enterNode(@NotNull ActionGroup var1);

        public void visitLeaf(@NotNull AnAction var1);

        public void leaveNode();

        @Nullable
        public Component getCustomComponent(@NotNull AnAction var1);

        public boolean beginUpdate(@NotNull AnAction var1, AnActionEvent var2);

        public void endUpdate(@NotNull AnAction var1);
    }
}

