/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.widget;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.notification.EventLog;
import com.intellij.notification.EventLogListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.widget.IdeNotificationArea;
import com.intellij.notification.impl.widget.NotificationWidgetFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetsManager;
import com.intellij.ui.components.JBLabel;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

final class NotificationWidgetListener
implements UISettingsListener,
ToolWindowManagerListener,
EventLogListener {
    NotificationWidgetListener() {
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        if (uiSettings == null) {
            NotificationWidgetListener.$$$reportNull$$$0(0);
        }
        NotificationWidgetListener.updateWidgetAndIcon();
    }

    @Override
    public void toolWindowsRegistered(@NotNull List<String> ids, @NotNull ToolWindowManager toolWindowManager) {
        if (ids == null) {
            NotificationWidgetListener.$$$reportNull$$$0(1);
        }
        if (toolWindowManager == null) {
            NotificationWidgetListener.$$$reportNull$$$0(2);
        }
        for (String id2 : ids) {
            if (!"Event Log".equals(id2)) continue;
            NotificationWidgetListener.updateWidgetAndIcon();
        }
    }

    @Override
    public void modelChanged() {
        if (NotificationWidgetFactory.isAvailable()) {
            return;
        }
        ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
        if (projectManager == null) {
            return;
        }
        for (Project project : projectManager.getOpenProjects()) {
            if (NotificationWidgetFactory.isAvailable()) continue;
            NotificationWidgetListener.updateToolWindowNotificationsIcon(project);
        }
    }

    private static void updateWidgetAndIcon() {
        ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
        if (projectManager == null) {
            return;
        }
        boolean widgetIsAvailable = NotificationWidgetFactory.isAvailable();
        NotificationWidgetFactory widgetFactory = (NotificationWidgetFactory)StatusBarWidgetFactory.EP_NAME.findExtension(NotificationWidgetFactory.class);
        for (Project project : projectManager.getOpenProjects()) {
            if (widgetIsAvailable) {
                StatusBarWidgetsManager widgetsManager;
                if (widgetFactory == null || (widgetsManager = (StatusBarWidgetsManager)((Object)project.getService(StatusBarWidgetsManager.class))).wasWidgetCreated(widgetFactory)) continue;
                widgetsManager.updateWidget(widgetFactory);
                continue;
            }
            NotificationWidgetListener.updateToolWindowNotificationsIcon(project);
            if (widgetFactory == null) continue;
            ((StatusBarWidgetsManager)((Object)project.getService(StatusBarWidgetsManager.class))).updateWidget(widgetFactory);
        }
    }

    private static void updateToolWindowNotificationsIcon(@NotNull Project project) {
        ToolWindow eventLog;
        if (project == null) {
            NotificationWidgetListener.$$$reportNull$$$0(3);
        }
        if ((eventLog = EventLog.getEventLog(project)) != null) {
            List<Notification> notifications = EventLog.getNotifications(project);
            NotificationType type = IdeNotificationArea.getMaximumType(notifications);
            int size = notifications.size();
            ApplicationManager.getApplication().invokeLater(() -> eventLog.setIcon((Icon)IdeNotificationArea.createIconWithNotificationCount((JComponent)new JBLabel(), type, size, true)));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/notification/impl/widget/NotificationWidgetListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "uiSettingsChanged";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "toolWindowsRegistered";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateToolWindowNotificationsIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

