/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.scopeChooser.EditScopesDialog;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.ide.util.scopeChooser.ScopeDescriptorProvider;
import com.intellij.ide.util.scopeChooser.ScopePresentableNameToSerializationIdMapper;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchScopeProvider;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.BitUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Comparator;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class ScopeChooserCombo
extends ComboboxWithBrowseButton
implements Disposable {
    public static final int OPT_LIBRARIES = 1;
    public static final int OPT_SEARCH_RESULTS = 2;
    public static final int OPT_FROM_SELECTION = 4;
    public static final int OPT_USAGE_VIEW = 8;
    public static final int OPT_EMPTY_SCOPES = 16;
    private Project myProject;
    private int myOptions = 12;
    private Condition<? super ScopeDescriptor> myScopeFilter;
    private BrowseListener myBrowseListener = null;

    public ScopeChooserCombo() {
        super((JComboBox)((Object)new MyComboBox()));
    }

    public ScopeChooserCombo(Project project, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, String preselect) {
        this();
        this.init(project, suggestSearchInLibs, prevSearchWholeFiles, preselect);
    }

    public void init(Project project, String preselect) {
        this.init(project, false, true, preselect);
    }

    public void init(Project project, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, String preselect) {
        this.init(project, suggestSearchInLibs, prevSearchWholeFiles, preselect, null);
    }

    public void init(Project project, boolean suggestSearchInLibs, boolean prevSearchWholeFiles, Object selection, @Nullable Condition<? super ScopeDescriptor> scopeFilter) {
        if (this.myProject != null) {
            throw new IllegalStateException("scope chooser combo already initialized");
        }
        this.myOptions = BitUtil.set((int)this.myOptions, (int)1, (boolean)suggestSearchInLibs);
        this.myOptions = BitUtil.set((int)this.myOptions, (int)2, (boolean)prevSearchWholeFiles);
        this.myProject = project;
        NamedScopesHolder.ScopeListener scopeListener2 = () -> {
            SearchScope selectedScope = this.getSelectedScope();
            this.rebuildModelAndSelectScopeOnSuccess(selectedScope);
        };
        this.myScopeFilter = scopeFilter;
        NamedScopeManager.getInstance((Project)project).addScopeListener(scopeListener2, (Disposable)this);
        DependencyValidationManager.getInstance((Project)project).addScopeListener(scopeListener2, (Disposable)this);
        this.addActionListener(this::handleScopeChooserAction);
        ComboBox<ScopeDescriptor> combo = this.getComboBox();
        combo.setMinimumAndPreferredWidth(JBUIScale.scale((int)300));
        combo.setRenderer(ScopeChooserCombo.createDefaultRenderer());
        combo.setSwingPopup(false);
        this.rebuildModelAndSelectScopeOnSuccess(selection);
    }

    @NotNull
    public static ListCellRenderer<ScopeDescriptor> createDefaultRenderer() {
        return new MyRenderer();
    }

    public ComboBox<ScopeDescriptor> getComboBox() {
        return (ComboBox)super.getComboBox();
    }

    public void setBrowseListener(BrowseListener browseListener) {
        this.myBrowseListener = browseListener;
    }

    public void setCurrentSelection(boolean currentSelection) {
        this.myOptions = BitUtil.set((int)this.myOptions, (int)4, (boolean)currentSelection);
    }

    public void setUsageView(boolean usageView) {
        this.myOptions = BitUtil.set((int)this.myOptions, (int)8, (boolean)usageView);
    }

    public void selectItem(@Nullable Object selection) {
        if (selection == null) {
            return;
        }
        ComboBox<ScopeDescriptor> combo = this.getComboBox();
        DefaultComboBoxModel model2 = (DefaultComboBoxModel)combo.getModel();
        for (int i2 = 0; i2 < model2.getSize(); ++i2) {
            ScopeDescriptor descriptor2 = (ScopeDescriptor)model2.getElementAt(i2);
            if ((!(selection instanceof String) || !selection.equals(descriptor2.getDisplayName())) && (!(selection instanceof SearchScope) || !descriptor2.scopeEquals((SearchScope)selection))) continue;
            combo.setSelectedIndex(i2);
            break;
        }
    }

    private void handleScopeChooserAction(ActionEvent ignore) {
        EditScopesDialog dlg;
        String selection = this.getSelectedScopeName();
        if (this.myBrowseListener != null) {
            this.myBrowseListener.onBeforeBrowseStarted();
        }
        if ((dlg = EditScopesDialog.showDialog(this.myProject, selection)).isOK()) {
            NamedScope namedScope = dlg.getSelectedScope();
            this.rebuildModelAndSelectScopeOnSuccess(namedScope == null ? null : namedScope.getScopeId());
        }
        if (this.myBrowseListener != null) {
            this.myBrowseListener.onAfterBrowseFinished();
        }
    }

    public static boolean processScopes(@NotNull Project project, @NotNull DataContext dataContext, int options2, @NotNull Processor<? super ScopeDescriptor> processor2) {
        if (project == null) {
            ScopeChooserCombo.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            ScopeChooserCombo.$$$reportNull$$$0(1);
        }
        if (processor2 == null) {
            ScopeChooserCombo.$$$reportNull$$$0(2);
        }
        List<SearchScope> predefinedScopes = PredefinedSearchScopeProvider.getInstance().getPredefinedScopes(project, dataContext, BitUtil.isSet((int)options2, (int)1), BitUtil.isSet((int)options2, (int)2), BitUtil.isSet((int)options2, (int)4), BitUtil.isSet((int)options2, (int)8), BitUtil.isSet((int)options2, (int)16));
        for (SearchScope searchScope2 : predefinedScopes) {
            if (processor2.process((Object)new ScopeDescriptor(searchScope2))) continue;
            return false;
        }
        for (ScopeDescriptorProvider provider2 : ScopeDescriptorProvider.EP_NAME.getExtensionList()) {
            ScopeDescriptor[] scopeDescriptorArray = provider2.getScopeDescriptors(project);
            int n = scopeDescriptorArray.length;
            for (int j = 0; j < n; ++j) {
                ScopeDescriptor descriptor2 = scopeDescriptorArray[j];
                if (processor2.process((Object)descriptor2)) continue;
                return false;
            }
        }
        Comparator comparator2 = (o1, o2) -> {
            int w2;
            int w1 = o1 instanceof WeighedItem ? ((WeighedItem)o1).getWeight() : Integer.MAX_VALUE;
            int n = w2 = o2 instanceof WeighedItem ? ((WeighedItem)o2).getWeight() : Integer.MAX_VALUE;
            if (w1 == w2) {
                return StringUtil.naturalCompare((String)o1.getDisplayName(), (String)o2.getDisplayName());
            }
            return w1 - w2;
        };
        for (SearchScopeProvider each : (SearchScopeProvider[])SearchScopeProvider.EP_NAME.getExtensions()) {
            List<SearchScope> scopes;
            if (StringUtil.isEmpty((String)each.getDisplayName()) || (scopes = each.getSearchScopes(project, dataContext)).isEmpty()) continue;
            if (!processor2.process((Object)new ScopeSeparator(each.getDisplayName()))) {
                return false;
            }
            for (SearchScope scope : ContainerUtil.sorted(scopes, (Comparator)comparator2)) {
                if (processor2.process((Object)new ScopeDescriptor(scope))) continue;
                return false;
            }
        }
        return true;
    }

    private void rebuildModelAndSelectScopeOnSuccess(@Nullable Object selection) {
        DefaultComboBoxModel model2 = new DefaultComboBoxModel();
        Promise promise = DataManager.getInstance().getDataContextFromFocusAsync();
        promise.onSuccess(c -> {
            this.processScopes(model2, (DataContext)c);
            this.getComboBox().setModel((ComboBoxModel)model2);
            this.selectItem(selection);
        });
    }

    protected void processScopes(DefaultComboBoxModel<ScopeDescriptor> model2, DataContext c) {
        ScopeChooserCombo.processScopes(this.myProject, c, this.myOptions, (Processor<? super ScopeDescriptor>)((Processor)descriptor2 -> {
            if (this.myScopeFilter == null || this.myScopeFilter.value(descriptor2)) {
                model2.addElement((ScopeDescriptor)descriptor2);
            }
            return true;
        }));
    }

    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension preferredSize = super.getPreferredSize();
        return new Dimension(Math.min(400, preferredSize.width), preferredSize.height);
    }

    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        Dimension minimumSize = super.getMinimumSize();
        return new Dimension(Math.min(200, minimumSize.width), minimumSize.height);
    }

    public void setShowEmptyScopes(boolean showEmptyScopes) {
        this.myOptions = BitUtil.set((int)this.myOptions, (int)16, (boolean)showEmptyScopes);
    }

    @Nullable
    public SearchScope getSelectedScope() {
        ScopeDescriptor item = (ScopeDescriptor)this.getComboBox().getSelectedItem();
        return item == null ? null : item.getScope();
    }

    @Nullable
    @Nls
    public String getSelectedScopeName() {
        ScopeDescriptor item = (ScopeDescriptor)this.getComboBox().getSelectedItem();
        return item == null ? null : item.getDisplayName();
    }

    @Nullable
    @NonNls
    public String getSelectedScopeId() {
        ScopeDescriptor item = (ScopeDescriptor)this.getComboBox().getSelectedItem();
        String scopeName = item != null ? item.getDisplayName() : null;
        return scopeName != null ? ScopePresentableNameToSerializationIdMapper.getScopeSerializationId(scopeName) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
        }
        objectArray[1] = "com/intellij/ide/util/scopeChooser/ScopeChooserCombo";
        objectArray[2] = "processScopes";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyComboBox
    extends ComboBox {
        private MyComboBox() {
        }

        public void setSelectedItem(Object item) {
            if (!(item instanceof ScopeSeparator)) {
                super.setSelectedItem(item);
            }
        }

        public void setSelectedIndex(int anIndex) {
            Object item = this.getItemAt(anIndex);
            if (!(item instanceof ScopeSeparator)) {
                super.setSelectedIndex(anIndex);
            }
        }
    }

    public static interface BrowseListener {
        public void onBeforeBrowseStarted();

        public void onAfterBrowseFinished();
    }

    private static class MyRenderer
    extends SimpleListCellRenderer<ScopeDescriptor> {
        final TitledSeparator separator = new TitledSeparator();

        private MyRenderer() {
        }

        public void customize(@NotNull JList<? extends ScopeDescriptor> list2, ScopeDescriptor value2, int index, boolean selected2, boolean hasFocus) {
            if (list2 == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                return;
            }
            this.setIcon(value2.getIcon());
            this.setText(value2.getDisplayName());
        }

        public Component getListCellRendererComponent(JList<? extends ScopeDescriptor> list2, ScopeDescriptor value2, int index, boolean selected2, boolean hasFocus) {
            if (value2 instanceof ScopeSeparator) {
                this.separator.setText(value2.getDisplayName());
                this.separator.setBorder((Border)(index == -1 ? null : new JBEmptyBorder(4, 2, 4, 0)));
                return this.separator;
            }
            return super.getListCellRendererComponent(list2, (Object)value2, index, selected2, hasFocus);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/ide/util/scopeChooser/ScopeChooserCombo$MyRenderer", "customize"));
        }
    }

    private static class ScopeSeparator
    extends ScopeDescriptor {
        @Nls
        final String text;

        ScopeSeparator(@NotNull @Nls String text2) {
            if (text2 == null) {
                ScopeSeparator.$$$reportNull$$$0(0);
            }
            super(null);
            this.text = text2;
        }

        @Override
        public String getDisplayName() {
            return this.text;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/util/scopeChooser/ScopeChooserCombo$ScopeSeparator", "<init>"));
        }
    }
}

