/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins.newui;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.newui.EventHandler;
import com.intellij.ide.plugins.newui.ListPluginComponent;
import com.intellij.ide.plugins.newui.PluginsGroupComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Function;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class PluginsGroupComponentWithProgress
extends PluginsGroupComponent {
    private AsyncProcessIcon myIcon;
    private Runnable myVisibleRunnable;

    public PluginsGroupComponentWithProgress(@NotNull LayoutManager layout, @NotNull EventHandler eventHandler, @NotNull Function<? super IdeaPluginDescriptor, ? extends ListPluginComponent> function) {
        if (layout == null) {
            PluginsGroupComponentWithProgress.$$$reportNull$$$0(0);
        }
        if (eventHandler == null) {
            PluginsGroupComponentWithProgress.$$$reportNull$$$0(1);
        }
        if (function == null) {
            PluginsGroupComponentWithProgress.$$$reportNull$$$0(2);
        }
        super(layout, eventHandler, function);
        this.myIcon = new AsyncProcessIcon.BigCentered(IdeBundle.message((String)"progress.text.loading", (Object[])new Object[0]));
        this.myIcon.setOpaque(false);
        this.myIcon.setPaintPassiveIcon(false);
        this.add((Component)this.myIcon);
        this.myIcon.resume();
    }

    public void doLayout() {
        super.doLayout();
        this.updateIconLocation();
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.updateIconLocation();
    }

    private void updateIconLocation() {
        if (this.myIcon != null && this.myIcon.isVisible()) {
            this.myIcon.updateLocation((JComponent)((Object)this));
        }
    }

    public void startLoading() {
        if (this.myIcon != null) {
            this.myIcon.setVisible(true);
            this.myIcon.resume();
            this.fullRepaint();
        }
    }

    public void stopLoading() {
        if (this.myIcon != null) {
            this.myIcon.suspend();
            this.myIcon.setVisible(false);
            this.fullRepaint();
        }
    }

    private void fullRepaint() {
        this.doLayout();
        this.revalidate();
        this.repaint();
    }

    public void dispose() {
        if (this.myIcon != null) {
            this.remove((Component)this.myIcon);
            Disposer.dispose((Disposable)this.myIcon);
            this.myIcon = null;
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (this.myIcon != null) {
            this.add((Component)this.myIcon);
        }
    }

    public void setVisibleRunnable(@NotNull Runnable visibleRunnable) {
        if (visibleRunnable == null) {
            PluginsGroupComponentWithProgress.$$$reportNull$$$0(3);
        }
        this.myVisibleRunnable = visibleRunnable;
    }

    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag && this.myVisibleRunnable != null) {
            Runnable runnable2 = this.myVisibleRunnable;
            this.myVisibleRunnable = null;
            runnable2.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleRunnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/plugins/newui/PluginsGroupComponentWithProgress";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setVisibleRunnable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

