/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.menuBar;

import com.intellij.ide.RecentProjectListActionProvider;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AlwaysVisibleActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LightEditRecentFileActionGroup
extends ActionGroup
implements DumbAware,
AlwaysVisibleActionGroup {
    LightEditRecentFileActionGroup() {
        super(ApplicationBundle.messagePointer((String)"light.edit.action.recentFile.text", (Object[])new Object[0]), true);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        Project project;
        Project project2 = project = e != null ? e.getProject() : null;
        if (!LightEdit.owns((Project)project)) {
            if (AnAction.EMPTY_ARRAY == null) {
                LightEditRecentFileActionGroup.$$$reportNull$$$0(0);
            }
            return AnAction.EMPTY_ARRAY;
        }
        List<VirtualFile> recentFiles = LightEditRecentFileActionGroup.getRecentFiles(project);
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.addAll(ContainerUtil.map(recentFiles, file2 -> new OpenFileAction((VirtualFile)file2)));
        List<AnAction> recentProjectsActions = RecentProjectListActionProvider.getInstance().getActions(false);
        if (!recentProjectsActions.isEmpty()) {
            if (!actions.isEmpty()) {
                actions.add(Separator.create());
            }
            actions.addAll(recentProjectsActions);
        }
        AnAction[] anActionArray = actions.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            LightEditRecentFileActionGroup.$$$reportNull$$$0(1);
        }
        return anActionArray;
    }

    @NotNull
    private static List<VirtualFile> getRecentFiles(@NotNull Project project) {
        if (project == null) {
            LightEditRecentFileActionGroup.$$$reportNull$$$0(2);
        }
        List<VirtualFile> historyFiles = EditorHistoryManager.getInstance(project).getFileList();
        LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>(historyFiles);
        result2.removeAll(Arrays.asList(FileEditorManager.getInstance((Project)project).getOpenFiles()));
        List list2 = ContainerUtil.reverse(new ArrayList<VirtualFile>(result2));
        if (list2 == null) {
            LightEditRecentFileActionGroup.$$$reportNull$$$0(3);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/lightEdit/menuBar/LightEditRecentFileActionGroup";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/lightEdit/menuBar/LightEditRecentFileActionGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRecentFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class OpenFileAction
    extends DumbAwareAction
    implements LightEditCompatible {
        private final VirtualFile myFile;

        private OpenFileAction(@NotNull VirtualFile file2) {
            if (file2 == null) {
                OpenFileAction.$$$reportNull$$$0(0);
            }
            this.myFile = file2;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                OpenFileAction.$$$reportNull$$$0(1);
            }
            Presentation presentation2 = e.getPresentation();
            Project project = e.getProject();
            if (project == null) {
                presentation2.setEnabled(false);
                return;
            }
            presentation2.setText(UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project, this.myFile), false);
            presentation2.setIcon(IconUtil.getIcon((VirtualFile)this.myFile, (int)2, (Project)project));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                OpenFileAction.$$$reportNull$$$0(2);
            }
            if ((project = e.getProject()) != null) {
                LightEditUtil.markUnknownFileTypeAsPlainTextIfNeeded(project, this.myFile);
                LightEditFeatureUsagesUtil.logFileOpen(LightEditFeatureUsagesUtil.OpenPlace.RecentFiles);
                new OpenFileDescriptor(project, this.myFile).navigate(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/lightEdit/menuBar/LightEditRecentFileActionGroup$OpenFileAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

