/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDDropHandler;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDEventImpl;
import com.intellij.ide.dnd.DnDImage;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDSupport;
import com.intellij.ide.dnd.DnDTargetChecker;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.dnd.TransferableWrapper;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.favoritesTreeView.FavoriteTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesListNode;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.favoritesTreeView.FavoritesViewTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FavoritesPanel {
    private final Project myProject;
    private final FavoritesTreeViewPanel myViewPanel;
    private final DnDAwareTree myTree;
    private final Image myFavoritesImage;

    public FavoritesPanel(@NotNull Project project) {
        if (project == null) {
            FavoritesPanel.$$$reportNull$$$0(0);
        }
        this.myFavoritesImage = IconUtil.toImage((Icon)AllIcons.Toolwindows.ToolWindowFavorites);
        this.myProject = project;
        this.myViewPanel = new FavoritesTreeViewPanel(this.myProject);
        this.myTree = this.myViewPanel.getTree();
        FavoritesViewTreeBuilder treeBuilder = this.myViewPanel.getBuilder();
        if (treeBuilder != null) {
            Disposer.register((Disposable)this.myProject, (Disposable)treeBuilder);
        }
        this.setupDnD();
    }

    public FavoritesTreeViewPanel getPanel() {
        return this.myViewPanel;
    }

    private void setupDnD() {
        DnDSupport.createBuilder((JComponent)((Object)this.myTree)).setBeanProvider(info -> {
            FavoriteTreeNodeDescriptor root;
            Object o;
            TreePath path = this.myTree.getPathForLocation(info.getPoint().x, info.getPoint().y);
            if (path != null && path.getPathCount() == 3 && (o = path.getLastPathComponent()) instanceof DefaultMutableTreeNode && (o = ((DefaultMutableTreeNode)o).getUserObject()) instanceof FavoriteTreeNodeDescriptor && (root = ((FavoriteTreeNodeDescriptor)((Object)((Object)o))).getFavoritesRoot()) != null && root != o && (o = root.getElement()) instanceof FavoritesListNode && ((FavoritesListNode)((Object)((Object)o))).getProvider() == null) {
                return new DnDDragStartBean((Object)path);
            }
            if (path != null && path.getPathCount() == 2 && (o = path.getLastPathComponent()) instanceof DefaultMutableTreeNode && (o = ((DefaultMutableTreeNode)o).getUserObject()) instanceof FavoriteTreeNodeDescriptor && (root = ((FavoriteTreeNodeDescriptor)((Object)((Object)o))).getFavoritesRoot()) == o) {
                return new DnDDragStartBean((Object)path);
            }
            return new DnDDragStartBean(""){

                public boolean isEmpty() {
                    return true;
                }
            };
        }).setTargetChecker(new DnDTargetChecker(){

            public boolean update(DnDEvent event) {
                Object obj = event.getAttachedObject();
                if ("".equals(obj)) {
                    event.setDropPossible(false);
                    return false;
                }
                int pathCount = 0;
                if (obj instanceof TreePath && (pathCount = ((TreePath)obj).getPathCount()) < 2) {
                    event.setDropPossible(false);
                    return true;
                }
                FavoritesListNode node = FavoritesPanel.this.myViewPanel.findFavoritesListNode(event.getPoint());
                if (obj instanceof TreePath && pathCount == 3 && FavoritesPanel.this.myViewPanel.myTree.getPath((PresentableNodeDescriptor)node).isDescendant((TreePath)obj) || node != null && node.getProvider() != null) {
                    event.setDropPossible(false);
                    return false;
                }
                FavoritesPanel.this.highlight(node, event);
                if (obj instanceof TreePath && pathCount == 2 && node != null && node.getProvider() == null) {
                    event.setDropPossible(true);
                    return true;
                }
                if (node != null) {
                    event.setDropPossible(true);
                    return true;
                }
                event.setDropPossible(false);
                return false;
            }
        }).setDropHandler(new DnDDropHandler(){

            public void drop(DnDEvent event) {
                FavoritesListNode node = FavoritesPanel.this.myViewPanel.findFavoritesListNode(event.getPoint());
                FavoritesManager mgr = FavoritesManager.getInstance(FavoritesPanel.this.myProject);
                if (node == null) {
                    return;
                }
                String listTo = (String)node.getValue();
                Object obj = event.getAttachedObject();
                if (obj instanceof TreePath) {
                    Rectangle bounds2;
                    TreePath path = (TreePath)obj;
                    String listFrom = (String)FavoritesTreeViewPanel.getListNodeFromPath(path).getValue();
                    if (listTo.equals(listFrom)) {
                        return;
                    }
                    if (path.getPathCount() == 3) {
                        AbstractTreeNode abstractTreeNode = ((FavoriteTreeNodeDescriptor)((Object)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject())).getElement();
                        Object element2 = abstractTreeNode.getValue();
                        mgr.removeRoot(listFrom, Collections.singletonList(abstractTreeNode));
                        if (element2 instanceof SmartPsiElementPointer) {
                            element2 = ((SmartPsiElementPointer)element2).getElement();
                        }
                        mgr.addRoots(listTo, null, element2);
                    }
                    if (path.getPathCount() == 2 && (bounds2 = FavoritesPanel.this.myTree.getPathBounds(FavoritesPanel.this.myTree.getPath((PresentableNodeDescriptor)node))) != null) {
                        mgr.setOrder(listFrom, listTo, event.getPoint().y < bounds2.y + bounds2.height / 2);
                    }
                } else if (obj instanceof Transferable && ((Transferable)obj).isDataFlavorSupported(DnDEventImpl.ourDataFlavor)) {
                    List elements2 = Collections.emptyList();
                    try {
                        Object data2 = ((Transferable)obj).getTransferData(DnDEventImpl.ourDataFlavor);
                        if (data2 instanceof Object[]) {
                            elements2 = JBIterable.of((Object[])((Object[])data2)).filter(PsiElement.class).toList();
                        }
                    }
                    catch (UnsupportedFlavorException | IOException exception) {
                        // empty catch block
                    }
                    if (!elements2.isEmpty()) {
                        FavoritesPanel.this.myViewPanel.dropPsiElements(mgr, node, elements2.toArray(PsiElement.EMPTY_ARRAY));
                    }
                } else if (obj instanceof TransferableWrapper) {
                    FavoritesPanel.this.myViewPanel.dropPsiElements(mgr, node, ((TransferableWrapper)obj).getPsiElements());
                } else if (obj instanceof DnDNativeTarget.EventInfo) {
                    FavoritesPanel.this.myViewPanel.dropPsiElements(mgr, node, (PsiElement[])FavoritesPanel.this.getPsiFiles(FileCopyPasteUtil.getFileList(((DnDNativeTarget.EventInfo)obj).getTransferable())));
                }
            }
        }).setImageProvider(info -> new DnDImage(this.myFavoritesImage, new Point(-this.myFavoritesImage.getWidth(null) / 2, -this.myFavoritesImage.getHeight(null) / 2))).enableAsNativeTarget().setDisposableParent((Disposable)this.myProject).install();
    }

    private void highlight(FavoritesListNode node, DnDEvent event) {
        int pathCount = 0;
        Object object = event.getAttachedObject();
        if (object instanceof TreePath) {
            pathCount = ((TreePath)object).getPathCount();
        }
        if (node != null) {
            Rectangle bounds2;
            Object userObject;
            Object pathObj;
            TreePath pathToList;
            for (pathToList = this.myTree.getPath((PresentableNodeDescriptor)node); !(pathToList == null || (pathObj = pathToList.getLastPathComponent()) instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)pathObj).getUserObject()) instanceof FavoriteTreeNodeDescriptor && ((FavoriteTreeNodeDescriptor)((Object)userObject)).getElement() == node); pathToList = pathToList.getParentPath()) {
            }
            if (pathToList != null && (bounds2 = this.myTree.getPathBounds(pathToList)) != null) {
                if (pathCount == 2) {
                    boolean below;
                    FavoritesListNode pathToReorder = FavoritesTreeViewPanel.getListNodeFromPath((TreePath)object);
                    FavoritesListNode anchorPath = FavoritesTreeViewPanel.getListNodeFromPath(pathToList);
                    boolean bl = below = event.getPoint().y >= bounds2.y + bounds2.height / 2;
                    if (pathToReorder == null || anchorPath == null || !FavoritesManager.getInstance(this.myProject).canReorder((String)pathToReorder.getValue(), (String)anchorPath.getValue(), !below)) {
                        event.hideHighlighter();
                        return;
                    }
                    if (below) {
                        bounds2.y += bounds2.height - 2;
                    }
                    bounds2.height = 2;
                }
                event.setHighlighting(new RelativeRectangle((Component)((Object)this.myTree), bounds2), 1);
            }
        } else {
            event.hideHighlighter();
        }
    }

    private PsiFileSystemItem @Nullable [] getPsiFiles(@Nullable List<? extends File> fileList) {
        if (fileList == null) {
            return null;
        }
        ArrayList<PsiFileSystemItem> sourceFiles = new ArrayList<PsiFileSystemItem>();
        for (File file2 : fileList) {
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
            PsiFileSystemItem psiFile = PsiUtilCore.findFileSystemItem((Project)this.myProject, (VirtualFile)vFile);
            if (psiFile == null) continue;
            sourceFiles.add(psiFile);
        }
        return sourceFiles.toArray(new PsiFileSystemItem[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/favoritesTreeView/FavoritesPanel", "<init>"));
    }
}

