/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmarks;

import com.intellij.ide.bookmarks.Bookmark;
import com.intellij.ide.bookmarks.BookmarkManager;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.ui.popup.util.ItemWrapper;
import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.Nls;

public class BookmarkItem
extends ItemWrapper
implements Comparable<BookmarkItem> {
    private final Bookmark myBookmark;

    public BookmarkItem(Bookmark bookmark) {
        this.myBookmark = bookmark;
    }

    public Bookmark getBookmark() {
        return this.myBookmark;
    }

    public void setupRenderer(ColoredListCellRenderer renderer2, Project project, boolean selected2) {
        BookmarkItem.setupRenderer((SimpleColoredComponent)renderer2, project, this.myBookmark, selected2);
    }

    public static void setupRenderer(SimpleColoredComponent renderer2, Project project, Bookmark bookmark, boolean selected2) {
        String description;
        VirtualFile file2 = bookmark.getFile();
        if (!file2.isValid()) {
            return;
        }
        PsiFileSystemItem fileOrDir = PsiUtilCore.findFileSystemItem((Project)project, (VirtualFile)file2);
        if (fileOrDir != null) {
            renderer2.setIcon(fileOrDir.getIcon(0));
        }
        if (!StringUtilRt.isEmptyOrSpaces((CharSequence)(description = bookmark.getDescription()))) {
            renderer2.append(description + " ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES, true);
        }
        FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(file2);
        TextAttributes attributes = new TextAttributes(fileStatus.getColor(), null, null, EffectType.LINE_UNDERSCORE, 0);
        renderer2.append(file2.getName(), SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes), true);
        if (bookmark.getLine() >= 0) {
            renderer2.append(":", SimpleTextAttributes.GRAYED_ATTRIBUTES, true);
            renderer2.append(String.valueOf(bookmark.getLine() + 1), SimpleTextAttributes.GRAYED_ATTRIBUTES, true);
        }
        renderer2.append(" (" + VfsUtilCore.getRelativeLocation((VirtualFile)file2, (VirtualFile)project.getBaseDir()) + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        if (!selected2) {
            Color color;
            FileColorManager colorManager = FileColorManager.getInstance((Project)project);
            if (fileOrDir instanceof PsiFile && (color = colorManager.getRendererBackground((PsiFile)fileOrDir)) != null) {
                renderer2.setBackground(color);
            }
        }
    }

    public void setupRenderer(ColoredTreeCellRenderer renderer2, Project project, boolean selected2) {
        BookmarkItem.setupRenderer((SimpleColoredComponent)renderer2, project, this.myBookmark, selected2);
    }

    public void updateAccessoryView(JComponent component2) {
        JLabel label2 = (JLabel)component2;
        char mnemonic = this.myBookmark.getMnemonic();
        if (mnemonic != '\u0000') {
            label2.setText(Character.toString(mnemonic) + ".");
        } else {
            label2.setText("");
        }
    }

    public String speedSearchText() {
        return this.myBookmark.getFile().getName() + " " + this.myBookmark.getDescription();
    }

    @Nls
    public String footerText() {
        return this.myBookmark.getFile().getPresentableUrl();
    }

    protected void doUpdateDetailView(DetailView panel2, boolean editorOnly) {
        panel2.navigateInPreviewEditor(DetailView.PreviewEditorState.create((VirtualFile)this.myBookmark.getFile(), (int)this.myBookmark.getLine()));
    }

    public boolean allowedToRemove() {
        return true;
    }

    public void removed(Project project) {
        BookmarkManager.getInstance(project).removeBookmark(this.getBookmark());
    }

    @Override
    public int compareTo(BookmarkItem o) {
        return this.myBookmark.compareTo(o.myBookmark);
    }
}

