/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.GotoClassPresentationUpdater;
import com.intellij.ide.actions.SearchEverywhereBaseAction;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereTabDescriptor;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.keymap.impl.ModifierKeyDoubleClickHandler;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.FontUtil;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchEverywhereAction
extends SearchEverywhereBaseAction
implements CustomComponentAction,
DumbAware,
DataProvider {
    public static final Key<ConcurrentHashMap<ClientId, JBPopup>> SEARCH_EVERYWHERE_POPUP = new Key("SearchEverywherePopup");

    public SearchEverywhereAction() {
        this.setEnabledInModalContext(false);
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
        if (presentation2 == null) {
            SearchEverywhereAction.$$$reportNull$$$0(0);
        }
        if (place == null) {
            SearchEverywhereAction.$$$reportNull$$$0(1);
        }
        return new ActionButton(this, presentation2, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

            @Override
            protected void updateToolTipText() {
                String shortcutText = SearchEverywhereAction.getShortcut();
                String classesTabName = String.join((CharSequence)"/", GotoClassPresentationUpdater.getActionTitlePluralized());
                if (Registry.is((String)"ide.helptooltip.enabled")) {
                    HelpTooltip.dispose((Component)this);
                    new HelpTooltip().setTitle(this.myPresentation.getText()).setShortcut(shortcutText).setDescription(IdeBundle.message((String)"search.everywhere.action.tooltip.description.text", (Object[])new Object[]{classesTabName})).installOn((JComponent)this);
                } else {
                    this.setToolTipText(IdeBundle.message((String)"search.everywhere.action.tooltip.text", (Object[])new Object[]{shortcutText, classesTabName}));
                }
            }
        };
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            SearchEverywhereAction.$$$reportNull$$$0(2);
        }
        return null;
    }

    protected static String getShortcut() {
        Shortcut[] shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"SearchEverywhere").getShortcuts();
        if (shortcuts.length == 0) {
            return "Double" + (String)(SystemInfo.isMac ? FontUtil.thinSpace() + "\u21e7" : " Shift");
        }
        return KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SearchEverywhereAction.$$$reportNull$$$0(3);
        }
        if (LightEdit.owns((Project)e.getProject())) {
            return;
        }
        if (Registry.is((String)"ide.suppress.double.click.handler") && e.getInputEvent() instanceof KeyEvent && ((KeyEvent)e.getInputEvent()).getKeyCode() == 16) {
            return;
        }
        String searchProviderID = Registry.is((String)"search.everywhere.group.contributors.by.type") ? SearchEverywhereTabDescriptor.PROJECT.getId() : "SearchEverywhereContributor.All";
        this.showInSearchEverywherePopup(searchProviderID, e, true, true);
    }

    static {
        ModifierKeyDoubleClickHandler.getInstance().registerAction("SearchEverywhere", 16, -1, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/SearchEverywhereAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createCustomComponent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

