/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetModel;
import com.intellij.facet.FacetTypeId;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FacetModelBase
implements FacetModel {
    private volatile Map<FacetTypeId<?>, Collection<Facet<?>>> myType2Facets;
    private volatile Map<FacetAndType, Collection<Facet<?>>> myChildFacets;
    private volatile Facet<?>[] mySortedFacets;

    public Facet<?> @NotNull [] getSortedFacets() {
        if (this.mySortedFacets == null) {
            Facet[] allFacets = this.getAllFacets();
            if (allFacets.length == 0) {
                this.mySortedFacets = Facet.EMPTY_ARRAY;
            } else {
                LinkedHashSet facets2 = new LinkedHashSet();
                for (Facet facet : allFacets) {
                    FacetModelBase.addUnderlyingFacets(facets2, facet);
                }
                this.mySortedFacets = facets2.toArray(Facet.EMPTY_ARRAY);
            }
        }
        if (this.mySortedFacets == null) {
            FacetModelBase.$$$reportNull$$$0(0);
        }
        return this.mySortedFacets;
    }

    private static void addUnderlyingFacets(LinkedHashSet<? super Facet<?>> facets2, Facet<?> facet) {
        Facet underlyingFacet = facet.getUnderlyingFacet();
        if (underlyingFacet != null && !facets2.contains(facet)) {
            FacetModelBase.addUnderlyingFacets(facets2, underlyingFacet);
        }
        facets2.add(facet);
    }

    @NotNull
    public <F extends Facet<?>> Collection<F> getFacetsByType(@NotNull Facet<?> underlyingFacet, FacetTypeId<F> typeId) {
        Collection<Facet<?>> facets2;
        if (underlyingFacet == null) {
            FacetModelBase.$$$reportNull$$$0(1);
        }
        if (this.myChildFacets == null) {
            MultiMap children2 = new MultiMap();
            for (Facet facet : this.getAllFacets()) {
                Facet underlying = facet.getUnderlyingFacet();
                if (underlying == null) continue;
                children2.putValue((Object)new FacetAndType(underlying, facet.getTypeId()), (Object)facet);
            }
            this.myChildFacets = children2.freezeValues();
        }
        Collection<Object> collection = (facets2 = this.myChildFacets.get(new FacetAndType(underlyingFacet, typeId))) != null ? facets2 : Collections.emptyList();
        if (collection == null) {
            FacetModelBase.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public String getFacetName(@NotNull Facet<?> facet) {
        if (facet == null) {
            FacetModelBase.$$$reportNull$$$0(3);
        }
        String string = facet.getName();
        if (string == null) {
            FacetModelBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public <F extends Facet<?>> F findFacet(FacetTypeId<F> type, String name) {
        Collection<F> fs = this.getFacetsByType(type);
        for (Facet f : fs) {
            if (!f.getName().equals(name)) continue;
            return (F)f;
        }
        return null;
    }

    @Nullable
    public <F extends Facet<?>> F getFacetByType(@NotNull Facet<?> underlyingFacet, FacetTypeId<F> typeId) {
        Collection<F> fs;
        if (underlyingFacet == null) {
            FacetModelBase.$$$reportNull$$$0(5);
        }
        return (F)((fs = this.getFacetsByType(underlyingFacet, typeId)).isEmpty() ? null : (Facet)fs.iterator().next());
    }

    @Nullable
    public <F extends Facet<?>> F getFacetByType(FacetTypeId<F> typeId) {
        Collection<F> facets2 = this.getFacetsByType(typeId);
        return (F)(facets2.isEmpty() ? null : (Facet)facets2.iterator().next());
    }

    @NotNull
    public <F extends Facet<?>> Collection<F> getFacetsByType(FacetTypeId<F> typeId) {
        Collection<Facet<?>> facets2;
        if (this.myType2Facets == null) {
            MultiMap typeToFacets = new MultiMap();
            for (Facet facet : this.getAllFacets()) {
                typeToFacets.putValue((Object)facet.getTypeId(), (Object)facet);
            }
            this.myType2Facets = typeToFacets.freezeValues();
        }
        Collection<Object> collection = (facets2 = this.myType2Facets.get(typeId)) != null ? facets2 : Collections.emptyList();
        if (collection == null) {
            FacetModelBase.$$$reportNull$$$0(6);
        }
        return collection;
    }

    protected void facetsChanged() {
        this.myChildFacets = null;
        this.myType2Facets = null;
        this.mySortedFacets = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/FacetModelBase";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "underlyingFacet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedFacets";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/FacetModelBase";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetsByType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getFacetsByType";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFacetName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFacetByType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FacetAndType {
        final Facet<?> myFacet;
        final FacetTypeId<?> myTypeId;

        private FacetAndType(Facet<?> facet, FacetTypeId<?> id2) {
            this.myFacet = facet;
            this.myTypeId = id2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FacetAndType type = (FacetAndType)o;
            return Objects.equals(this.myFacet, type.myFacet) && Objects.equals(this.myTypeId, type.myTypeId);
        }

        public int hashCode() {
            return Objects.hash(this.myFacet, this.myTypeId);
        }
    }
}

