/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="descriptor")
final class WslDistributionDescriptor {
    @Tag(value="id")
    @NlsSafe
    private String myId;
    @Tag(value="microsoft-id")
    @NlsSafe
    private String myMsId;
    @Tag(value="executable-path")
    @NlsSafe
    @Nullable
    private String myExecutablePath;
    @Tag(value="presentable-name")
    @NlsSafe
    private String myPresentableName;
    private final AtomicNotNullLazyValue<String> myMntRootProvider;

    WslDistributionDescriptor() {
        this.myMntRootProvider = AtomicNotNullLazyValue.createValue(this::computeMntRoot);
    }

    WslDistributionDescriptor(@NotNull String id2, @NotNull String msId, @Nullable String executablePath, @NotNull String presentableName) {
        if (id2 == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(0);
        }
        if (msId == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(1);
        }
        if (presentableName == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(2);
        }
        this.myMntRootProvider = AtomicNotNullLazyValue.createValue(this::computeMntRoot);
        this.myId = id2;
        this.myMsId = msId;
        this.myExecutablePath = executablePath;
        this.myPresentableName = presentableName;
    }

    @NotNull
    @NlsSafe
    public String getId() {
        String string = Objects.requireNonNull(this.myId);
        if (string == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getMsId() {
        String string = Objects.requireNonNull(this.myMsId);
        if (string == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    public String getExecutablePath() {
        return this.myExecutablePath;
    }

    @NotNull
    @NlsSafe
    public String getPresentableName() {
        String string = Objects.requireNonNull(this.myPresentableName);
        if (string == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(5);
        }
        return string;
    }

    boolean isValid() {
        return StringUtil.isNotEmpty((String)this.myId) && StringUtil.isNotEmpty((String)this.myMsId) && StringUtil.isNotEmpty((String)this.myExecutablePath) && StringUtil.isNotEmpty((String)this.myPresentableName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WslDistributionDescriptor that = (WslDistributionDescriptor)o;
        return Objects.equals(this.getId(), that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return "WslDistributionDescriptor{id='" + this.myId + "', msId='" + this.myMsId + "'}";
    }

    @NotNull
    @NlsSafe
    final String getMntRoot() {
        String string = (String)this.myMntRootProvider.getValue();
        if (string == null) {
            WslDistributionDescriptor.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    private String computeMntRoot() {
        String currentPathSuffix;
        ProcessOutput pwdOutput;
        String windowsCurrentDirectory = System.getProperty("user.dir");
        if (StringUtil.isEmpty((String)windowsCurrentDirectory) || windowsCurrentDirectory.length() < 3) {
            WSLUtil.LOG.warn("Could not obtain current directory from user.dir (or path is too short): " + windowsCurrentDirectory);
            return "/mnt/";
        }
        WSLDistribution distribution = WSLUtil.getDistributionById(this.getId());
        if (distribution == null) {
            return "/mnt/";
        }
        try {
            WSLCommandLineOptions options2 = new WSLCommandLineOptions().setLaunchWithWslExe(true).setExecuteCommandInShell(false);
            pwdOutput = distribution.executeOnWsl(Collections.singletonList("pwd"), options2, -1, null);
        }
        catch (ExecutionException e) {
            WSLUtil.LOG.warn("Error reading pwd output for " + this.getId(), (Throwable)e);
            return "/mnt/";
        }
        if (pwdOutput.getExitCode() != 0) {
            WSLUtil.LOG.info("Non-zero exit code while fetching pwd: [id=" + this.getId() + "; [exitCode=" + pwdOutput.getExitCode() + "; [stderr=" + pwdOutput.getStderr() + "; [stdout=" + pwdOutput.getStdout() + "]");
            return "/mnt/";
        }
        List pwdOutputLines = pwdOutput.getStdoutLines();
        if (pwdOutputLines.size() != 1) {
            WSLUtil.LOG.warn("One line response expected from `pwd`: [id=" + this.getId() + "; exitCode=" + pwdOutput.getExitCode() + "; stderr=" + pwdOutput.getStderr() + "; stdout=" + pwdOutput.getStdout() + "]");
            return "/mnt/";
        }
        String wslCurrentDirectory = ((String)pwdOutputLines.get(0)).trim();
        if (StringUtil.endsWithIgnoreCase((String)wslCurrentDirectory, (String)(currentPathSuffix = WSLDistribution.convertWindowsPath(windowsCurrentDirectory)))) {
            String string = StringUtil.trimEnd((String)wslCurrentDirectory, (String)currentPathSuffix, (boolean)true);
            if (string == null) {
                WslDistributionDescriptor.$$$reportNull$$$0(7);
            }
            return string;
        }
        WSLUtil.LOG.warn("Wsl current directory does not ends with windows converted suffix: [pwd=" + wslCurrentDirectory + "; suffix=" + currentPathSuffix + "]");
        return "/mnt/";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/wsl/WslDistributionDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/wsl/WslDistributionDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMsId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getMntRoot";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "computeMntRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

