/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui.layout.impl;

import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.execution.ui.layout.LayoutStateDefaults;
import com.intellij.execution.ui.layout.LayoutViewOptions;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.execution.ui.layout.impl.RunnerLayout;
import com.intellij.execution.ui.layout.impl.RunnerLayoutSettings;
import com.intellij.execution.ui.layout.impl.ViewImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.switcher.QuickActionProvider;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunnerLayoutUiImpl
implements Disposable.Parent,
RunnerLayoutUi,
LayoutStateDefaults,
LayoutViewOptions,
DataProvider {
    private final RunnerLayout myLayout;
    private final RunnerContentUi myContentUI;
    private final ContentManager myViewsContentManager;
    public static final Key<String> CONTENT_TYPE = Key.create((String)"ContentType");

    public RunnerLayoutUiImpl(@NotNull Project project, @NotNull Disposable parent, @NotNull String runnerId, @NotNull String runnerTitle, @NotNull String sessionName) {
        if (project == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(1);
        }
        if (runnerId == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(2);
        }
        if (runnerTitle == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(3);
        }
        if (sessionName == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(4);
        }
        this.myLayout = RunnerLayoutSettings.getInstance().getLayout(runnerId);
        Disposer.register((Disposable)parent, (Disposable)this);
        this.myContentUI = new RunnerContentUi(project, this, ActionManager.getInstance(), IdeFocusManager.getInstance((Project)project), this.myLayout, runnerTitle + " - " + sessionName, runnerId);
        Disposer.register((Disposable)this, (Disposable)this.myContentUI);
        this.myViewsContentManager = RunnerLayoutUiImpl.getContentFactory().createContentManager(this.myContentUI.getContentUI(), true, project);
        this.myViewsContentManager.addDataProvider((DataProvider)this);
        Disposer.register((Disposable)this, (Disposable)this.myViewsContentManager);
    }

    @Deprecated
    @NotNull
    public LayoutViewOptions setTopToolbar(@NotNull ActionGroup actions, @NotNull String place) {
        if (actions == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(5);
        }
        if (place == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(6);
        }
        LayoutViewOptions layoutViewOptions = this.setTopLeftToolbar(actions, place);
        if (layoutViewOptions == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(7);
        }
        return layoutViewOptions;
    }

    @NotNull
    public LayoutViewOptions setTopLeftToolbar(@NotNull ActionGroup actions, @NotNull String place) {
        if (actions == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(8);
        }
        if (place == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(9);
        }
        this.myContentUI.setTopLeftActions(actions, place);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(10);
        }
        return runnerLayoutUiImpl;
    }

    @NotNull
    public LayoutViewOptions setTopMiddleToolbar(@NotNull ActionGroup actions, @NotNull String place) {
        if (actions == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(11);
        }
        if (place == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(12);
        }
        this.myContentUI.setTopMiddleActions(actions, place);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(13);
        }
        return runnerLayoutUiImpl;
    }

    @NotNull
    public LayoutViewOptions setTopRightToolbar(@NotNull ActionGroup actions, @NotNull String place) {
        if (actions == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(14);
        }
        if (place == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(15);
        }
        this.myContentUI.setTopRightActions(actions, place);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(16);
        }
        return runnerLayoutUiImpl;
    }

    @NotNull
    public LayoutStateDefaults initTabDefaults(int id2, String text2, Icon icon2) {
        this.getLayout().setDefault(id2, text2, icon2);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(17);
        }
        return runnerLayoutUiImpl;
    }

    @NotNull
    public LayoutStateDefaults initContentAttraction(@NotNull String contentId, @NotNull String condition, @NotNull LayoutAttractionPolicy policy) {
        if (contentId == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(18);
        }
        if (condition == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(19);
        }
        if (policy == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(20);
        }
        this.getLayout().setDefaultToFocus(contentId, condition, policy);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(21);
        }
        return runnerLayoutUiImpl;
    }

    @NotNull
    public LayoutStateDefaults cancelContentAttraction(@NotNull String condition) {
        if (condition == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(22);
        }
        this.getLayout().cancelDefaultFocusBy(condition);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(23);
        }
        return runnerLayoutUiImpl;
    }

    @NotNull
    public Content addContent(@NotNull Content content2) {
        if (content2 == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(24);
        }
        Content content3 = this.addContent(content2, false, -1, PlaceInGrid.center, false);
        if (content3 == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(25);
        }
        return content3;
    }

    @NotNull
    public Content addContent(@NotNull Content content2, int defaultTabId, @NotNull PlaceInGrid defaultPlace, boolean defaultIsMinimized) {
        if (content2 == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(26);
        }
        if (defaultPlace == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(27);
        }
        Content content3 = this.addContent(content2, true, defaultTabId, defaultPlace, defaultIsMinimized);
        if (content3 == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(28);
        }
        return content3;
    }

    public Content addContent(@NotNull Content content2, boolean applyDefaults, int defaultTabId, @NotNull PlaceInGrid defaultPlace, boolean defaultIsMinimized) {
        if (content2 == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(29);
        }
        if (defaultPlace == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(30);
        }
        String id2 = (String)content2.getUserData(CONTENT_TYPE);
        assert (id2 != null) : "Content id is missing, use RunnerLayoutUi to create content instances";
        if (applyDefaults) {
            this.getLayout().setDefault(id2, defaultTabId, defaultPlace, defaultIsMinimized);
        }
        this.getContentManager().addContent(content2);
        return content2;
    }

    @NotNull
    public Content createContent(@NotNull String id2, @NotNull JComponent component2, @NotNull String displayName, @Nullable Icon icon2, @Nullable JComponent focusable) {
        if (id2 == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(31);
        }
        if (component2 == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(32);
        }
        if (displayName == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(33);
        }
        Content content2 = this.createContent(id2, (ComponentWithActions)new ComponentWithActions.Impl(component2), displayName, icon2, focusable);
        if (content2 == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(34);
        }
        return content2;
    }

    @NotNull
    public Content createContent(@NotNull String contentId, @NotNull ComponentWithActions withActions, @NotNull String displayName, @Nullable Icon icon2, @Nullable JComponent toFocus) {
        if (contentId == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(35);
        }
        if (withActions == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(36);
        }
        if (displayName == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(37);
        }
        Content content2 = RunnerLayoutUiImpl.getContentFactory().createContent(withActions.getComponent(), displayName, false);
        content2.putUserData(CONTENT_TYPE, (Object)contentId);
        content2.putUserData(ViewImpl.ID, (Object)contentId);
        content2.setIcon(icon2);
        if (toFocus != null) {
            content2.setPreferredFocusableComponent(toFocus);
        }
        if (!withActions.isContentBuiltIn()) {
            content2.setSearchComponent(withActions.getSearchComponent());
            content2.setActions(withActions.getToolbarActions(), withActions.getToolbarPlace(), withActions.getToolbarContextComponent());
        }
        Content content3 = content2;
        if (content3 == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(38);
        }
        return content3;
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myViewsContentManager.getComponent();
        if (jComponent == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(39);
        }
        return jComponent;
    }

    private static ContentFactory getContentFactory() {
        return ContentFactory.SERVICE.getInstance();
    }

    public RunnerLayout getLayout() {
        return this.myLayout;
    }

    public void updateActionsNow() {
        this.myContentUI.updateActionsImmediately();
    }

    public void beforeTreeDispose() {
        this.myContentUI.saveUiState();
    }

    public void dispose() {
    }

    @NotNull
    public ContentManager getContentManager() {
        ContentManager contentManager2 = this.myViewsContentManager;
        if (contentManager2 == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(40);
        }
        return contentManager2;
    }

    @NotNull
    public ActionCallback selectAndFocus(@Nullable Content content2, boolean requestFocus, boolean forced) {
        ActionCallback actionCallback = this.selectAndFocus(content2, requestFocus, forced, false);
        if (actionCallback == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(41);
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback selectAndFocus(@Nullable Content content2, boolean requestFocus, boolean forced, boolean implicit) {
        if (content2 == null) {
            ActionCallback actionCallback = ActionCallback.REJECTED;
            if (actionCallback == null) {
                RunnerLayoutUiImpl.$$$reportNull$$$0(42);
            }
            return actionCallback;
        }
        ActionCallback actionCallback = this.getContentManager(content2).setSelectedContent(content2, requestFocus || this.shouldRequestFocus(), forced, implicit);
        if (actionCallback == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(43);
        }
        return actionCallback;
    }

    private ContentManager getContentManager(@NotNull Content content2) {
        if (content2 == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(44);
        }
        return this.myContentUI.getContentManager(content2);
    }

    private boolean shouldRequestFocus() {
        Component focused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return focused != null && SwingUtilities.isDescendingFrom(focused, this.getContentManager().getComponent());
    }

    public boolean removeContent(@Nullable Content content2, boolean dispose2) {
        return content2 != null && this.getContentManager().removeContent(content2, dispose2);
    }

    public boolean isToFocus(@NotNull Content content2, @NotNull String condition) {
        if (content2 == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(45);
        }
        if (condition == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(46);
        }
        String id2 = (String)content2.getUserData(ViewImpl.ID);
        return this.getLayout().isToFocus(id2, condition);
    }

    @NotNull
    public LayoutViewOptions setToFocus(@Nullable Content content2, @NotNull String condition) {
        if (condition == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(47);
        }
        this.getLayout().setToFocus(content2 != null ? (String)content2.getUserData(ViewImpl.ID) : null, condition);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(48);
        }
        return runnerLayoutUiImpl;
    }

    public void attractBy(@NotNull String condition) {
        if (condition == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(49);
        }
        this.myContentUI.attractByCondition(condition, true);
    }

    public void clearAttractionBy(@NotNull String condition) {
        if (condition == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(50);
        }
        this.myContentUI.clearAttractionByCondition(condition, true);
    }

    public void removeContent(@NotNull String id2, boolean dispose2) {
        Content content2;
        if (id2 == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(51);
        }
        if ((content2 = this.findContent(id2)) != null) {
            this.getContentManager().removeContent(content2, dispose2);
        }
    }

    public AnAction getLayoutActions() {
        return this.myContentUI.getLayoutActions();
    }

    public AnAction @NotNull [] getLayoutActionsList() {
        ActionGroup group2 = (ActionGroup)this.getLayoutActions();
        AnAction[] anActionArray = group2.getChildren(null);
        if (anActionArray == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(52);
        }
        return anActionArray;
    }

    @NotNull
    public LayoutViewOptions setTabPopupActions(@NotNull ActionGroup group2) {
        if (group2 == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(53);
        }
        this.myContentUI.setTabPopupActions(group2);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(54);
        }
        return runnerLayoutUiImpl;
    }

    @NotNull
    public LayoutViewOptions setLeftToolbar(@NotNull ActionGroup leftToolbar, @NotNull String place) {
        if (leftToolbar == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(55);
        }
        if (place == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(56);
        }
        this.myContentUI.setLeftToolbar(leftToolbar, place);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(57);
        }
        return runnerLayoutUiImpl;
    }

    @Nullable
    public Content findContent(@NotNull String key) {
        if (key == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(58);
        }
        return this.myContentUI.findContent(key);
    }

    @NotNull
    public RunnerLayoutUi addListener(final @NotNull ContentManagerListener listener2, @NotNull Disposable parent) {
        if (listener2 == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(59);
        }
        if (parent == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(60);
        }
        final ContentManager mgr = this.getContentManager();
        mgr.addContentManagerListener(listener2);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                mgr.removeContentManagerListener(listener2);
            }
        });
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(61);
        }
        return runnerLayoutUiImpl;
    }

    public void removeListener(@NotNull ContentManagerListener listener2) {
        if (listener2 == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(62);
        }
        this.getContentManager().removeContentManagerListener(listener2);
    }

    public void setBouncing(@NotNull Content content2, boolean activate2) {
        if (content2 == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(63);
        }
        this.myContentUI.processBounce(content2, activate2);
    }

    public boolean isDisposed() {
        return this.getContentManager().isDisposed();
    }

    @NotNull
    public LayoutViewOptions setMinimizeActionEnabled(boolean enabled) {
        this.myContentUI.setMinimizeActionEnabled(enabled);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(64);
        }
        return runnerLayoutUiImpl;
    }

    public LayoutViewOptions setToDisposeRemoveContent(boolean toDispose) {
        this.myContentUI.setToDisposeRemovedContent(toDispose);
        return this;
    }

    @NotNull
    public LayoutViewOptions setMoveToGridActionEnabled(boolean enabled) {
        this.myContentUI.setMovetoGridActionEnabled(enabled);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(65);
        }
        return runnerLayoutUiImpl;
    }

    @NotNull
    public LayoutViewOptions setAttractionPolicy(@NotNull String contentId, LayoutAttractionPolicy policy) {
        if (contentId == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(66);
        }
        this.myContentUI.setPolicy(contentId, policy);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(67);
        }
        return runnerLayoutUiImpl;
    }

    @NotNull
    public LayoutViewOptions setConditionAttractionPolicy(@NotNull String condition, LayoutAttractionPolicy policy) {
        if (condition == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(68);
        }
        this.myContentUI.setConditionPolicy(condition, policy);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(69);
        }
        return runnerLayoutUiImpl;
    }

    @NotNull
    public LayoutStateDefaults getDefaults() {
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(70);
        }
        return runnerLayoutUiImpl;
    }

    @NotNull
    public LayoutViewOptions getOptions() {
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(71);
        }
        return runnerLayoutUiImpl;
    }

    @NotNull
    public LayoutViewOptions setAdditionalFocusActions(@NotNull ActionGroup group2) {
        if (group2 == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(72);
        }
        this.myContentUI.setAdditionalFocusActions(group2);
        RunnerLayoutUiImpl runnerLayoutUiImpl = this;
        if (runnerLayoutUiImpl == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(73);
        }
        return runnerLayoutUiImpl;
    }

    public AnAction getSettingsActions() {
        return this.myContentUI.getSettingsActions();
    }

    public AnAction @NotNull [] getSettingsActionsList() {
        ActionGroup group2 = (ActionGroup)this.getSettingsActions();
        AnAction[] anActionArray = group2.getChildren(null);
        if (anActionArray == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(74);
        }
        return anActionArray;
    }

    public Content @NotNull [] getContents() {
        Content[] contents = new Content[this.getContentManager().getContentCount()];
        for (int i2 = 0; i2 < contents.length; ++i2) {
            contents[i2] = this.getContentManager().getContent(i2);
        }
        if (contents == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(75);
        }
        return contents;
    }

    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            RunnerLayoutUiImpl.$$$reportNull$$$0(76);
        }
        if (QuickActionProvider.KEY.is(dataId) || RunnerContentUi.KEY.is(dataId)) {
            return this.myContentUI;
        }
        return null;
    }

    public void setLeftToolbarVisible(boolean value2) {
        this.myContentUI.setLeftToolbarVisible(value2);
    }

    public void setContentToolbarBefore(boolean value2) {
        this.myContentUI.setContentToolbarBefore(value2);
    }

    public List<AnAction> getActions() {
        return this.myContentUI.getActions(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 48: 
            case 52: 
            case 54: 
            case 57: 
            case 61: 
            case 64: 
            case 65: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 48: 
            case 52: 
            case 54: 
            case 57: 
            case 61: 
            case 64: 
            case 65: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerTitle";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionName";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 15: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 48: 
            case 52: 
            case 54: 
            case 57: 
            case 61: 
            case 64: 
            case 65: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl";
                break;
            }
            case 18: 
            case 35: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentId";
                break;
            }
            case 19: 
            case 22: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 24: 
            case 26: 
            case 29: 
            case 44: 
            case 45: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultPlace";
                break;
            }
            case 31: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "withActions";
                break;
            }
            case 53: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftToolbar";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 59: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/layout/impl/RunnerLayoutUiImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setTopToolbar";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "setTopLeftToolbar";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "setTopMiddleToolbar";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "setTopRightToolbar";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "initTabDefaults";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "initContentAttraction";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "cancelContentAttraction";
                break;
            }
            case 25: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "addContent";
                break;
            }
            case 34: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createContent";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentManager";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "selectAndFocus";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "setToFocus";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutActionsList";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "setTabPopupActions";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "setLeftToolbar";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "addListener";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "setMinimizeActionEnabled";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "setMoveToGridActionEnabled";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "setAttractionPolicy";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "setConditionAttractionPolicy";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaults";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "setAdditionalFocusActions";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsActionsList";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTopToolbar";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 48: 
            case 52: 
            case 54: 
            case 57: 
            case 61: 
            case 64: 
            case 65: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setTopLeftToolbar";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setTopMiddleToolbar";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setTopRightToolbar";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "initContentAttraction";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "cancelContentAttraction";
                break;
            }
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addContent";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createContent";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getContentManager";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isToFocus";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "setToFocus";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "attractBy";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "clearAttractionBy";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "removeContent";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "setTabPopupActions";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "setLeftToolbar";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "findContent";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "setBouncing";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "setAttractionPolicy";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "setConditionAttractionPolicy";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalFocusActions";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 25: 
            case 28: 
            case 34: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 48: 
            case 52: 
            case 54: 
            case 57: 
            case 61: 
            case 64: 
            case 65: 
            case 67: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 75: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

