/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfigurationKt;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.execution.target.TargetEnvironmentWizard;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SeparatorWithText;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunOnTargetComboBox
extends ComboBox<Item> {
    public static final Logger LOGGER = Logger.getInstance(RunOnTargetComboBox.class);
    @NotNull
    private final Project myProject;
    @Nullable
    private LanguageRuntimeType<?> myDefaultRuntimeType;
    private boolean hasSavedTargets;

    public RunOnTargetComboBox(@NotNull Project project) {
        if (project == null) {
            RunOnTargetComboBox.$$$reportNull$$$0(0);
        }
        this.hasSavedTargets = false;
        this.setModel(new MyModel());
        this.myProject = project;
        this.setRenderer((ListCellRenderer)((Object)new MyRenderer()));
        this.addActionListener(e -> this.validateSelectedTarget());
    }

    public void initModel() {
        this.hasSavedTargets = false;
        MyModel model2 = (MyModel)this.getModel();
        model2.removeAllElements();
        model2.addElement(null);
        ArrayList types = new ArrayList();
        for (TargetEnvironmentType targetEnvironmentType : TargetEnvironmentType.EXTENSION_NAME.getExtensionList()) {
            if (!targetEnvironmentType.providesNewWizard(this.myProject, this.myDefaultRuntimeType)) continue;
            types.add(new Type(targetEnvironmentType));
        }
        if (!types.isEmpty()) {
            model2.addElement(new Separator(ExecutionBundle.message((String)"run.on.targets.label.new.targets", (Object[])new Object[0])));
            for (Type type : types) {
                model2.addElement(type);
            }
        }
    }

    public void setDefaultLanguageRuntimeType(@Nullable LanguageRuntimeType<?> defaultLanguageRuntimeType) {
        this.myDefaultRuntimeType = defaultLanguageRuntimeType;
    }

    @Nullable
    public LanguageRuntimeType<?> getDefaultLanguageRuntimeType() {
        return this.myDefaultRuntimeType;
    }

    public void addTarget(@NotNull TargetEnvironmentConfiguration config2, int index) {
        if (config2 == null) {
            RunOnTargetComboBox.$$$reportNull$$$0(1);
        }
        if (!this.hasSavedTargets) {
            this.hasSavedTargets = true;
            ((MyModel)this.getModel()).insertElementAt(new Separator(ExecutionBundle.message((String)"run.on.targets.label.saved.targets", (Object[])new Object[0])), 1);
        }
        ((MyModel)this.getModel()).insertElementAt(new Target(config2), index);
    }

    @Nullable
    public String getSelectedTargetName() {
        return (String)ObjectUtils.doIfCast((Object)this.getSelectedItem(), Item.class, i2 -> i2.getDisplayName());
    }

    public void addTargets(List<TargetEnvironmentConfiguration> configs) {
        int index = 2;
        for (TargetEnvironmentConfiguration config2 : configs) {
            this.addTarget(config2, index);
            ++index;
        }
    }

    public void selectTarget(String configName) {
        if (configName == null) {
            this.setSelectedItem(null);
            return;
        }
        for (int i2 = 0; i2 < this.getModel().getSize(); ++i2) {
            Item at = (Item)this.getModel().getElementAt(i2);
            if (!(at instanceof Target) || !configName.equals(at.getDisplayName())) continue;
            this.setSelectedItem(at);
        }
    }

    private void validateSelectedTarget() {
        Object selected2 = this.getSelectedItem();
        boolean hasErrors = false;
        if (selected2 instanceof Target) {
            Target target2 = (Target)selected2;
            target2.revalidateConfiguration();
            hasErrors = target2.hasErrors();
        }
        this.putClientProperty("JComponent.outline", hasErrors ? "error" : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/RunOnTargetComboBox";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addTarget";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyRenderer
    extends ColoredListCellRenderer<Item> {
        private MyRenderer() {
        }

        public Component getListCellRendererComponent(JList<? extends Item> list2, Item value2, int index, boolean selected2, boolean hasFocus) {
            if (value2 instanceof Separator) {
                SeparatorWithText separator = new SeparatorWithText();
                separator.setCaption(value2.getDisplayName());
                return separator;
            }
            return super.getListCellRendererComponent(list2, (Object)value2, index, selected2, hasFocus);
        }

        protected void customizeCellRenderer(@NotNull JList<? extends Item> list2, Item value2, int index, boolean selected2, boolean hasFocus) {
            if (list2 == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            if (value2 == null) {
                this.append(ExecutionBundle.message((String)"local.machine", (Object[])new Object[0]));
                this.setIcon(AllIcons.Nodes.HomeFolder);
            } else {
                this.append(value2.getDisplayName());
                this.setIcon(value2.getIcon());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/execution/RunOnTargetComboBox$MyRenderer", "customizeCellRenderer"));
        }
    }

    private class MyModel
    extends DefaultComboBoxModel<Item> {
        private MyModel() {
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (anObject instanceof Separator) {
                return;
            }
            if (anObject instanceof Type) {
                RunOnTargetComboBox.this.hidePopup();
                TargetEnvironmentWizard wizard = ((Type)anObject).createWizard(RunOnTargetComboBox.this.myProject, RunOnTargetComboBox.this.myDefaultRuntimeType);
                if (wizard != null && wizard.showAndGet()) {
                    TargetEnvironmentConfiguration newTarget = wizard.getSubject();
                    TargetEnvironmentsManager.getInstance((Project)RunOnTargetComboBox.this.myProject).addTarget(newTarget);
                    RunOnTargetComboBox.this.addTarget(newTarget, 2);
                    RunOnTargetComboBox.this.setSelectedIndex(2);
                }
                return;
            }
            super.setSelectedItem(anObject);
        }
    }

    private static final class Type<T extends TargetEnvironmentConfiguration>
    extends Item {
        @NotNull
        private final TargetEnvironmentType<T> type;

        private Type(@NotNull TargetEnvironmentType<T> type) {
            if (type == null) {
                Type.$$$reportNull$$$0(0);
            }
            super(type.getDisplayName(), type.getIcon());
            this.type = type;
        }

        @Nullable
        TargetEnvironmentWizard createWizard(@NotNull Project project, @Nullable LanguageRuntimeType<?> languageRuntime) {
            if (project == null) {
                Type.$$$reportNull$$$0(1);
            }
            return TargetEnvironmentWizard.createWizard(project, this.type, languageRuntime);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/RunOnTargetComboBox$Type";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createWizard";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class Target
    extends Item {
        private final TargetEnvironmentConfiguration myConfig;
        @Nullable
        private ValidationInfo myValidationInfo;

        private Target(TargetEnvironmentConfiguration config2) {
            super(config2.getDisplayName(), TargetEnvironmentConfigurationKt.getTargetType((TargetEnvironmentConfiguration)config2).getIcon());
            this.myConfig = config2;
            this.revalidateConfiguration();
        }

        public void revalidateConfiguration() {
            try {
                this.myConfig.validateConfiguration();
                this.myValidationInfo = null;
            }
            catch (RuntimeConfigurationException e) {
                this.myValidationInfo = new ValidationInfo(e.getLocalizedMessage());
            }
        }

        @Nullable
        public ValidationInfo getValidationInfo() {
            return this.myValidationInfo;
        }

        public boolean hasErrors() {
            return this.getValidationInfo() != null;
        }

        @Override
        public Icon getIcon() {
            Icon rawIcon = super.getIcon();
            return rawIcon != null && this.hasErrors() ? LayeredIcon.create((Icon)rawIcon, (Icon)AllIcons.RunConfigurations.InvalidConfigurationLayer) : rawIcon;
        }
    }

    private static final class Separator
    extends Item {
        private Separator(@NlsContexts.Label String displayName) {
            super(displayName, null);
        }
    }

    public static abstract class Item {
        private final @NlsContexts.Label String displayName;
        private final Icon icon;

        public Item(@NlsContexts.Label String displayName, Icon icon2) {
            this.displayName = displayName;
            this.icon = icon2;
        }

        @NlsContexts.Label
        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getIcon() {
            return this.icon;
        }
    }
}

