/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.core;

import com.intellij.core.CoreModuleScopeProvider;
import com.intellij.mock.MockComponentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.impl.ModulePathMacroManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.impl.ModuleEx;
import com.intellij.openapi.module.impl.ModuleScopeProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.ModuleFileIndexImpl;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreModule
extends MockComponentManager
implements ModuleEx {
    private final Path myPath;
    @NotNull
    private final Disposable myLifetime;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ModuleScopeProvider myModuleScopeProvider;

    public CoreModule(@NotNull Disposable parentDisposable, @NotNull Project project, @NotNull Path moduleFilePath) {
        if (parentDisposable == null) {
            CoreModule.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CoreModule.$$$reportNull$$$0(1);
        }
        if (moduleFilePath == null) {
            CoreModule.$$$reportNull$$$0(2);
        }
        super(project.getPicoContainer(), parentDisposable);
        this.myLifetime = parentDisposable;
        this.myProject = project;
        this.myPath = moduleFilePath;
        this.initModuleExtensions();
        ModuleRootManagerImpl moduleRootManager = new ModuleRootManagerImpl(this){

            @Override
            public void loadState(@NotNull ModuleRootManagerImpl.ModuleRootManagerState object) {
                if (object == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.loadState(object, false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/core/CoreModule$1", "loadState"));
            }
        };
        Disposer.register((Disposable)parentDisposable, (Disposable)moduleRootManager);
        this.getPicoContainer().registerComponentInstance(ModuleRootManager.class, (Object)moduleRootManager);
        this.getPicoContainer().registerComponentInstance(PathMacroManager.class, (Object)this.createModulePathMacroManager(project));
        this.getPicoContainer().registerComponentInstance(ModuleFileIndex.class, (Object)this.createModuleFileIndex());
        this.myModuleScopeProvider = this.createModuleScopeProvider();
    }

    protected void initModuleExtensions() {
    }

    protected <T> void addModuleExtension(@NotNull ExtensionPointName<T> name, @NotNull T extension) {
        if (name == null) {
            CoreModule.$$$reportNull$$$0(3);
        }
        if (extension == null) {
            CoreModule.$$$reportNull$$$0(4);
        }
        name.getPoint((AreaInstance)this).registerExtension(extension, this.myLifetime);
    }

    protected ModuleScopeProvider createModuleScopeProvider() {
        return new CoreModuleScopeProvider();
    }

    protected PathMacroManager createModulePathMacroManager(@NotNull Project project) {
        if (project == null) {
            CoreModule.$$$reportNull$$$0(5);
        }
        return new ModulePathMacroManager(this);
    }

    protected ModuleFileIndex createModuleFileIndex() {
        return new ModuleFileIndexImpl(this);
    }

    @Override
    public void clearScopesCache() {
        this.myModuleScopeProvider.clearCache();
    }

    public VirtualFile getModuleFile() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Path getModuleNioFile() {
        Path path = this.myPath;
        if (path == null) {
            CoreModule.$$$reportNull$$$0(6);
        }
        return path;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            CoreModule.$$$reportNull$$$0(7);
        }
        return project;
    }

    @NotNull
    public String getName() {
        String string = StringUtil.trimEnd((String)this.myPath.getFileName().toString(), (String)".iml");
        if (string == null) {
            CoreModule.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean isLoaded() {
        return true;
    }

    public void setOption(@NotNull String optionName, @Nullable String optionValue) {
        if (optionName == null) {
            CoreModule.$$$reportNull$$$0(9);
        }
        throw new UnsupportedOperationException();
    }

    public String getOptionValue(@NotNull String optionName) {
        if (optionName == null) {
            CoreModule.$$$reportNull$$$0(10);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public GlobalSearchScope getModuleScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleScope();
        if (globalSearchScope == null) {
            CoreModule.$$$reportNull$$$0(11);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleScope(includeTests);
        if (globalSearchScope == null) {
            CoreModule.$$$reportNull$$$0(12);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleWithLibrariesScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithLibrariesScope();
        if (globalSearchScope == null) {
            CoreModule.$$$reportNull$$$0(13);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependenciesScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithDependenciesScope();
        if (globalSearchScope == null) {
            CoreModule.$$$reportNull$$$0(14);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleContentScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleContentScope();
        if (globalSearchScope == null) {
            CoreModule.$$$reportNull$$$0(15);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleContentWithDependenciesScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleContentWithDependenciesScope();
        if (globalSearchScope == null) {
            CoreModule.$$$reportNull$$$0(16);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependenciesAndLibrariesScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithDependenciesAndLibrariesScope(includeTests);
        if (globalSearchScope == null) {
            CoreModule.$$$reportNull$$$0(17);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleWithDependentsScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleWithDependentsScope();
        if (globalSearchScope == null) {
            CoreModule.$$$reportNull$$$0(18);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleTestsWithDependentsScope() {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleTestsWithDependentsScope();
        if (globalSearchScope == null) {
            CoreModule.$$$reportNull$$$0(19);
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope getModuleRuntimeScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = this.myModuleScopeProvider.getModuleRuntimeScope(includeTests);
        if (globalSearchScope == null) {
            CoreModule.$$$reportNull$$$0(20);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFilePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/core/CoreModule";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/core/CoreModule";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleNioFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleScope";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleWithLibrariesScope";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleWithDependenciesScope";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleContentScope";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleContentWithDependenciesScope";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleWithDependenciesAndLibrariesScope";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleWithDependentsScope";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleTestsWithDependentsScope";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleRuntimeScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addModuleExtension";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createModulePathMacroManager";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setOption";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getOptionValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

