/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.problemsView.toolWindow;

import com.intellij.analysis.problemsView.toolWindow.HighlightingPanel;
import com.intellij.analysis.problemsView.toolWindow.Node;
import com.intellij.analysis.problemsView.toolWindow.NodeComparator;
import com.intellij.analysis.problemsView.toolWindow.ProblemNode;
import com.intellij.analysis.problemsView.toolWindow.ProblemsTreeModel;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewPreview;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewState;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewStatsCollector;
import com.intellij.analysis.problemsView.toolWindow.Root;
import com.intellij.codeInsight.daemon.impl.IntentionsUI;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleOptionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.RestoreSelectionListener;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ProblemsViewPanel
extends OnePixelSplitter
implements Disposable,
DataProvider {
    private final Project myProject;
    private final ProblemsViewState myState;
    private final Supplier<@NlsContexts.TabTitle String> myName;
    private final ProblemsTreeModel myTreeModel;
    private final ProblemsViewPreview myPreview;
    private final JPanel myPanel;
    private final ActionToolbar myToolbar;
    private final Insets myToolbarInsets;
    private final Tree myTree;
    private final TreeExpander myTreeExpander;
    private final AtomicReference<Long> myShowTime;
    private final SingleAlarm mySelectionAlarm;
    private final SingleAlarm myUpdateAlarm;
    private final ToggleOptionAction.Option myAutoscrollToSource;
    private final ToggleOptionAction.Option myShowPreview;
    private final ToggleOptionAction.Option mySortFoldersFirst;
    private final ToggleOptionAction.Option mySortBySeverity;
    private final ToggleOptionAction.Option mySortByName;

    ProblemsViewPanel(@NotNull Project project, @NotNull ProblemsViewState state, @NotNull Supplier<String> name) {
        if (project == null) {
            ProblemsViewPanel.$$$reportNull$$$0(0);
        }
        if (state == null) {
            ProblemsViewPanel.$$$reportNull$$$0(1);
        }
        if (name == null) {
            ProblemsViewPanel.$$$reportNull$$$0(2);
        }
        super(false, 0.5f, 0.1f, 0.9f);
        this.myTreeModel = new ProblemsTreeModel(this);
        this.myPreview = new ProblemsViewPreview(this);
        this.myToolbarInsets = JBUI.insetsRight((int)1);
        this.myShowTime = new AtomicReference();
        this.mySelectionAlarm = new SingleAlarm(() -> {
            ProblemNode node = (ProblemNode)((Object)((Object)TreeUtil.getLastUserObject(ProblemNode.class, (TreePath)this.getTree().getSelectionPath())));
            if (node != null) {
                ProblemsViewStatsCollector.problemSelected(this, node.getProblem());
            }
            this.updateAutoscroll();
            this.updatePreview();
        }, 50, ModalityState.stateForComponent((Component)((Object)this)), (Disposable)this);
        this.myUpdateAlarm = new SingleAlarm(() -> {
            ToolWindow window = ProblemsView.getToolWindow(this.getProject());
            if (window == null) {
                return;
            }
            ContentManager manager = window.getContentManagerIfCreated();
            if (manager == null) {
                return;
            }
            Content content2 = manager.getContent((JComponent)((Object)this));
            if (content2 == null) {
                return;
            }
            Root root = this.myTreeModel.getRoot();
            int count = root == null ? 0 : root.getProblemCount();
            content2.setDisplayName(this.getName(count));
            Icon icon2 = this.getToolWindowIcon(count);
            if (icon2 != null) {
                window.setIcon(icon2);
            }
        }, 50, ModalityState.stateForComponent((Component)((Object)this)), (Disposable)this);
        this.myAutoscrollToSource = new ToggleOptionAction.Option(){

            public boolean isSelected() {
                return ProblemsViewPanel.this.myState.getAutoscrollToSource();
            }

            public void setSelected(boolean selected2) {
                ProblemsViewPanel.this.myState.setAutoscrollToSource(selected2);
                if (selected2) {
                    ProblemsViewPanel.this.updateAutoscroll();
                }
            }
        };
        this.myShowPreview = new ToggleOptionAction.Option(){

            public boolean isEnabled() {
                VirtualFile file2 = ProblemsViewPanel.this.getSelectedFile();
                return file2 != null && null != ProblemsView.getDocument(ProblemsViewPanel.this.getProject(), file2);
            }

            public boolean isAlwaysVisible() {
                return true;
            }

            public boolean isSelected() {
                return ProblemsViewPanel.this.myState.getShowPreview();
            }

            public void setSelected(boolean selected2) {
                ProblemsViewPanel.this.myState.setShowPreview(selected2);
                ProblemsViewPanel.this.updatePreview();
            }
        };
        this.mySortFoldersFirst = new ToggleOptionAction.Option(){

            public boolean isSelected() {
                return ProblemsViewPanel.this.myState.getSortFoldersFirst();
            }

            public void setSelected(boolean selected2) {
                ProblemsViewPanel.this.myState.setSortFoldersFirst(selected2);
                ProblemsViewPanel.this.myTreeModel.setComparator(ProblemsViewPanel.this.createComparator());
            }
        };
        this.mySortBySeverity = new ToggleOptionAction.Option(){

            public boolean isSelected() {
                return ProblemsViewPanel.this.myState.getSortBySeverity();
            }

            public void setSelected(boolean selected2) {
                ProblemsViewPanel.this.myState.setSortBySeverity(selected2);
                ProblemsViewPanel.this.myTreeModel.setComparator(ProblemsViewPanel.this.createComparator());
            }
        };
        this.mySortByName = new ToggleOptionAction.Option(){

            public boolean isSelected() {
                return ProblemsViewPanel.this.myState.getSortByName();
            }

            public void setSelected(boolean selected2) {
                ProblemsViewPanel.this.myState.setSortByName(selected2);
                ProblemsViewPanel.this.myTreeModel.setComparator(ProblemsViewPanel.this.createComparator());
            }
        };
        this.myProject = project;
        this.myState = state;
        this.myName = name;
        this.myTreeModel.setComparator(this.createComparator());
        this.myTree = new Tree((TreeModel)((Object)new AsyncTreeModel((TreeModel)((Object)this.myTreeModel), this)));
        this.myTree.setRootVisible(false);
        this.myTree.getSelectionModel().setSelectionMode(1);
        this.myTree.addTreeSelectionListener((TreeSelectionListener)new RestoreSelectionListener());
        this.myTree.addTreeSelectionListener(event -> this.mySelectionAlarm.cancelAndRequest());
        new TreeSpeedSearch((JTree)this.myTree);
        EditSourceOnDoubleClickHandler.install((JTree)this.myTree);
        EditSourceOnEnterKeyHandler.install((JTree)this.myTree);
        PopupHandler.installPopupHandler((JComponent)this.myTree, (String)"ProblemsView.ToolWindow.TreePopup", (String)"popup");
        this.myTreeExpander = new DefaultTreeExpander((JTree)this.myTree);
        ActionGroup group2 = (ActionGroup)ActionManager.getInstance().getAction("ProblemsView.ToolWindow.Toolbar");
        this.myToolbar = ActionManager.getInstance().createActionToolbar(((Object)((Object)this)).getClass().getName(), group2, false);
        this.myToolbar.getComponent().setVisible(state.getShowToolbar());
        UIUtil.addBorder((JComponent)this.myToolbar.getComponent(), (Border)new CustomLineBorder(this.myToolbarInsets));
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.add("Center", ScrollPaneFactory.createScrollPane((Component)this.myTree, (boolean)true));
        this.myPanel.add("West", this.myToolbar.getComponent());
        this.setFirstComponent(this.myPanel);
        this.putClientProperty(UIUtil.NOT_IN_HIERARCHY_COMPONENTS, () -> JBIterable.of((Object)this.myPreview).filter(component2 -> null == component2.getParent()).iterator());
    }

    public void dispose() {
        this.visibilityChangedTo(false);
        this.myPreview.preview(false);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            ProblemsViewPanel.$$$reportNull$$$0(3);
        }
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.getProject();
        }
        if (PlatformDataKeys.TREE_EXPANDER.is(dataId)) {
            return this.getTreeExpander();
        }
        if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
            VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData((DataProvider)this);
            return file2 == null ? null : this.getPreview().findFileEditor(file2, this.getProject());
        }
        Node node = this.getSelectedNode();
        if (node != null) {
            if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
                return node.getNavigatable();
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                return node.getVirtualFile();
            }
            if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                Navigatable[] navigatableArray;
                Navigatable navigatable = node.getNavigatable();
                if (navigatable == null) {
                    navigatableArray = null;
                } else {
                    Navigatable[] navigatableArray2 = new Navigatable[1];
                    navigatableArray = navigatableArray2;
                    navigatableArray2[0] = navigatable;
                }
                return navigatableArray;
            }
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                VirtualFile[] virtualFileArray;
                VirtualFile file3 = node.getVirtualFile();
                if (file3 == null) {
                    virtualFileArray = null;
                } else {
                    VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                    virtualFileArray = virtualFileArray2;
                    virtualFileArray2[0] = file3;
                }
                return virtualFileArray;
            }
        }
        return null;
    }

    final void updateToolWindowContent() {
        this.myUpdateAlarm.cancelAndRequest();
    }

    @Nullable
    Icon getToolWindowIcon(int count) {
        return null;
    }

    @NotNull
    @NlsContexts.TabTitle
    String getName(int count) {
        String name = this.myName.get();
        if (count <= 0) {
            String string = name;
            if (string == null) {
                ProblemsViewPanel.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = new HtmlBuilder().append(name).append(" ").append((HtmlChunk)HtmlChunk.tag((String)"font").attr("color", ColorUtil.toHtmlColor((Color)UIUtil.getInactiveTextColor())).addText(String.valueOf(count))).wrapWithHtmlBody().toString();
        if (string == null) {
            ProblemsViewPanel.$$$reportNull$$$0(5);
        }
        return string;
    }

    protected void loadProportion() {
        if (this.myState != null) {
            this.setProportion(this.myState.getProportion());
        }
    }

    protected void saveProportion() {
        if (this.myState != null) {
            this.myState.setProportion(this.getProportion());
        }
    }

    @NotNull
    final Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ProblemsViewPanel.$$$reportNull$$$0(6);
        }
        return project;
    }

    @NotNull
    final ProblemsViewState getState() {
        ProblemsViewState problemsViewState = this.myState;
        if (problemsViewState == null) {
            ProblemsViewPanel.$$$reportNull$$$0(7);
        }
        return problemsViewState;
    }

    @NotNull
    final ProblemsTreeModel getTreeModel() {
        ProblemsTreeModel problemsTreeModel = this.myTreeModel;
        if (problemsTreeModel == null) {
            ProblemsViewPanel.$$$reportNull$$$0(8);
        }
        return problemsTreeModel;
    }

    @NotNull
    final Tree getTree() {
        Tree tree = this.myTree;
        if (tree == null) {
            ProblemsViewPanel.$$$reportNull$$$0(9);
        }
        return tree;
    }

    @NotNull
    final ProblemsViewPreview getPreview() {
        ProblemsViewPreview problemsViewPreview = this.myPreview;
        if (problemsViewPreview == null) {
            ProblemsViewPanel.$$$reportNull$$$0(10);
        }
        return problemsViewPreview;
    }

    @Nullable
    TreeExpander getTreeExpander() {
        return this.myTreeExpander;
    }

    void orientationChangedTo(boolean vertical) {
        this.setOrientation(vertical);
        this.myPanel.remove(this.myToolbar.getComponent());
        this.myToolbar.setOrientation(vertical ? 0 : 1);
        this.myToolbarInsets.right = !vertical ? JBUIScale.scale((int)1) : 0;
        this.myToolbarInsets.bottom = vertical ? JBUIScale.scale((int)1) : 0;
        this.myPanel.add(vertical ? "North" : "West", this.myToolbar.getComponent());
        this.updatePreview();
    }

    void selectionChangedTo(boolean selected2) {
        if (selected2) {
            this.myTreeModel.setComparator(this.createComparator());
            this.updatePreview();
            ToolWindow window = ProblemsView.getToolWindow(this.getProject());
            if (window instanceof ToolWindowEx) {
                ActionGroup group2 = (ActionGroup)ActionManager.getInstance().getAction("ProblemsView.ToolWindow.SecondaryActions");
                ((ToolWindowEx)window).setAdditionalGearActions(group2);
            }
        }
        this.visibilityChangedTo(selected2);
    }

    void visibilityChangedTo(boolean visible) {
        if (visible) {
            this.myShowTime.set(System.nanoTime());
            ProblemsViewStatsCollector.tabShown(this);
        } else {
            Long time = this.myShowTime.getAndSet(null);
            if (time != null) {
                ProblemsViewStatsCollector.tabHidden(this, System.nanoTime() - time);
            }
            IntentionsUI.getInstance(this.getProject()).hide();
        }
    }

    @Nullable
    private static Node getNode(@Nullable TreePath path) {
        return (Node)((Object)TreeUtil.getLastUserObject(Node.class, (TreePath)path));
    }

    @Nullable
    private Node getSelectedNode() {
        return ProblemsViewPanel.getNode(this.getTree().getSelectionPath());
    }

    @Nullable
    VirtualFile getSelectedFile() {
        Node node = this.getSelectedNode();
        return node == null ? null : node.getVirtualFile();
    }

    private void updateAutoscroll() {
        if (UIUtil.isFocusAncestor((Component)((Object)this)) && ProblemsViewPanel.isNotNullAndSelected(this.getAutoscrollToSource())) {
            this.invokeLater(() -> {
                Navigatable navigatable;
                Node node = this.getSelectedNode();
                Navigatable navigatable2 = navigatable = node == null ? null : node.getNavigatable();
                if (navigatable != null && navigatable.canNavigateToSource()) {
                    OpenSourceUtil.navigate((boolean)false, (Navigatable[])new Navigatable[]{navigatable});
                }
            });
        }
    }

    private void updatePreview() {
        Editor editor = this.myPreview.preview(ProblemsViewPanel.isNotNullAndSelected(this.getShowPreview()));
        if (editor != null) {
            this.invokeLater(() -> {
                if (editor.getComponent().isShowing()) {
                    OpenFileDescriptor descriptor2;
                    Node node = this.getSelectedNode();
                    OpenFileDescriptor openFileDescriptor = descriptor2 = node == null ? null : node.getDescriptor();
                    if (descriptor2 != null) {
                        descriptor2.navigateIn(editor);
                    }
                }
            });
        }
    }

    private void invokeLater(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ProblemsViewPanel.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().invokeLater(runnable2, ModalityState.stateForComponent((Component)((Object)this)));
    }

    @NotNull
    Comparator<Node> createComparator() {
        return new NodeComparator(ProblemsViewPanel.isNullableOrSelected(this.getSortFoldersFirst()), ProblemsViewPanel.isNullableOrSelected(this.getSortBySeverity()), ProblemsViewPanel.isNotNullAndSelected(this.getSortByName()));
    }

    @Nullable
    ToggleOptionAction.Option getAutoscrollToSource() {
        return ProblemsViewPanel.isNotNullAndSelected(this.getShowPreview()) ? null : this.myAutoscrollToSource;
    }

    @Nullable
    ToggleOptionAction.Option getShowPreview() {
        return this.myShowPreview;
    }

    @Nullable
    ToggleOptionAction.Option getSortFoldersFirst() {
        return null;
    }

    @Nullable
    ToggleOptionAction.Option getSortBySeverity() {
        return this instanceof HighlightingPanel ? this.mySortBySeverity : null;
    }

    @Nullable
    ToggleOptionAction.Option getSortByName() {
        return this.mySortByName;
    }

    private static boolean isNotNullAndSelected(@Nullable ToggleOptionAction.Option option2) {
        return option2 != null && option2.isSelected();
    }

    private static boolean isNullableOrSelected(@Nullable ToggleOptionAction.Option option2) {
        return option2 == null || option2.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/analysis/problemsView/toolWindow/ProblemsViewPanel";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/analysis/problemsView/toolWindow/ProblemsViewPanel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

