/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.annotation;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class CommonAnnotationHolder<C> {
    CommonAnnotationHolder() {
    }

    public static <T extends DomElement> CommonAnnotationHolder<T> create(DomElementAnnotationHolder holder) {
        return new DomHolderAdapter(holder);
    }

    public static <T extends PsiElement> CommonAnnotationHolder<T> create(AnnotationHolder holder) {
        return new HolderAdapter(holder);
    }

    public abstract void createAnnotation(@NotNull HighlightSeverity var1, @NotNull C var2, @Nullable @InspectionMessage String var3, @Nullable GutterIconRenderer var4);

    private static class HolderAdapter<T extends PsiElement>
    extends CommonAnnotationHolder<T> {
        private final AnnotationHolder myHolder;

        HolderAdapter(AnnotationHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void createAnnotation(@NotNull HighlightSeverity severity, @NotNull T element, @Nullable @InspectionMessage String message, @Nullable GutterIconRenderer renderer) {
            AnnotationBuilder builder;
            if (severity == null) {
                HolderAdapter.$$$reportNull$$$0(0);
            }
            if (element == null) {
                HolderAdapter.$$$reportNull$$$0(1);
            }
            AnnotationBuilder annotationBuilder = builder = message == null ? this.myHolder.newSilentAnnotation(severity) : this.myHolder.newAnnotation(severity, message);
            if (renderer != null) {
                builder = builder.gutterIconRenderer(renderer);
            }
            builder.create();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "severity";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "org/intellij/plugins/relaxNG/model/annotation/CommonAnnotationHolder$HolderAdapter";
            objectArray[2] = "createAnnotation";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DomHolderAdapter<T extends DomElement>
    extends CommonAnnotationHolder<T> {
        private final DomElementAnnotationHolder myHolder;

        DomHolderAdapter(DomElementAnnotationHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void createAnnotation(@NotNull HighlightSeverity severity, @NotNull DomElement element, @Nullable @InspectionMessage String message, @Nullable GutterIconRenderer renderer) {
            if (severity == null) {
                DomHolderAdapter.$$$reportNull$$$0(0);
            }
            if (element == null) {
                DomHolderAdapter.$$$reportNull$$$0(1);
            }
            Annotation annotation = this.myHolder.createAnnotation(element, severity, message);
            annotation.setTooltip(message);
            annotation.setGutterIconRenderer(renderer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "severity";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
            }
            objectArray[1] = "org/intellij/plugins/relaxNG/model/annotation/CommonAnnotationHolder$DomHolderAdapter";
            objectArray[2] = "createAnnotation";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

