/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.xml.SchemaPrefixReference;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XmlUnboundNsPrefixInspection
extends XmlSuppressableInspectionTool {
    @NonNls
    private static final String XML = "xml";

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            XmlUnboundNsPrefixInspection.$$$reportNull$$$0(0);
        }
        return new XmlElementVisitor(){
            private Boolean isXml;

            private boolean isXmlFile(XmlElement element) {
                if (this.isXml == null) {
                    PsiFile file = element.getContainingFile();
                    this.isXml = file instanceof XmlFile && !InjectedLanguageManager.getInstance((Project)element.getProject()).isInjectedFragment(file);
                }
                return this.isXml;
            }

            public void visitXmlToken(XmlToken token) {
                if (this.isXmlFile((XmlElement)token) && token.getTokenType() == XmlTokenType.XML_NAME) {
                    PsiElement parent;
                    PsiElement element = token.getPrevSibling();
                    while (element instanceof PsiWhiteSpace) {
                        element = element.getPrevSibling();
                    }
                    if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_START_TAG_START && (parent = element.getParent()) instanceof XmlTag && !(token.getNextSibling() instanceof OuterLanguageElement)) {
                        XmlTag tag = (XmlTag)parent;
                        XmlUnboundNsPrefixInspection.checkUnboundNamespacePrefix((XmlElement)tag, tag, tag.getNamespacePrefix(), token, holder, isOnTheFly);
                    }
                }
            }

            public void visitXmlAttribute(XmlAttribute attribute) {
                if (!this.isXmlFile((XmlElement)attribute)) {
                    return;
                }
                String namespace = attribute.getNamespace();
                if (attribute.isNamespaceDeclaration() || "http://www.w3.org/2001/XMLSchema-instance".equals(namespace)) {
                    return;
                }
                XmlTag tag = attribute.getParent();
                if (tag == null) {
                    return;
                }
                XmlElementDescriptor elementDescriptor = tag.getDescriptor();
                if (elementDescriptor == null || elementDescriptor instanceof AnyXmlElementDescriptor) {
                    return;
                }
                String name = attribute.getName();
                XmlUnboundNsPrefixInspection.checkUnboundNamespacePrefix((XmlElement)attribute, tag, XmlUtil.findPrefixByQualifiedName(name), null, holder, isOnTheFly);
            }

            public void visitXmlAttributeValue(XmlAttributeValue value) {
                PsiReference[] references;
                for (PsiReference reference : references = value.getReferences()) {
                    if (!(reference instanceof SchemaPrefixReference) || XmlUnboundNsPrefixInspection.XML.equals(((SchemaPrefixReference)reference).getNamespacePrefix()) || reference.resolve() != null) continue;
                    holder.registerProblem(reference, XmlAnalysisBundle.message((String)"xml.inspections.unbound.namespace", (Object[])new Object[]{((SchemaPrefixReference)reference).getNamespacePrefix()}), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
                }
            }
        };
    }

    private static void checkUnboundNamespacePrefix(XmlElement element, XmlTag context, String namespacePrefix, XmlToken token, ProblemsHolder holder, boolean isOnTheFly) {
        ProblemHighlightType highlightType;
        String localizedMessage;
        if (namespacePrefix.isEmpty() && (!(element instanceof XmlTag) || !(element.getParent() instanceof XmlDocument)) || XML.equals(namespacePrefix)) {
            return;
        }
        String namespaceByPrefix = context.getNamespaceByPrefix(namespacePrefix);
        if (!namespaceByPrefix.isEmpty()) {
            return;
        }
        PsiFile psiFile = context.getContainingFile();
        if (!(psiFile instanceof XmlFile)) {
            return;
        }
        XmlFile containingFile = (XmlFile)psiFile;
        if (!HighlightingLevelManager.getInstance((Project)containingFile.getProject()).shouldInspect((PsiElement)containingFile)) {
            return;
        }
        XmlExtension extension = XmlExtension.getExtension((PsiFile)containingFile);
        if (extension.getPrefixDeclaration(context, namespacePrefix) != null) {
            return;
        }
        String string = localizedMessage = isOnTheFly ? XmlAnalysisBundle.message((String)"xml.inspections.unbound.namespace", (Object[])new Object[]{namespacePrefix}) : XmlAnalysisBundle.message((String)"xml.inspections.unbound.namespace.no.param", (Object[])new Object[0]);
        if (namespacePrefix.isEmpty()) {
            XmlTag tag = (XmlTag)element;
            if (!"http://java.sun.com/JSP/Page".equals(tag.getNamespace()) && isOnTheFly) {
                LocalQuickFix fix = XmlQuickFixFactory.getInstance().createNSDeclarationIntentionFix((PsiElement)context, namespacePrefix, token);
                XmlUnboundNsPrefixInspection.reportTagProblem((XmlElement)tag, localizedMessage, null, ProblemHighlightType.INFORMATION, fix, holder);
            }
            return;
        }
        int prefixLength = namespacePrefix.length();
        TextRange range = new TextRange(0, prefixLength);
        HighlightInfoType infoType = extension.getHighlightInfoType(containingFile);
        ProblemHighlightType problemHighlightType = highlightType = infoType == HighlightInfoType.ERROR ? ProblemHighlightType.ERROR : ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
        if (element instanceof XmlTag) {
            LocalQuickFix fix = isOnTheFly ? XmlQuickFixFactory.getInstance().createNSDeclarationIntentionFix((PsiElement)context, namespacePrefix, token) : null;
            XmlUnboundNsPrefixInspection.reportTagProblem(element, localizedMessage, range, highlightType, fix, holder);
        } else if (element instanceof XmlAttribute) {
            LocalQuickFix fix = isOnTheFly ? XmlQuickFixFactory.getInstance().createNSDeclarationIntentionFix((PsiElement)element, namespacePrefix, token) : null;
            XmlAttribute attribute = (XmlAttribute)element;
            holder.registerProblem((PsiElement)attribute.getNameElement(), localizedMessage, highlightType, range, new LocalQuickFix[]{fix});
        } else {
            holder.registerProblem((PsiElement)element, localizedMessage, highlightType, range, new LocalQuickFix[0]);
        }
    }

    private static void reportTagProblem(XmlElement element, @InspectionMessage String localizedMessage, TextRange range, ProblemHighlightType highlightType, LocalQuickFix fix, ProblemsHolder holder) {
        XmlToken nameToken = XmlTagUtil.getStartTagNameElement((XmlTag)((XmlTag)element));
        if (nameToken != null) {
            holder.registerProblem((PsiElement)nameToken, localizedMessage, highlightType, range, new LocalQuickFix[]{fix});
        }
        if ((nameToken = XmlTagUtil.getEndTagNameElement((XmlTag)((XmlTag)element))) != null) {
            holder.registerProblem((PsiElement)nameToken, localizedMessage, highlightType, range, new LocalQuickFix[]{fix});
        }
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return "XmlUnboundNsPrefix";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/analysis/XmlUnboundNsPrefixInspection", "buildVisitor"));
    }
}

