/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Fail;
import org.fest.assertions.Formatting;
import org.fest.assertions.GenericAssert;
import org.fest.assertions.ImageReader;
import org.fest.assertions.RGBColor;
import org.fest.assertions.Threshold;
import org.fest.util.Objects;
import org.fest.util.Preconditions;
import org.fest.util.VisibleForTesting;

public class ImageAssert
extends GenericAssert<ImageAssert, BufferedImage> {
    private static final Threshold ZERO_THRESHOLD = Threshold.threshold(0);
    private static ImageReader imageReader = new ImageReader();

    protected ImageAssert(@Nullable BufferedImage actual) {
        super(ImageAssert.class, actual);
    }

    @Nullable
    public static BufferedImage read(@Nonnull String imageFilePath) throws IOException {
        Preconditions.checkNotNull((Object)imageFilePath);
        File imageFile = new File(imageFilePath);
        if (!imageFile.isFile()) {
            throw new IllegalArgumentException(Formatting.format("The path <%s> does not belong to a file", imageFilePath));
        }
        return imageReader.read(imageFile);
    }

    @Nullable
    private static Dimension sizeOf(@Nullable BufferedImage image) {
        if (image == null) {
            return null;
        }
        return new Dimension(image.getWidth(), image.getHeight());
    }

    @VisibleForTesting
    static void imageReader(@Nonnull ImageReader newImageReader) {
        imageReader = newImageReader;
    }

    @Override
    @Nonnull
    public ImageAssert isEqualTo(@Nullable BufferedImage expected) {
        return this.isEqualTo(expected, ZERO_THRESHOLD);
    }

    @Nonnull
    public ImageAssert isEqualTo(@Nullable BufferedImage expected, @Nonnull Threshold threshold) {
        Preconditions.checkNotNull((Object)threshold);
        if (Objects.areEqual((Object)this.actual, (Object)expected)) {
            return this;
        }
        this.failIfNull(expected);
        this.failIfNotEqual(ImageAssert.sizeOf((BufferedImage)this.actual), ImageAssert.sizeOf(expected));
        this.failIfNotEqualColor((BufferedImage)Preconditions.checkNotNull((Object)expected), threshold);
        return this;
    }

    private void failIfNull(@Nullable BufferedImage expected) {
        if (expected != null) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(ErrorMessages.unexpectedNotEqual(this.actual, null));
    }

    private void failIfNotEqual(@Nullable Dimension a, @Nullable Dimension e) {
        if (Objects.areEqual((Object)a, (Object)e)) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(Formatting.format("image size: expected:<%s> but was:<%s>", new DimensionFormatter(e), new DimensionFormatter(a)));
    }

    private void failIfNotEqualColor(@Nonnull BufferedImage expected, @Nonnull Threshold threshold) {
        int w = ((BufferedImage)this.actual).getWidth();
        int h = ((BufferedImage)this.actual).getHeight();
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                this.failIfNotEqual(new RGBColor(((BufferedImage)this.actual).getRGB(x, y)), new RGBColor(expected.getRGB(x, y)), threshold, x, y);
            }
        }
    }

    private void failIfNotEqual(@Nonnull RGBColor a, @Nonnull RGBColor e, @Nonnull Threshold threshold, int x, int y) {
        if (a.isEqualTo(e, threshold.value())) {
            return;
        }
        this.failIfCustomMessageIsSet();
        this.fail(String.format("expected:<%s> but was:<%s> at pixel [%d,%d]", a, e, x, y));
    }

    @Override
    @Nonnull
    public ImageAssert isNotEqualTo(@Nullable BufferedImage image) {
        if (Objects.areEqual((Object)this.actual, (Object)image)) {
            this.failIfCustomMessageIsSet();
            throw this.failure(ErrorMessages.unexpectedEqual(this.actual, image));
        }
        if (image == null) {
            return this;
        }
        if (Objects.areEqual((Object)ImageAssert.sizeOf((BufferedImage)this.actual), (Object)ImageAssert.sizeOf(image)) && this.hasEqualColor(image)) {
            this.failIfCustomMessageIsSet();
            throw this.failure("images are equal");
        }
        return this;
    }

    private boolean hasEqualColor(@Nonnull BufferedImage expected) {
        int w = ((BufferedImage)this.actual).getWidth();
        int h = ((BufferedImage)this.actual).getHeight();
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                if (((BufferedImage)this.actual).getRGB(x, y) == expected.getRGB(x, y)) continue;
                return false;
            }
        }
        return true;
    }

    @Nonnull
    public ImageAssert hasSize(@Nonnull Dimension expected) {
        this.isNotNull();
        Preconditions.checkNotNull((Object)expected);
        Dimension actualDimension = new Dimension(((BufferedImage)this.actual).getWidth(), ((BufferedImage)this.actual).getHeight());
        if (Objects.areEqual((Object)actualDimension, (Object)expected)) {
            return this;
        }
        Fail.failWithMessage(this.customErrorMessage());
        throw Fail.comparisonFailed(this.rawDescription(), new DimensionFormatter(actualDimension), new DimensionFormatter(expected));
    }

    private static class DimensionFormatter {
        private final Dimension dimension;

        DimensionFormatter(@Nullable Dimension dimension) {
            this.dimension = dimension;
        }

        public String toString() {
            if (this.dimension == null) {
                return null;
            }
            String format = "(w=%d, h=%d)";
            return String.format(format, this.dimension.width, this.dimension.height);
        }
    }
}

