/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.hover;

import com.intellij.openapi.util.Key;
import com.intellij.ui.hover.HoverListener;
import com.intellij.ui.hover.TreeHoverListener;
import com.intellij.ui.render.RenderingUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.ToIntFunction;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public abstract class TableHoverListener
extends HoverListener {
    private final AtomicInteger rowHolder = new AtomicInteger(-1);
    private final AtomicInteger columnHolder = new AtomicInteger(-1);
    private static final Key<Integer> HOVERED_ROW_KEY = Key.create((String)"TableHoveredRow");
    public static final HoverListener DEFAULT = new TableHoverListener(){

        @Override
        public void onHover(@NotNull JTable table, int row, int column) {
            if (table == null) {
                1.$$$reportNull$$$0(0);
            }
            1.setHoveredRow(table, row);
            Object property = table.getClientProperty(RenderingUtil.FOCUSABLE_SIBLING);
            if (property instanceof JTree) {
                TreeHoverListener.setHoveredRow((JTree)property, row);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/ui/hover/TableHoverListener$1", "onHover"));
        }
    };

    public abstract void onHover(@NotNull JTable var1, int var2, int var3);

    @Override
    public final void mouseEntered(@NotNull Component component, int x, int y) {
        if (component == null) {
            TableHoverListener.$$$reportNull$$$0(0);
        }
        this.mouseMoved(component, x, y);
    }

    @Override
    public final void mouseMoved(@NotNull Component component, int x, int y) {
        if (component == null) {
            TableHoverListener.$$$reportNull$$$0(1);
        }
        this.update(component, table -> table.rowAtPoint(new Point(x, y)), table -> table.columnAtPoint(new Point(x, y)));
    }

    @Override
    public final void mouseExited(@NotNull Component component) {
        if (component == null) {
            TableHoverListener.$$$reportNull$$$0(2);
        }
        this.update(component, table -> -1, table -> -1);
    }

    private void update(@NotNull Component component, @NotNull ToIntFunction<JTable> rowFunc, @NotNull ToIntFunction<JTable> columnFunc) {
        if (component == null) {
            TableHoverListener.$$$reportNull$$$0(3);
        }
        if (rowFunc == null) {
            TableHoverListener.$$$reportNull$$$0(4);
        }
        if (columnFunc == null) {
            TableHoverListener.$$$reportNull$$$0(5);
        }
        if (component instanceof JTable) {
            JTable table = (JTable)component;
            int rowNew = rowFunc.applyAsInt(table);
            int rowOld = this.rowHolder.getAndSet(rowNew);
            int columnNew = columnFunc.applyAsInt(table);
            int columnOld = this.columnHolder.getAndSet(columnNew);
            if (rowNew != rowOld || columnNew != columnOld) {
                this.onHover(table, rowNew, columnNew);
            }
        }
    }

    @ApiStatus.Internal
    static void setHoveredRow(@NotNull JTable table, int rowNew) {
        int rowOld;
        if (table == null) {
            TableHoverListener.$$$reportNull$$$0(6);
        }
        if (rowNew == (rowOld = TableHoverListener.getHoveredRow(table))) {
            return;
        }
        table.putClientProperty(HOVERED_ROW_KEY, rowNew < 0 ? null : Integer.valueOf(rowNew));
        if (RenderingUtil.isHoverPaintingDisabled((JComponent)table)) {
            return;
        }
        TableHoverListener.repaintRow(table, rowOld, 0);
        TableHoverListener.repaintRow(table, rowNew, 0);
    }

    public static int getHoveredRow(@NotNull JTable table) {
        Object property;
        if (table == null) {
            TableHoverListener.$$$reportNull$$$0(7);
        }
        return (property = table.getClientProperty(HOVERED_ROW_KEY)) instanceof Integer ? (Integer)property : -1;
    }

    private static void repaintRow(@NotNull JTable table, int row, int column) {
        Rectangle bounds;
        if (table == null) {
            TableHoverListener.$$$reportNull$$$0(8);
        }
        Rectangle rectangle = bounds = row < 0 ? null : table.getCellRect(row, column, false);
        if (bounds != null) {
            table.repaint(0, bounds.y, table.getWidth(), bounds.height);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowFunc";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnFunc";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/hover/TableHoverListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseEntered";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseMoved";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseExited";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "setHoveredRow";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getHoveredRow";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "repaintRow";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

