/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class GuiUtils {
    private static final Insets paddingInsideDialog = JBUI.insets((int)5);
    private static final CharFilter NOT_MNEMONIC_CHAR_FILTER = ch -> ch != '&' && ch != '\u001b';

    public static JPanel constructFieldWithBrowseButton(JComponent aComponent, ActionListener aActionListener) {
        return GuiUtils.constructFieldWithBrowseButton(aComponent, aActionListener, 0);
    }

    public static JPanel constructFieldWithBrowseButton(TextFieldWithHistory aComponent, ActionListener aActionListener) {
        return GuiUtils.constructFieldWithBrowseButton(aComponent, aActionListener, 0);
    }

    private static JPanel constructFieldWithBrowseButton(JComponent aComponent, ActionListener aActionListener, int delta) {
        JPanel result = new JPanel(new GridBagLayout());
        result.add((Component)aComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        FixedSizeButton browseButton = new FixedSizeButton(aComponent.getPreferredSize().height - delta);
        ComponentWithBrowseButton.MyDoClickAction.addTo(browseButton, aComponent);
        result.add((Component)browseButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        browseButton.addActionListener(aActionListener);
        return result;
    }

    @Deprecated
    public static JPanel constructDirectoryBrowserField(final JTextField field, final String objectName) {
        return GuiUtils.constructFieldWithBrowseButton(field, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle("Select " + objectName);
                VirtualFile file = FileChooser.chooseFile(descriptor, field, null, null);
                if (file != null) {
                    field.setText(FileUtil.toSystemDependentName((String)file.getPath()));
                    field.postActionEvent();
                }
            }
        });
    }

    @Deprecated
    public static JPanel makeTitledPanel(JComponent aComponent, @NlsContexts.BorderTitle String aTitle) {
        JPanel result = GuiUtils.makePaddedPanel(aComponent, false, true, false, true);
        return GuiUtils.wrapWithBorder(result, IdeBorderFactory.createTitledBorder(aTitle));
    }

    private static JPanel wrapWithBorder(JComponent aPanel, Border aBorder) {
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)aPanel, "Center");
        wrapper.setBorder(aBorder);
        return wrapper;
    }

    @Deprecated
    public static BorderLayout createBorderLayout() {
        return new BorderLayout(GuiUtils.paddingInsideDialog.left, GuiUtils.paddingInsideDialog.top);
    }

    @Deprecated
    public static GridLayout createGridLayout(int aRows, int aColumns) {
        return new GridLayout(aRows, aColumns, GuiUtils.paddingInsideDialog.left, GuiUtils.paddingInsideDialog.top);
    }

    public static Component createVerticalStrut() {
        return Box.createRigidArea(new Dimension(0, GuiUtils.paddingInsideDialog.top));
    }

    private static JPanel makePaddedPanel(JComponent aComponent, boolean aTop, boolean aLeft, boolean aBottom, boolean aRight) {
        return GuiUtils.wrapWithBorder(aComponent, BorderFactory.createEmptyBorder(aTop ? GuiUtils.paddingInsideDialog.top : 0, aLeft ? GuiUtils.paddingInsideDialog.left : 0, aBottom ? GuiUtils.paddingInsideDialog.bottom : 0, aRight ? GuiUtils.paddingInsideDialog.right : 0));
    }

    public static String getTextWithoutMnemonicEscaping(String text) {
        return StringUtil.strip((String)text, (CharFilter)NOT_MNEMONIC_CHAR_FILTER);
    }

    public static char getDisplayedMnemonic(String text) {
        int i = GuiUtils.getDisplayedMnemonicIndex(text);
        return i == -1 ? (char)'\uffff' : text.charAt(i + 1);
    }

    public static int getDisplayedMnemonicIndex(String text) {
        return text.indexOf("&");
    }

    public static void replaceJSplitPaneWithIDEASplitter(JComponent root) {
        GuiUtils.replaceJSplitPaneWithIDEASplitter(root, false);
    }

    public static void replaceJSplitPaneWithIDEASplitter(JComponent root, boolean useOnePixelDivider) {
        Container parent = root.getParent();
        if (root instanceof JSplitPane) {
            if (parent.getComponents().length != 1 && !(parent instanceof Splitter)) {
                return;
            }
            JSplitPane pane = (JSplitPane)root;
            Component component1 = pane.getTopComponent();
            Component component2 = pane.getBottomComponent();
            int orientation = pane.getOrientation();
            boolean vertical = orientation == 0;
            JBSplitter splitter = useOnePixelDivider ? new OnePixelSplitter(vertical) : new JBSplitter(vertical);
            splitter.setFirstComponent((JComponent)component1);
            splitter.setSecondComponent((JComponent)component2);
            splitter.setShowDividerControls(pane.isOneTouchExpandable());
            splitter.setHonorComponentsMinimumSize(true);
            if (pane.getDividerLocation() > 0) {
                SwingUtilities.invokeLater(() -> {
                    double proportion = pane.getOrientation() == 0 ? (double)pane.getDividerLocation() / (double)(parent.getHeight() - pane.getDividerSize()) : (double)pane.getDividerLocation() / (double)(parent.getWidth() - pane.getDividerSize());
                    if (proportion > 0.0 && proportion < 1.0) {
                        splitter.setProportion((float)proportion);
                    }
                });
            }
            if (parent instanceof Splitter) {
                Splitter psplitter = (Splitter)parent;
                if (psplitter.getFirstComponent() == root) {
                    psplitter.setFirstComponent((JComponent)((Object)splitter));
                } else {
                    psplitter.setSecondComponent((JComponent)((Object)splitter));
                }
            } else {
                parent.remove(0);
                parent.setLayout(new BorderLayout());
                parent.add((Component)((Object)splitter), "Center");
            }
            GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)component1, useOnePixelDivider);
            GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)component2, useOnePixelDivider);
        } else {
            Component[] components;
            for (Component component : components = root.getComponents()) {
                if (!(component instanceof JComponent)) continue;
                GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)component, useOnePixelDivider);
            }
        }
    }

    public static void iterateChildren(Component container, Consumer<? super Component> consumer, JComponent ... excludeComponents) {
        if (excludeComponents != null && ArrayUtil.find((Object[])excludeComponents, (Object)container) != -1) {
            return;
        }
        consumer.consume((Object)container);
        if (container instanceof Container) {
            Component[] components;
            for (Component child : components = ((Container)container).getComponents()) {
                GuiUtils.iterateChildren(child, consumer, excludeComponents);
            }
        }
    }

    public static void enableChildren(boolean enabled, Component ... components) {
        for (Component component : components) {
            GuiUtils.enableChildren(component, enabled, new JComponent[0]);
        }
    }

    public static void showComponents(boolean visible, Component ... components) {
        for (Component component : components) {
            component.setVisible(visible);
        }
    }

    public static void enableChildren(Component container, boolean enabled, JComponent ... excludeComponents) {
        GuiUtils.iterateChildren(container, (Consumer<? super Component>)((Consumer)t -> GuiUtils.enableComponent(t, enabled)), excludeComponents);
    }

    private static void enableComponent(Component component, boolean enabled) {
        if (component.isEnabled() == enabled) {
            return;
        }
        component.setEnabled(enabled);
        if (component instanceof JPanel) {
            Border border = ((JPanel)component).getBorder();
            if (border instanceof TitledBorder) {
                Color color = enabled ? component.getForeground() : UIUtil.getInactiveTextColor();
                ((TitledBorder)border).setTitleColor(color);
            }
        } else if (component instanceof JLabel) {
            Color color = UIUtil.getInactiveTextColor();
            @NonNls String changeColorString = "<font color=#" + GuiUtils.colorToHex(color) + ">";
            JLabel label = (JLabel)component;
            @NonNls Object text = label.getText();
            if (text != null && ((String)text).startsWith("<html>")) {
                if (StringUtil.startsWithConcatenation((String)text, (String[])new String[]{"<html>", changeColorString}) && enabled) {
                    text = "<html>" + ((String)text).substring(("<html>" + changeColorString).length());
                } else if (!StringUtil.startsWithConcatenation((String)text, (String[])new String[]{"<html>", changeColorString}) && !enabled) {
                    text = "<html>" + changeColorString + ((String)text).substring("<html>".length());
                }
                label.setText((String)text);
            }
        } else if (component instanceof JTable) {
            TableColumnModel columnModel = ((JTable)component).getColumnModel();
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                TableCellRenderer cellRenderer = columnModel.getColumn(0).getCellRenderer();
                if (!(cellRenderer instanceof Component)) continue;
                GuiUtils.enableComponent((Component)((Object)cellRenderer), enabled);
            }
        }
    }

    public static String colorToHex(Color color) {
        return GuiUtils.to2DigitsHex(color.getRed()) + GuiUtils.to2DigitsHex(color.getGreen()) + GuiUtils.to2DigitsHex(color.getBlue());
    }

    private static String to2DigitsHex(int i) {
        Object s = Integer.toHexString(i);
        if (((String)s).length() < 2) {
            s = "0" + (String)s;
        }
        return s;
    }

    @Deprecated
    public static void runOrInvokeAndWait(@NotNull Runnable runnable) throws InvocationTargetException, InterruptedException {
        if (runnable == null) {
            GuiUtils.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().invokeAndWait(runnable);
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable, @NotNull ModalityState modalityState) {
        Application app;
        if (runnable == null) {
            GuiUtils.$$$reportNull$$$0(1);
        }
        if (modalityState == null) {
            GuiUtils.$$$reportNull$$$0(2);
        }
        if ((app = ApplicationManager.getApplication()).isDispatchThread()) {
            runnable.run();
        } else {
            app.invokeLater(runnable, modalityState);
        }
    }

    public static void invokeLaterIfNeeded(@NotNull Runnable runnable, @NotNull ModalityState modalityState, @NotNull Condition expired) {
        Application app;
        if (runnable == null) {
            GuiUtils.$$$reportNull$$$0(3);
        }
        if (modalityState == null) {
            GuiUtils.$$$reportNull$$$0(4);
        }
        if (expired == null) {
            GuiUtils.$$$reportNull$$$0(5);
        }
        if ((app = ApplicationManager.getApplication()).isDispatchThread()) {
            runnable.run();
        } else {
            app.invokeLater(runnable, modalityState, expired);
        }
    }

    public static JTextField createUndoableTextField() {
        return new JBTextField();
    }

    @NotNull
    public static Dimension getSizeByChars(int charCount, @NotNull JComponent comp) {
        if (comp == null) {
            GuiUtils.$$$reportNull$$$0(6);
        }
        Dimension size = comp.getPreferredSize();
        FontMetrics fontMetrics = comp.getFontMetrics(comp.getFont());
        size.width = fontMetrics.charWidth('a') * charCount;
        Dimension dimension = size;
        if (dimension == null) {
            GuiUtils.$$$reportNull$$$0(7);
        }
        return dimension;
    }

    public static void installVisibilityReferent(final JComponent owner, JComponent referent) {
        referent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                this.toggleVisibility(e);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                this.toggleVisibility(e);
            }

            private void toggleVisibility(ComponentEvent e) {
                Component component = e.getComponent();
                if (component != null) {
                    owner.setVisible(component.isVisible());
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expired";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/GuiUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/GuiUtils";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSizeByChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runOrInvokeAndWait";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invokeLaterIfNeeded";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSizeByChars";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

