/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.match;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementSettingsSerializer;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenType;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Comparator;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultArrangementEntryMatcherSerializer {
    private static final Comparator<ArrangementMatchCondition> CONDITION_COMPARATOR = (c1, c2) -> {
        boolean isAtom1 = c1 instanceof ArrangementAtomMatchCondition;
        boolean isAtom2 = c2 instanceof ArrangementAtomMatchCondition;
        if (isAtom1 ^ isAtom2) {
            return isAtom1 ? 1 : -1;
        }
        if (!isAtom1) {
            return 0;
        }
        ArrangementAtomMatchCondition atom1 = (ArrangementAtomMatchCondition)c1;
        ArrangementAtomMatchCondition atom2 = (ArrangementAtomMatchCondition)c2;
        int cmp = atom1.getType().compareTo(atom2.getType());
        if (cmp == 0) {
            cmp = atom1.getValue().toString().compareTo(atom2.getValue().toString());
        }
        return cmp;
    };
    @NotNull
    private static final Logger LOG = Logger.getInstance(DefaultArrangementEntryMatcherSerializer.class);
    @NotNull
    private static final String COMPOSITE_CONDITION_NAME = "AND";
    private final DefaultArrangementSettingsSerializer.Mixin myMixin;

    public DefaultArrangementEntryMatcherSerializer(DefaultArrangementSettingsSerializer.Mixin mixin) {
        this.myMixin = mixin;
    }

    @Nullable
    public <T extends ArrangementEntryMatcher> Element serialize(@NotNull T matcher) {
        if (matcher == null) {
            DefaultArrangementEntryMatcherSerializer.$$$reportNull$$$0(0);
        }
        if (matcher instanceof StdArrangementEntryMatcher) {
            return DefaultArrangementEntryMatcherSerializer.serialize(((StdArrangementEntryMatcher)matcher).getCondition());
        }
        LOG.warn(String.format("Can't serialize arrangement entry matcher of class '%s'. Reason: expected to find '%s' instance instead", matcher.getClass(), StdArrangementEntryMatcher.class));
        return null;
    }

    @NotNull
    private static Element serialize(@NotNull ArrangementMatchCondition condition) {
        if (condition == null) {
            DefaultArrangementEntryMatcherSerializer.$$$reportNull$$$0(1);
        }
        MySerializationVisitor visitor = new MySerializationVisitor();
        condition.invite(visitor);
        Element element = visitor.result;
        if (element == null) {
            DefaultArrangementEntryMatcherSerializer.$$$reportNull$$$0(2);
        }
        return element;
    }

    @Nullable
    public StdArrangementEntryMatcher deserialize(@NotNull Element matcherElement) {
        ArrangementMatchCondition condition;
        if (matcherElement == null) {
            DefaultArrangementEntryMatcherSerializer.$$$reportNull$$$0(3);
        }
        return (condition = this.deserializeCondition(matcherElement)) == null ? null : new StdArrangementEntryMatcher(condition);
    }

    @Nullable
    private ArrangementMatchCondition deserializeCondition(@NotNull Element matcherElement) {
        String name;
        if (matcherElement == null) {
            DefaultArrangementEntryMatcherSerializer.$$$reportNull$$$0(4);
        }
        if (COMPOSITE_CONDITION_NAME.equals(name = matcherElement.getName())) {
            ArrangementCompositeMatchCondition composite = new ArrangementCompositeMatchCondition();
            for (Object child : matcherElement.getChildren()) {
                ArrangementMatchCondition deserialised = this.deserializeCondition((Element)child);
                if (deserialised == null) continue;
                composite.addOperand(deserialised);
            }
            return composite;
        }
        return this.deserializeAtomCondition(matcherElement);
    }

    @Nullable
    private ArrangementMatchCondition deserializeAtomCondition(@NotNull Element matcherElement) {
        if (matcherElement == null) {
            DefaultArrangementEntryMatcherSerializer.$$$reportNull$$$0(5);
        }
        String id = matcherElement.getName();
        ArrangementSettingsToken token = StdArrangementTokens.byId(id);
        boolean processInnerText = true;
        if (token != null && (StdArrangementTokens.General.TYPE.equals(token) || StdArrangementTokens.General.MODIFIER.equals(token))) {
            id = matcherElement.getText();
            if (StringUtil.isEmpty((String)id)) {
                LOG.warn("Can't deserialize match condition at legacy format");
                return null;
            }
            token = StdArrangementTokens.byId(id);
            processInnerText = false;
        }
        if (token == null) {
            token = this.myMixin.deserializeToken(id);
        }
        if (token == null) {
            LOG.warn(String.format("Can't deserialize match condition with id '%s'", id));
            return null;
        }
        Object value = token;
        String text = matcherElement.getText();
        if (text != null && processInnerText && !StringUtil.isEmpty((String)(text = StringUtil.unescapeStringCharacters((String)matcherElement.getText())))) {
            Boolean booleanValue = DefaultArrangementEntryMatcherSerializer.parseBooleanValue(text);
            value = booleanValue != null ? booleanValue : text;
        }
        return new ArrangementAtomMatchCondition(token, value);
    }

    @Nullable
    private static Boolean parseBooleanValue(@NotNull String text) {
        if (text == null) {
            DefaultArrangementEntryMatcherSerializer.$$$reportNull$$$0(6);
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)Boolean.TRUE.toString())) {
            return true;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)Boolean.FALSE.toString())) {
            return false;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/match/DefaultArrangementEntryMatcherSerializer";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcherElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/match/DefaultArrangementEntryMatcherSerializer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deserializeCondition";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deserializeAtomCondition";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseBooleanValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySerializationVisitor
    implements ArrangementMatchConditionVisitor {
        Element result;
        Element parent;

        private MySerializationVisitor() {
        }

        @Override
        public void visit(@NotNull ArrangementAtomMatchCondition condition) {
            if (condition == null) {
                MySerializationVisitor.$$$reportNull$$$0(0);
            }
            ArrangementSettingsToken type = condition.getType();
            Element element = new Element(type.getId());
            if (StdArrangementTokenType.REG_EXP.is(type)) {
                element.setText(StringUtil.escapeStringCharacters((String)condition.getValue().toString()));
            } else if (condition.getValue() instanceof Boolean) {
                element.setText(condition.getValue().toString());
            }
            this.register(element);
        }

        @Override
        public void visit(@NotNull ArrangementCompositeMatchCondition condition) {
            if (condition == null) {
                MySerializationVisitor.$$$reportNull$$$0(1);
            }
            Element composite = new Element(DefaultArrangementEntryMatcherSerializer.COMPOSITE_CONDITION_NAME);
            this.register(composite);
            this.parent = composite;
            ArrayList<ArrangementMatchCondition> operands = new ArrayList<ArrangementMatchCondition>(condition.getOperands());
            ContainerUtil.sort(operands, CONDITION_COMPARATOR);
            for (ArrangementMatchCondition c : operands) {
                c.invite(this);
            }
        }

        private void register(@NotNull Element element) {
            if (element == null) {
                MySerializationVisitor.$$$reportNull$$$0(2);
            }
            if (this.result == null) {
                this.result = element;
            }
            if (this.parent != null) {
                this.parent.addContent(element);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/match/DefaultArrangementEntryMatcherSerializer$MySerializationVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visit";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "register";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

