/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.MainConfigurationStateSplitter;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CodeStyleSettingsMigrationListener;
import com.intellij.psi.codeStyle.LegacyCodeStyleSettingsManager;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ProjectCodeStyleConfiguration", storages={@Storage(value="codeStyles", stateSplitter=StateSplitter.class)})
public final class ProjectCodeStyleSettingsManager
extends CodeStyleSettingsManager {
    private static final Logger LOG = Logger.getInstance(ProjectCodeStyleSettingsManager.class);
    private static final String MAIN_PROJECT_CODE_STYLE_NAME = "Project";
    private static final String PROJECT_CODE_STYLE_CONFIG_FILE_NAME = "codeStyleConfig";
    private final Project myProject;
    private volatile boolean myIsLoaded;
    private final Map<String, CodeStyleSettings> mySettingsMap;
    private final boolean mySettingsExist;
    private final Object myStateLock;

    public ProjectCodeStyleSettingsManager(@NotNull Project project) {
        if (project == null) {
            ProjectCodeStyleSettingsManager.$$$reportNull$$$0(0);
        }
        this.mySettingsMap = new HashMap<String, CodeStyleSettings>();
        this.myStateLock = new Object();
        this.myProject = project;
        this.setMainProjectCodeStyle(null);
        this.registerExtensionPointListeners((Disposable)project);
        this.mySettingsExist = this.checkProjectSettingsExist();
    }

    @Override
    public void initializeComponent() {
        this.initProjectSettings(this.myProject);
        this.getCurrentSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProjectSettings(@NotNull Project project) {
        if (project == null) {
            ProjectCodeStyleSettingsManager.$$$reportNull$$$0(1);
        }
        Object object = this.myStateLock;
        synchronized (object) {
            if (!this.myIsLoaded) {
                LegacyCodeStyleSettingsManager legacySettingsManager = (LegacyCodeStyleSettingsManager)project.getService(LegacyCodeStyleSettingsManager.class);
                if (legacySettingsManager != null && legacySettingsManager.getState() != null) {
                    this.loadState(legacySettingsManager.getState());
                    if (!(project.isDefault() || ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment())) {
                        this.saveProjectAndNotify(project);
                    }
                    LOG.info("Imported old project code style settings.");
                } else {
                    this.initDefaults();
                    LOG.info("Initialized from default code style settings.");
                }
            }
        }
    }

    private void saveProjectAndNotify(@NotNull Project project) {
        if (project == null) {
            ProjectCodeStyleSettingsManager.$$$reportNull$$$0(2);
        }
        this.getMainProjectCodeStyle().getModificationTracker().incModificationCount();
        project.save();
        ((CodeStyleSettingsMigrationListener)this.myProject.getMessageBus().syncPublisher(CodeStyleSettingsMigrationListener.TOPIC)).codeStyleSettingsMigrated(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMainProjectCodeStyle(@Nullable CodeStyleSettings settings) {
        Object object = this.myStateLock;
        synchronized (object) {
            this.mySettingsMap.put(MAIN_PROJECT_CODE_STYLE_NAME, settings != null ? settings : this.createSettings());
        }
    }

    @Override
    @NotNull
    public CodeStyleSettings getMainProjectCodeStyle() {
        CodeStyleSettings codeStyleSettings = this.mySettingsMap.get(MAIN_PROJECT_CODE_STYLE_NAME);
        if (codeStyleSettings == null) {
            ProjectCodeStyleSettingsManager.$$$reportNull$$$0(3);
        }
        return codeStyleSettings;
    }

    private void initDefaults() {
        CodeStyleSettingsManager appCodeStyleSettingsManager = CodeStyleSettingsManager.getInstance();
        if (appCodeStyleSettingsManager != null) {
            CodeStyleSettings defaultProjectSettings = appCodeStyleSettingsManager.getMainProjectCodeStyle();
            this.setMainProjectCodeStyle(defaultProjectSettings != null ? this.cloneSettings(defaultProjectSettings) : null);
            this.USE_PER_PROJECT_SETTINGS = appCodeStyleSettingsManager.USE_PER_PROJECT_SETTINGS;
            this.PREFERRED_PROJECT_CODE_STYLE = appCodeStyleSettingsManager.PREFERRED_PROJECT_CODE_STYLE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadState(@NotNull Element state) {
        if (state == null) {
            ProjectCodeStyleSettingsManager.$$$reportNull$$$0(4);
        }
        Object object = this.myStateLock;
        synchronized (object) {
            LOG.info("Loading Project code style");
            super.loadState(state);
            this.updateFromOldProjectSettings();
            for (Element subStyle : state.getChildren("code_scheme")) {
                String name = subStyle.getAttributeValue("name");
                CodeStyleSettings settings = this.createSettings();
                settings.readExternal(subStyle);
                if (MAIN_PROJECT_CODE_STYLE_NAME.equals(name)) {
                    this.setMainProjectCodeStyle(settings);
                } else {
                    this.mySettingsMap.put(name, settings);
                }
                LOG.info(name + " code style loaded");
            }
            this.myIsLoaded = true;
        }
    }

    private void updateFromOldProjectSettings() {
        CodeStyleSettings oldProjectSettings = this.PER_PROJECT_SETTINGS;
        if (oldProjectSettings != null) {
            oldProjectSettings.resetDeprecatedFields();
        }
        this.setMainProjectCodeStyle(oldProjectSettings);
        this.PER_PROJECT_SETTINGS = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getState() {
        Object object = this.myStateLock;
        synchronized (object) {
            this.checkState();
            Element e = super.getState();
            if (e != null) {
                LOG.info("Saving Project code style");
                for (String name : this.mySettingsMap.keySet()) {
                    CodeStyleSettings settings = this.mySettingsMap.get(name);
                    Element codeStyle = new Element("code_scheme");
                    codeStyle.setAttribute("name", name);
                    settings.writeExternal(codeStyle);
                    if (codeStyle.getContent().isEmpty()) continue;
                    e.addContent(codeStyle);
                    LOG.info(name + " code style saved");
                }
            }
            return e;
        }
    }

    @Override
    protected void checkState() {
        if (this.mySettingsExist && !this.myIsLoaded) {
            LOG.error("Invalid state: project settings exist but not loaded yet. The call may cause settings damage.");
        }
    }

    @Override
    protected boolean isIgnoredOnSave(@NotNull String fieldName) {
        if (fieldName == null) {
            ProjectCodeStyleSettingsManager.$$$reportNull$$$0(5);
        }
        return "PER_PROJECT_SETTINGS".equals(fieldName);
    }

    @Override
    protected Collection<CodeStyleSettings> enumSettings() {
        return Collections.unmodifiableCollection(this.mySettingsMap.values());
    }

    private boolean checkProjectSettingsExist() {
        VirtualFile projectFile = this.myProject.getProjectFile();
        if (projectFile != null) {
            VirtualFile ideaDir = projectFile.getParent();
            File projectStyleFile = new File(ideaDir.getPath() + File.separator + "codeStyles" + File.separator + "Project.xml");
            return projectStyleFile.exists();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/ProjectCodeStyleSettingsManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/ProjectCodeStyleSettingsManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainProjectCodeStyle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "initProjectSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveProjectAndNotify";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredOnSave";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class StateSplitter
    extends MainConfigurationStateSplitter {
        StateSplitter() {
        }

        @Override
        @NotNull
        protected String getComponentStateFileName() {
            return ProjectCodeStyleSettingsManager.PROJECT_CODE_STYLE_CONFIG_FILE_NAME;
        }

        @Override
        @NotNull
        protected String getSubStateTagName() {
            return "code_scheme";
        }

        @Override
        @NotNull
        protected String getSubStateFileName(@NotNull Element element) {
            if (element == null) {
                StateSplitter.$$$reportNull$$$0(0);
            }
            String string = Objects.requireNonNull(element.getAttributeValue("name"));
            if (string == null) {
                StateSplitter.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/codeStyle/ProjectCodeStyleSettingsManager$StateSplitter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/codeStyle/ProjectCodeStyleSettingsManager$StateSplitter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubStateFileName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSubStateFileName";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

