/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageEntry {
    private final String myPackageName;
    private final boolean myWithSubpackages;
    private final boolean isStatic;
    public static final PackageEntry BLANK_LINE_ENTRY = new PackageEntry(false, "<blank line>", true){

        @Override
        public boolean matchesPackageName(String packageName) {
            return false;
        }
    };
    public static final PackageEntry ALL_OTHER_IMPORTS_ENTRY = new PackageEntry(false, "<all other imports>", true){

        @Override
        public boolean matchesPackageName(String packageName) {
            return true;
        }
    };
    public static final PackageEntry ALL_OTHER_STATIC_IMPORTS_ENTRY = new PackageEntry(true, "<all other static imports>", true){

        @Override
        public boolean matchesPackageName(String packageName) {
            return true;
        }
    };

    public PackageEntry(boolean isStatic, @NotNull @NonNls String packageName, boolean withSubpackages) {
        if (packageName == null) {
            PackageEntry.$$$reportNull$$$0(0);
        }
        this.isStatic = isStatic;
        this.myPackageName = StringUtil.trimEnd((String)packageName, (String)".*");
        this.myWithSubpackages = withSubpackages;
    }

    @NlsSafe
    public String getPackageName() {
        return this.myPackageName;
    }

    public boolean isWithSubpackages() {
        return this.myWithSubpackages;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean matchesPackageName(String packageName) {
        if (packageName.startsWith(this.myPackageName)) {
            if (packageName.length() == this.myPackageName.length()) {
                return true;
            }
            if (this.myWithSubpackages && packageName.charAt(this.myPackageName.length()) == '.') {
                return true;
            }
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PackageEntry)) {
            return false;
        }
        PackageEntry entry = (PackageEntry)obj;
        return entry.myWithSubpackages == this.myWithSubpackages && entry.isStatic() == this.isStatic() && Objects.equals(entry.myPackageName, this.myPackageName);
    }

    public int hashCode() {
        return this.myPackageName.hashCode();
    }

    public boolean isSpecial() {
        return this == BLANK_LINE_ENTRY || this == ALL_OTHER_IMPORTS_ENTRY || this == ALL_OTHER_STATIC_IMPORTS_ENTRY;
    }

    public boolean isBetterMatchForPackageThan(@Nullable PackageEntry entry, @NotNull String packageName, boolean isStatic) {
        if (packageName == null) {
            PackageEntry.$$$reportNull$$$0(1);
        }
        if (this.isStatic() != isStatic || !this.matchesPackageName(packageName)) {
            return false;
        }
        if (entry == null) {
            return true;
        }
        if (entry.isStatic() != isStatic) {
            return false;
        }
        if (entry.isWithSubpackages() != this.isWithSubpackages()) {
            return !this.isWithSubpackages();
        }
        if (entry == ALL_OTHER_IMPORTS_ENTRY || entry == ALL_OTHER_STATIC_IMPORTS_ENTRY) {
            return true;
        }
        if (this == ALL_OTHER_IMPORTS_ENTRY || this == ALL_OTHER_STATIC_IMPORTS_ENTRY) {
            return false;
        }
        return StringUtil.countChars((CharSequence)entry.getPackageName(), (char)'.') < StringUtil.countChars((CharSequence)this.getPackageName(), (char)'.');
    }

    @NonNls
    public String toString() {
        return (this.isStatic() ? "static " : "") + this.getPackageName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "packageName";
        objectArray2[1] = "com/intellij/psi/codeStyle/PackageEntry";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isBetterMatchForPackageThan";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

