/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.KeyboardGestureAction;
import com.intellij.openapi.actionSystem.KeyboardModifierGestureShortcut;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.PressureShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.MacKeymapUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KeymapUtil {
    @NonNls
    private static final String CANCEL_KEY_TEXT = "Cancel";
    @NonNls
    private static final String BREAK_KEY_TEXT = "Break";
    @NonNls
    private static final String SHIFT = "shift";
    @NonNls
    private static final String CONTROL = "control";
    @NonNls
    private static final String CTRL = "ctrl";
    @NonNls
    private static final String META = "meta";
    @NonNls
    private static final String ALT = "alt";
    @NonNls
    private static final String ALT_GRAPH = "altGraph";
    @NonNls
    private static final String DOUBLE_CLICK = "doubleClick";
    private static final Set<Integer> ourTooltipKeys = new HashSet<Integer>();
    private static final Set<Integer> ourOtherTooltipKeys = new HashSet<Integer>();
    private static RegistryValue ourTooltipKeysProperty;

    private KeymapUtil() {
    }

    @NotNull
    public static String getShortcutText(@NotNull @NonNls String actionId) {
        KeyboardShortcut shortcut;
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(0);
        }
        if ((shortcut = ActionManager.getInstance().getKeyboardShortcut(actionId)) == null) {
            return "<no shortcut>";
        }
        return KeymapUtil.getShortcutText(shortcut);
    }

    @NotNull
    @NlsSafe
    public static String getShortcutText(@NotNull Shortcut shortcut) {
        if (shortcut == null) {
            KeymapUtil.$$$reportNull$$$0(1);
        }
        Object s = "";
        if (shortcut instanceof KeyboardShortcut) {
            KeyboardShortcut keyboardShortcut = (KeyboardShortcut)shortcut;
            String acceleratorText = KeymapUtil.getKeystrokeText(keyboardShortcut.getFirstKeyStroke());
            if (!acceleratorText.isEmpty()) {
                s = acceleratorText;
            }
            if (!(acceleratorText = KeymapUtil.getKeystrokeText(keyboardShortcut.getSecondKeyStroke())).isEmpty()) {
                s = (String)s + ", " + acceleratorText;
            }
        } else if (shortcut instanceof MouseShortcut) {
            s = KeymapUtil.getMouseShortcutText((MouseShortcut)shortcut);
        } else if (shortcut instanceof KeyboardModifierGestureShortcut) {
            KeyboardModifierGestureShortcut gestureShortcut = (KeyboardModifierGestureShortcut)shortcut;
            s = gestureShortcut.getType() == KeyboardGestureAction.ModifierType.dblClick ? "Press, release and hold " : "Hold ";
            s = (String)s + KeymapUtil.getKeystrokeText(gestureShortcut.getStroke());
        } else {
            throw new IllegalArgumentException("unknown shortcut class: " + shortcut.getClass().getCanonicalName());
        }
        String string = s;
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getMouseShortcutText(@NotNull MouseShortcut shortcut) {
        if (shortcut == null) {
            KeymapUtil.$$$reportNull$$$0(3);
        }
        if (shortcut instanceof PressureShortcut) {
            String string = shortcut.toString();
            if (string == null) {
                KeymapUtil.$$$reportNull$$$0(4);
            }
            return string;
        }
        return KeymapUtil.getMouseShortcutText(shortcut.getButton(), shortcut.getModifiers(), shortcut.getClickCount());
    }

    @NotNull
    private static String getMouseShortcutText(int button, @JdkConstants.InputEventMask int modifiers, int clickCount) {
        String resource;
        if (button == 143) {
            resource = "mouse.wheel.rotate.up.shortcut.text";
        } else if (button == 142) {
            resource = "mouse.wheel.rotate.down.shortcut.text";
        } else if (clickCount < 2) {
            resource = "mouse.click.shortcut.text";
        } else if (clickCount < 3) {
            resource = "mouse.double.click.shortcut.text";
        } else {
            throw new IllegalStateException("unknown clickCount: " + clickCount);
        }
        String string = KeyMapBundle.message(resource, KeymapUtil.getModifiersText(KeymapUtil.mapNewModifiers(modifiers)), button);
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @JdkConstants.InputEventMask
    private static int mapNewModifiers(@JdkConstants.InputEventMask int modifiers) {
        if ((modifiers & 0x40) != 0) {
            modifiers |= 1;
        }
        if ((modifiers & 0x200) != 0) {
            modifiers |= 8;
        }
        if ((modifiers & 0x2000) != 0) {
            modifiers |= 0x20;
        }
        if ((modifiers & 0x80) != 0) {
            modifiers |= 2;
        }
        if ((modifiers & 0x100) != 0) {
            modifiers |= 4;
        }
        return modifiers;
    }

    @NotNull
    @NlsSafe
    public static String getKeystrokeText(KeyStroke accelerator) {
        if (accelerator == null) {
            return "";
        }
        if (KeymapUtil.isNativeMacShortcuts()) {
            String string = MacKeymapUtil.getKeyStrokeText(accelerator);
            if (string == null) {
                KeymapUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        Object acceleratorText = "";
        int modifiers = accelerator.getModifiers();
        if (modifiers > 0) {
            acceleratorText = KeymapUtil.getModifiersText(modifiers);
        }
        int code = accelerator.getKeyCode();
        acceleratorText = (String)acceleratorText + (KeymapUtil.isSimplifiedMacShortcuts() ? KeymapUtil.getSimplifiedMacKeyText(code) : KeymapUtil.getKeyText(code));
        String string = ((String)acceleratorText).trim();
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String getKeyText(int code) {
        switch (code) {
            case 192: {
                return "`";
            }
            case 108: {
                return ",";
            }
            case 110: {
                return ".";
            }
            case 47: {
                return "/";
            }
            case 92: {
                return "\\";
            }
            case 46: {
                return ".";
            }
            case 59: {
                return ";";
            }
            case 93: {
                return "]";
            }
            case 91: {
                return "[";
            }
            case 61: {
                return "=";
            }
        }
        String result = KeymapUtil.isNativeMacShortcuts() ? MacKeymapUtil.getKeyText(code) : KeyEvent.getKeyText(code);
        String string = CANCEL_KEY_TEXT.equals(result) ? BREAK_KEY_TEXT : result;
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static boolean isNativeMacShortcuts() {
        return SystemInfo.isMac && !KeymapUtil.isSimplifiedMacShortcuts();
    }

    private static boolean isSimplifiedMacShortcuts() {
        return SystemInfo.isMac && Registry.is((String)"ide.macos.disable.native.shortcut.symbols", (boolean)false);
    }

    @NotNull
    private static String getModifiersText(@JdkConstants.InputEventMask int modifiers) {
        if (KeymapUtil.isNativeMacShortcuts()) {
            String string = MacKeymapUtil.getModifiersText(modifiers);
            if (string == null) {
                KeymapUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        String keyModifiersText = KeymapUtil.isSimplifiedMacShortcuts() ? KeymapUtil.getSimplifiedMacKeyModifiersText(modifiers) : KeyEvent.getKeyModifiersText(modifiers);
        Object object = keyModifiersText.isEmpty() ? keyModifiersText : keyModifiersText + "+";
        if (object == null) {
            KeymapUtil.$$$reportNull$$$0(10);
        }
        return object;
    }

    private static String getSimplifiedMacKeyModifiersText(int modifiers) {
        StringBuilder buf = new StringBuilder();
        if ((modifiers & 4) != 0) {
            buf.append("Cmd+");
        }
        if ((modifiers & 2) != 0) {
            buf.append("Ctrl+");
        }
        if ((modifiers & 8) != 0) {
            buf.append("Opt+");
        }
        if ((modifiers & 1) != 0) {
            buf.append("Shift+");
        }
        if ((modifiers & 0x20) != 0) {
            buf.append("Alt Graph+");
        }
        if ((modifiers & 0x10) != 0) {
            buf.append("Button1+");
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    @NotNull
    public static ShortcutSet getActiveKeymapShortcuts(@Nullable @NonNls String actionId) {
        KeymapManager keymapManager = KeymapManager.getInstance();
        if (keymapManager == null || actionId == null) {
            return new CustomShortcutSet(Shortcut.EMPTY_ARRAY);
        }
        return new CustomShortcutSet(keymapManager.getActiveKeymap().getShortcuts(actionId));
    }

    private static String getSimplifiedMacKeyText(int code) {
        switch (code) {
            case 10: {
                return "Enter";
            }
            case 8: {
                return "Backspace";
            }
            case 9: {
                return "Tab";
            }
            case 3: {
                return CANCEL_KEY_TEXT;
            }
            case 12: {
                return "Clear";
            }
            case 65312: {
                return "Compose";
            }
            case 19: {
                return "Pause";
            }
            case 20: {
                return "Caps Lock";
            }
            case 27: {
                return "Escape";
            }
            case 32: {
                return "Space";
            }
            case 33: {
                return "Page Up";
            }
            case 34: {
                return "Page Down";
            }
            case 35: {
                return "End";
            }
            case 36: {
                return "Home";
            }
            case 37: {
                return "Left";
            }
            case 38: {
                return "Up";
            }
            case 39: {
                return "Right";
            }
            case 40: {
                return "Down";
            }
            case 65368: {
                return "Begin";
            }
            case 16: {
                return "Shift";
            }
            case 17: {
                return "Control";
            }
            case 18: {
                return "Alt";
            }
            case 157: {
                return "Meta";
            }
            case 65406: {
                return "Alt Graph";
            }
            case 106: {
                return "NumPad *";
            }
            case 107: {
                return "NumPad +";
            }
            case 108: {
                return "NumPad ,";
            }
            case 109: {
                return "NumPad -";
            }
            case 110: {
                return "NumPad .";
            }
            case 111: {
                return "NumPad /";
            }
            case 127: {
                return "Delete";
            }
            case 144: {
                return "Num Lock";
            }
            case 145: {
                return "Scroll Lock";
            }
            case 524: {
                return "Windows";
            }
            case 525: {
                return "Context Menu";
            }
            case 112: {
                return "F1";
            }
            case 113: {
                return "F2";
            }
            case 114: {
                return "F3";
            }
            case 115: {
                return "F4";
            }
            case 116: {
                return "F5";
            }
            case 117: {
                return "F6";
            }
            case 118: {
                return "F7";
            }
            case 119: {
                return "F8";
            }
            case 120: {
                return "F9";
            }
            case 121: {
                return "F10";
            }
            case 122: {
                return "F11";
            }
            case 123: {
                return "F12";
            }
            case 61440: {
                return "F13";
            }
            case 61441: {
                return "F14";
            }
            case 61442: {
                return "F15";
            }
            case 61443: {
                return "F16";
            }
            case 61444: {
                return "F17";
            }
            case 61445: {
                return "F18";
            }
            case 61446: {
                return "F19";
            }
            case 61447: {
                return "F20";
            }
            case 61448: {
                return "F21";
            }
            case 61449: {
                return "F22";
            }
            case 61450: {
                return "F23";
            }
            case 61451: {
                return "F24";
            }
            case 154: {
                return "Print Screen";
            }
            case 155: {
                return "Insert";
            }
            case 156: {
                return "Help";
            }
            case 224: {
                return "Up";
            }
            case 225: {
                return "Down";
            }
            case 226: {
                return "Left";
            }
            case 227: {
                return "Right";
            }
        }
        return KeymapUtil.getKeyText(code);
    }

    @Nullable
    public static Shortcut getPrimaryShortcut(@Nullable @NonNls String actionId) {
        KeymapManager keymapManager = KeymapManager.getInstance();
        if (keymapManager == null || actionId == null) {
            return null;
        }
        return (Shortcut)ArrayUtil.getFirstElement((Object[])keymapManager.getActiveKeymap().getShortcuts(actionId));
    }

    @NotNull
    @NlsSafe
    public static String getFirstKeyboardShortcutText(@NotNull @NonNls String actionId) {
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(11);
        }
        for (Shortcut shortcut : KeymapUtil.getActiveKeymapShortcuts(actionId).getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            return KeymapUtil.getShortcutText(shortcut);
        }
        return "";
    }

    @NotNull
    @NlsSafe
    public static String getFirstMouseShortcutText(@NotNull @NonNls String actionId) {
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(12);
        }
        for (Shortcut shortcut : KeymapUtil.getActiveKeymapShortcuts(actionId).getShortcuts()) {
            if (!(shortcut instanceof MouseShortcut)) continue;
            return KeymapUtil.getShortcutText(shortcut);
        }
        return "";
    }

    public static boolean isEventForAction(@NotNull KeyEvent keyEvent, @NotNull @NonNls String actionId) {
        if (keyEvent == null) {
            KeymapUtil.$$$reportNull$$$0(13);
        }
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(14);
        }
        for (Shortcut shortcut : KeymapUtil.getActiveKeymapShortcuts(actionId).getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut) || AWTKeyStroke.getAWTKeyStrokeForEvent(keyEvent) != ((KeyboardShortcut)shortcut).getFirstKeyStroke()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @NlsSafe
    public static String getFirstKeyboardShortcutText(@NotNull AnAction action) {
        if (action == null) {
            KeymapUtil.$$$reportNull$$$0(15);
        }
        return KeymapUtil.getFirstKeyboardShortcutText(action.getShortcutSet());
    }

    @NotNull
    @NlsSafe
    public static String getFirstKeyboardShortcutText(@NotNull ShortcutSet set) {
        Object[] shortcuts;
        KeyboardShortcut shortcut;
        if (set == null) {
            KeymapUtil.$$$reportNull$$$0(16);
        }
        return (shortcut = (KeyboardShortcut)ContainerUtil.findInstance((Object[])(shortcuts = set.getShortcuts()), KeyboardShortcut.class)) == null ? "" : KeymapUtil.getShortcutText(shortcut);
    }

    @NotNull
    @NlsSafe
    public static String getPreferredShortcutText(Shortcut @NotNull [] shortcuts) {
        KeyboardShortcut shortcut;
        if (shortcuts == null) {
            KeymapUtil.$$$reportNull$$$0(17);
        }
        return (shortcut = (KeyboardShortcut)ContainerUtil.findInstance((Object[])shortcuts, KeyboardShortcut.class)) != null ? KeymapUtil.getShortcutText(shortcut) : (shortcuts.length > 0 ? KeymapUtil.getShortcutText(shortcuts[0]) : "");
    }

    @NotNull
    @NlsSafe
    public static String getShortcutsText(Shortcut @NotNull [] shortcuts) {
        if (shortcuts == null) {
            KeymapUtil.$$$reportNull$$$0(18);
        }
        if (shortcuts.length == 0) {
            return "";
        }
        String string = Arrays.stream(shortcuts).map(KeymapUtil::getShortcutText).collect(Collectors.joining(" "));
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static MouseShortcut parseMouseShortcut(@NotNull String keystrokeString) throws InvalidDataException {
        if (keystrokeString == null) {
            KeymapUtil.$$$reportNull$$$0(20);
        }
        if (keystrokeString.startsWith("Force touch")) {
            return new PressureShortcut(2.0);
        }
        int button = -1;
        int modifiers = 0;
        int clickCount = 1;
        StringTokenizer tokenizer = new StringTokenizer(keystrokeString);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (SHIFT.equals(token)) {
                modifiers |= 0x40;
                continue;
            }
            if (CONTROL.equals(token) || CTRL.equals(token)) {
                modifiers |= 0x80;
                continue;
            }
            if (META.equals(token)) {
                modifiers |= 0x100;
                continue;
            }
            if (ALT.equals(token)) {
                modifiers |= 0x200;
                continue;
            }
            if (ALT_GRAPH.equals(token)) {
                modifiers |= 0x2000;
                continue;
            }
            if (token.startsWith("button") && token.length() > 6) {
                try {
                    button = Integer.parseInt(token.substring(6));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new InvalidDataException("unparsable token: " + token);
                }
            }
            if (DOUBLE_CLICK.equals(token)) {
                clickCount = 2;
                continue;
            }
            throw new InvalidDataException("unknown token: " + token);
        }
        return new MouseShortcut(button, modifiers, clickCount);
    }

    @NotNull
    public static String getMouseShortcutString(@NotNull MouseShortcut shortcut) {
        if (shortcut == null) {
            KeymapUtil.$$$reportNull$$$0(21);
        }
        if (shortcut instanceof PressureShortcut) {
            return "Force touch";
        }
        StringBuilder buffer = new StringBuilder();
        int modifiers = shortcut.getModifiers();
        if ((0x40 & modifiers) > 0) {
            buffer.append(SHIFT);
            buffer.append(' ');
        }
        if ((0x80 & modifiers) > 0) {
            buffer.append(CONTROL);
            buffer.append(' ');
        }
        if ((0x100 & modifiers) > 0) {
            buffer.append(META);
            buffer.append(' ');
        }
        if ((0x200 & modifiers) > 0) {
            buffer.append(ALT);
            buffer.append(' ');
        }
        if ((0x2000 & modifiers) > 0) {
            buffer.append(ALT_GRAPH);
            buffer.append(' ');
        }
        buffer.append("button").append(shortcut.getButton()).append(' ');
        if (shortcut.getClickCount() > 1) {
            buffer.append(DOUBLE_CLICK);
        }
        String string = buffer.toString().trim();
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    public static String getKeyModifiersTextForMacOSLeopard(@JdkConstants.InputEventMask int modifiers) {
        StringBuilder buf = new StringBuilder();
        if ((modifiers & 4) != 0) {
            buf.append("\u2318");
        }
        if ((modifiers & 2) != 0) {
            buf.append(Toolkit.getProperty("AWT.control", "Ctrl"));
        }
        if ((modifiers & 8) != 0) {
            buf.append("\u2325");
        }
        if ((modifiers & 1) != 0) {
            buf.append(Toolkit.getProperty("AWT.shift", "Shift"));
        }
        if ((modifiers & 0x20) != 0) {
            buf.append(Toolkit.getProperty("AWT.altGraph", "Alt Graph"));
        }
        if ((modifiers & 0x10) != 0) {
            buf.append(Toolkit.getProperty("AWT.button1", "Button1"));
        }
        String string = buf.toString();
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    public static boolean isTooltipRequest(@NotNull KeyEvent keyEvent) {
        if (keyEvent == null) {
            KeymapUtil.$$$reportNull$$$0(24);
        }
        if (ourTooltipKeysProperty == null) {
            ourTooltipKeysProperty = Registry.get((String)"ide.forcedShowTooltip");
            ourTooltipKeysProperty.addListener(new RegistryValueListener(){

                public void afterValueChanged(@NotNull RegistryValue value) {
                    if (value == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    KeymapUtil.updateTooltipRequestKey(value);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/keymap/KeymapUtil$1", "afterValueChanged"));
                }
            }, Disposer.get((String)"ui"));
            KeymapUtil.updateTooltipRequestKey(ourTooltipKeysProperty);
        }
        if (keyEvent.getID() != 401) {
            return false;
        }
        for (Integer each : ourTooltipKeys) {
            if ((keyEvent.getModifiers() & each) != 0) continue;
            return false;
        }
        for (Integer each : ourOtherTooltipKeys) {
            if ((keyEvent.getModifiers() & each) <= 0) continue;
            return false;
        }
        int code = keyEvent.getKeyCode();
        return code == 157 || code == 17 || code == 16 || code == 18;
    }

    private static void updateTooltipRequestKey(@NotNull RegistryValue value) {
        if (value == null) {
            KeymapUtil.$$$reportNull$$$0(25);
        }
        String text = value.asString();
        ourTooltipKeys.clear();
        ourOtherTooltipKeys.clear();
        KeymapUtil.processKey(text.contains(META), 4);
        KeymapUtil.processKey(text.contains(CONTROL) || text.contains(CTRL), 2);
        KeymapUtil.processKey(text.contains(SHIFT), 1);
        KeymapUtil.processKey(text.contains(ALT), 8);
    }

    private static void processKey(boolean condition, int value) {
        if (condition) {
            ourTooltipKeys.add(value);
        } else {
            ourOtherTooltipKeys.add(value);
        }
    }

    public static boolean isEmacsKeymap() {
        return KeymapUtil.isEmacsKeymap(KeymapManager.getInstance().getActiveKeymap());
    }

    public static boolean isEmacsKeymap(@Nullable Keymap keymap) {
        while (keymap != null) {
            if ("Emacs".equalsIgnoreCase(keymap.getName())) {
                return true;
            }
            keymap = keymap.getParent();
        }
        return false;
    }

    @Nullable
    public static KeyStroke getKeyStroke(@NotNull ShortcutSet shortcutSet) {
        Shortcut[] shortcuts;
        if (shortcutSet == null) {
            KeymapUtil.$$$reportNull$$$0(26);
        }
        if ((shortcuts = shortcutSet.getShortcuts()).length == 0 || !(shortcuts[0] instanceof KeyboardShortcut)) {
            return null;
        }
        KeyboardShortcut shortcut = (KeyboardShortcut)shortcuts[0];
        if (shortcut.getSecondKeyStroke() != null) {
            return null;
        }
        return shortcut.getFirstKeyStroke();
    }

    @NotNull
    public static Collection<KeyStroke> getKeyStrokes(@NotNull ShortcutSet shortcutSet) {
        Shortcut[] shortcuts;
        if (shortcutSet == null) {
            KeymapUtil.$$$reportNull$$$0(27);
        }
        if ((shortcuts = shortcutSet.getShortcuts()).length == 0) {
            Set<KeyStroke> set = Collections.emptySet();
            if (set == null) {
                KeymapUtil.$$$reportNull$$$0(28);
            }
            return set;
        }
        SmartHashSet result = new SmartHashSet();
        for (Shortcut shortcut : shortcuts) {
            KeyboardShortcut kbShortcut;
            if (!(shortcut instanceof KeyboardShortcut) || (kbShortcut = (KeyboardShortcut)shortcut).getSecondKeyStroke() != null) continue;
            result.add(kbShortcut.getFirstKeyStroke());
        }
        SmartHashSet smartHashSet = result.isEmpty() ? Collections.emptySet() : result;
        if (smartHashSet == null) {
            KeymapUtil.$$$reportNull$$$0(29);
        }
        return smartHashSet;
    }

    @NotNull
    @NlsContexts.Tooltip
    public static String createTooltipText(@NotNull @NlsContexts.Tooltip String name, @NotNull @NonNls String actionId) {
        String text;
        if (name == null) {
            KeymapUtil.$$$reportNull$$$0(30);
        }
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(31);
        }
        Object object = (text = KeymapUtil.getFirstKeyboardShortcutText(actionId)).isEmpty() ? name : name + " (" + text + ")";
        if (object == null) {
            KeymapUtil.$$$reportNull$$$0(32);
        }
        return object;
    }

    @NotNull
    @NlsSafe
    public static String createTooltipText(@Nullable String name, @NotNull AnAction action) {
        Object toolTipText;
        if (action == null) {
            KeymapUtil.$$$reportNull$$$0(33);
        }
        Object object = toolTipText = name == null ? "" : name;
        while (StringUtil.endsWithChar((CharSequence)toolTipText, (char)'.')) {
            toolTipText = ((String)toolTipText).substring(0, ((String)toolTipText).length() - 1);
        }
        String shortcutsText = KeymapUtil.getFirstKeyboardShortcutText(action);
        if (!shortcutsText.isEmpty()) {
            toolTipText = (String)toolTipText + " (" + shortcutsText + ")";
        }
        String string = toolTipText;
        if (string == null) {
            KeymapUtil.$$$reportNull$$$0(34);
        }
        return string;
    }

    public static boolean matchActionMouseShortcutsModifiers(@NotNull Keymap activeKeymap, @JdkConstants.InputEventMask int modifiers, @NotNull @NonNls String actionId) {
        if (activeKeymap == null) {
            KeymapUtil.$$$reportNull$$$0(35);
        }
        if (actionId == null) {
            KeymapUtil.$$$reportNull$$$0(36);
        }
        MouseShortcut syntheticShortcut = new MouseShortcut(1, modifiers, 1);
        for (Shortcut shortcut : activeKeymap.getShortcuts(actionId)) {
            MouseShortcut mouseShortcut;
            if (!(shortcut instanceof MouseShortcut) || (mouseShortcut = (MouseShortcut)shortcut).getModifiers() != syntheticShortcut.getModifiers()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static MouseShortcut createMouseShortcut(@NotNull MouseEvent e) {
        if (e == null) {
            KeymapUtil.$$$reportNull$$$0(37);
        }
        int button = MouseShortcut.getButton(e);
        int modifiers = e.getModifiersEx();
        if (button == 0 && e.getID() == 506) {
            if ((modifiers & 0x400) != 0) {
                button = 1;
            } else if ((modifiers & 0x800) != 0) {
                button = 2;
            }
        }
        return new MouseShortcut(button, modifiers, 1);
    }

    public static boolean reassignAction(@NotNull JComponent component, @NotNull KeyStroke oldKeyStroke, @Nullable KeyStroke newKeyStroke, int condition) {
        if (component == null) {
            KeymapUtil.$$$reportNull$$$0(38);
        }
        if (oldKeyStroke == null) {
            KeymapUtil.$$$reportNull$$$0(39);
        }
        return KeymapUtil.reassignAction(component, oldKeyStroke, newKeyStroke, condition, true);
    }

    public static boolean reassignAction(@NotNull JComponent component, @NotNull KeyStroke oldKeyStroke, @Nullable KeyStroke newKeyStroke, int condition, boolean muteOldKeystroke) {
        ActionListener action;
        if (component == null) {
            KeymapUtil.$$$reportNull$$$0(40);
        }
        if (oldKeyStroke == null) {
            KeymapUtil.$$$reportNull$$$0(41);
        }
        if ((action = component.getActionForKeyStroke(oldKeyStroke)) == null) {
            return false;
        }
        if (newKeyStroke != null) {
            component.registerKeyboardAction(action, newKeyStroke, condition);
        }
        if (muteOldKeystroke) {
            component.registerKeyboardAction(new RedispatchEventAction(component), oldKeyStroke, condition);
        }
        return true;
    }

    @Nullable
    public static ShortcutSet filterKeyStrokes(@NotNull ShortcutSet source, KeyStroke ... toLeaveOut) {
        if (source == null) {
            KeymapUtil.$$$reportNull$$$0(42);
        }
        ArrayList<Shortcut> filtered = new ArrayList<Shortcut>(Arrays.asList(source.getShortcuts()));
        for (Shortcut shortcut : source.getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut) || ArrayUtil.find((Object[])toLeaveOut, (Object)((KeyboardShortcut)shortcut).getFirstKeyStroke()) == -1) continue;
            filtered.remove(shortcut);
        }
        return filtered.isEmpty() ? null : new CustomShortcutSet(filtered.toArray(Shortcut.EMPTY_ARRAY));
    }

    @Nullable
    public static CustomShortcutSet getMnemonicAsShortcut(int mnemonic) {
        if ((mnemonic = KeyEvent.getExtendedKeyCodeForChar(mnemonic)) != 0) {
            KeyboardShortcut ctrlAltShortcut = new KeyboardShortcut(KeyStroke.getKeyStroke(mnemonic, 640), null);
            KeyboardShortcut altShortcut = new KeyboardShortcut(KeyStroke.getKeyStroke(mnemonic, 512), null);
            CustomShortcutSet shortcutSet = SystemInfo.isMac ? (Registry.is((String)"ide.mac.alt.mnemonic.without.ctrl") ? new CustomShortcutSet(ctrlAltShortcut, altShortcut) : new CustomShortcutSet(ctrlAltShortcut)) : new CustomShortcutSet(altShortcut);
            return shortcutSet;
        }
        return null;
    }

    @Deprecated
    @Nullable
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static String getEventCallerKeystrokeText(@NotNull AnActionEvent event) {
        if (event == null) {
            KeymapUtil.$$$reportNull$$$0(43);
        }
        if (event.getInputEvent() instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)event.getInputEvent();
            return KeymapUtil.getKeystrokeText(KeyStroke.getKeyStroke(ke.getKeyCode(), ke.getModifiers()));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 19: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 32: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 19: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 32: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 1: 
            case 3: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcut";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 19: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/keymap/KeymapUtil";
                break;
            }
            case 13: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyEvent";
                break;
            }
            case 15: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcuts";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keystrokeString";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcutSet";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeKeymap";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldKeyStroke";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/keymap/KeymapUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMouseShortcutText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeystrokeText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiersText";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutsText";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getMouseShortcutString";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyModifiersTextForMacOSLeopard";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyStrokes";
                break;
            }
            case 32: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltipText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getShortcutText";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 19: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 32: 
            case 34: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getMouseShortcutText";
                break;
            }
            case 11: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFirstKeyboardShortcutText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFirstMouseShortcutText";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isEventForAction";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredShortcutText";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getShortcutsText";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parseMouseShortcut";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getMouseShortcutString";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isTooltipRequest";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "updateTooltipRequestKey";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getKeyStroke";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getKeyStrokes";
                break;
            }
            case 30: 
            case 31: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createTooltipText";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "matchActionMouseShortcutsModifiers";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createMouseShortcut";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "reassignAction";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "filterKeyStrokes";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getEventCallerKeystrokeText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 19: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 32: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class RedispatchEventAction
    extends AbstractAction {
        private final Component myComponent;

        RedispatchEventAction(@NotNull Component component) {
            if (component == null) {
                RedispatchEventAction.$$$reportNull$$$0(0);
            }
            this.myComponent = component;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Container parent;
            AWTEvent event = EventQueue.getCurrentEvent();
            if (event instanceof KeyEvent && event.getSource() == this.myComponent && (parent = this.myComponent.getParent()) != null) {
                KeyEvent keyEvent = (KeyEvent)event;
                parent.dispatchEvent(new KeyEvent(parent, event.getID(), ((KeyEvent)event).getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getKeyLocation()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/keymap/KeymapUtil$RedispatchEventAction", "<init>"));
        }
    }
}

