/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.experimental.toolbar;

import com.intellij.ide.ui.ToolbarSettings;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.experimental.toolbar.ExperimentalToolbarStateEnum;
import com.intellij.ide.ui.experimental.toolbar.ExperimentalToolbarStateWrapper;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.registry.Registry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@State(name="ToolbarSettingsService", storages={@Storage(value="other.xml")})
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0006H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J&\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006J\b\u0010\u001a\u001a\u00020\u0006H\u0016J\b\u0010\u001b\u001a\u00020\u0006H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\b\u0010!\u001a\u00020\u001dH\u0002R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR$\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/ide/ui/experimental/toolbar/ExperimentalToolbarSettings;", "Lcom/intellij/ide/ui/ToolbarSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/ide/ui/experimental/toolbar/ExperimentalToolbarStateWrapper;", "()V", "newToolbarEnabled", "", "getNewToolbarEnabled", "()Z", "showNewNavbarRunGroup", "getShowNewNavbarRunGroup", "showNewNavbarVcsGroup", "getShowNewNavbarVcsGroup", "value", "showNewToolbar", "getShowNewToolbar", "setShowNewToolbar", "(Z)V", "toolbarState", "getShowToolbarInNavigationBar", "getState", "getToolbarStateByVisibilityFlags", "Lcom/intellij/ide/ui/experimental/toolbar/ExperimentalToolbarStateEnum;", "oldToolbarVisible", "newToolbarVisible", "navBarVisible", "isNavBarVisible", "isToolbarVisible", "loadState", "", "state", "setNavBarVisible", "setToolbarVisible", "updateSettingsState", "intellij.platform.editor"})
public final class ExperimentalToolbarSettings
implements ToolbarSettings,
PersistentStateComponent<ExperimentalToolbarStateWrapper> {
    private ExperimentalToolbarStateWrapper toolbarState = new ExperimentalToolbarStateWrapper();

    public final boolean getNewToolbarEnabled() {
        return Registry.is((String)"ide.new.navbar", (boolean)false);
    }

    public final boolean getShowNewNavbarVcsGroup() {
        return Registry.is((String)"ide.new.navbar.vcs.group", (boolean)false);
    }

    public final boolean getShowNewNavbarRunGroup() {
        return Registry.is((String)"ide.new.navbar.run.debug", (boolean)false);
    }

    @Override
    @NotNull
    public ExperimentalToolbarStateWrapper getState() {
        return this.toolbarState;
    }

    @Override
    public void loadState(@NotNull ExperimentalToolbarStateWrapper state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.toolbarState = state;
        this.updateSettingsState();
    }

    @NotNull
    public final ExperimentalToolbarStateEnum getToolbarStateByVisibilityFlags(boolean newToolbarEnabled, boolean oldToolbarVisible, boolean newToolbarVisible, boolean navBarVisible) {
        if (oldToolbarVisible && newToolbarVisible) {
            throw (Throwable)new IllegalStateException();
        }
        if (newToolbarEnabled && newToolbarVisible) {
            if (navBarVisible) {
                return ExperimentalToolbarStateEnum.NEW_TOOLBAR_WITH_NAVBAR;
            }
            return ExperimentalToolbarStateEnum.NEW_TOOLBAR_WITHOUT_NAVBAR;
        }
        if (oldToolbarVisible) {
            if (navBarVisible) {
                return ExperimentalToolbarStateEnum.OLD_TOOLBAR_WITH_NAVBAR_SEPARATE;
            }
            return ExperimentalToolbarStateEnum.OLD_TOOLBAR_WITHOUT_NAVBAR;
        }
        if (navBarVisible) {
            return ExperimentalToolbarStateEnum.OLD_NAVBAR;
        }
        return ExperimentalToolbarStateEnum.NO_TOOLBAR_NO_NAVBAR;
    }

    @Override
    public boolean isNavBarVisible() {
        return this.toolbarState.getState().getNavBarVisible();
    }

    @Override
    public void setNavBarVisible(boolean value) {
        this.toolbarState.setState(this.getToolbarStateByVisibilityFlags(this.getNewToolbarEnabled(), this.toolbarState.getState().getOldToolbarVisible(), this.toolbarState.getState().getNewToolbarVisible(), value));
        this.updateSettingsState();
        UISettings.Companion.getInstance().fireUISettingsChanged();
    }

    private final void updateSettingsState() {
        UISettings.Companion.getInstance().getState().setShowNavigationBar(this.toolbarState.getState().getNavBarVisible());
        UISettings.Companion.getInstance().getState().setShowMainToolbar(this.toolbarState.getState().getOldToolbarVisible());
    }

    @Override
    public boolean isToolbarVisible() {
        return this.toolbarState.getState().getOldToolbarVisible();
    }

    @Override
    public void setToolbarVisible(boolean value) {
        if (value) {
            this.toolbarState.setState(this.getToolbarStateByVisibilityFlags(this.getNewToolbarEnabled(), value, false, this.toolbarState.getState().getNavBarVisible()));
        } else {
            this.toolbarState.setState(this.getToolbarStateByVisibilityFlags(this.getNewToolbarEnabled(), value, this.toolbarState.getState().getNewToolbarVisible(), this.toolbarState.getState().getNavBarVisible()));
        }
        this.updateSettingsState();
        UISettings.Companion.getInstance().fireUISettingsChanged();
    }

    @Override
    public boolean getShowToolbarInNavigationBar() {
        return this.toolbarState.equals((Object)ExperimentalToolbarStateEnum.OLD_NAVBAR);
    }

    public final boolean getShowNewToolbar() {
        return this.toolbarState.getState().getNewToolbarVisible();
    }

    public final void setShowNewToolbar(boolean value) {
        if (value) {
            this.toolbarState.setState(this.getToolbarStateByVisibilityFlags(this.getNewToolbarEnabled(), false, value, this.toolbarState.getState().getNavBarVisible()));
        } else {
            this.toolbarState.setState(this.getToolbarStateByVisibilityFlags(this.getNewToolbarEnabled(), this.toolbarState.getState().getOldToolbarVisible(), value, this.toolbarState.getState().getNavBarVisible()));
        }
        this.updateSettingsState();
        UISettings.Companion.getInstance().fireUISettingsChanged();
    }

    private ExperimentalToolbarSettings() {
    }
}

