/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.fileSet;

import com.intellij.formatting.fileSet.FileSetDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Pair;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NamedScopeDescriptor
implements FileSetDescriptor {
    public static final String NAMED_SCOPE_TYPE = "namedScope";
    private final String myScopeId;
    @Nullable
    private PackageSet myFileSet;

    public NamedScopeDescriptor(@NotNull NamedScope scope) {
        if (scope == null) {
            NamedScopeDescriptor.$$$reportNull$$$0(0);
        }
        this.myScopeId = scope.getScopeId();
        this.myFileSet = scope.getValue();
    }

    public NamedScopeDescriptor(@NotNull String scopeId) {
        if (scopeId == null) {
            NamedScopeDescriptor.$$$reportNull$$$0(1);
        }
        this.myScopeId = scopeId;
    }

    @Override
    public void setPattern(@Nullable String pattern) {
        try {
            this.myFileSet = pattern != null ? PackageSetFactory.getInstance().compile(pattern) : null;
        }
        catch (ParsingException e) {
            this.myFileSet = null;
        }
    }

    @Override
    public boolean matches(@NotNull PsiFile psiFile) {
        PackageSet fileSet;
        Pair<NamedScopesHolder, NamedScope> resolved;
        if (psiFile == null) {
            NamedScopeDescriptor.$$$reportNull$$$0(2);
        }
        if ((resolved = this.resolveScope(psiFile.getProject())) == null) {
            resolved = this.resolveScope(ProjectManager.getInstance().getDefaultProject());
        }
        if (resolved != null && (fileSet = ((NamedScope)resolved.second).getValue()) != null) {
            return fileSet.contains(psiFile, (NamedScopesHolder)resolved.first);
        }
        if (this.myFileSet != null) {
            DependencyValidationManager holder = DependencyValidationManager.getInstance(psiFile.getProject());
            return this.myFileSet.contains(psiFile, holder);
        }
        return false;
    }

    private Pair<NamedScopesHolder, NamedScope> resolveScope(@NotNull Project project) {
        NamedScopesHolder holder;
        NamedScope scope;
        if (project == null) {
            NamedScopeDescriptor.$$$reportNull$$$0(3);
        }
        if ((scope = (holder = DependencyValidationManager.getInstance(project)).getScope(this.myScopeId)) == null) {
            holder = NamedScopeManager.getInstance(project);
            scope = holder.getScope(this.myScopeId);
        }
        return scope != null ? Pair.create((Object)holder, (Object)scope) : null;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myScopeId;
        if (string == null) {
            NamedScopeDescriptor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public String getType() {
        return NAMED_SCOPE_TYPE;
    }

    @Override
    @Nullable
    public String getPattern() {
        return this.myFileSet != null ? this.myFileSet.getText() : null;
    }

    @Nullable
    public PackageSet getFileSet() {
        return this.myFileSet;
    }

    public String toString() {
        return "scope: " + this.myScopeId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/fileSet/NamedScopeDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/fileSet/NamedScopeDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveScope";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

