/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ui.FragmentStatisticsService;
import com.intellij.execution.ui.TagButton;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Ref;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingsEditorFragment<Settings, C extends JComponent>
extends SettingsEditor<Settings> {
    private final String myId;
    @Nls
    private final String myName;
    @Nls
    private final String myGroup;
    protected C myComponent;
    private final BiConsumer<? super Settings, ? super C> myReset;
    private final BiConsumer<? super Settings, ? super C> myApply;
    private final int myCommandLinePosition;
    private final Predicate<? super Settings> myInitialSelection;
    @Nullable
    @Nls
    private String myHint;
    @Nullable
    private JComponent myHintComponent;
    @Nullable
    @Nls
    private String myActionHint;
    @Nullable
    private String myConfigId;
    @Nullable
    private Function<? super C, ? extends JComponent> myEditorGetter;
    private boolean myRemovable = true;
    private boolean myCanBeHidden;

    public SettingsEditorFragment(String id, @Nls(capitalization=Nls.Capitalization.Sentence) String name, @Nls(capitalization=Nls.Capitalization.Title) String group, C component, int commandLinePosition, BiConsumer<? super Settings, ? super C> reset, BiConsumer<? super Settings, ? super C> apply, Predicate<? super Settings> initialSelection) {
        this.myId = id;
        this.myName = name;
        this.myGroup = group;
        this.myComponent = component;
        this.myReset = reset;
        this.myApply = apply;
        this.myCommandLinePosition = commandLinePosition;
        this.myInitialSelection = initialSelection;
    }

    public SettingsEditorFragment(String id, @Nls(capitalization=Nls.Capitalization.Sentence) String name, @Nls(capitalization=Nls.Capitalization.Title) String group, C component, BiConsumer<? super Settings, ? super C> reset, BiConsumer<? super Settings, ? super C> apply, Predicate<? super Settings> initialSelection) {
        this(id, name, group, (C)component, 0, reset, apply, initialSelection);
    }

    public static <S> SettingsEditorFragment<S, ?> createWrapper(String id, @Nls String name, @Nls String group, @NotNull SettingsEditor<S> inner, Predicate<? super S> initialSelection) {
        if (inner == null) {
            SettingsEditorFragment.$$$reportNull$$$0(0);
        }
        JComponent component = inner.getComponent();
        SettingsEditorFragment<? super S, JComponent> fragment = new SettingsEditorFragment<S, JComponent>(id, name, group, component, (settings, c) -> inner.resetFrom(settings), (settings, c) -> {
            try {
                inner.applyTo(settings);
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
        }, initialSelection);
        Disposer.register(fragment, inner);
        return fragment;
    }

    public static <Settings> SettingsEditorFragment<Settings, ?> createTag(String id, @Nls String name, @Nls String group, Predicate<? super Settings> getter, BiConsumer<? super Settings, ? super Boolean> setter) {
        Ref ref = new Ref();
        TagButton tagButton = new TagButton(name, e -> {
            ((SettingsEditorFragment)ref.get()).setSelected(false);
            ((SettingsEditorFragment)ref.get()).logChange(false, (AnActionEvent)e);
        });
        SettingsEditorFragment fragment = new SettingsEditorFragment<Settings, JComponent>(id, name, group, tagButton, (settings, button) -> button.setVisible(getter.test((Object)settings)), (settings, button) -> setter.accept((Object)settings, (Boolean)button.isVisible()), getter){

            @Override
            public boolean isTag() {
                return true;
            }
        };
        Disposer.register((Disposable)fragment, (Disposable)tagButton);
        ref.set((Object)fragment);
        return fragment;
    }

    public String getId() {
        return this.myId;
    }

    @Nls
    public String getName() {
        return this.myName;
    }

    @Nls
    public String getGroup() {
        return this.myGroup;
    }

    public C component() {
        return this.myComponent;
    }

    public JComponent[] getAllComponents() {
        return new JComponent[]{this.component()};
    }

    public boolean isTag() {
        return false;
    }

    @Nullable
    public ActionGroup getCustomActionGroup() {
        return null;
    }

    public boolean isSelected() {
        return ((Component)this.myComponent).isVisible();
    }

    public boolean isInitiallyVisible(Settings settings) {
        return this.myInitialSelection.test(settings);
    }

    public boolean isRemovable() {
        return this.myRemovable;
    }

    public void setRemovable(boolean removable) {
        this.myRemovable = removable;
    }

    public boolean isCanBeHidden() {
        return this.myCanBeHidden;
    }

    public void setCanBeHidden(boolean canBeHidden) {
        this.myCanBeHidden = canBeHidden;
    }

    public void setSelected(boolean selected) {
        ((JComponent)this.myComponent).setVisible(selected);
        if (this.myHintComponent != null) {
            this.myHintComponent.setVisible(selected);
        }
        this.fireEditorStateChanged();
    }

    public void toggle(boolean selected, @Nullable AnActionEvent e) {
        this.setSelected(selected);
        if (selected) {
            ((JComponent)this.myComponent).scrollRectToVisible(new Rectangle(new Point(0, 50), ((JComponent)this.myComponent).getPreferredSize()));
        }
        this.logChange(selected, e);
    }

    protected void logChange(boolean selected, @Nullable AnActionEvent e) {
        if (selected) {
            FragmentStatisticsService.getInstance().logOptionModified(this.getProject(), this.getId(), this.myConfigId, e);
        } else {
            FragmentStatisticsService.getInstance().logOptionRemoved(this.getProject(), this.getId(), this.myConfigId, e);
        }
    }

    private Project getProject() {
        return (Project)DataManager.getInstance().getDataContext((Component)this.myComponent).getData(PlatformDataKeys.PROJECT_CONTEXT);
    }

    public void setEditorGetter(@Nullable Function<? super C, ? extends JComponent> editorGetter) {
        this.myEditorGetter = editorGetter;
    }

    public JComponent getEditorComponent() {
        Object component = this.component();
        if (this.myEditorGetter != null) {
            return this.myEditorGetter.apply(this.component());
        }
        if (component instanceof LabeledComponent) {
            component = ((LabeledComponent)component).getComponent();
        } else if (component instanceof TagButton) {
            return ((TagButton)component).myButton;
        }
        return component instanceof ComponentWithBrowseButton ? ((ComponentWithBrowseButton)component).getChildComponent() : component;
    }

    public int getCommandLinePosition() {
        return this.myCommandLinePosition;
    }

    public int getMenuPosition() {
        return 0;
    }

    @Override
    protected void resetEditorFrom(@NotNull Settings s) {
        if (s == null) {
            SettingsEditorFragment.$$$reportNull$$$0(1);
        }
        this.myReset.accept(s, this.myComponent);
    }

    @Override
    protected void applyEditorTo(@NotNull Settings s) {
        if (s == null) {
            SettingsEditorFragment.$$$reportNull$$$0(2);
        }
        this.myApply.accept(s, this.myComponent);
    }

    @Override
    @NotNull
    protected JComponent createEditor() {
        ((JComponent)this.myComponent).setVisible(this.isSelected());
        C c = this.myComponent;
        if (c == null) {
            SettingsEditorFragment.$$$reportNull$$$0(3);
        }
        return c;
    }

    public List<SettingsEditorFragment<Settings, ?>> getChildren() {
        return Collections.emptyList();
    }

    @Nullable
    @Nls
    public String getChildrenGroupName() {
        return null;
    }

    @Nullable
    @NlsActions.ActionDescription
    public String getActionHint() {
        return this.myActionHint;
    }

    public void setActionHint(@Nullable @Nls String hint) {
        this.myActionHint = hint;
    }

    @Nullable
    public String getHint(@Nullable JComponent component) {
        return this.myHint;
    }

    public void setHint(@Nullable @Nls String hint) {
        this.myHint = hint;
    }

    public void setConfigId(@Nullable String configId) {
        this.myConfigId = configId;
    }

    @Nullable
    public JComponent getHintComponent() {
        if (this.myHintComponent == null && this.myHint != null) {
            JLabel comment = ComponentPanelBuilder.createNonWrappingCommentComponent(this.myHint);
            comment.setFocusable(false);
            this.myHintComponent = LabeledComponent.create(comment, "", "West");
        }
        return this.myHintComponent;
    }

    public String toString() {
        return this.myId + " " + this.myName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inner";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ui/SettingsEditorFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ui/SettingsEditorFragment";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createWrapper";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

