/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ui.SettingsEditorFragment;
import com.intellij.openapi.actionSystem.EmptyAction;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FragmentHintManager {
    private final List<SettingsEditorFragment<?, ?>> myFragments;
    @NotNull
    private final Consumer<? super String> myHintConsumer;
    private final String myDefaultHint;

    public FragmentHintManager(@NotNull Consumer<? super @NlsContexts.DialogMessage String> hintConsumer, @NlsContexts.DialogMessage @Nullable String defaultHint) {
        if (hintConsumer == null) {
            FragmentHintManager.$$$reportNull$$$0(0);
        }
        this.myFragments = new ArrayList();
        this.myHintConsumer = hintConsumer;
        this.myDefaultHint = defaultHint;
        hintConsumer.consume((Object)defaultHint);
    }

    public void registerFragments(Collection<? extends SettingsEditorFragment<?, ?>> fragments) {
        fragments.forEach(fragment -> this.registerFragment((SettingsEditorFragment<?, ?>)fragment));
    }

    public void registerFragment(SettingsEditorFragment<?, ?> fragment) {
        this.myFragments.add(fragment);
        for (JComponent jComponent : fragment.getAllComponents()) {
            this.registerComponent(fragment, FragmentHintManager.getComponent(jComponent));
        }
    }

    private void registerComponent(final SettingsEditorFragment<?, ?> fragment, final JComponent component) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                FragmentHintManager.this.showHint(fragment, component);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                FragmentHintManager.this.showHint(null, component);
            }
        });
        component.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                FragmentHintManager.this.showHint(fragment, component);
            }

            @Override
            public void focusLost(FocusEvent e) {
                FragmentHintManager.this.showHint(null, component);
            }
        });
    }

    private static JComponent getComponent(JComponent component) {
        if (component instanceof LabeledComponent) {
            component = ((LabeledComponent)component).getComponent();
        }
        if (component instanceof RawCommandLineEditor) {
            component = ((RawCommandLineEditor)component).getEditorField();
        }
        if (component instanceof ComponentWithBrowseButton) {
            component = ((ComponentWithBrowseButton)component).getChildComponent();
        }
        return component;
    }

    private void showHint(@Nullable SettingsEditorFragment<?, ?> fragment, @Nullable JComponent component) {
        ShortcutSet shortcut;
        String hint = this.myDefaultHint;
        if (fragment != null) {
            hint = fragment.getHint(component);
        } else {
            fragment = (SettingsEditorFragment)ContainerUtil.find(this.myFragments, f -> f.getEditorComponent().hasFocus());
            if (fragment != null) {
                hint = fragment.getHint(component);
            }
        }
        if (fragment != null && (shortcut = ActionUtil.getMnemonicAsShortcut(new EmptyAction(fragment.getName(), null, null))) != null && shortcut.getShortcuts().length > 0) {
            String text = KeymapUtil.getShortcutsText(new Shortcut[]{(Shortcut)ArrayUtil.getLastElement((Object[])shortcut.getShortcuts())});
            hint = hint == null ? text : hint + ". " + text;
        }
        this.myHintConsumer.consume((Object)(hint == null ? this.myDefaultHint : hint));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintConsumer", "com/intellij/execution/ui/FragmentHintManager", "<init>"));
    }
}

