/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.Platform;
import com.intellij.execution.target.PathMapping;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentPaths;
import com.intellij.openapi.util.io.FileUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\\\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00022\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0002\u001a \u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\nH\u0000\u001a\u0012\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001*\u00020\u0012H\u0002\u001a\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0002\u001a\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0002\u00a8\u0006\u0017"}, d2={"findPathVariants", "", "", "mappings", "", "Lcom/intellij/execution/target/PathMapping;", "sourcePath", "sourcePathFun", "Lkotlin/Function1;", "sourceFileSeparator", "", "destPathFun", "destFileSeparator", "joinTargetPaths", "basePath", "relativePath", "fileSeparator", "collectPathMappings", "Lcom/intellij/execution/target/TargetEnvironment;", "getLocalPaths", "targetPath", "getTargetPaths", "localPath", "intellij.platform.lang"})
@JvmName(name="TargetEnvironmentPaths")
public final class TargetEnvironmentPaths {
    @NotNull
    public static final List<String> getLocalPaths(@NotNull TargetEnvironment $this$getLocalPaths, @NotNull String targetPath) {
        Intrinsics.checkNotNullParameter((Object)$this$getLocalPaths, (String)"$this$getLocalPaths");
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        return TargetEnvironmentPaths.findPathVariants((Iterable<PathMapping>)TargetEnvironmentPaths.collectPathMappings($this$getLocalPaths), targetPath, (Function1<? super PathMapping, String>)((Function1)getLocalPaths.1.INSTANCE), $this$getLocalPaths.getTargetPlatform().getPlatform().fileSeparator, (Function1<? super PathMapping, String>)((Function1)getLocalPaths.2.INSTANCE), Platform.current().fileSeparator);
    }

    @NotNull
    public static final List<String> getTargetPaths(@NotNull TargetEnvironment $this$getTargetPaths, @NotNull String localPath) {
        Intrinsics.checkNotNullParameter((Object)$this$getTargetPaths, (String)"$this$getTargetPaths");
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        return TargetEnvironmentPaths.findPathVariants((Iterable<PathMapping>)TargetEnvironmentPaths.collectPathMappings($this$getTargetPaths), localPath, (Function1<? super PathMapping, String>)((Function1)getTargetPaths.1.INSTANCE), Platform.current().fileSeparator, (Function1<? super PathMapping, String>)((Function1)getTargetPaths.2.INSTANCE), $this$getTargetPaths.getTargetPlatform().getPlatform().fileSeparator);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<PathMapping> collectPathMappings(TargetEnvironment $this$collectPathMappings) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$collectPathMappings.getUploadVolumes().values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TargetEnvironment.UploadableVolume uploadableVolume = (TargetEnvironment.UploadableVolume)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PathMapping pathMapping = new PathMapping(((Object)it.getLocalRoot()).toString(), it.getTargetRoot());
            collection.add(pathMapping);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> findPathVariants(Iterable<PathMapping> mappings, String sourcePath, Function1<? super PathMapping, String> sourcePathFun, char sourceFileSeparator, Function1<? super PathMapping, String> destPathFun, char destFileSeparator) {
        void $this$mapNotNullTo$iv$iv;
        Iterable<PathMapping> $this$mapNotNull$iv = mappings;
        boolean $i$f$mapNotNull = false;
        Iterable<PathMapping> iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            PathMapping mapping = (PathMapping)element$iv$iv;
            boolean bl2 = false;
            String sourceBase = (String)sourcePathFun.invoke((Object)mapping);
            if (FileUtil.isAncestor((String)sourceBase, (String)sourcePath, (boolean)false)) {
                String destBase = (String)destPathFun.invoke((Object)mapping);
                if (FileUtil.getRelativePath((String)sourceBase, (String)sourcePath, (char)sourceFileSeparator) != null) {
                    String string2;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    String relativeSourcePath = string2;
                    boolean bl5 = false;
                    String string3 = relativeSourcePath;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"relativeSourcePath");
                    string = TargetEnvironmentPaths.joinTargetPaths(destBase, string3, destFileSeparator);
                } else {
                    string = null;
                }
            } else {
                string = null;
            }
            if (string == null) continue;
            String string4 = string;
            boolean bl6 = false;
            boolean bl7 = false;
            String it$iv$iv = string4;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final String joinTargetPaths(@NotNull String basePath, @NotNull String relativePath, char fileSeparator) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        String resultCanonicalPath = FileUtil.toCanonicalPath((String)(basePath + fileSeparator + relativePath), (char)fileSeparator);
        String string = FileUtil.toSystemDependentName((String)resultCanonicalPath, (char)fileSeparator);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FileUtil.toSystemDepende\u2026nicalPath, fileSeparator)");
        return string;
    }
}

